<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" />

<xsl:template match="ComponentTree">
	<html>
	<head>
	<title></title>
	<link rel="stylesheet" type="text/css" href="/oma/docs/oma.css" />
	<xsl:if test="@skin != ''">
		<link rel="stylesheet" type="text/css">
			<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if>scheme.css</xsl:attribute>
		</link>
		<xsl:if test="@language != ''">
			<link rel="stylesheet" type="text/css">
				<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/scheme.css</xsl:attribute>
			</link>
			<xsl:if test="@country != ''">
				<link rel="stylesheet" type="text/css">
					<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/<xsl:value-of select="@country"/>/scheme.css</xsl:attribute>
				</link>
			</xsl:if>
		</xsl:if>
	</xsl:if>
	<script language="javascript">
	var g_sLastLink = "";
	var g_sFirstComponent = "";
	var g_sDefaultHelp = "";
	var g_sDefaultApp = "";
	var g_iOpenedArrow;
	var g_iClosedArrow;
	var g_iOpenedLine;
	var g_iClosedLine;
	var g_bCallChangeImage = false;
	var g_bModal = false;
	var g_bSNBGoingBack = false;
	var g_bLSNBGoingBack = false;
	var g_sSNB = "";
	var g_sLSNB = "";
	var g_nSNBLatency = 0;
	var g_nLSNBLatency = 0;
	var g_nDataAreaLatency = 0;
	var g_nSNBLoadStart;
	var g_sNewLink = "";
	var g_hCalculateLatency;
	var g_hClearLock;
	var preferencesFlag = false;
	var g_bLoadInProgress = false;
	g_sFirstPreferenceComponent = "";
	g_sDefaultPreferenceHelp = "";
	g_sDefaultPreferenceApp = "";
	var snbLoad = false;
	var lsnbLoad = false;
	var daLoad = false;
	var machineArchType = <xsl:value-of select="@archtype"/>;
	
	function init () {
		snbLoad = false;
		lsnbLoad = false;
		daLoad = false;
		g_iClosedArrow = new Image ();
		g_iClosedArrow.src =  "/oma/<xsl:if test="@skin != ''">skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if></xsl:if>images/ctplus.gif";
		g_iOpenedArrow = new Image ();
		g_iOpenedArrow.src = "/oma/<xsl:if test="@skin != ''">skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if></xsl:if>images/ctminus.gif";
		g_iClosedLine = new Image ();
		g_iClosedLine.src =  "/oma/<xsl:if test="@skin != ''">skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if></xsl:if>images/ctline.gif";
		g_iOpenedLine = new Image ();
		g_iOpenedLine.src = "/oma/<xsl:if test="@skin != ''">skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if></xsl:if>images/ctpfork.gif";
		<xsl:choose>
			<!-- If a history item is returned by the servlet, use that instead of the default selection. -->
			<xsl:when test="@ct">
				select ('<xsl:value-of select="@ct"/>', '<xsl:value-of select="@snb"/>', '<xsl:value-of select="@lsnb"/>');
			</xsl:when>
			<xsl:otherwise>
				changeState (g_sFirstComponent, '', '', g_sDefaultHelp, '', '', g_sDefaultApp);
				_changeImage (g_sFirstComponent, true);
			</xsl:otherwise>
		</xsl:choose>
		resize ();
	}
	function changeImage (index) {
		g_bCallChangeImage = true;
	}
	function _changeImage (index, bForceOpen) {
		var s = document.getElementById ("subcat_" + index);
		if (s != null) {
			if (s.style.display == "none")  {
				document.images["imageA_" + index].src =  g_iOpenedArrow.src;
				document.images["imageB_" + index].src =  g_iOpenedLine.src;
				s.style.display = "";
			}
			else if (bForceOpen == false) {
				document.images["imageA_" + index].src =  g_iClosedArrow.src;
				document.images["imageB_" + index].src =  g_iClosedLine.src;
				s.style.display = "none";
			}
		}
	}
	function clearLock () {
		if (g_bLoadInProgress != false) {
			g_bLoadInProgress = false;
			window.clearInterval (g_hClearLock);
			dadoc = parent.da.document;
			for (i = 0; i &lt; dadoc.links.length; i++) {
				link = dadoc.links[i];
				href = link.href;
				if (href.indexOf ('#') == 0) {
					link.href = href.substr (1);
				}
			}
		}
	}
	function setLock () {
		if (g_bLoadInProgress != true) {
			g_bLoadInProgress = true;
			dadoc = parent.da.document;
			for (i = 0; i &lt; dadoc.links.length; i++) {
				link = dadoc.links[i];
				href = link.href;
				if (href.indexOf("#") == -1) //if this is not an internal link
					link.href = '#' + href;
			}
		}
	}
	function calculateSNBLatency () {
		if (g_bLoadInProgress == false) {
			var now = new Date ();
			g_nSNBLatency = now.getTime () - g_nSNBLoadStart;
			window.clearInterval (g_hCalculateLatency);
		}
	}
	function loadSNB (sComponent, sSNB, sLSNB, sHelp, sApp) {
		var vvid = top.gnv.getVID();
		g_sNewLink = "/servlet/LoadSNB?component=" + sComponent + '&amp;snb=' + sSNB + '&amp;lsnb=' + sLSNB + '&amp;help=' + sHelp+'&amp;app=' + sApp + '&amp;vid=' + vvid;
		
		if(navigator.appName == "Netscape") {
			<!-- on Netscape, if we try to load the same URL, browser ignores the request and this results in a blank page,
			 this code tries to detect an attempt to load the same URL and deceives the browser by adding useless extra informaton
			 to the URL and forces the browser to load the URL. -->
			if (isURLSame (g_sNewLink)) {
				// deceive browser by appending junk to the URL.
				g_sNewLink = g_sNewLink + '&amp;foolbrowser=true';
			}
			
			g_nSNBLoadStart = (new Date ()).getTime ();
			parent.snb.location.href = g_sNewLink;
			g_hCalculateLatency = window.setInterval (calculateSNBLatency, 100);
			
			if (g_nSNBLatency > 0)
				g_hClearLock = window.setInterval (clearLock , g_nSNBLatency);
		}
		else {
			parent.snb.location.href = g_sNewLink;
		}
	}
	function isURLSame (sNewLink) {
		var sModifiedCurrentSNBHref;
		var iIndex;
		var boolURLSame = false;
		var sCurrentSNBHref = new String (parent.snb.location.href);
		
		if (sCurrentSNBHref.indexOf ("#") != -1) {
			if (sCurrentSNBHref.indexOf ("#") + 1 == sCurrentSNBHref.length) {
				// '#' is at the end of the string
				sCurrentSNBHref = sCurrentSNBHref.substring (0, sCurrentSNBHref.indexOf ("#"));
			}
		}
		
		iIndex = sCurrentSNBHref.indexOf ("/servlet/LoadSNB?");
		
		if (iIndex != -1) {
			sModifiedCurrentSNBHref = sCurrentSNBHref.substring ( iIndex, sCurrentSNBHref.length);
			if (sModifiedCurrentSNBHref == sNewLink) {
				boolURLSame = true;
			}
		}
		
		return boolURLSame;
	}
	function changeState (sComponentName, sSNB, sLSNB, sHelp,sApp) {
		if (g_bLoadInProgress == false) {
			setLock ();
			if (_changeState (sComponentName) == true) {
				loadSNB (sComponentName, sSNB, sLSNB, sHelp,sApp);
			}
		}
	}
	function _changeState (sComponentName) {
		if (g_bModal == false) {
			try {
					if (g_sLastLink != "") {
						document.getElementById("link_" + g_sLastLink).className = "component-tree-item";
						for (var i = 0; ; i++) {
							var cell = document.getElementById("cellA" + i + "_" + g_sLastLink);
							if (cell != null) cell.className = "component-tree-item";
							else break;
						}
						document.getElementById("cellB_" + g_sLastLink).className = "component-tree-item";
						document.getElementById("table_" + g_sLastLink).width = 159;
					}
					g_sLastLink = sComponentName;
					document.getElementById("link_" + g_sLastLink).className = "component-tree-item component-tree-selection";
					for (var i = 0; ; i++) {
						var cell = document.getElementById("cellA" + i + "_" + g_sLastLink);
						if (cell != null) cell.className = "component-tree-item component-tree-selection";
						else break;
					}
					document.getElementById("cellB_" + g_sLastLink).className = "component-tree-item component-tree-selection";
					resize ();
					if (g_bCallChangeImage == true) {
						// User clicked on the image.  Collapse if necessary
						_changeImage (sComponentName, false);
						g_bCallChangeImage = false;
					}
					else {
						// User clicked on the component name; force the display of the sub-items
						_changeImage (sComponentName, true);
					}
					return true;
			}
			catch (e) {
				top.location.href = "/servlet/OMSALogin?msgStatus=null";
				return false;
			}
		}
		return false;
	}
	function resize() {
		try {
				document.getElementById("table_" + g_sLastLink).width = document.getElementById("component-tree").offsetWidth;
		}
		catch (e) {
			top.location.href = "/servlet/OMSALogin?msgStatus=null";
		}
	}
	function select (sSelection, sSNB, sLSNB) {
		if (_select (sSelection) == true) {
			changeState (sSelection, sSNB, sLSNB, '');
		}
	}
	function _select (sSelection) {
		var link = document.getElementById("link_" + sSelection);
		if (link != null) {
			_changeState (sSelection);
			var tSelection = document.getElementById ("table_" + sSelection);
			var pParent = tSelection.parentNode;
			while (pParent != null) {
				var s = new String (pParent.id);
				if (s.indexOf ("subcat_") != -1) {
					_changeImage (s.substr (7), true);
				}
				pParent = pParent.parentNode;
			}
			return true;
		}
		else {
			// Go back to the top if item requested cannot be found.
			changeState ('System', '', '', '');
		}
		return false;
	}
	function modal (bModal) {
		g_bModal = bModal;
		if (bModal == false) {
			clearLock ();
		}
	}
	function testCode () {
		_select('ServerAdministrator');
		parent.snb._select('Preferences');
		parent.lsnb._select('server');
	}

	</script>
	</head>
	<body id="component-tree" class="component-tree" onload="javascript:init()" onresize="javascript:resize ();">
		<br />
		<xsl:apply-templates select="Sp_Application" />
<!-- Test code
		<a href="#" onclick="javascript:modal(true)">Modal</a>
		<br />
		<a href="#" onclick="javascript:modal(false)">UnModal</a>
-->
	</body>
	</html>
</xsl:template>

<xsl:template match="Sp_Application">	
	<xsl:choose>
		<xsl:when test="/ComponentTree/@curr-program = 'pref'">
			<script language="javascript">
				<xsl:for-each select="*">
					<xsl:if test="name() = /ComponentTree/@prev-program">
						preferencesFlag = true;
						g_sFirstPreferenceComponent = '<xsl:value-of select="name()"/>';
						g_sDefaultPreferenceHelp = '<xsl:value-of select="@help"/>';
						g_sDefaultPreferenceApp = '<xsl:value-of select="@app"/>';
					</xsl:if>
				</xsl:for-each>
			</script>
		</xsl:when>
	</xsl:choose>	
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match="*">
	<script language="javascript">
		if (g_sFirstComponent == "") {
			if (preferencesFlag == true){
				g_sFirstComponent = g_sFirstPreferenceComponent;
				g_sDefaultHelp = g_sDefaultPreferenceHelp;
				g_sDefaultApp = g_sDefaultPreferenceApp;
			}
			else{
				g_sFirstComponent = '<xsl:value-of select="name()"/>';
				g_sDefaultHelp = '<xsl:value-of select="@help"/>';
				g_sDefaultApp = '<xsl:value-of select="@app"/>';
			}
		}
	</script>
	<table cellpadding="0" cellspacing="0" border="0">
		<xsl:attribute name="id">table_<xsl:value-of select="name()"/></xsl:attribute>
		<tr>
			<xsl:attribute name="id">row_<xsl:value-of select="name()"/></xsl:attribute>
			<!-- Add a 5px cell as gutter -->
			<td class="component-tree-item" style="width: 5px">
				<xsl:attribute name="id">cellA0_<xsl:value-of select="name()"/></xsl:attribute>
				<img style="width: 5px" src="/oma/images/blank.gif" />
			</td>
			<xsl:if test="count(parent::node()) > 0">
				<xsl:call-template name="draw-parental-relationship">
					<xsl:with-param name="parentNode" select="parent::node()" />
				</xsl:call-template>
			</xsl:if>
			<xsl:element name="td">
				<xsl:attribute name="id">cellB_<xsl:value-of select="name()"/></xsl:attribute>
				<xsl:attribute name="align">left</xsl:attribute>
				<xsl:attribute name="valign">middle</xsl:attribute>
				<xsl:attribute name="class">component-tree-item</xsl:attribute>
				<xsl:attribute name="nowrap">true</xsl:attribute>
				<xsl:if test="count(node()) = 0">
					<xsl:element name="img">
						<xsl:attribute name="src">/oma/<xsl:if test="/ComponentTree/@skin != ''">skins/<xsl:value-of select="/ComponentTree/@skin"/>/<xsl:if test="/ComponentTree/@scheme != ''">schemes/<xsl:value-of select="/ComponentTree/@scheme"/>/</xsl:if></xsl:if>images/<xsl:choose><xsl:when test="count(following-sibling::node()) = 0 and (count(ancestor-or-self::node()) > 4)">ctl.gif</xsl:when><xsl:when test="((count(child::node()) = 0) and (count(ancestor-or-self::node()) &lt;= 4))">ctminus.gif</xsl:when><xsl:otherwise>ctfork.gif</xsl:otherwise></xsl:choose></xsl:attribute>
						<xsl:attribute name="width">15</xsl:attribute>
						<xsl:attribute name="height">15</xsl:attribute>
						<xsl:attribute name="border">0</xsl:attribute>
						<xsl:attribute name="align">absmiddle</xsl:attribute>
					</xsl:element>
					<xsl:element name="img">
						<xsl:attribute name="src">/oma/<xsl:if test="/ComponentTree/@skin != ''">skins/<xsl:value-of select="/ComponentTree/@skin"/>/<xsl:if test="/ComponentTree/@scheme != ''">schemes/<xsl:value-of select="/ComponentTree/@scheme"/>/</xsl:if></xsl:if>images/ctline.gif</xsl:attribute>
						<xsl:attribute name="width">15</xsl:attribute>
						<xsl:attribute name="height">15</xsl:attribute>
						<xsl:attribute name="border">0</xsl:attribute>
						<xsl:attribute name="align">absmiddle</xsl:attribute>
					</xsl:element>				
				</xsl:if>
				<xsl:element name="a">
					<xsl:attribute name="id">link_<xsl:value-of select="name()"/></xsl:attribute>
					<!-- MM : Begin - Fix for id issue -->
					<!-- SilkTest expects name attribute for hrefs. Hence providing 'name' -->
					<xsl:attribute name="name">link_<xsl:value-of select="name()"/></xsl:attribute>
					<!-- MM : End - Fix for id issue -->
					<xsl:attribute name="href">#</xsl:attribute>
					<xsl:attribute name="onclick">javascript:changeState ('<xsl:value-of select="name()"/>', '', '', '<xsl:value-of select="@help"/>', '', '', '<xsl:value-of select="@app"/>');</xsl:attribute>
					<xsl:attribute name="class">component-tree-item</xsl:attribute>
					<xsl:if test="count(node()) > 0">
						<xsl:element name="img">
							<xsl:attribute name="onClick">javascript:changeImage('<xsl:value-of select="name()"/>')</xsl:attribute>
							<xsl:attribute name="name">imageA_<xsl:value-of select="name()"/></xsl:attribute>
							<xsl:attribute name="src">/oma/<xsl:if test="/ComponentTree/@skin != ''">skins/<xsl:value-of select="/ComponentTree/@skin"/>/<xsl:if test="/ComponentTree/@scheme != ''">schemes/<xsl:value-of select="/ComponentTree/@scheme"/>/</xsl:if></xsl:if>images/ctplus.gif</xsl:attribute>
							<xsl:attribute name="width">15</xsl:attribute>
							<xsl:attribute name="height">15</xsl:attribute>
							<xsl:attribute name="border">0</xsl:attribute>
							<xsl:attribute name="align">absmiddle</xsl:attribute>
						</xsl:element>
						<xsl:element name="img">
							<xsl:attribute name="onClick">javascript:changeImage('<xsl:value-of select="name()"/>')</xsl:attribute>
							<xsl:attribute name="name">imageB_<xsl:value-of select="name()"/></xsl:attribute>
							<xsl:attribute name="src">/oma/<xsl:if test="/ComponentTree/@skin != ''">skins/<xsl:value-of select="/ComponentTree/@skin"/>/<xsl:if test="/ComponentTree/@scheme != ''">schemes/<xsl:value-of select="/ComponentTree/@scheme"/>/</xsl:if></xsl:if>images/ctline.gif</xsl:attribute>
							<xsl:attribute name="width">15</xsl:attribute>
							<xsl:attribute name="height">15</xsl:attribute>
							<xsl:attribute name="border">0</xsl:attribute>
							<xsl:attribute name="align">absmiddle</xsl:attribute>
						</xsl:element>
					</xsl:if>
					<xsl:choose>
						<xsl:when test="@display=''"><xsl:value-of select="name()" /></xsl:when>
						<xsl:otherwise><xsl:value-of select="@display" /></xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
		</tr>
	</table>
	<xsl:if test="count(node()) > 0">
		<xsl:element name="div">
			<xsl:attribute name="id">subcat_<xsl:value-of select="name()" /></xsl:attribute>
			<xsl:attribute name="style">display: none</xsl:attribute>
			<xsl:apply-templates />
		</xsl:element>
	</xsl:if>
</xsl:template>

<!--
	JJ 09/04/01
	This template draws the parent-child relationship graphs by examining the
	ancestry of an element to determine the need for parent/child linkage line.
-->
<xsl:template name="draw-parental-relationship">
	<xsl:param name="parentNode" />
	<xsl:if test="count($parentNode/parent::node()) > 0">
		<xsl:call-template name="draw-parental-relationship">
			<xsl:with-param name="parentNode" select="$parentNode/parent::node ()" />
		</xsl:call-template>
	</xsl:if>
	<!-- 
		The current Component Tree specification contains the ComponentTree element that is not part of the viewable tree;
		additionaly, we do not add indentation for the top element of a  component tree (i.e. System).  The code that follows
		skips adding HTML indentation elements.
	-->
	<xsl:if test="count($parentNode/ancestor-or-self::node()) > 2">
		<td style="width: 15px" class="component-tree-item">
			<xsl:attribute name="id">cellA<xsl:value-of select="count($parentNode/ancestor-or-self::node()) - 2" />_<xsl:value-of select="name()" /></xsl:attribute>
			<img style="width: 15px; height:15px" border="0">
				<xsl:attribute name="src">
					<xsl:choose>
						<xsl:when test="count($parentNode/following-sibling::node()) = 0">/oma/images/blank.gif</xsl:when>
						<xsl:otherwise>/oma/<xsl:if test="/ComponentTree/@skin != ''">skins/<xsl:value-of select="/ComponentTree/@skin"/>/<xsl:if test="/ComponentTree/@scheme != ''">schemes/<xsl:value-of select="/ComponentTree/@scheme"/>/</xsl:if></xsl:if>images/ctdash.gif</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</img>
		</td>
	</xsl:if>
</xsl:template>

</xsl:stylesheet>
