<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text" indent="no"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
		<xsl:apply-templates select="DataArea"/>
	</xsl:template>
	<xsl:template match="DataArea">
		<xsl:apply-templates />
		<!--<xsl:apply-templates select="PageTitle"/>
		<xsl:apply-templates select="PromptText"/>
		<xsl:apply-templates select="SubHeader"/>
		<xsl:apply-templates select="ListData"/>
		<xsl:apply-templates select="TableData"/>
		<xsl:apply-templates select="ComboData"/>
		<xsl:apply-templates select="SummaryData"/>-->
	</xsl:template>
	<xsl:template match="PageTitle">
		<xsl:if test="@display">
			<xsl:value-of select="@display"/>
			<xsl:if test="@status!=''">
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>	
				<xsl:value-of select="$strHealth"/><xsl:call-template name="display-status">
				    	<xsl:with-param name="status"><xsl:value-of select="@status"/></xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:call-template name="NewLine"/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="PromptText">
		<xsl:if test=". !=''">
			<xsl:choose>
				<xsl:when test="@ignoreoncli = 'true'"></xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="NewLine"/>
					<xsl:value-of select="."/>
					<xsl:call-template name="NewLine"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>


    	<xsl:template match="SubHeader">
		<xsl:if test="@display">
	  		<xsl:call-template name="NewLine" /> 
			
			<xsl:choose>
	         		<xsl:when test="@banner">
					<xsl:choose>
						<xsl:when test="@status">

							<xsl:call-template name="banner-status">
								<xsl:with-param name="status">
			  						<xsl:value-of select="@status" /> 
			  					</xsl:with-param>
								<xsl:with-param name="display">
			  						<xsl:value-of select="@display" /> 
			  					</xsl:with-param>
			  				</xsl:call-template>
			  				<xsl:call-template name="NewLine" /> 
			  			</xsl:when>
						<xsl:otherwise>
		  					<xsl:value-of select="@display" /> 
		  					<xsl:call-template name="NewLine" /> 
		  				</xsl:otherwise>
			  		</xsl:choose>
				</xsl:when>
				
				
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="@status">
			  				<xsl:value-of select="@display" /> 
			  				<xsl:text>:</xsl:text> 
							<xsl:call-template name="display-status">
								<xsl:with-param name="status">
			  						<xsl:value-of select="@status" /> 
			  					</xsl:with-param>
			  				</xsl:call-template>
			  				<xsl:call-template name="NewLine" /> 
			  			</xsl:when>
						<xsl:otherwise>
		  					<xsl:value-of select="@display" /> 
		  					<xsl:call-template name="NewLine" /> 
		  				</xsl:otherwise>
			  		</xsl:choose>
				</xsl:otherwise>
	      	</xsl:choose>
  		</xsl:if>
  	</xsl:template>


	<xsl:template match="ListData">
		<xsl:apply-templates select="SubHeader"/>
		<xsl:choose>
			<xsl:when test="@display">
				<xsl:call-template name="NewLine"/>
				<xsl:value-of select="@display"/>
				<xsl:call-template name="NewLine"/>
				<xsl:variable name="colwidth">
					<xsl:call-template name="MAX">
						<xsl:with-param name="list" select="Data"/>
						<xsl:with-param name="type" select="'display'"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="DataList">
					<xsl:with-param name="columnwidth" select="$colwidth"/>
					<xsl:with-param name="Data" select="Data"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="NewLine"/>
				<xsl:variable name="colwidth">
					<xsl:call-template name="MAX">
						<xsl:with-param name="list" select="Data"/>
						<xsl:with-param name="type" select="'display'"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="DataList">
					<xsl:with-param name="columnwidth" select="$colwidth"/>
					<xsl:with-param name="Data" select="Data"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="TableData">
		<xsl:choose>
			<xsl:when test="(count(SubHeader)) > 1">
				<xsl:for-each select="SubHeader">
					<xsl:call-template name="NewLine"/>
					<xsl:choose>
						<xsl:when test="@banner">
							<xsl:choose>
								<xsl:when test="@status">		
									<xsl:call-template name="banner-status">
										<xsl:with-param name="status">
					  						<xsl:value-of select="@status" /> 
					  					</xsl:with-param>
										<xsl:with-param name="display">
					  						<xsl:value-of select="@display" /> 
					  					</xsl:with-param>
					  				</xsl:call-template>
					  			</xsl:when>
								<xsl:otherwise>
				  					<xsl:value-of select="@display" />
				  				</xsl:otherwise>
			  				</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="@status">
									<xsl:value-of select="@display"/><xsl:text> : </xsl:text><xsl:call-template name="display-status">
									    	<xsl:with-param name="status"><xsl:value-of select="@status"/></xsl:with-param>
									</xsl:call-template>
								 </xsl:when>
								 <xsl:otherwise>
									<xsl:value-of select="@display"/>
								</xsl:otherwise>
					           </xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:call-template name="NewLine"/>
				</xsl:for-each>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="SubHeader/@display">
						<xsl:call-template name="NewLine"/>
						<xsl:choose>
							<xsl:when test="SubHeader/@banner">
								<xsl:choose>
									<xsl:when test="SubHeader/@status">		
										<xsl:call-template name="banner-status">
											<xsl:with-param name="status">
						  						<xsl:value-of select="SubHeader/@status" /> 
						  					</xsl:with-param>
											<xsl:with-param name="display">
						  						<xsl:value-of select="SubHeader/@display" /> 
						  					</xsl:with-param>
						  				</xsl:call-template>
						  				<xsl:call-template name="NewLine" /> 
						  			</xsl:when>
									<xsl:otherwise>
					  					<xsl:value-of select="SubHeader/@display" />
					  					<xsl:call-template name="NewLine" />
					  				</xsl:otherwise>
				  				</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="SubHeader/@status">
										<xsl:value-of select="SubHeader/@display"/><xsl:text> : </xsl:text><xsl:call-template name="display-status">
										    	<xsl:with-param name="status"><xsl:value-of select="SubHeader/@status"/></xsl:with-param>
										</xsl:call-template>
									 </xsl:when>
									 <xsl:otherwise>
										<xsl:value-of select="SubHeader/@display"/>
									</xsl:otherwise>
						           </xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="NewLine"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:variable name="maxlength">
			<xsl:call-template name="MAX">
				<xsl:with-param name="list" select="Header/Data"/>
				<xsl:with-param name="type">display</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:call-template name="Row">
			<xsl:with-param name="maxlength" select="$maxlength"/>
			<xsl:with-param name="Row" select="Row"/>
			<xsl:with-param name="Header" select="Header"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="ComboData">
		<xsl:if test="ListData/SubHeader/@display">
			<xsl:call-template name="NewLine"/>
			<xsl:value-of select="ListData/SubHeader/@display"/>
			<xsl:call-template name="NewLine"/>
		</xsl:if>
		<xsl:apply-templates select="ListData"/>
		<xsl:if test="TableData">
			<xsl:apply-templates select="TableData"/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="SummaryData">
		<xsl:variable name="maxDisplay">
			<xsl:call-template name="MAX">
				<xsl:with-param name="list" select="//Section//ListData//Data"/>
				<xsl:with-param name="type">display</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:for-each select="Section">
			<xsl:if test="ListData">
				<!-- 2. Section name  -->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="spaces">
				<xsl:with-param name="length" select="(string-length(@display) + 1)"/>
				<xsl:with-param name="character" select="'-'"/>
				</xsl:call-template>
				<xsl:call-template name="NewLine"/>
				<xsl:value-of select="@display"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="spaces">
				<xsl:with-param name="length" select="(string-length(@display) + 1)"/>
				<xsl:with-param name="character" select="'-'"/>
				</xsl:call-template>
				<xsl:call-template name="NewLine"/>
				<!-- 2. End Section name  -->
				<xsl:for-each select="ListData">
					<!-- 3. List Name -->
						<xsl:if test="@display">
							<xsl:if test="position()!='1'">
								<xsl:call-template name="NewLine"/>
							</xsl:if>
							<xsl:value-of select="@display"/>							
							<xsl:call-template name="NewLine"/>
						</xsl:if>
					<!-- 3. End List Name -->
					<!-- 4. Print Data  -->
					<xsl:for-each select="Data">
						<xsl:value-of select="@display"/>
						<xsl:call-template name="spaces">
							<xsl:with-param name="length"><xsl:value-of select="($maxDisplay - string-length(@display))"/></xsl:with-param>
							<xsl:with-param name="character" select="' '"/>
						</xsl:call-template>
						<xsl:text>: </xsl:text>
						<xsl:value-of select="@value"/>
						<xsl:call-template name="NewLine"/>
					</xsl:for-each>
					<!-- 4. End Print Data -->
				</xsl:for-each>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="Row">
		<xsl:param name="maxlength"/>
		<xsl:param name="Row"/>
		<xsl:param name="Header"/>
			<xsl:for-each select="$Row">
				<xsl:call-template name="Data">
					<xsl:with-param name="maxlength" select="$maxlength"/>
					<xsl:with-param name="Data" select="Data"/>
					<xsl:with-param name="Header" select="$Header"/>
				</xsl:call-template>
				<xsl:if test="position() != last()">
					<xsl:call-template name="NewLine"/>
				</xsl:if>
			</xsl:for-each>
	</xsl:template>
	<xsl:template name="Data">
		<xsl:param name="maxlength"/>
		<xsl:param name="Data"/>
		<xsl:param name="Header"/>
		<xsl:for-each select="$Data">
			<xsl:choose>
				<xsl:when test="@ignoreoncli='true'">
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="@type">
							<xsl:if test="@type!='hidden'">
								<xsl:variable name="pos" select="position()"/>
								<xsl:value-of select="$Header/Data[$pos]/@display"/>
								<xsl:variable name="spaces">
									<xsl:value-of select="(($maxlength) - string-length($Header/Data[$pos]/@display))"/>
								</xsl:variable>
								<xsl:call-template name="spaces">
									<xsl:with-param name="length" select="$spaces"/>
									<xsl:with-param name="character" select="' '"/>
								</xsl:call-template>
								<xsl:text>: </xsl:text>
								<xsl:choose>
									<xsl:when test="@type='icon'">
										<xsl:value-of select="@alt"/>
									</xsl:when>
									<xsl:when test="@type='status'">
										<xsl:call-template name="display-status">
											<xsl:with-param name="status" select="@value" />
										</xsl:call-template>
									</xsl:when>
									<xsl:when test="@type='status-text'">
										<xsl:call-template name="display-status">
											<xsl:with-param name="status" select="@value" />
										</xsl:call-template>
									</xsl:when>
									<xsl:when test="@type='editbox'">
										<xsl:value-of select="@value"/>
									</xsl:when>
									<xsl:when test="@type='radio'">
										<xsl:value-of select="@value"/><xsl:text> </xsl:text>
										<xsl:call-template name="GetState">
											<xsl:with-param name="state"><xsl:value-of select="@state"/></xsl:with-param>
										</xsl:call-template>
									</xsl:when>
									<xsl:when test="@type='checkbox'">
										<xsl:call-template name="GetState">
											<xsl:with-param name="state"><xsl:value-of select="@state"/></xsl:with-param>
										</xsl:call-template>
									</xsl:when>
									<xsl:when test="@type='ipaddrbox'">
										<xsl:value-of select="@value1"/><xsl:text>.</xsl:text><xsl:value-of select="@value2"/><xsl:text>.</xsl:text><xsl:value-of select="@value3"/><xsl:text>.</xsl:text><xsl:value-of select="@value4"/>
									</xsl:when>
									<xsl:when test="@type='select'">
										<xsl:for-each select="Choice">
											<xsl:if test="@default='true'">
												<xsl:value-of select="@value"/>
											</xsl:if>
										</xsl:for-each>
									</xsl:when>
									<xsl:when test="@type='password'">
										<xsl:call-template name="PassWord">
											<xsl:with-param name="size"><xsl:value-of select="@size"/></xsl:with-param>
										</xsl:call-template>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="@value"/>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:call-template name="NewLine"/>
							</xsl:if>
						</xsl:when>
						<xsl:otherwise>
							<xsl:variable name="pos" select="position()"/>
							<xsl:value-of select="$Header/Data[$pos]/@display"/>
							<xsl:variable name="spaces">
								<xsl:value-of select="(($maxlength) - string-length($Header/Data[$pos]/@display))"/>
							</xsl:variable>
							<xsl:call-template name="spaces">
								<xsl:with-param name="length" select="$spaces"/>
								<xsl:with-param name="character" select="' '"/>
							</xsl:call-template>
							<xsl:text>: </xsl:text>
							<xsl:choose>
								<xsl:when test="ValueList/value">
									<xsl:for-each select="ValueList/value">
										<xsl:if test="position()!=1">
											<xsl:call-template name="spaces">
												<xsl:with-param name="length" select="$maxlength"/>
												<xsl:with-param name="character" select="' '"/>
											</xsl:call-template>
											<xsl:text>: </xsl:text>
										</xsl:if>
										<xsl:value-of select="."/>
										<xsl:if test="position()!=last()">
											<xsl:call-template name="NewLine"/>
										</xsl:if>
									</xsl:for-each>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="@value"/>
								</xsl:otherwise>
							</xsl:choose>
							<xsl:call-template name="NewLine"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>	
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="DataList">
		<xsl:param name="columnwidth"/>
		<xsl:param name="Data"/>
			<xsl:for-each select="$Data">
				<xsl:choose>
					<xsl:when test="@ignoreoncli='true'"></xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="@type">
								<xsl:if test="@type!='hidden'">
									<xsl:value-of select="@display"/>
									<xsl:variable name="spaces">
										<xsl:value-of select="(($columnwidth) - string-length(@display))"/>
									</xsl:variable>
									<xsl:call-template name="spaces">
										<xsl:with-param name="length" select="$spaces"/>
										<xsl:with-param name="character" select="' '"/>
									</xsl:call-template>
									<xsl:text>: </xsl:text>
									<xsl:choose>
										<xsl:when test="@type">
											<xsl:choose>
												<xsl:when test="@type='icon'">
													<xsl:value-of select="@alt"/>
												</xsl:when>
												<xsl:when test="@type='status'">
													<xsl:call-template name="display-status">
														<xsl:with-param name="status" select="@value" />
													</xsl:call-template>
												</xsl:when>
												<xsl:when test="@type='status-text'">
													<xsl:call-template name="display-status">
														<xsl:with-param name="status" select="@value" />
													</xsl:call-template>
												</xsl:when>
												<xsl:when test="@type='editbox'">
													<xsl:value-of select="@value"/>
												</xsl:when>
												<xsl:when test="@type='radio'">
													<xsl:call-template name="GetState">
														<xsl:with-param name="state"><xsl:value-of select="@state"/></xsl:with-param>
													</xsl:call-template>
												</xsl:when>
												<xsl:when test="@type='checkbox'">
													<xsl:call-template name="GetState">
														<xsl:with-param name="state"><xsl:value-of select="@state"/></xsl:with-param>
													</xsl:call-template>
												</xsl:when>
												<xsl:when test="@type='ipaddrbox'">
													<xsl:value-of select="@value1"/><xsl:text>.</xsl:text><xsl:value-of select="@value2"/><xsl:text>.</xsl:text><xsl:value-of select="@value3"/><xsl:text>.</xsl:text><xsl:value-of select="@value4"/>
												</xsl:when>
												<xsl:when test="@type='select'">
													<xsl:for-each select="Choice">
														<xsl:if test="@default='true'">
															<xsl:value-of select="@value"/>
														</xsl:if>
													</xsl:for-each>
												</xsl:when>
												<xsl:when test="@type='password'">
													<xsl:call-template name="PassWord">
														<xsl:with-param name="size"><xsl:value-of select="@size"/></xsl:with-param>
													</xsl:call-template>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="@value"/>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="@value"/>
										</xsl:otherwise>
									</xsl:choose>
									<xsl:call-template name="NewLine"/>
								</xsl:if>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="@display"/>
								<xsl:variable name="spaces">
									<xsl:value-of select="(($columnwidth) - string-length(@display))"/>
								</xsl:variable>
								<xsl:call-template name="spaces">
									<xsl:with-param name="length" select="$spaces"/>
									<xsl:with-param name="character" select="' '"/>
								</xsl:call-template>
								<xsl:text>: </xsl:text>
								<xsl:value-of select="@value"/>
								<xsl:call-template name="NewLine"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>	
	</xsl:template>
	<xsl:template name="PassWord">
		<xsl:param name="size"/>
		<xsl:text>*</xsl:text>
		<xsl:if test="$size &gt; '0'">
			<xsl:call-template name="PassWord">
				<xsl:with-param name="size"><xsl:value-of select="($size) - 1"/></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<xsl:template name="getcolumnwidth">
		<xsl:param name="list"/>
		<xsl:param name="column"/>
		<xsl:choose>
			<xsl:when test="$list">
				<xsl:choose>
					<xsl:when test="$column=1">
						<xsl:choose>
							<xsl:when test="contains($list,',')">
								<xsl:value-of select="substring-before($list,',')"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$list"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:when test="$column &gt; 1">
						<xsl:variable name="last">
							<xsl:value-of select="substring-after($list,',')"/>
						</xsl:variable>
						<xsl:call-template name="getcolumnwidth">
							<xsl:with-param name="list" select="$last"/>
							<xsl:with-param name="column" select="($column)-1"/>
						</xsl:call-template>
					</xsl:when>
				</xsl:choose>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetState">
		<xsl:param name="state"/>
		<xsl:choose>
			<xsl:when test="$state=1">true</xsl:when>
			<xsl:when test="$state=3">true</xsl:when>
			<xsl:otherwise>false</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="MAX">
		<xsl:param name="list"/>
		<xsl:param name="type"/>
		<xsl:choose>
			<xsl:when test="$list">
				<xsl:variable name="first">
					<xsl:choose>
						<xsl:when test="$type='display'">
							<xsl:choose>
								<xsl:when test="($list[1]/@ignoreoncli)='true'">0</xsl:when>
								<xsl:otherwise><xsl:value-of select="string-length($list[1]/@display)"/></xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="string-length($list[1]/@value)"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>	
				<xsl:variable name="rest">
					<xsl:call-template name="MAX">
						<xsl:with-param name="list" select="$list[position()!=1]"/>
						<xsl:with-param name="type" select="$type"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:choose>
				     <!--The following translate stuff removes spurious comma inserted when in French or German Locale under Linux 7.2  -->
					<xsl:when test="normalize-space(translate($first,',',' ')) &gt; normalize-space(translate($rest,',',' ')) ">
						<xsl:value-of select="normalize-space(translate($first,',',' '))"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="normalize-space(translate($rest,',',' '))"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="spaces">
		<xsl:param name="length"/>
		<xsl:param name="character"/>
		<xsl:if test="$length!=0">
			<xsl:call-template name="spaces">
				<!--The following translate stuff removes spurious comma inserted when in French or German Locale under Linux 7.2  -->
				<xsl:with-param name="length" select="normalize-space(translate($length,',',' '))-1"/>
				<xsl:with-param name="character" select="$character"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:value-of select="$character"/>
	</xsl:template>
	<xsl:template name="NewLine">
		<xsl:text>
</xsl:text>
	</xsl:template>

	<xsl:template name="GetStatusLen">
		<xsl:param name="status" />
		<xsl:variable name="StatusStr">
			<xsl:call-template name="GetStatus">
				<xsl:with-param name="status" select="$status"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:value-of select="(string-length( $StatusStr ))"/>
	</xsl:template>

	<xsl:template name="GetStatus">
		<xsl:param name="status" />
		<xsl:choose>
			<xsl:when test="$status='0'"><xsl:value-of select="$strUnknown"/></xsl:when>
			<xsl:when test="$status='1'"><xsl:value-of select="$strUnknown1"/></xsl:when>
			<xsl:when test="$status='2'"><xsl:value-of select="$strOk"/></xsl:when>
			<xsl:when test="$status='3'"><xsl:value-of select="$strNonCritical"/></xsl:when>
			<xsl:when test="$status='4'"><xsl:value-of select="$strCritical"/></xsl:when>
			<xsl:when test="$status='5'"><xsl:value-of select="$strNonRecoverable"/></xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="banner-status">
		<xsl:param name="status" />
		<xsl:param name="display" />
		<xsl:variable name="StatusLen">
			<xsl:call-template name="GetStatusLen">
				<xsl:with-param name="status" select="$status"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:call-template name="spaces">
			<xsl:with-param name="length" select="(string-length(@display) + 1 +$StatusLen )"/>
			<xsl:with-param name="character" select="'-'"/>
		</xsl:call-template>
		<xsl:call-template name="NewLine"/>
		<xsl:value-of select="@display" /> 
		<xsl:text>: </xsl:text>
		<xsl:call-template name="GetStatus">
			<xsl:with-param name="status" select="$status"/>
		</xsl:call-template>
		<xsl:call-template name="NewLine"/>
		<xsl:call-template name="spaces">
			<xsl:with-param name="length" select="(string-length(@display) + 1 +$StatusLen )"/>
			<xsl:with-param name="character" select="'-'"/>
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="display-status">
		<xsl:param name="status" />
		<xsl:call-template name="GetStatus">
			<xsl:with-param name="status" select="$status"/>
		</xsl:call-template>		
	</xsl:template>
	
	<xsl:template match="*"/>
</xsl:stylesheet>
