<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/OMA">
		<DataArea>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strInformation"/></xsl:attribute>
			</PageTitle>
			<CustomButton>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.oma.webplugins.SvrinfoWebPlugin&amp;help=SVRInfo</xsl:attribute>
				</Data>
			</CustomButton>
			<ListData>
				<xsl:apply-templates select="Skin"/>
				<xsl:apply-templates select="Scheme"/>
				<xsl:apply-templates select="Sestimeout"/>
				<xsl:apply-templates select="Port"/>
			</ListData>
		</DataArea>
	</xsl:template>
	
	<xsl:template match="Skin">
		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strCurrentSkin"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
		</Data>
	</xsl:template>
	<xsl:template match="Scheme">
		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strCurrentScheme"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
		</Data>
	</xsl:template>
	<xsl:template match="Sestimeout">
		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strCurrentSessionTimeout"/></xsl:attribute>
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test=".='-1'">disabled</xsl:when>
					<xsl:otherwise><xsl:value-of select="."/><xsl:text disable-output-escaping="yes">  </xsl:text><xsl:value-of select="@unit"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>				
	</xsl:template>
	<xsl:template match="Port">
		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strCurrentHTTPPort"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
		</Data>				
	</xsl:template>
	<xsl:template match="*"/>
</xsl:stylesheet>
