<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/OMA">

		<DataArea backpagetarget="/servlet/DataArea?plugin=com.dell.oma.webplugins.SessionMgmtWebPlugin&amp;help=SessionManagement&amp;app=oma&amp;ct=System&amp;snb=SessionMgmt&amp;lsnb=Sessions" email="true" printable="true" exportdata="true">

<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strSessionInfo"/></xsl:attribute>
			</PageTitle>
			<CustomButton>
					<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
						<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.oma.webplugins.SessionMgmtWebPlugin&amp;help=SessionManagement&amp;</xsl:attribute>
					</Data>
				</CustomButton>
				<xsl:call-template name="MainHeading"/>
				<xsl:apply-templates select="sessionList "/>		

		<script language="javascript">
		function confirmTermination(varoid)
		{
			if(confirm('<xsl:value-of select="$strSessionTerminate"/>')){
				document.getElementById("dataarea").action=top.gnv.appendVID('/servlet/DataArea?plugin=com.dell.oma.webplugins.RemoveSessionWebPlugin&amp;help=SessionTerminate&amp;oid='+varoid);
				document.getElementById("dataarea").submit();

			}
		}
		</script>

		</DataArea>
	</xsl:template>
	
	<xsl:template name="MainHeading">
	<ListData type="custom">
		<Data width="300">
			<xsl:attribute name="display"><xsl:value-of select="$strTotalNumberOf"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="/OMA/sessionList/@count"/></xsl:attribute>
		</Data>
	</ListData>
</xsl:template>

<xsl:template match="sessionList ">
		<TableData columnspacing="true">
			<PromptText><xsl:value-of select="$strPromptDisplay"/></PromptText>
			<Header>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strUserSessionID"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strUserSessionID"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strUserName"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strUserName"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strUserLoginTime"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strUserLoginTime"/></xsl:attribute>
				</Data>

				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strInvalidateUserSession"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strInvalidateUserSession"/></xsl:attribute>
				</Data>
			</Header>
			<xsl:apply-templates select="user"/>		
		</TableData>
</xsl:template>

<xsl:template match="user">
	<Row>
	
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="counter"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="counter"/></xsl:attribute>
		</Data>
		<Data>
					<xsl:attribute name="display"><xsl:value-of select="userName"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="userName"/></xsl:attribute>
		</Data>
		<Data>
					<xsl:attribute name="display"><xsl:value-of select="time"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="time"/></xsl:attribute>
		</Data>

		
		<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strInvalidate"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strInvalidate"/></xsl:attribute>
					<xsl:attribute name="link">true</xsl:attribute>
					<xsl:attribute name="href">javascript:confirmTermination('<xsl:value-of select="sessionKey"/>');</xsl:attribute>
		</Data>
	</Row>
</xsl:template>
	<xsl:template match="*"/>
</xsl:stylesheet>