<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/OMA">
		<HTML>
			<head>
			<title>
			<xsl:choose>
				<!-- OEM -->
				<xsl:when test="OEM/OEMTitleCompanyName = ''">
					<xsl:choose>
						<xsl:when test="OEM/ProdName = ''">
							<xsl:value-of select="OEM/OEMTitleCoreProductName" />
						</xsl:when>
						<xsl:otherwise>
							YYY<xsl:call-template name="ProdName"><xsl:with-param name="prodname"><xsl:value-of select="OEM/ProdName" /></xsl:with-param></xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<!-- none-OEM -->
				<xsl:otherwise>
					<xsl:value-of select="OEM/OEMTitleCompanyName" />&#160;<xsl:value-of select="OEM/OEMTitleCoreProductName" />&#160;<xsl:call-template name="ProdName"><xsl:with-param name="prodname"><xsl:value-of select="OEM/ProdName" /></xsl:with-param></xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
			</title>
			</head>
			<xsl:choose>
				<xsl:when test="Embedded = 'true'">
					<xsl:call-template name="body" />
				</xsl:when>
				<xsl:otherwise>
					<script language="javascript" src="/oma/js/index.js" />
					<frameset rows="64,*" border="0" frameborder="no" framespacing="0">
						<frame src="/servlet/SecureGlobalNavBarServlet" name="gnv" scrolling="no" marginheight="0" marginwidth="0" frameborder="no" framespacing="0" border="0" />
						<xsl:call-template name="body" />
					</frameset>
				</xsl:otherwise>
			</xsl:choose>
			<noframes />
		</HTML>
	</xsl:template>

	<xsl:template name="ProdName">
		<xsl:param name="prodname"/>
		<xsl:choose>
			<xsl:when test="$prodname = 'Preferences'"><!--XLATESTART-->&#12503;&#12522;&#12501;&#12449;&#12521;&#12531;&#12473;<!--XLATESTART--></xsl:when>
			<xsl:otherwise><xsl:value-of select="$prodname"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="body">
		<frameset rows="60,*" border="0" frameborder="no" framespacing="0">
		    <frameset cols="159,*" border="0" frameborder="0" framespacing="0">
		        <frame src="/servlet/ServerName" name="sn" scrolling="no" marginheight="0" marginwidth="0" />
		        <frameset rows="30,30" border="0" frameborder="no" framespacing="0">
		            <frame src="/oma/loading.html" name="snb" scrolling="no" marginheight="0" marginwidth="0" frameborder="no" framespacing="0" />
		            <frame src="/oma/loading.html" name="lsnb" scrolling="no" marginheight="0" marginwidth="0" />
		        </frameset>
		    </frameset>
		    <frameset cols="0,159,*" border="0" frameborder="0" framespacing="1">
		            <frame src="/oma/blank.html" name="pf" marginheight="0" marginwidth="0" />
		            <frame src="/servlet/ComponentTree" name="ct" scrolling="auto" marginheight="0" marginwidth="0" />
		            <frame src="/oma/loading.html" name="da" marginheight="0" marginwidth="0" />
		    </frameset>
		</frameset>
	</xsl:template>
</xsl:stylesheet>