<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text" indent="no"/>
	<xsl:strip-space elements="*"/>

	<xsl:template match="/OMA">
		<xsl:call-template name="CLIMsgID">
			<xsl:with-param name="id"><xsl:value-of select="CLIMsgID"/></xsl:with-param>
			<xsl:with-param name="shownvpairs"><xsl:value-of select="CLIShowNVPairs"/></xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="CLIMsgID">
		<xsl:param name="id"/>
		<xsl:param name="shownvpairs"/>
		<xsl:choose>
			<xsl:when test="$id = '1'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command"><xsl:value-of select="CLISubCommand"/></xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->SCSI RAID Array Subsystem list.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '2'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command"><xsl:value-of select="CLISubCommand"/></xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Array disks for a particular controller or virtual disk.<!--XLATESTOP-->
				<xsl:if test="$shownvpairs = 'true'">
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>controller=ID	 </xsl:text><!--XLATESTART-->Displays array disks and enclosure/channel information for a
		 particular controller.<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->		 The controller ID can be retrieved from the following command: <!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->		 omreport storage arrays<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>vdisk=ID	 </xsl:text><!--XLATESTART-->Displays array disks for a particular virtual disk.<!--XLATESTOP-->
										<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->		 The virtual disk ID can be retrieved from the following 
		 command: <!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->		 omreport storage arrays<!--XLATESTOP-->
				</xsl:if>
			</xsl:when>
			<xsl:when test="$id = '3'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command"><xsl:value-of select="CLISubCommand"/></xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Operating System disks properties.<!--XLATESTOP-->
					<xsl:if test="$shownvpairs = 'true'">
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>volume=ID	 </xsl:text><!--XLATESTART-->Lists operating system disks for a particular volume. <!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->		 The volume ID can be retrieved from the following command: <!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->		 omreport storage volumes<!--XLATESTOP-->
				</xsl:if>
			</xsl:when>
			<xsl:when test="$id = '4'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command"><xsl:value-of select="CLISubCommand"/></xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Detailed information for a particular Operating System disk.<!--XLATESTOP-->
					<xsl:if test="$shownvpairs = 'true'">
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>osdisk=ID	 </xsl:text><!--XLATESTART-->ID of operating system disk (required).<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->		 The osdisk ID can be retrieved from the following command: <!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->		 omreport storage osdisks<!--XLATESTOP-->
				</xsl:if>
			</xsl:when>
			<xsl:when test="$id = '5'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command"><xsl:value-of select="CLISubCommand"/></xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Properties for all volumes.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '7'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command"><xsl:value-of select="CLISubCommand"/></xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Storage component properties.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '8'">
				<!--XLATESTART-->Error! Invalid controller ID.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '9'">
				<!--XLATESTART-->Error! Invalid virtual disk ID.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '10'">
				<!--XLATESTART-->Error! Invalid operating system disk ID.<!--XLATESTOP-->
			</xsl:when>						
			<xsl:when test="$id = '11'">
				<!--XLATESTART-->Error! Invalid volume ID.<!--XLATESTOP-->
			</xsl:when>			
			<xsl:when test="$id = '12'">
				<!--XLATESTART-->Error! Storage Management Subsystem is not installed.<!--XLATESTOP-->
			</xsl:when>					
			<xsl:when test="$id = '13'">
				<!--XLATESTART-->No osdisks present on volume.<!--XLATESTOP-->
			</xsl:when>			
			<xsl:when test="$id = '14'">
				<!--XLATESTART-->Error! At least one extra parameter necessary.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '15'">
				<!--XLATESTART-->Error! Parameter missing.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '16'">
				<!--XLATESTART-->Error! At least one extra parameter necessary.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '17'">
				<!--XLATESTART-->Error! Invalid enclosure ID.<!--XLATESTOP-->
			</xsl:when>				
			<xsl:when test="$id = '18'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command"><xsl:value-of select="CLISubCommand"/></xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Detailed information for a particular Enclosure.<!--XLATESTOP-->
					<xsl:if test="$shownvpairs = 'true'">
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>enclosure=ID	 </xsl:text><!--XLATESTART-->ID of enclosure (required).<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->		 The enclosure ID can be retrieved from the following commands: <!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->		 omreport storage arraydisks<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->		 omreport storage enclosures<!--XLATESTOP-->
				</xsl:if>
				</xsl:when>
			<xsl:when test="$id = '19'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command"><xsl:value-of select="CLISubCommand"/></xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Properties of all Enclosures.<!--XLATESTOP-->
			</xsl:when>			
			<xsl:when test="$id = '20'">
				<!--XLATESTART-->No RAID controllers detected on system.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '21'">
				<!--XLATESTART-->Error! No Enclosures detected on system.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '22'">
				<!--XLATESTART-->Error! The command is not supported on this operating system.<!--XLATESTOP-->
			</xsl:when>
			
			
			<xsl:when test="$id = '1000'">
				<!--XLATETHIS-->Command Successful.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1001'">
				<!--XLATETHIS-->Error! Signed number expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1002'">
				<!--XLATETHIS-->Error! unsigned number expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1003'">
				<!--XLATETHIS-->Error! true or false expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1004'">
				<!--XLATETHIS-->Error! alphanumeric or symbol expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1005'">
				<!--XLATETHIS-->Error! Required parameter missing: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1006'">
				<!--XLATETHIS-->Error! At least one optional parameter must be specified.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1007'">
				<!--XLATETHIS-->Error! Command incomplete <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1008'">
				<!--XLATETHIS-->Error! Hardware not found: <!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1009'">
				<!--XLATETHIS-->Error! cannot load data accessor: <!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1010'">
				<!--XLATETHIS-->Error! Index too large. Maximum index for this command is: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1011'">
				<!--XLATETHIS-->Error! Hardware subsystem reports command failed.  <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1012'">
				<!--XLATETHIS-->Error! Unrecognized parameter value: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1013'">
				<!--XLATETHIS-->Error! Text too long. Maximum number of characters is: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1014'">
				<!--XLATETHIS-->Error! Value incorrect for parameter: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1015'">
				<!--XLATETHIS-->Error! Number expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1016'">
				<!--XLATETHIS-->Error! Date in form mmddyy expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>		
			<xsl:when test="$id = '1017'">
				<!--XLATETHIS-->Error! Percent (0-100) expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>	
			<xsl:when test="$id = '1018'">
				<!--XLATETHIS-->Error! Number with up to 1 digit after decimal point expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>			
			<xsl:when test="$id = '1019'">
				<!--XLATETHIS-->Error! Number with up to 2 digits after decimal point  expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>			
			<xsl:when test="$id = '1020'">
				<!--XLATETHIS-->Error! Number with up to 3 digits after decimal point  expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>	
			<xsl:when test="$id = '1021'">
				<!--XLATETHIS-->Error! Month is invalid: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1022'">
				<!--XLATETHIS-->Error! Day is invalid: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1023'">
				<!--XLATETHIS-->Error! Not a leap year: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1024'">
				<!--XLATETHIS-->Error! Alphanumeric expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>	
			<xsl:when test="$id = '1025'">
				<!--XLATETHIS-->Error! Unrecognized parameter: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1101'">
				<!--XLATETHIS-->Error! Signed number or "default" expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1102'">
				<!--XLATETHIS-->Error! unsigned number or "default" expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1103'">
				<!--XLATETHIS-->Error! true or false or "default" expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1104'">
				<!--XLATETHIS-->Error! alphanumeric or symbol or "default" expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:otherwise></xsl:otherwise>
		</xsl:choose>
		<xsl:call-template name="NewLine"/>
	</xsl:template>
	
	<xsl:template name="CLISubCommand">
			<xsl:value-of select="$command"/>
			<xsl:call-template name="Spaces">
				<xsl:with-param name="num"><xsl:value-of select="(17) - string-length($command)"/></xsl:with-param>
			</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="Spaces">
		<xsl:param name="num"/>
		<xsl:choose>
			<xsl:when test="$num = '16'">
				<xsl:text>                </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '15'">
				<xsl:text>               </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '14'">
				<xsl:text>              </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '13'">
				<xsl:text>             </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '12'">
				<xsl:text>            </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '11'">
				<xsl:text>           </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '10'">
				<xsl:text>          </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '9'">
				<xsl:text>         </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '8'">
				<xsl:text>        </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '7'">
				<xsl:text>       </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '6'">
				<xsl:text>      </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '5'">
				<xsl:text>     </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '4'">
				<xsl:text>    </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '3'">
				<xsl:text>   </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '2'">
				<xsl:text>  </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '1'">
				<xsl:text> </xsl:text>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="NewLine">
		<xsl:text>
</xsl:text>

	</xsl:template>
</xsl:stylesheet>
