<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">

	<xsl:template match="OMA">
		<DataArea>
			<ListData>
					<xsl:apply-templates select="About"/>
			</ListData>
		</DataArea>
	</xsl:template>

	<xsl:template match="About">
		<Data>
			<xsl:attribute name="display"><!--XLATETHIS-->Product name<!--/XLATETHIS--></xsl:attribute>
			<xsl:choose>
				<xsl:when test="ProductName"><xsl:attribute name="value"><xsl:value-of select="ProductName"/></xsl:attribute></xsl:when>
				<xsl:otherwise>	<xsl:attribute name="value">Information Not Available.</xsl:attribute></xsl:otherwise>
			</xsl:choose>
		</Data>
		<Data>
			<xsl:attribute name="display"><!--XLATETHIS-->Version <!--/XLATETHIS--></xsl:attribute>
			<xsl:choose>
				<xsl:when test="ProductVersion"><xsl:attribute name="value"><xsl:value-of select="ProductVersion"/></xsl:attribute></xsl:when>
				<xsl:otherwise>	<xsl:attribute name="value">Information Not Available.</xsl:attribute></xsl:otherwise>
			</xsl:choose>
		</Data>
		<Data>
			<xsl:attribute name="display"><!--XLATETHIS-->Copyright <!--/XLATETHIS--></xsl:attribute>
			<xsl:choose>
				<xsl:when test="LegalCopyright"><xsl:attribute name="value"><xsl:value-of select="LegalCopyright"/></xsl:attribute></xsl:when>
				<xsl:otherwise>	<xsl:attribute name="value">Information Not Available.</xsl:attribute></xsl:otherwise>
			</xsl:choose>
		</Data>
		<Data>
			<xsl:attribute name="display"><!--XLATETHIS-->Company <!--/XLATETHIS--></xsl:attribute>
			<xsl:choose>
				<xsl:when test="CompanyName"><xsl:attribute name="value"><xsl:value-of select="CompanyName"/></xsl:attribute></xsl:when>
				<xsl:otherwise>	<xsl:attribute name="value">Information Not Available.</xsl:attribute></xsl:otherwise>
			</xsl:choose>
		</Data>
		<xsl:for-each select="Component">
			<xsl:sort select="Name"/>
			<xsl:choose>
			<xsl:when test="ID = 'osia' and Name">
				<!--IGNORE, AutDB provides only the version while name comes from OEM.ini-->
			</xsl:when>
			<xsl:when test="ID = 'OLD' or ID = 'old' or ID = 'odf' or ID = 'OLDCOMMON'">
				<!--IGNORE, OLD is removed from OMSA, so hide OLD components details.  -->
			</xsl:when>
			<xsl:otherwise>
			<Data>
				<xsl:attribute name="name">Contains_<xsl:value-of select="position()" /></xsl:attribute>
				<xsl:choose>
					<xsl:when test="position() &lt; '2'">
						<xsl:attribute name="display"><!--XLATESTART-->Contains <!--XLATESTOP--></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="display"></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="ID = 'osia'">
							<xsl:choose>
								<xsl:when test="(../OEMTitleCompanyName)!=''">
									<xsl:value-of select="../OEMTitleCompanyName" /><xsl:text> </xsl:text><xsl:value-of select="../OEMTitleCoreProductName" />
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../OEMTitleCoreProductName" />
								</xsl:otherwise>
							</xsl:choose>
							<br/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="Name" />
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="ID = 'osia'">
							<xsl:text> </xsl:text><xsl:value-of select="../OEMTitleVersion" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:text> </xsl:text>
							<xsl:value-of select="Version" />
							<!-- Add build number for oma framework -->
							<xsl:if test="ID = 'OMACORE' or ID = 'omacore' ">
								<xsl:variable name="buildNum"><xsl:value-of select="BuildNumber"/></xsl:variable>
								<xsl:if test="$buildNum != ''"> (<xsl:value-of select="$buildNum"/>)</xsl:if>
							</xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
			</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>
