<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text" indent="no"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
		<xsl:call-template name="CLISubCommand">
			<xsl:with-param name="command"><xsl:value-of select="CLISubCommand"/></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="CLIMsgID">
			<xsl:with-param name="id"><xsl:value-of select="CLIMsgID"/></xsl:with-param>
			<xsl:with-param name="shownvpairs"><xsl:value-of select="CLIShowNVPairs"/></xsl:with-param>
			<xsl:with-param name="nametxt">
				<xsl:value-of select="CLIParseName"/>
			</xsl:with-param>
			<xsl:with-param name="paramtxt">
				<xsl:value-of select="CLIParamName"/>	
			</xsl:with-param>		
			<xsl:with-param name="parsetxt">
				<xsl:value-of select="CLIParseTxt"/>
			</xsl:with-param>
			<xsl:with-param name="parsetxt2">
				<xsl:value-of select="CLIParseTxt2"/>
			</xsl:with-param>
			<xsl:with-param name="hipstat">
				<xsl:value-of select="CustomStat"/>
			</xsl:with-param>
		</xsl:call-template>
		</xsl:template>	
	<xsl:template name="CLIMsgID">
		<xsl:param name="id"/>
		<xsl:param name="shownvpairs"/>
		<xsl:param name="nametxt"/>
		<xsl:choose>
			<xsl:when test="$id = '1'">
				<xsl:text>Dial-In user properties.</xsl:text>
				<xsl:if test="$shownvpairs = 'true'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
			 <xsl:call-template name="NewLine"/>username=&lt;text&gt;     <!--XLATESTART-->Specifies user name of entry to view.<!--XLATESTOP-->
			 <xsl:call-template name="NewLine"/>index=&lt;number&gt;      <!--XLATESTART-->Specifies index of entry to view.<!--XLATESTOP-->
				</xsl:if>
			</xsl:when>
			<xsl:when test="$id = '2'">
			<xsl:text>Dial-Out user properties.</xsl:text>
			<xsl:if test="$shownvpairs = 'true'">
				<xsl:call-template name="NewLine"/>				
					<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>ipaddr=&lt;text&gt;           <!--XLATESTART-->Specifies IP address of entry to view.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>index=&lt;number&gt;          <!--XLATESTART-->Specifies index of entry to view.<!--XLATESTOP-->
</xsl:if>

			</xsl:when>
			<xsl:when test="$id = '3'">
				<xsl:text>Onboard modem properties.</xsl:text>
			</xsl:when>
			<xsl:when test="$id = '4'">
				<xsl:text>Network properties.</xsl:text>
			</xsl:when>
			<xsl:when test="$id = '5'">
				<xsl:text>Remote features properties.</xsl:text>
			</xsl:when>
			<xsl:when test="$id = '6'">
				<xsl:text>Remote Access Card (RAC) properties.</xsl:text>
			</xsl:when>
			<xsl:when test="$id = '7'">
				<xsl:text>SNMP trap properties.</xsl:text>
				<xsl:if test="$shownvpairs = 'true'">
				<xsl:call-template name="NewLine"/>		
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>ipaddr=&lt;text&gt;           <!--XLATESTART-->Specifies IP address of entry to view.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>index=&lt;number&gt;          <!--XLATESTART-->Specifies index of entry to view.<!--XLATESTOP-->
            </xsl:if>
			</xsl:when>
			<xsl:when test="$id = '8'">
				<xsl:text>Remote Access Card (RAC) properties.</xsl:text>
			</xsl:when>
			<xsl:when test="$id = '9'">
				<xsl:text>User properties.</xsl:text>
				<xsl:if test="$shownvpairs = 'true'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
			 <xsl:call-template name="NewLine"/>username=&lt;text&gt;     <!--XLATESTART-->Specifies user name of entry to view.<!--XLATESTOP-->
			 <xsl:call-template name="NewLine"/>index=&lt;number&gt;      <!--XLATESTART-->Specifies index of entry to view.<!--XLATESTOP-->
			</xsl:if>
			</xsl:when>
			<xsl:when test="$id = '10'">
				<xsl:text>Dial-In user properties.</xsl:text>
				<xsl:if test="$shownvpairs = 'true'">
					<xsl:call-template name="NewLine"/>	
					<xsl:call-template name="NewLine"/>	
					<xsl:text>To view a Dial-In user by index type command with index=&lt;number&gt;</xsl:text>
					<xsl:call-template name="NewLine"/>
					<xsl:text>example:	 omreport command sub-command index=0</xsl:text>
				</xsl:if>
			</xsl:when>
			<xsl:when test="$id = '11'">
				<xsl:text>Dial-Out user properties.</xsl:text>
				<xsl:if test="$shownvpairs = 'true'">
					<xsl:call-template name="NewLine"/>	
					<xsl:call-template name="NewLine"/>	
					<xsl:text>To view a Dial-Out user by index type command with index=&lt;number&gt;</xsl:text>
					<xsl:call-template name="NewLine"/>
					<xsl:text>example:	 omreport command sub-command index=0</xsl:text>
				</xsl:if>
			</xsl:when>
			<xsl:when test="$id = '12'">
				<xsl:text>SNMP trap properties.</xsl:text>
				<xsl:if test="$shownvpairs = 'true'">
				<xsl:call-template name="NewLine"/>		
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>ipaddr=&lt;text&gt;           <!--XLATESTART-->Specifies IP address of entry to view.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>index=&lt;number&gt;          <!--XLATESTART-->Specifies index of entry to view.<!--XLATESTOP-->
            </xsl:if>
			</xsl:when>
			<xsl:when test="$id = '13'">
				<xsl:text>User properties.</xsl:text>
				<xsl:if test="$shownvpairs = 'true'">
					<xsl:call-template name="NewLine"/>	
					<xsl:call-template name="NewLine"/>	
					<xsl:text>To view an user by index type command with index=&lt;number&gt;</xsl:text>
					<xsl:call-template name="NewLine"/>
					<xsl:text>example:	 omreport command sub-command index=0</xsl:text>
				</xsl:if>
			</xsl:when>
			<xsl:when test="$id = '14'">
				<xsl:text>Dial-In user properties.</xsl:text>
				<xsl:if test="$shownvpairs = 'true'">
					<xsl:call-template name="NewLine"/>	
					<xsl:call-template name="NewLine"/>	
					<xsl:text>To view by Dial-In user name type command with UserName=&lt;Text&gt; </xsl:text>
					<xsl:call-template name="NewLine"/>
					<xsl:text>example:	 omreport command sub-command UserName=John</xsl:text>
				</xsl:if>
			</xsl:when>
			<xsl:when test="$id = '15'">
				<xsl:text>Dial-Out user properties.</xsl:text>
				<xsl:if test="$shownvpairs = 'true'">
					<xsl:call-template name="NewLine"/>	
					<xsl:call-template name="NewLine"/>	
					<xsl:text>To view by Dial-Out IP address type command with IpAddr=&lt;Text&gt;</xsl:text>
					<xsl:call-template name="NewLine"/>
					<xsl:text>example:	 omreport command sub-command IpAddr=111.111.111.111</xsl:text>
				</xsl:if>
			</xsl:when>
			<xsl:when test="$id = '16'">
				<xsl:text>SNMP trap properties.</xsl:text>
				<xsl:if test="$shownvpairs = 'true'">
				<xsl:call-template name="NewLine"/>		
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>ipaddr=&lt;text&gt;           <!--XLATESTART-->Specifies IP address of entry to view.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>index=&lt;number&gt;          <!--XLATESTART-->Specifies index of entry to view.<!--XLATESTOP-->
            </xsl:if>
			</xsl:when>
			<xsl:when test="$id = '17'">
				<xsl:text>User properties.</xsl:text>
				<xsl:if test="$shownvpairs = 'true'">
					<xsl:call-template name="NewLine"/>	
					<xsl:call-template name="NewLine"/>	
					<xsl:text>To view by user name type command with UserName=&lt;Text&gt;</xsl:text>
					<xsl:call-template name="NewLine"/>
					<xsl:text>example:	 omreport command sub-command UserName=John</xsl:text>
				</xsl:if>
			</xsl:when>
			<xsl:when test="$id = '18'">
				<xsl:text>Server or CA Certificate.</xsl:text>
				<xsl:if test="$shownvpairs = 'true'">
				<xsl:call-template name="NewLine"/>		
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>type=&lt;server|ca&gt;           <!--XLATESTART-->Specifies type of certificate to view (Required).<!--XLATESTOP-->
	            </xsl:if>
			</xsl:when>
			<xsl:when test="$id = '19'">
				<xsl:text>Authentication properties.</xsl:text>
			 </xsl:when>			
			<xsl:when test="$id = '999'">
				<!--XLATETHIS-->For further help, type the command followed by -?<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id = '1000'">
			<xsl:call-template name="SuccessMsg"><xsl:with-param name="subCom"><xsl:value-of select="$nametxt"/></xsl:with-param> 
			      </xsl:call-template>
			</xsl:when>
			<xsl:when test="$id = '1001'">
				<!--XLATETHIS-->Error! Signed number expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				</xsl:when>
			<xsl:when test="$id = '1002'">
				<!--XLATETHIS-->Error! unsigned number expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1003'">
				<!--XLATETHIS-->Error! true or false expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				</xsl:when>
			<xsl:when test="$id = '1004'">
				<!--XLATETHIS-->Error! alphanumeric or symbol expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				</xsl:when>
			<xsl:when test="$id = '1005'">
				<!--XLATETHIS-->Error! Required parameter missing: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/><xsl:text>=</xsl:text>
			      <xsl:call-template name="CLIParamFormat"><xsl:with-param name="format"><xsl:value-of select="$parsetxt2"/></xsl:with-param> 
			      </xsl:call-template>
				</xsl:when>
			<xsl:when test="$id = '1006'">
				<!--XLATETHIS-->Error! At least one optional parameter must be specified.<!--XLATETHIS-->
				</xsl:when>
			<xsl:when test="$id = '1007'">
				<!--XLATETHIS-->Error! Command incomplete <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				</xsl:when>
			<xsl:when test="$id = '1008'">
				<!--XLATETHIS-->Error! Hardware or feature not present. <!--XLATETHIS-->
				</xsl:when>
			<xsl:when test="$id = '1009'">
				<!--XLATETHIS-->Error! cannot load data accessor: <!--XLATETHIS-->
				</xsl:when>
			<xsl:when test="$id = '1010'">
				<!--XLATETHIS-->Error! Index too large. Maximum for this object type is: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				</xsl:when>
			<xsl:when test="$id = '1011'">
			      <xsl:call-template name="CLICommandFailed">
					<xsl:with-param name="subCom"><xsl:value-of select="$nametxt"/></xsl:with-param> 
     					<xsl:with-param name="paramNam"><xsl:value-of select="$paramtxt"/></xsl:with-param> 
					<xsl:with-param name="parseTxt"><xsl:value-of select="$parsetxt"/></xsl:with-param> 
     					<xsl:with-param name="parseTxt2"><xsl:value-of select="$parsetxt2"/></xsl:with-param> 
					<xsl:with-param name="stat"><xsl:value-of select="$hipstat"/></xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$id = '1011'">
				<!--XLATETHIS-->Error! Hardware subsystem reports command failed. <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				</xsl:when>
			<xsl:when test="$id = '1012'">
				<!--XLATETHIS-->Error! Unrecognized parameter value: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				</xsl:when>
			<xsl:when test="$id = '1013'">
				<!--XLATESTART-->Error! Text too long: <!--XLATESTOP-->
				<xsl:value-of select="$parsetxt2"/>
			</xsl:when>

			<xsl:when test="$id = '1014'">
				<!--XLATETHIS-->Error! Value incorrect for parameter: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/><xsl:text>=</xsl:text>
				<xsl:value-of select="$parsetxt2"/>
			</xsl:when>
			<xsl:when test="$id = '1015'">
				<!--XLATETHIS-->Error! Number expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				</xsl:when>
			<xsl:when test="$id = '1016'">
				<!--XLATETHIS-->Error! Date in form mmddyy expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>		
			<xsl:when test="$id = '1017'">
				<!--XLATETHIS-->Error! Percent (0-100) expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				</xsl:when>	
			<xsl:when test="$id = '1018'">
				<!--XLATETHIS-->Error! Number with up to 1 digit after decimal point expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				</xsl:when>			
			<xsl:when test="$id = '1019'">
				<!--XLATETHIS-->Error! Number with up to 2 digits after decimal point  expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				</xsl:when>			
			<xsl:when test="$id = '1020'">
				<!--XLATETHIS-->Error! Number with up to 3 digits after decimal point  expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				</xsl:when>	
			<xsl:when test="$id = '1021'">
				<!--XLATETHIS-->Error! Month is invalid: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				</xsl:when>
			<xsl:when test="$id = '1022'">
				<!--XLATETHIS-->Error! Day is invalid: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				</xsl:when>
			<xsl:when test="$id = '1023'">
				<!--XLATETHIS-->Error! Not a leap year: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				</xsl:when>
			<xsl:when test="$id = '1024'">
				<!--XLATETHIS-->Error! Alphanumeric expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				</xsl:when>	
			<xsl:when test="$id = '1025'">
				<!--XLATETHIS-->Error! Unrecognized parameter: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				</xsl:when>
			<xsl:when test="$id = '1026'">
				<!--XLATETHIS-->Error! Cannot make date with this mmddyy on 32 bit operating system: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				</xsl:when>
			<xsl:when test="$id = '1027'">
				<!--XLATETHIS-->Error! IP Address (ddd.ddd.ddd.ddd) expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				</xsl:when>
			<xsl:when test="$id = '1028'">
				<!--XLATETHIS-->Error! Required parameter missing: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/><xsl:text>=</xsl:text>
				<xsl:value-of select="$parsetxt2"/>
				</xsl:when>
			<xsl:when test="$id = '1033'">
				<!--XLATETHIS-->Error! Text with at least one character expected.<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1040'">
				<!--XLATETHIS-->Error! Illegal combination of parameters.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id = '1044'">
				<!--XLATETHIS-->Error! Invalid Value for parameter.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id = '1101'">
				<!--XLATETHIS-->Error! Signed number or "default" expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1102'">
				<!--XLATETHIS-->Error! unsigned number or "default" expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1103'">
				<!--XLATETHIS-->Error! true or false or "default" expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1104'">
				<!--XLATETHIS-->Error! alphanumeric or symbol or "default" expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1105'">
				<!--XLATETHIS-->Error! The index parameter is invalid <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1106'">
				<!--XLATETHIS-->Error! User not found <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1107'">
				<!--XLATETHIS-->Error! Received invalid set request <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1108'">
				<!--XLATETHIS-->Error! Login attempt failed <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1109'">
				<!--XLATETHIS-->Error! Failure from card <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1110'">
				<!--XLATETHIS-->Error! RAC Service not configured <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1111'">
				<!--XLATETHIS-->Error! Received too much data <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1112'">
				<!--XLATETHIS-->Error! Omconfig command failed <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1113'">
				<!--XLATETHIS-->Error! Duplicate user entry <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '4001'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">modem</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Set modem properties.</xsl:text>
			</xsl:when>			
			<xsl:when test="$id = '4002'">
			<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">modem</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Set modem properties.</xsl:text>
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>baudrate=&lt;number&gt;         <!--XLATESTART-->Sets the baud rate for modem.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>initstring=&lt;text&gt;         <!--XLATESTART-->Sets the initialization string for modem.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>dialtype=&lt;tone, pulse&gt;    <!--XLATESTART-->Sets the dial type for modem.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>countrycode=&lt;text&gt;        <!--XLATESTART-->Sets the country code for modem.<!--XLATESTOP-->				</xsl:when>
			<xsl:when test="$id = '4011'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">dialinusers</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Set Dial-In user properties.</xsl:text>
			</xsl:when>			
			<xsl:when test="$id = '4012'">
			<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">dialinusers</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Set Dial-In user properties.</xsl:text>
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>username=&lt;text:Reqd&gt;       <!--XLATESTART-->Sets the PPP user name.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>index=&lt;number:0-15&gt;        <!--XLATESTART-->Sets the Dial-In user index to populate.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>password=&lt;text&gt;            <!--XLATESTART-->Sets the PPP password.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>callbacknumber=&lt;number&gt;    <!--XLATESTART-->Sets the callback number.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>callbacktype=&lt;text&gt;        <!--XLATESTART-->Valid options: none, preset, usr-specified.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '4021'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">dialoutusers</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Set Dial-Out user properties.</xsl:text>
			</xsl:when>			
			<xsl:when test="$id = '4022'">
			<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">dialoutusers</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Set Dial-Out user properties.</xsl:text>
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>ipaddr=&lt;text:Reqd&gt;      <!--XLATESTART-->Sets the IP address. Dot separated IP expected.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>index=&lt;number:0-15&gt;     <!--XLATESTART-->Sets the Dial-Out user index to populate.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>username=&lt;text&gt;         <!--XLATESTART-->Sets the PPP user name for a Dial-Out user.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>password=&lt;text&gt;         <!--XLATESTART-->Sets the PPP password.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>phonenumber=&lt;number&gt;    <!--XLATESTART-->Sets the phone number.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>authtype=&lt;text&gt;         <!--XLATESTART-->Valid options: any, encrypted.<!--XLATESTOP-->
					</xsl:when>
			<xsl:when test="$id = '4031'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">network</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Set network properties.</xsl:text>
			</xsl:when>			
			<xsl:when test="$id = '4032'">
					<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">network</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Set  network properties.</xsl:text>
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>ipaddr=&lt;text&gt;                 <!--XLATESTART-->Sets the IP address.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>subnetmask=&lt;text&gt;             <!--XLATESTART-->Sets subnet mask. Dot separated IP expected.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>gateway=&lt;text&gt;                <!--XLATESTART-->Sets the gateway. Dot separated IP expected.<!--XLATESTOP--><xsl:call-template name="NewLine"/>nicenable=&lt;true|false&gt;        <!--XLATESTART-->Enables the NIC.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>dhcpenable=&lt;true|false&gt;       <!--XLATESTART-->Enables DHCP.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>smtpaddr=&lt;text&gt;               <!--XLATESTART-->Sets the SMTP address. Dot separated IP expected.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>smtpenable=&lt;true|false&gt;       <!--XLATESTART-->Enables SMTP.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>dialinenable=&lt;true|false&gt;     <!--XLATESTART-->Enables Dial-In communications.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>dialindhcpenable=&lt;true|false&gt; <!--XLATESTART-->Enables the Dial-In DHCP.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>dialinipaddr=&lt;text&gt;           <!--XLATESTART-->Sets the base IP. Dot separated IP expected.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>dialinauthtype=&lt;text&gt;         <!--XLATESTART-->Valid options: any, encrypted.<!--XLATESTOP-->
					</xsl:when>
			<xsl:when test="$id = '4041'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">remote </xsl:with-param>
				</xsl:call-template>
				<xsl:text>Set remote features properties.</xsl:text>
			</xsl:when>			
			<xsl:when test="$id = '4042'">
			<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">remote</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Set remote features properties.</xsl:text>
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>floppytftpenable=&lt;true|false&gt;     <!--XLATESTART-->Enables remote boot.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>floppytftpipaddr=&lt;text&gt;           <!--XLATESTART-->Sets the floppy TFTP address.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>floppytftppath=&lt;text&gt;             <!--XLATESTART-->Sets the floppy TFTP path.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>fwupdatetftpipaddr=&lt;text&gt;         <!--XLATESTART-->Sets the firmware TFTP address.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>fwupdatetftppath=&lt;text&gt;           <!--XLATESTART-->Sets the firmware TFTP path.<!--XLATESTOP-->
							</xsl:when>
			<xsl:when test="$id = '4051'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">snmptraps</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Set SNMP trap properties.</xsl:text>
			</xsl:when>			
			<xsl:when test="$id = '4052'">
			<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">snmptraps</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Set SNMP trap properties.</xsl:text>
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>ipaddr=&lt;text: Required&gt;      <!--XLATESTART-->Sets the IP address.<!--XLATESTOP-->	
<xsl:call-template name="NewLine"/>index=&lt;number:0-15&gt;          <!--XLATESTART-->Sets the SNMP trap index to populate.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>trapsenable=&lt;true|false&gt;     <!--XLATESTART-->Enables SNMP Traps.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>community=&lt;text: Required&gt;   <!--XLATESTART-->Sets the community.<!--XLATESTOP-->
					</xsl:when>
			<xsl:when test="$id = '4061'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">users</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Set user properties.</xsl:text>
			</xsl:when>			
			<xsl:when test="$id = '4062'">
			<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">users</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Set user properties.</xsl:text>
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>username=&lt;text: Required&gt;         <!--XLATESTART-->Sets the user name.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>index=&lt;number:0-15&gt;               <!--XLATESTART-->Sets the user index to populate.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>userpassword=&lt;text&gt;               <!--XLATESTART-->Sets the password.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>numericpagingenable=&lt;true|false&gt;  <!--XLATESTART-->Enables numeric paging.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>numericpagernumber=&lt;number&gt;       <!--XLATESTART-->Sets the numeric pager number.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>numericpagermsg=&lt;text&gt;            <!--XLATESTART-->Sets the numeric pager message.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>emailpagingenable=&lt;true|false&gt;    <!--XLATESTART-->Enables Email paging.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>emailaddress=&lt;text&gt;               <!--XLATESTART-->Sets the Email address.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>emailmsg=&lt;text&gt;                   <!--XLATESTART-->Sets the Email message.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>alphapagingenable=&lt;true|false&gt;    <!--XLATESTART-->Enables alpha Paging.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>alphanumber=&lt;number&gt;              <!--XLATESTART-->Sets the alpha Number.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>alphaprotocol=&lt;8N1|7E0&gt;           <!--XLATESTART-->Sets the alpha protocol.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>alphabaudrate=&lt;number&gt;            <!--XLATESTART-->Sets the alpha baud rate.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>alphapagerid=&lt;number&gt;             <!--XLATESTART-->Sets the alpha pager ID.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>alphacustommsg=&lt;text&gt;             <!--XLATESTART-->Sets the alpha custom message.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>alphapagerpassword=&lt;text&gt;         <!--XLATESTART-->Sets the alpha pager password.<!--XLATESTOP-->
						</xsl:when>
			<xsl:when test="$id = '4071'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">rac</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Set RAC properties.</xsl:text>
			</xsl:when>
            <xsl:when test="$id = '4072'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">rac</xsl:with-param>
				</xsl:call-template>
				<xsl:text>RAC properties.</xsl:text>
			</xsl:when>
			<xsl:when test="$id = '4081'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">reset</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Set RAC reset.</xsl:text>
			</xsl:when>	
			<xsl:when test="$id = '4082'">
			<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">reset</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Set RAC reset.</xsl:text>
			</xsl:when>
			<xsl:when test="$id = '4091'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">rmdialinuser</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Remove a Dial-In user.</xsl:text>
			</xsl:when>			
			<xsl:when test="$id = '4092'">
			<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">rmdialinuser</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Remove a Dial-In user.</xsl:text>
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
			  <xsl:call-template name="NewLine"/>username=&lt;text&gt;    <!--XLATESTART-->Specifies user name of entry to delete.<!--XLATESTOP-->
			  <xsl:call-template name="NewLine"/>index=&lt;number&gt;     <!--XLATESTART-->Specifies index of entry to delete.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '5001'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">rmdialinusridx </xsl:with-param>
				</xsl:call-template>
				<xsl:text>Set a RAC Dial-In user's Properties.</xsl:text>
			</xsl:when>			
			<xsl:when test="$id = '5002'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->For command omconfig rmdialinusridx valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>	
<xsl:call-template name="NewLine"/>Index=&lt;number:required&gt;       <!--XLATESTART-->Specifies index of entry to delete<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '5011'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">rmdialoutuser</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Remove a Dial-Out user.</xsl:text>
			</xsl:when>			
			<xsl:when test="$id = '5012'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">rmdialoutuser</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Remove a Dial-Out user.</xsl:text>
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>ipaddr=&lt;text&gt;           <!--XLATESTART-->Specifies IP address of entry to delete.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>index=&lt;number&gt;          <!--XLATESTART-->Specifies index of entry to delete.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '5021'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">rmdialoutusridx</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Set a RAC Dial-Out user's properties.</xsl:text>
			</xsl:when>			
			<xsl:when test="$id = '5022'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->For command omconfig rmdialoutusridx valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>	
<xsl:call-template name="NewLine"/>Index=&lt;number:Required&gt;           <!--XLATESTART-->Specifies index of entry to delete<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '5031'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">rmsnmptrap</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Remove a SNMP trap entry.</xsl:text>
			</xsl:when>			
			<xsl:when test="$id = '5032'">
			<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">rmsnmptrap</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Remove a SNMP trap entry.</xsl:text>
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>ipaddr=&lt;text&gt;           <!--XLATESTART-->Specifies IP address of entry to delete.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>index=&lt;number&gt;          <!--XLATESTART-->Specifies index of entry to delete.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '5041'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">rmsnmptrapidx   </xsl:with-param>
				</xsl:call-template>
				<xsl:text>Set a RAC SNMP trap's properties.</xsl:text>
			</xsl:when>			
			<xsl:when test="$id = '5042'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->For command omconfig rmsnmptrapidx valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>	
<xsl:call-template name="NewLine"/>Index=&lt;number:Required&gt;           <!--XLATESTART-->Specifies index of entry to delete<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '5051'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">rmuser</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Remove a User.</xsl:text>
			</xsl:when>			
			<xsl:when test="$id = '5052'">
			<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">rmuser</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Remove a User.</xsl:text>	
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>username=&lt;text&gt;         <!--XLATESTART-->Specifies user name of entry to delete.<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>index=&lt;number&gt;          <!--XLATESTART-->Specifies index of entry to delete.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '5061'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">rmusridx       </xsl:with-param>
				</xsl:call-template>
				<xsl:text>Set a RAC user's properties.</xsl:text>
			</xsl:when>			
			<xsl:when test="$id = '5062'">
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->For command omconfig rmusridx valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>	
<xsl:call-template name="NewLine"/>Index=&lt;number:Required&gt;           <!--XLATESTART-->Specifies index of entry to delete<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '5071'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">authentication</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Set authentication properties.</xsl:text>
			</xsl:when>			
			<xsl:when test="$id = '5072'">
			<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">authentication</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Set authentication properties.</xsl:text>
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
<xsl:call-template name="NewLine"/>localauthenable=&lt;true|false&gt;           <!--XLATESTART-->Enables local operating system authentication.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '5081'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">uploadcert</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Upload server or CA certificate.</xsl:text>
			</xsl:when>			
			<xsl:when test="$id = '5082'">
			<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">uploadcert</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Upload server or CA certificate.</xsl:text>
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>file=&lt;text&gt;      <!--XLATESTART-->Specifies the absolute path of the certificate file to upload.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>type=&lt;server|ca&gt; <!--XLATESTART-->Specifies the type of certificate to upload.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '5091'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">generatecert</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Generate certificate signing request.</xsl:text>
			</xsl:when>			
			<xsl:when test="$id = '5092'">
			<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">generatecert</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Generate certificate signing request.</xsl:text>
				<xsl:call-template name="NewLine"/>	
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>commonname=&lt;text&gt;   <!--XLATESTART-->Specifies the common name attribute of the certificate.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>orgunit=&lt;text&gt;      <!--XLATESTART-->Specifies the organization unit attribute of the certificate.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>orgname=&lt;text&gt;      <!--XLATESTART-->Specifies the organization name attribute of the certificate.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>countrycode=&lt;text&gt;  <!--XLATESTART-->Specifies the country code attribute of the certificate (Upto 2 chars).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>locality=&lt;text&gt;     <!--XLATESTART-->Specifies the locality name attribute of the certificate.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>state=&lt;text&gt;        <!--XLATESTART-->Specifies the state name attribute of the certificate.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>emailaddress=&lt;text&gt; <!--XLATESTART-->Specifies the E-mail address attribute of the certificate.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>file=&lt;text&gt;         <!--XLATESTART-->Specifies the absolute path of the certificate file to generate.<!--XLATESTOP-->
			</xsl:when>
			<xsl:otherwise>
			<!--XLATETHIS-->Error! RAC error. Hardware or feature not ready. <!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:call-template name="NewLine"/>
	</xsl:template>
	<xsl:template name="CLIParamFormat">
		<xsl:param name="format"/>
		<xsl:choose>
			<xsl:when test="$format = '1'">
			     <xsl:text>text</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '2'">
			     <xsl:text>text</xsl:text>
			</xsl:when>			
			<xsl:when test="$format = '3'">
			     <xsl:text>text (alphanumeric only)</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '4'">
			     <xsl:text>number</xsl:text>
			</xsl:when>	
			<xsl:when test="$format = '5'">
			     <xsl:text>&lt;true|false&gt;</xsl:text>
			</xsl:when>			
			<xsl:when test="$format = '6'">
			     <xsl:text>number</xsl:text>
			</xsl:when>				
			<xsl:when test="$format = '7'">
			     <xsl:text>number</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '8'">
			     <xsl:text>d.d</xsl:text>
			</xsl:when>			
			<xsl:when test="$format = '9'">
			     <xsl:text>number</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '10'">
			     <xsl:text>date</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '19'">
			     <xsl:text>percent (0-100)</xsl:text>
			</xsl:when>			
			<xsl:otherwise>
				<!--XLATESTART-->value<!--XLATESTOP-->			
                    </xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="CLISubCommand">
		<xsl:param name="command"/>
		<xsl:if test="$command != ''">
			<xsl:value-of select="$command"/>
			<xsl:call-template name="Spaces">
				<xsl:with-param name="num"><xsl:value-of select="(17) - string-length($command)"/></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<xsl:template name="CLICommandFailed">
		<xsl:param name="subCom"/>
		<xsl:param name="paramNam"/>
		<xsl:param name="parseTxt"/>
		<xsl:param name="parseTxt2"/>		
		<xsl:param name="stat"/>
		<xsl:choose>
			<xsl:when test="$subCom = 'rmuser'">
				<xsl:choose>
					<xsl:when test="$stat = '1058'">
				     		<xsl:text>Error! index parameter invalid. </xsl:text>
					</xsl:when>
					<xsl:when test="$stat = '256'">
				     		<xsl:text>Error! User not found. </xsl:text>
					</xsl:when>
					<xsl:otherwise>
				     		<xsl:text>Error! omconfig command failed. </xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$subCom = 'rmdialinuser'">
				<xsl:choose>
					<xsl:when test="$stat = '256'">
				     		<xsl:text>Error! User not found. </xsl:text>
					</xsl:when>
					<xsl:when test="$stat = '1073'">
				     		<xsl:text>Error! index parameter invalid. </xsl:text>
					</xsl:when>
					<xsl:otherwise>
				     		<xsl:text>Error! omconfig command failed. </xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$subCom = 'rmdialoutuser'">
				<xsl:choose>
					<xsl:when test="$stat = '256'">
				     		<xsl:text>Error! User not found. </xsl:text>
					</xsl:when>
					<xsl:when test="$stat = '1073'">
				     		<xsl:text>Error! index parameter invalid. </xsl:text>
					</xsl:when>
					<xsl:otherwise>
				     		<xsl:text>Error! omconfig command failed. </xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$subCom = 'rmsnmptrap'">
				<xsl:choose>
					<xsl:when test="$stat = '256'">
				     		<xsl:text>Error! IP Address not found. </xsl:text>
					</xsl:when>
					<xsl:when test="$stat = '1073'">
				     		<xsl:text>Error! index parameter invalid. </xsl:text>
					</xsl:when>
					<xsl:otherwise>
				     		<xsl:text>Error! omconfig command failed. </xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$subCom = 'users'">
				<xsl:choose>
					<xsl:when test="$stat = '271'">
				     		<xsl:text>Error! New user cannot be created without a password. </xsl:text>
					</xsl:when>
					<xsl:when test="$stat = '256'">
				     		<xsl:text>Error! User already exists either with the same username or index.</xsl:text>
					</xsl:when>
					<xsl:otherwise>
				     		<xsl:text>Error! omconfig command failed. </xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$subCom = 'dialinusers'">
				<xsl:choose>
					<xsl:when test="$stat = '271'">
				     		<xsl:text>Error! New dial-in user cannot be created without a password. </xsl:text>
					</xsl:when>
					<xsl:when test="$stat = '257'">
				     		<xsl:text>Error! User already exists either with the same username or index. </xsl:text>
					</xsl:when>
					<xsl:when test="$stat = '258'">
				     		<xsl:text>Error! User already exists either with the same username or index. </xsl:text>
					</xsl:when>
					<xsl:when test="$stat = '290'">
				     		<xsl:text>Error! Index too large. Maximum for this object type is: 15. </xsl:text>
					</xsl:when>
					<xsl:otherwise>
				     		<xsl:text>Error! omconfig command failed. </xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$subCom = 'authentication'">
				<xsl:choose>
					<xsl:when test="$stat = '9999'">
				     		<xsl:text>Local OS authentication is not supported for Firmware version 3.20 or above </xsl:text>
					</xsl:when>
					<xsl:otherwise>
				     		<xsl:text>Error! omconfig command failed. </xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>Error! omconfig command failed. </xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template >
	<xsl:template name="Spaces">
		<xsl:param name="num"/>
		<xsl:choose>
			<xsl:when test="$num = '16'">
				<xsl:text>                </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '15'">
				<xsl:text>               </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '14'">
				<xsl:text>              </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '13'">
				<xsl:text>             </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '12'">
				<xsl:text>            </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '11'">
				<xsl:text>           </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '10'">
				<xsl:text>          </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '9'">
				<xsl:text>         </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '8'">
				<xsl:text>        </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '7'">
				<xsl:text>       </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '6'">
				<xsl:text>      </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '5'">
				<xsl:text>     </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '4'">
				<xsl:text>    </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '3'">
				<xsl:text>   </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '2'">
				<xsl:text>  </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '1'">
				<xsl:text> </xsl:text>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="NewLine">
		<xsl:text>
</xsl:text>
	</xsl:template>
	<xsl:template name="SuccessMsg">
		<xsl:param name="subCom"/>
		<xsl:choose>
			<xsl:when test="$subCom = 'reset'">
			    <!--XLATETHIS-->Command Successful. This operation caused the remote hardware to reset.<!--XLATETHIS-->
<xsl:call-template name="NewLine"/><!--XLATETHIS-->Do not set any additional attributes in the next minute.<!--XLATETHIS--> 
<xsl:call-template name="NewLine"/><!--XLATETHIS-->Communication with the remote hardware is being re-established.<!--XLATETHIS-->
			</xsl:when>
<xsl:when test="$subCom = 'generatecert'">
		  <!--XLATETHIS-->Command Successful.<!--XLATETHIS-->
		  </xsl:when>
		  <xsl:when test="$subCom = 'uploadcert'">
		  <!--XLATETHIS-->Command Successful. Reset RAC card!<!--XLATETHIS-->
		  </xsl:when>
              <xsl:when test="$subCom = 'authentication'">
		  <!--XLATETHIS-->Command Successful.<!--XLATETHIS-->
		  </xsl:when>
			<xsl:otherwise>
				<!--XLATESTART-->Command Successful. Reset RAC card!<!--XLATESTOP-->
                    </xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
