<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text" indent="no"/>
	<xsl:strip-space elements="*"/>

	<xsl:variable name="subCommandIndentSize">17</xsl:variable>

	<xsl:template match="/OMA">
		<xsl:call-template name="CLISubCommand">
			<xsl:with-param name="command"><xsl:value-of select="CLISubCommand"/></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="CLIMsgID">
			<xsl:with-param name="id"><xsl:value-of select="CLIMsgID"/></xsl:with-param>
			<xsl:with-param name="shownvpairs"><xsl:value-of select="CLIShowNVPairs"/></xsl:with-param>
			<xsl:with-param name="nametxt">
				<xsl:value-of select="CLIParseName"/>
			</xsl:with-param>
			<xsl:with-param name="paramtxt">
				<xsl:value-of select="CLIParamName"/>
			</xsl:with-param>
			<xsl:with-param name="parsetxt">
				<xsl:value-of select="CLIParseTxt"/>
			</xsl:with-param>
			<xsl:with-param name="parsetxt2">
				<xsl:value-of select="CLIParseTxt2"/>
			</xsl:with-param>
			<xsl:with-param name="hipstat">
				<xsl:value-of select="CustomStat"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<xsl:template match="/leds">
		<xsl:call-template name="CLISubCommand">
			<xsl:with-param name="command">leds</xsl:with-param>
		</xsl:call-template>
		<!--XLATESTART-->LED configuration.<!--XLATESTOP-->
		<xsl:call-template name="NewLine"/>
		<xsl:apply-templates select="ChassisInfo">
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template match="ChassisInfo">
		<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
		<xsl:call-template name="NewLine"/>
		<xsl:text>index=&lt;number&gt;   </xsl:text><!--XLATESTART-->Chassis index (defaults to 0, main system chassis).<!--XLATESTOP-->
		<xsl:call-template name="NewLine"/>
  		    <xsl:text>led=fault        severity=&lt;warning|critical&gt; Flash on failure level.</xsl:text>
		    <xsl:call-template name="NewLine"/>
			<xsl:text>led=hdfault      action=clear                Clear hard disk fault LED.</xsl:text>
		     <xsl:call-template name="NewLine"/>
		    <xsl:text>led=identify     flash=&lt;off|on&gt;              Flash chassis identify LED.</xsl:text>
		    <xsl:call-template name="NewLine"/>
    		    <xsl:text>                 timeout=&lt;number&gt;            Flash timeout value ( &gt;0 seconds).</xsl:text>
     		<xsl:call-template name="NewLine"/>
	</xsl:template>

	<xsl:template match="/ChassisData">
			<xsl:call-template name="CLISubCommand">
				<xsl:with-param name="command">info</xsl:with-param>
			</xsl:call-template>
			<!--XLATESTART-->Set chassis information.<!--XLATESTOP-->
			<xsl:call-template name="NewLine"/>
			<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
			<xsl:call-template name="NewLine"/>
			<xsl:text>index=&lt;number&gt;   </xsl:text><!--XLATESTART-->Chassis index (defaults to 0, main system chassis).<!--XLATESTOP-->
			<xsl:call-template name="NewLine"/>
               <xsl:text>tag=&lt;text&gt;       </xsl:text><!--XLATESTART-->Asset tag value (up to 10 chars, alphanumeric text only). <!--XLATESTOP-->
               <xsl:call-template name="NewLine"/>
			<xsl:for-each select="ChassisList/Chassis/ChassisInfo/BaseBoardList/BaseBoard">
			    <xsl:choose>
		            	<xsl:when test="BaseBoardType=&apos;11&apos;">
		                	<xsl:text>pmmtag=&lt;text&gt;    </xsl:text><!--XLATESTART-->Processor Memory Module tag value.<!--XLATESTOP-->
		                	<xsl:call-template name="NewLine"/>
				   	</xsl:when>
		            	<xsl:when test="BaseBoardType=&apos;12&apos;">
		               	<xsl:text>iomtag=&lt;text&gt;    </xsl:text><!--XLATESTART-->Processor I/O Module tag value.<!--XLATESTOP-->
		               	<xsl:call-template name="NewLine"/>
				   	</xsl:when>
		         </xsl:choose>
			</xsl:for-each>
			<xsl:for-each select="ChassisList/Chassis/ChassisInfo/BaseBoardList/BaseBoard[BaseBoardType=&apos;2&apos;] ">
		     	<xsl:choose>
	            		<xsl:when test="position() = 1">
	               		<xsl:text>dsm0tag=&lt;text&gt;   </xsl:text><!--XLATESTART-->Data Storage Module 0 tag value.<!--XLATESTOP-->
	               		<xsl:call-template name="NewLine"/>
			   		</xsl:when>
	            		<xsl:when test="position() = 2">
	               		<xsl:text>dsm1tag=&lt;text&gt;   </xsl:text><!--XLATESTART-->Data Storage Module 1 tag value.<!--XLATESTOP-->
	               		<xsl:call-template name="NewLine"/>
			   		</xsl:when>
	            		<xsl:when test="position() = 3">
		               	<xsl:text>dsm2tag=&lt;text&gt;   </xsl:text><!--XLATESTART-->Data Storage Module 2 tag value.<!--XLATESTOP-->
		               	<xsl:call-template name="NewLine"/>
			   		</xsl:when>
	         		</xsl:choose>
			</xsl:for-each>
			<xsl:text>name=&lt;text&gt;      </xsl:text><!--XLATESTART-->Set chassis name.<!--XLATESTOP-->
		     <xsl:call-template name="NewLine"/>
	</xsl:template>

  <xsl:template match="/MainSystemData">
    <xsl:call-template name="CLISubCommand">
      <xsl:with-param name="command">info</xsl:with-param>
    </xsl:call-template>
    <!--XLATESTART-->Set main system information.<!--XLATESTOP-->
    <xsl:call-template name="NewLine"/>
    <!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
    <xsl:call-template name="NewLine"/>
    <xsl:text>index=&lt;number&gt;   </xsl:text><!--XLATESTART-->Main system index (defaults to 0, main system).<!--XLATESTOP-->
    <xsl:call-template name="NewLine"/>
    <xsl:text>tag=&lt;text&gt;       </xsl:text><!--XLATESTART-->Asset tag value (up to 10 chars, alphanumeric text only). <!--XLATESTOP-->
    <xsl:call-template name="NewLine"/>
    <xsl:for-each select="ChassisList/Chassis/ChassisInfo/BaseBoardList/BaseBoard">
      <xsl:choose>
        <xsl:when test="BaseBoardType=&apos;11&apos;">
          <xsl:text>pmmtag=&lt;text&gt;    </xsl:text><!--XLATESTART-->Processor Memory Module tag value.<!--XLATESTOP-->
          <xsl:call-template name="NewLine"/>
        </xsl:when>
        <xsl:when test="BaseBoardType=&apos;12&apos;">
          <xsl:text>iomtag=&lt;text&gt;    </xsl:text><!--XLATESTART-->Processor I/O Module tag value.<!--XLATESTOP-->
          <xsl:call-template name="NewLine"/>
        </xsl:when>
      </xsl:choose>
    </xsl:for-each>
    <xsl:for-each select="ChassisList/Chassis/ChassisInfo/BaseBoardList/BaseBoard[BaseBoardType=&apos;2&apos;] ">
      <xsl:choose>
        <xsl:when test="position() = 1">
          <xsl:text>dsm0tag=&lt;text&gt;   </xsl:text><!--XLATESTART-->Data Storage Module 0 tag value.<!--XLATESTOP-->
          <xsl:call-template name="NewLine"/>
        </xsl:when>
        <xsl:when test="position() = 2">
          <xsl:text>dsm1tag=&lt;text&gt;   </xsl:text><!--XLATESTART-->Data Storage Module 1 tag value.<!--XLATESTOP-->
          <xsl:call-template name="NewLine"/>
        </xsl:when>
        <xsl:when test="position() = 3">
          <xsl:text>dsm2tag=&lt;text&gt;   </xsl:text><!--XLATESTART-->Data Storage Module 2 tag value.<!--XLATESTOP-->
          <xsl:call-template name="NewLine"/>
        </xsl:when>
      </xsl:choose>
    </xsl:for-each>
    <xsl:text>name=&lt;text&gt;      </xsl:text><!--XLATESTART-->Set main system name.<!--XLATESTOP-->
    <xsl:call-template name="NewLine"/>
  </xsl:template>

  <xsl:template match="/biossetup">
	     <xsl:if test="BIOSSetupListCount != &apos;0&apos;">
			<xsl:call-template name="CLISubCommand">
				<xsl:with-param name="command">biossetup</xsl:with-param>
			</xsl:call-template>
			<!--XLATESTART-->Configure BIOS setup.<!--XLATESTOP-->
			<xsl:call-template name="NewLine"/>
			<!--XLATESTART-->NOTE: Changing onboardraid or primaryscsi or ide attributes can make your<!--XLATESTOP--><xsl:call-template name="NewLine"/>
<!--XLATESTART-->      system inoperable or require an operating system reinstall<!--XLATESTOP-->
			<xsl:call-template name="NewLine"/>
			<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
			<xsl:call-template name="NewLine"/>
			<xsl:for-each select="BIOSSetupList/BIOSSetup">
				<xsl:choose>
					<xsl:when test="@objtype = &apos;240&apos;">
						<xsl:text>attribute=numlock        setting=&lt;on|off&gt;</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
			           	<xsl:when test="@objtype = &apos;241&apos;">
			        		<xsl:text>attribute=diskette       setting=&lt;off|auto|writeprotect&gt;</xsl:text>
				 		<xsl:call-template name="NewLine"/>
				     </xsl:when>
			          <xsl:when test="@objtype = &apos;242&apos;">
						<xsl:text>attribute=</xsl:text>
						<xsl:choose>
                <xsl:when test="ObjName = &apos;NIC&apos;">
								<xsl:text>nic </xsl:text>
							</xsl:when>
                <xsl:when test="ObjName = &apos;NIC 1&apos;">
								<xsl:text>nic1</xsl:text>
							</xsl:when>
              <xsl:when test="ObjName = &apos;NIC 2&apos;">
                <xsl:text>nic2</xsl:text>
              </xsl:when>
              <xsl:when test="ObjName = &apos;NIC 3&apos;">
                <xsl:text>nic3</xsl:text>
              </xsl:when>
              <xsl:when test="ObjName = &apos;NIC 4&apos;">
                <xsl:text>nic4</xsl:text>
              </xsl:when>
	    			</xsl:choose>
						<xsl:text>           setting=&lt;disabled|enabled|enabledwithpxe|enabledonly|enablednonepxe|enabledwithiscsi&gt;</xsl:text>
				 		<xsl:call-template name="NewLine"/>
					</xsl:when>
			           <xsl:when test="@objtype = &apos;243&apos;">
						<xsl:text>attribute=mouse          setting=&lt;on|off&gt;</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
		        	   	<xsl:when test="@objtype = &apos;244&apos;">
						<xsl:text>attribute=usb            setting=&lt;enabled|disabled&gt;</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
			           <xsl:when test="@objtype = &apos;260&apos;">
						<xsl:text>attribute=usbb           setting=&lt;enabled|enabledwithbios|disabled&gt;</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
		           	<xsl:when test="@objtype = &apos;245&apos;">
						<xsl:text>attribute=ide            setting=&lt;on|off&gt;  force=&lt;true&gt;</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
			          <xsl:when test="@objtype = &apos;246&apos;">
						<xsl:choose>
				         	    	<!--xsl:when test=&quot;ObjName=&apos;OnBoard RAID&apos;&quot;&gt;
						    		&lt;xsl:text&gt;attribute=onboardraid    setting=&lt;raid|off|scsi&gt;  force=&lt;true&gt;&lt;/xsl:text&gt;
								&lt;xsl:call-template name=&quot;NewLine&quot;/&gt;
							&lt;/xsl:when-->
						     <xsl:when test="ObjName=&apos;Primary SCSI&apos;">
							    	  <xsl:text>attribute=primaryscsi    setting=&lt;on|off&gt;  force=&lt;true&gt;</xsl:text>
								<xsl:call-template name="NewLine"/>
							</xsl:when>
						     <xsl:when test="ObjName=&apos;Secondary SCSI&apos;">
								<xsl:text>attribute=secondaryscsi  setting=&lt;on|off&gt;</xsl:text>
								<xsl:call-template name="NewLine"/>
							</xsl:when>
						</xsl:choose>
					</xsl:when>
			           <xsl:when test="@objtype = &apos;247&apos;">
						<xsl:text>attribute=bootsequence   setting=&lt;</xsl:text>
						<xsl:if test="Capabilities/DisketteFirst=&apos;true&apos; ">
							<xsl:text>diskettefirst</xsl:text>
						</xsl:if>
						<xsl:if test="Capabilities/HDOnly=&apos;true&apos;">
							<xsl:if test="Capabilities/DisketteFirst=&apos;true&apos; "><!--XLATESTART-->|<!--XLATESTOP-->
							</xsl:if>
							<xsl:text>hdonly</xsl:text>
						</xsl:if>
						<xsl:if test="Capabilities/DeviceList=&apos;true&apos;">
							<xsl:if test="(Capabilities/DisketteFirst=&apos;true&apos;) or  (Capabilities/HDOnly=&apos;true&apos;)"><!--XLATESTART-->|<!--XLATESTOP-->
							</xsl:if>
							<xsl:text>devicelist</xsl:text>
						</xsl:if>
						<xsl:if test="Capabilities/CDRomFirst=&apos;true&apos;">
							<xsl:if test="(Capabilities/DisketteFirst=&apos;true&apos;) or  (Capabilities/HDOnly=&apos;true&apos;) or (Capabilities/DeviceList=&apos;true&apos;)"><!--XLATESTART-->|<!--XLATESTOP-->
    							</xsl:if>
							<xsl:text>cdromfirst</xsl:text>
						</xsl:if>
						<xsl:text>&gt;</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
		           		<xsl:when test="@objtype = &apos;249&apos;">
						<xsl:text>attribute=ppaddress      setting=&lt;off|lpt1|lpt2|lpt3&gt;</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
			           	<xsl:when test="@objtype = &apos;250&apos;">
						<xsl:text>attribute=ppmode         setting=&lt;</xsl:text>
						<xsl:if test="Capabilities/AT=&apos;true&apos; ">
							<xsl:text>at</xsl:text>
						</xsl:if>
						<xsl:if test="Capabilities/PS2=&apos;true&apos; ">
							<xsl:text>|ps2</xsl:text>
						</xsl:if>
						<xsl:if test="Capabilities/ECP=&apos;true&apos; ">
							<xsl:text>|ecp</xsl:text>
						</xsl:if>
						<xsl:if test="Capabilities/EPP=&apos;true&apos; ">
							<xsl:text>|epp</xsl:text>
						</xsl:if>
						<xsl:text>&gt;</xsl:text>
					      <xsl:call-template name="NewLine"/>
					</xsl:when>
		        	   	<xsl:when test="@objtype = &apos;251&apos;">
						<xsl:choose>
				           	<xsl:when test="ObjName=&apos;Serial Port 1&apos;">
								<xsl:text>attribute=serialport1    setting=&lt;off|auto|com1|com3|bmcserial|bmcnic|rac|com1bmc&gt;</xsl:text>
								<xsl:call-template name="NewLine"/>
							</xsl:when>
				           	<xsl:when test="ObjName=&apos;Serial Port 2&apos;">
								<xsl:text>attribute=serialport2    setting=&lt;off|auto|com2|com4&gt;</xsl:text>
								<xsl:call-template name="NewLine"/>
							</xsl:when>
						</xsl:choose>
					</xsl:when>
		           	<xsl:when test="@objtype = &apos;252&apos;">
						<xsl:text>attribute=speaker        setting=&lt;on|off&gt;</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
		           	<xsl:when test="@objtype = &apos;253&apos;">
						<xsl:text>attribute=wakeonlan      setting=&lt;disable|expansion|onboard|addin&gt;</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
               		<xsl:when test="@objtype = &apos;261&apos;">
						<xsl:text>attribute=intrusion      setting=&lt;disable|enable&gt;</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
               		<xsl:when test="@objtype = &apos;262&apos;">
						<xsl:text>attribute=bezel          setting=&lt;disable|enable&gt;</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
		           	<xsl:when test="@objtype = &apos;263&apos;">
						 <xsl:text>attribute=romb           setting=&lt;off|raid|scsi&gt;  force=&lt;true&gt;</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<!--For Dual NIC -->
					<xsl:when test="@objtype = &apos;265&apos;">
            <xsl:text>attribute=</xsl:text>
            <xsl:choose>
              <xsl:when test="ObjName = &apos;Dual NIC&apos;">
                <xsl:text>dualnic </xsl:text>
              </xsl:when>
              <xsl:when test="ObjName = &apos;Dual NIC (1/2)&apos;">
                <xsl:text>dualnic1 </xsl:text>
              </xsl:when>
              <xsl:when test="ObjName = &apos;Dual NIC (3/4)&apos;">
                <xsl:text>dualnic2 </xsl:text>
              </xsl:when>
            </xsl:choose>
            <xsl:text>               setting=&lt;off|on|pxeboth|nic1pxe|nic2pxe|iscsiboth|nic1iscsi|nic2iscsi|nic1pxenic2iscsi|nic1iscsinic2pxe&gt;</xsl:text>
            <xsl:call-template name="NewLine"/>
            <xsl:text>                         Deprecated options: onpxenone, onpxeboth, onpxenic1, onpxenic2</xsl:text>
            <xsl:call-template name="NewLine"/>
					</xsl:when>
					<!--For Console Redirection -->
					<xsl:when test="@objtype = &apos;267&apos;">
						<xsl:text>attribute=conredirect    setting=&lt;disable|enable|com2|bmcnic|drac/mc&gt;</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<!--For AC Power Recovery Mode -->
					<xsl:when test="@objtype = &apos;368&apos;">
						<xsl:text>attribute=acpwrrecovery  setting=&lt;off|last|on&gt;</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>

					<!--For DBPM -->
					<xsl:when test="@objtype = &apos;372&apos;">
						<xsl:text>attribute=dbpm           setting=&lt;disabled|enabled&gt;</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<!--For CRAB -->
					<xsl:when test="@objtype = &apos;374&apos;">
						<xsl:text>attribute=crab           setting=&lt;disabled|enabled&gt;</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<!--For User Accessible USB Ports -->
					<xsl:when test="@objtype = &apos;375&apos;">
						<xsl:text>attribute=uausb          setting=&lt;on|backonly|off&gt;</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<!--For Serial Communication -->
					<xsl:when test="@objtype = &apos;378&apos;">
						<xsl:text>attribute=serialcom      setting=&lt;off|on|com1|com2&gt;</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<!--For External Serial Connector -->
					<xsl:when test="@objtype = &apos;379&apos;">
						<xsl:text>attribute=extserial      setting=&lt;com1|com2|rad&gt;</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<!--For CPU Virtualiztion Technology -->
					<xsl:when test="@objtype = &apos;380&apos;">
						<xsl:text>attribute=cpuvt          setting=&lt;disabled|enabled&gt;</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<!--For CPU HyperThreading -->
					<xsl:when test="@objtype = &apos;381&apos;">
						<xsl:text>attribute=cpuht          setting=&lt;disabled|enabled&gt;</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>

					<!--For Console Redirection FailSafe BAUD Rate -->
					<xsl:when test="@objtype = &apos;271&apos;">
						<xsl:text>attribute=fbr		 setting=&lt;115200|57600|19200|9600&gt;</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
		           	<xsl:when test="@objtype = &apos;264&apos;">
						<xsl:choose>
				           	<xsl:when test="ObjName=&apos;RAID Channel A&apos; and Capabilities/Rdonly=&apos;false&apos;">
						 		<xsl:text>attribute=romba          setting=&lt;raid|scsi&gt;  force=&lt;true&gt;</xsl:text>
								<xsl:call-template name="NewLine"/>
					     	</xsl:when>
				           	<xsl:when test="ObjName=&apos;RAID Channel B&apos; and Capabilities/Rdonly=&apos;false&apos;">
						 		<xsl:text>attribute=rombb      setting=&lt;raid|scsi&gt;  force=&lt;true&gt;</xsl:text>
								<xsl:call-template name="NewLine"/>
					     	</xsl:when>
						</xsl:choose>
					</xsl:when>
          <!--For Internal USB-->
          <xsl:when test="@objtype = &apos;454&apos;">
            <xsl:text>attribute=intusb         setting=&lt;disabled|enabled&gt;</xsl:text>
            <xsl:call-template name="NewLine"/>
          </xsl:when>

          <!--For Embedder Hyper Visor-->
          <xsl:when test="@objtype = &apos;455&apos;">
            <xsl:text>attribute=embhypvisor    setting=&lt;disabled|enabled&gt;</xsl:text>
            <xsl:call-template name="NewLine"/>
          </xsl:when>

          <!--For Optical Drive Controller-->
          <xsl:when test="@objtype = &apos;456&apos;">
            <xsl:text>attribute=optdrvclr      setting=&lt;disabled|enabled&gt;</xsl:text>
            <xsl:call-template name="NewLine"/>
          </xsl:when>
          
				</xsl:choose>
			</xsl:for-each>

			<xsl:apply-templates select="BIOSSetupList/BIOSSetup[ @objtype = 369][1]"/>
			<xsl:apply-templates select="BIOSSetupList/BIOSSetup[ @objtype = 370][1]"/>
			<xsl:apply-templates select="BIOSSetupList/BIOSSetup[ @objtype = 371][1]"/>

		</xsl:if>
	     <xsl:if test="BIOSSetupListCount = &apos;0&apos;">
			<xsl:text>Error! BIOS setup feature unavailable on this system.</xsl:text>
			<xsl:call-template name="NewLine"/>
		</xsl:if>
	</xsl:template>

     <xsl:template match="/biossetup/BIOSSetupList/BIOSSetup">
		<xsl:choose>
			<xsl:when test="@objtype=369">
						    <xsl:text>attribute=sata           setting=&lt;off|ata|qdma|raid&gt;</xsl:text>
						    <xsl:call-template name="NewLine"/>
			</xsl:when>
			<!--For SATA Port -->
			<xsl:when test="@objtype = &apos;370&apos;">
				<xsl:text>attribute=sataport[0..7, a..h] setting=&lt;off|auto&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<!--For IDE Primary Drive -->
			<xsl:when test="@objtype = &apos;371&apos;">
				<xsl:text>attribute=idepridrv[0..1] setting=&lt;off|auto&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
		</xsl:choose>
    </xsl:template>


	<xsl:template name="CLIMsgID">
		<xsl:param name="id"/>
		<xsl:param name="shownvpairs"/>
		<xsl:param name="paramtxt"/>
		<xsl:param name="nametxt"/>
		<xsl:param name="parsetxt"/>
		<xsl:param name="parsetxt2"/>
		<xsl:param name="hipstat"/>
		<xsl:choose>
			<xsl:when test="$id = &apos;1&apos;">
				<!--XLATESTART-->AC switch settings.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;2&apos;">
				<!--XLATESTART-->BIOS properties.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;3&apos;">
				<!--XLATESTART-->BIOS setup configuration.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;4&apos;">
				<!--XLATESTART-->Chassis properties.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;5&apos;">
				<!--XLATESTART-->Current probe(s) properties.<!--XLATESTOP-->
				<xsl:if test="$shownvpairs = &apos;true&apos;">
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>index=&lt;number&gt;	 </xsl:text><!--XLATESTART-->Displays properties for a particular current probe.<!--XLATESTOP-->
				</xsl:if>
			</xsl:when>
			<xsl:when test="$id = &apos;6&apos;">
				<!--XLATESTART-->Fan probe(s) properties.<!--XLATESTOP-->
				<xsl:if test="$shownvpairs = &apos;true&apos;">
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>index=&lt;number&gt;	 </xsl:text><!--XLATESTART-->Displays properties for a particular fan probe.<!--XLATESTOP-->
				</xsl:if>
			</xsl:when>
			<xsl:when test="$id = &apos;7&apos;">
				<!--XLATESTART-->Firmware properties.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;8&apos;">
				<!--XLATESTART-->Chassis intrusion status.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;9&apos;">
				<!--XLATESTART-->System memory configuration.<!--XLATESTOP-->
				<xsl:if test="$shownvpairs = &apos;true&apos;">
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>index=&lt;number&gt;	 </xsl:text><!--XLATESTART-->Displays memory device properties for a particular connector.<!--XLATESTOP-->
				</xsl:if>
			</xsl:when>
			<xsl:when test="$id = &apos;10&apos;">
				<!--XLATESTART-->Network interface card(s) properties.<!--XLATESTOP-->
				<xsl:if test="$shownvpairs = &apos;true&apos;">
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>index=&lt;number&gt;	 </xsl:text><!--XLATESTART-->Displays network card details for a particular card.<!--XLATESTOP-->
				</xsl:if>
			</xsl:when>
			<xsl:when test="$id = &apos;11&apos;">
				<!--XLATESTART-->Port(s) properties.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;12&apos;">
				<!--XLATESTART-->Processor(s) properties.<!--XLATESTOP-->
				<xsl:if test="$shownvpairs = &apos;true&apos;">
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>index=&lt;number&gt;	 </xsl:text><!--XLATESTART-->Displays cache details for a particular processor.<!--XLATESTOP-->
				</xsl:if>
			</xsl:when>
			<xsl:when test="$id = &apos;13&apos;">
				<!--XLATESTART-->Power supply(s) properties.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;14&apos;">
				<!--XLATESTART-->Slot(s) properties.<!--XLATESTOP-->
				<xsl:if test="$shownvpairs = &apos;true&apos;">
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>index=&lt;number&gt;	 </xsl:text><!--XLATESTART-->Displays adapter details for a particular slot.<!--XLATESTOP-->
				</xsl:if>
			</xsl:when>
			<xsl:when test="$id = &apos;15&apos;">
				<!--XLATESTART-->Chassis properties summary.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;16&apos;">
				<!--XLATESTART-->Temperature probe(s) properties.<!--XLATESTOP-->
				<xsl:if test="$shownvpairs = &apos;true&apos;">
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>index=&lt;number&gt;	 </xsl:text><!--XLATESTART-->Displays properties for a particular temperature probe.<!--XLATESTOP-->
				</xsl:if>
			</xsl:when>
			<xsl:when test="$id = &apos;17&apos;">
				<!--XLATESTART-->Voltage probe(s) properties.<!--XLATESTOP-->
				<xsl:if test="$shownvpairs = &apos;true&apos;">
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>index=&lt;number&gt;	 </xsl:text><!--XLATESTART-->Displays properties for a particular voltage probe.<!--XLATESTOP-->
				</xsl:if>
			</xsl:when>
			<xsl:when test="$id = &apos;18&apos;">
				<!--XLATESTART-->Port(s) properties.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;19&apos;">
				<!--XLATESTART-->Slot(s) properties.<!--XLATESTOP-->
				<xsl:if test="$shownvpairs = &apos;true&apos;">
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>index=&lt;number&gt;	 </xsl:text><!--XLATESTART-->Displays slot details for a particular slot.<!--XLATESTOP-->
				</xsl:if>
			</xsl:when>
			<xsl:when test="$id = &apos;20&apos;">
				<!--XLATESTART-->Chassis component properties.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;21&apos;">
				<!--XLATESTART-->Chassis asset tag value.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;22&apos;">
				<!--XLATESTART-->Fan control settings.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;23&apos;">
				<!--XLATESTART-->Front panel button control settings.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;24&apos;">
				<!--XLATESTART-->Chassis component properties.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;25&apos;">
				<!--XLATESTART-->Chassis LED settings.<!--XLATESTOP-->
				<xsl:if test="$shownvpairs = &apos;true&apos;">
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>index=&lt;number&gt;	 </xsl:text><!--XLATESTART-->Chassis index (defaults to 0).<!--XLATESTOP-->
				</xsl:if>
			</xsl:when>
			<xsl:when test="$id = &apos;26&apos;">
				<!--XLATESTART-->Chassis information.<!--XLATESTOP-->
				<xsl:if test="$shownvpairs = &apos;true&apos;">
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>index=&lt;number&gt;	 </xsl:text><!--XLATESTART-->Displays properties for a particular chassis.<!--XLATESTOP-->
				</xsl:if>
			</xsl:when>
			<xsl:when test="$id = &apos;32&apos;">
				<!--XLATESTART-->Modular Enclosure information.<!--XLATESTOP-->
			</xsl:when>
      		<xsl:when test="$id = &apos;34&apos;">
       			<!--XLATESTART-->Chassis component properties.<!--XLATESTOP-->
        			<xsl:call-template name="printSubcommandDeprecatedExt">
          			<xsl:with-param name="newCommand">mainsystem</xsl:with-param>
          			<xsl:with-param name="standalone">false</xsl:with-param>
        			</xsl:call-template>
     		</xsl:when>
			<xsl:when test="$id = &apos;24&apos;">
					<!--XLATESTART-->Mains system component properties.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;27&apos;">
				<!--XLATESTART-->Remote Access information.<!--XLATESTOP-->
				<xsl:call-template name="printSubcommandDeprecated">
					<xsl:with-param name="newCommand">remoteaccess</xsl:with-param>
					<xsl:with-param name="standalone"><xsl:value-of select="$shownvpairs"/></xsl:with-param>
				</xsl:call-template>
				<xsl:if test="$shownvpairs = &apos;true&apos;">
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>config=&lt;nic&gt;            Remote access NIC information.</xsl:text>
					<xsl:call-template name="NewLine"/>
					<xsl:text>config=&lt;serial&gt;         Remote access serial port information.</xsl:text>
					<xsl:call-template name="NewLine"/>
					<xsl:text>config=&lt;terminalmode&gt;   Remote access serial port advanced information.</xsl:text>
					<xsl:call-template name="NewLine"/>
					<xsl:text>config=&lt;serialoverlan&gt;  Remote access serial over LAN information.</xsl:text>
					<xsl:call-template name="NewLine"/>
					<xsl:text>config=&lt;advsol&gt;  	Remote access serial over LAN advanced information.</xsl:text>
					<xsl:call-template name="NewLine"/>
					<xsl:text>config=&lt;user&gt;           Remote access user information.</xsl:text>
					<xsl:call-template name="NewLine"/>
				</xsl:if>
			</xsl:when>

			<xsl:when test="$id = &apos;28&apos;">
				<!--XLATESTART-->System Components (FRU) information.<!--XLATESTOP-->
		      </xsl:when>

			<xsl:when test="$id = &apos;29&apos;">
				<!--XLATESTART-->Remote Access information.<!--XLATESTOP-->
				<xsl:if test="$shownvpairs = &apos;true&apos;">
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>config=&lt;nic&gt;            Remote access NIC information.</xsl:text>
					<xsl:call-template name="NewLine"/>
					<xsl:text>config=&lt;serial&gt;         Remote access serial port information.</xsl:text>
					<xsl:call-template name="NewLine"/>
					<xsl:text>config=&lt;terminalmode&gt;   Remote access serial port advanced information.</xsl:text>
					<xsl:call-template name="NewLine"/>
					<xsl:text>config=&lt;serialoverlan&gt;  Remote access serial over LAN information.</xsl:text>
					<xsl:call-template name="NewLine"/>
					<xsl:text>config=&lt;advsol&gt;  	Remote access serial over LAN advanced information.</xsl:text>
					<xsl:call-template name="NewLine"/>
					<xsl:text>config=&lt;user&gt;           Remote access user information.</xsl:text>
					<xsl:call-template name="NewLine"/>
				</xsl:if>
			</xsl:when>

			<xsl:when test="$id = &apos;30&apos;">
				<!--XLATESTART-->Command not supported. Use the racadm utility.<!--XLATESTOP-->
			</xsl:when>

			<xsl:when test="$id = &apos;31&apos;">
				<!--XLATESTART-->Battery(s) properties.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;33&apos;">
				<!--XLATESTART-->Main system component properties.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;39&apos;">
				<!--XLATESTART-->Hardware performance information.<!--XLATESTOP-->
			</xsl:when>
      <xsl:when test="$id = &apos;35&apos;">
        <!--XLATESTART-->Main system information.<!--XLATESTOP-->
        <xsl:if test="$shownvpairs = &apos;true&apos;">
          <xsl:call-template name="NewLine"/>
          <!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
          <xsl:call-template name="NewLine"/>
          <xsl:text>index=&lt;number&gt;	 </xsl:text><!--XLATESTART-->Displays properties for a particular main system.<!--XLATESTOP-->
        </xsl:if>
      </xsl:when>
        <xsl:when test="$id = &apos;36&apos;">
	          <!--XLATESTART-->Power monitoring properties.<!--XLATESTOP-->
      </xsl:when>
      <xsl:when test="$id = &apos;37&apos;">
        <!--XLATESTART-->Main system LED settings.<!--XLATESTOP-->
        <xsl:if test="$shownvpairs = &apos;true&apos;">
          <xsl:call-template name="NewLine"/>
          <!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
          <xsl:call-template name="NewLine"/>
          <xsl:text>index=&lt;number&gt;	 </xsl:text><!--XLATESTART-->Main system index (defaults to 0).<!--XLATESTOP-->
        </xsl:if>
      </xsl:when>

      <xsl:when test="$id = &apos;38&apos;">
        <!--XLATESTART-->Main system intrusion status.<!--XLATESTOP-->
      </xsl:when>
		      <xsl:when test="$id = &apos;999&apos;"><!--XLATETHIS-->For further help, type the command followed by -?<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = &apos;1000&apos;">
                          <xsl:call-template name="ConfigSuccess"><xsl:with-param name="subCom"><xsl:value-of select="$nametxt"/></xsl:with-param>
			      </xsl:call-template>
			</xsl:when>
            <xsl:when test="$id = '1001'">
                <!--XLATETHIS-->Error! Signed number expected, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
            </xsl:when>
            <xsl:when test="$id = '1002'">
                <!--XLATETHIS-->Error!. Unsigned, whole number expected, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
            </xsl:when>
            <xsl:when test="$id = '1003'">
                <!--XLATETHIS-->Error! true or false expected, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
            </xsl:when>
            <xsl:when test="$id = '1004'">
                <!--XLATETHIS-->Error! alphanumeric or symbol expected, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
            </xsl:when>
            <xsl:when test="$id = &apos;1005&apos;">
                <!--XLATETHIS-->Error! Required parameter missing: <!--XLATETHIS-->
                <xsl:value-of select="$parsetxt"/><xsl:text>=</xsl:text>
                <xsl:call-template name="CLIParamFormat"><xsl:with-param name="format"><xsl:value-of select="$parsetxt2"/></xsl:with-param>
			      </xsl:call-template>
			</xsl:when>
			<xsl:when test="$id = &apos;1006&apos;">
				<!--XLATETHIS-->Error! At least one optional parameter must be specified.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id = &apos;1007&apos;">
				<!--XLATETHIS-->Error! Command incomplete <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = &apos;1008&apos;">
				<xsl:call-template name="CLIObjNotFound">
					<xsl:with-param name="subCom"><xsl:value-of select="$nametxt"/></xsl:with-param>
					<xsl:with-param name="paramNam"><xsl:value-of select="$paramtxt"/></xsl:with-param>
					<xsl:with-param name="param1"><xsl:value-of select="$parsetxt"/></xsl:with-param>
				</xsl:call-template>
			</xsl:when>

			<xsl:when test="$id = &apos;9999&apos;">
			      <!--XLATESTART-->Error! No <!--XLATESTOP--><xsl:call-template name="CLIObjName"><xsl:with-param name="subCom"><xsl:value-of select="$nametxt"/></xsl:with-param></xsl:call-template><!--XLATETHIS--> found on this system.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id = &apos;1009&apos;">
				<!--XLATETHIS-->Error! cannot load data accessor: <!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id = &apos;1010&apos;">
			      <xsl:call-template name="CLIIndexRange">
					<xsl:with-param name="subCom"><xsl:value-of select="$nametxt"/></xsl:with-param>
					<xsl:with-param name="index"><xsl:value-of select="$parsetxt"/></xsl:with-param>
			      </xsl:call-template>
			</xsl:when>
			<xsl:when test="$id = &apos;1011&apos;">
			      <xsl:call-template name="CLICommandFailed">
					<xsl:with-param name="subCom"><xsl:value-of select="$nametxt"/></xsl:with-param>
		            <xsl:with-param name="paramNam"><xsl:value-of select="$paramtxt"/></xsl:with-param>
					<xsl:with-param name="stat"><xsl:value-of select="$hipstat"/></xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$id = &apos;1012&apos;">
				<!--XLATETHIS-->Error! Unrecognized parameter value: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = &apos;1013&apos;">
				<!--XLATESTART-->Error! Text too long: <!--XLATESTOP-->
				<xsl:value-of select="$parsetxt2"/>
				 <!--XLATESTART-->. Maximum number of characters is: <!--XLATESTOP-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = &apos;1045&apos;">
				<!--XLATESTART-->Error! To set ipaddress, subnet or gateway, ipsource=static is required. <!--XLATESTOP-->
			</xsl:when>
            <xsl:when test="$id = '1014'">
                <!--XLATETHIS-->Error! Value incorrect : <!--XLATETHIS-->
                <xsl:value-of select="$parsetxt"/><xsl:text>=</xsl:text>
                <xsl:value-of select="$parsetxt2"/>
            </xsl:when>
            <xsl:when test="$id = '1015'">
                <!--XLATETHIS-->Error! Number expected, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
            </xsl:when>
            <xsl:when test="$id = '1016'">
                <!--XLATETHIS-->Error! Date in form mmddyyyy expected, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text>
                <xsl:value-of select="$parsetxt"/>
            </xsl:when>
            <xsl:when test="$id = '1017'">
                <!--XLATETHIS-->Error! Percent (0-100) expected, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
            </xsl:when>
            <xsl:when test="$id = '1018'">
                <!--XLATETHIS-->Error! Number with up to 1 digit after decimal point expected, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text>
                <xsl:value-of select="$parsetxt"/>
            </xsl:when>
            <xsl:when test="$id = '1019'">
                <!--XLATETHIS-->Error! Number with up to 2 digits after decimal point expected, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text>
                <xsl:value-of select="$parsetxt"/>
            </xsl:when>
            <xsl:when test="$id = '1020'">
                <!--XLATETHIS-->Error! Number with up to 3 digits after decimal point expected, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text>
                <xsl:value-of select="$parsetxt"/>
            </xsl:when>
            <xsl:when test="$id = &apos;1021&apos;">
                <!--XLATETHIS-->Error! Month is invalid: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = &apos;1022&apos;">
				<!--XLATETHIS-->Error! Day is invalid: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = &apos;1023&apos;">
				<!--XLATETHIS-->Error! Not a leap year: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
            <xsl:when test="$id = '1024'">
                <!--XLATETHIS-->Error! Alphanumeric expected, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
            </xsl:when>
            <xsl:when test="$id = &apos;1025&apos;">
				<!--XLATETHIS-->Error! Unrecognized parameter: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = &apos;1026&apos;">
				<!--XLATETHIS-->Error! Cannot make date with this mmddyy on 32 bit operating system: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
            <xsl:when test="$id = '1027'">
                <!--XLATETHIS-->Error! Invalid IP Address, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
            </xsl:when>
            <xsl:when test="$id = &apos;1028&apos;">
				<!--XLATETHIS-->Error! Required parameter missing: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/><xsl:text>=</xsl:text>
				<xsl:value-of select="$parsetxt2"/>
			</xsl:when>
			<xsl:when test="$id = &apos;1029&apos;">
				<!--XLATETHIS-->Error! First char alpha folowed by alphanumeric expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>

			<xsl:when test="$id = &apos;1033&apos;">
				<!--XLATETHIS-->Error! Text with at least one character expected.<!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>

			<xsl:when test="$id = &apos;1034&apos;">
				<!--XLATETHIS-->Error! Year must be greater than or equal to 1970. Read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>

			<xsl:when test="$id = &apos;1035&apos;">
			      <xsl:call-template name="CLIPromptCanceled">
					<xsl:with-param name="subCom"><xsl:value-of select="$nametxt"/></xsl:with-param>
     				<xsl:with-param name="paramNam"><xsl:value-of select="$paramtxt"/></xsl:with-param>
     				<xsl:with-param name="parseTxt"><xsl:value-of select="$parsetxt"/></xsl:with-param>
					<xsl:with-param name="stat"><xsl:value-of select="$hipstat"/></xsl:with-param>
				</xsl:call-template>
			</xsl:when>

			<xsl:when test="$id = &apos;1036&apos;">
			      <xsl:call-template name="CLIPromptInvalid">
					<xsl:with-param name="subCom"><xsl:value-of select="$nametxt"/></xsl:with-param>
     				<xsl:with-param name="paramNam"><xsl:value-of select="$paramtxt"/></xsl:with-param>
     				<xsl:with-param name="parseTxt"><xsl:value-of select="$parsetxt"/></xsl:with-param>
					<xsl:with-param name="stat"><xsl:value-of select="$hipstat"/></xsl:with-param>
				</xsl:call-template>
			</xsl:when>

			<xsl:when test="$id = &apos;1037&apos;">
				<!--XLATETHIS-->Error! Whole numbers separated by colon(s) expected. Read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>

			<xsl:when test="$id = &apos;1038&apos;">
				<!--XLATETHIS-->Error! Whole numbers separated by colon range error. Max is: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>

			<xsl:when test="$id = &apos;1039&apos;">
				<!--XLATETHIS-->Error! Multiple values not unique:  <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>

			<xsl:when test="$id = &apos;1040&apos;">
				<!--XLATETHIS-->Error! Illegal combination of parameters.<!--XLATETHIS-->
			</xsl:when>

			<xsl:when test="$id = &apos;1041&apos;">
				<xsl:text>Error! Value of: (</xsl:text>
				<xsl:value-of select="$paramtxt"/>
				<xsl:text>) must be between: (</xsl:text>
				<xsl:value-of select="$parsetxt"/>
				<xsl:text>) and (</xsl:text>
				<xsl:value-of select="$parsetxt2"/>
				<xsl:text>)</xsl:text>
			</xsl:when>

			<xsl:when test="$id = &apos;1042&apos;">
				<xsl:text>Error! Value of: (</xsl:text>
				<xsl:value-of select="$paramtxt"/>
				<xsl:text>) must be between: (</xsl:text>
				<xsl:value-of select="$parsetxt"/>
				<xsl:text>) and (</xsl:text>
				<xsl:value-of select="$parsetxt2"/>
				<xsl:text>)</xsl:text>
			</xsl:when>

            <xsl:when test="$id = '1043'">
                <!--XLATETHIS-->Error! Invalid IP Subnet, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
            </xsl:when>

            <xsl:when test="$id = '1044'">
                <!--XLATETHIS-->Error! IP Subnet set bits must be contiguous, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text>
                <xsl:value-of select="$parsetxt"/>
            </xsl:when>

            <xsl:when test="$id = '1054'">
				<xsl:text>Error! Index invalid. The index must be greater than zero.</xsl:text>
			</xsl:when>

			<xsl:when test="$id = &apos;1101&apos;">
				<!--XLATETHIS-->Error! Signed number or &quot;default&quot; expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = &apos;1102&apos;">
				<!--XLATETHIS-->Error! unsigned number or &quot;default&quot; expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = &apos;1103&apos;">
				<!--XLATETHIS-->Error! true or false or &quot;default&quot; expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = &apos;1104&apos;">
				<!--XLATETHIS-->Error! alphanumeric or symbol or &quot;default&quot; expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
      <xsl:when test="$id = &apos;1105&apos;">
        <!--XLATETHIS-->Error! Positive numeric value expected, read: <!--XLATETHIS-->
        <xsl:value-of select="$parsetxt"/>
      </xsl:when>
      <xsl:when test="$id = &apos;1106&apos;">
        <!--XLATETHIS-->Error! User has insufficient privileges to run command.<!--XLATETHIS-->
      </xsl:when>
      <xsl:when test="$id = &apos;1200&apos;">
				<xsl:text>Error! This current probe </xsl:text>
				<xsl:value-of select="$paramtxt"/>
				 <xsl:text> warning threshold must be between </xsl:text>
                     <xsl:call-template name="prnVolt">
					<xsl:with-param name="volt"><xsl:value-of select="$parsetxt"/></xsl:with-param>
				</xsl:call-template>
			      <xsl:text> and </xsl:text>
				<xsl:call-template name="prnVolt">
				    <xsl:with-param name="volt"><xsl:value-of select="$parsetxt2"/>
				</xsl:with-param></xsl:call-template>
			</xsl:when>
			<xsl:when test="$id = &apos;1201&apos;">
				<xsl:text>Error! This fan probe </xsl:text>
				<xsl:value-of select="$paramtxt"/>
				 <xsl:text> warning threshold must be between </xsl:text>
                     <xsl:value-of select="$parsetxt"/>
			       <xsl:text> and </xsl:text>
				<xsl:value-of select="$parsetxt2"/>
			</xsl:when>
			<xsl:when test="$id = &apos;1202&apos;">
				<xsl:text>Error! This temp probe </xsl:text>
				<xsl:value-of select="$paramtxt"/>
				 <xsl:text> warning threshold must be between </xsl:text>
                         <xsl:call-template name="prnTemp">
					<xsl:with-param name="temp"><xsl:value-of select="$parsetxt"/></xsl:with-param>
				</xsl:call-template>
			      <xsl:text> and </xsl:text>
				<xsl:call-template name="prnTemp">
				    <xsl:with-param name="temp"><xsl:value-of select="$parsetxt2"/>
				</xsl:with-param></xsl:call-template>
			</xsl:when>
			<xsl:when test="$id = &apos;1203&apos;">
				<xsl:text>Error! This voltage probe </xsl:text>
				<xsl:value-of select="$paramtxt"/>
				 <xsl:text> warning threshold must be between </xsl:text>
                         <xsl:call-template name="prnVolt">
					<xsl:with-param name="volt"><xsl:value-of select="$parsetxt"/></xsl:with-param>
				</xsl:call-template>
			      <xsl:text> and </xsl:text>
				<xsl:call-template name="prnVolt">
				    <xsl:with-param name="volt"><xsl:value-of select="$parsetxt2"/>
				</xsl:with-param></xsl:call-template>
			</xsl:when>
			<xsl:when test="$id = &apos;1204&apos;">
				<xsl:text>Error! Current min warning threshold (</xsl:text>
				<xsl:call-template name="prnVolt">
					<xsl:with-param name="volt"><xsl:value-of select="$parsetxt"/></xsl:with-param></xsl:call-template>
				<xsl:text>) must be less than max (</xsl:text>
				<xsl:call-template name="prnVolt">
					<xsl:with-param name="volt"><xsl:value-of select="$parsetxt2"/></xsl:with-param>
				</xsl:call-template>
				<xsl:text>)</xsl:text>
			</xsl:when>
			<xsl:when test="$id = &apos;1205&apos;">
				<xsl:text>Error! Fan min warning threshold (</xsl:text>
				<xsl:value-of select="$parsetxt"/>
				<xsl:text>) must be less than max (</xsl:text>
				<xsl:value-of select="$parsetxt2"/>
				<xsl:text>)</xsl:text>
			</xsl:when>
			<xsl:when test="$id = &apos;1206&apos;">
				<xsl:text>Error! Temp min warning threshold (</xsl:text>
				<xsl:call-template name="prnTemp">
					<xsl:with-param name="temp"><xsl:value-of select="$parsetxt"/></xsl:with-param></xsl:call-template>
				<xsl:text>) must be less than max (</xsl:text>
				<xsl:call-template name="prnTemp">
					<xsl:with-param name="temp"><xsl:value-of select="$parsetxt2"/></xsl:with-param>
				</xsl:call-template>
				<xsl:text>)</xsl:text>
			</xsl:when>
			<xsl:when test="$id = &apos;1207&apos;">
				<xsl:text>Error! Voltage min warning threshold (</xsl:text>
				<xsl:call-template name="prnVolt">
					<xsl:with-param name="volt"><xsl:value-of select="$parsetxt"/></xsl:with-param></xsl:call-template>
				<xsl:text>) must be less than max (</xsl:text>
				<xsl:call-template name="prnVolt">
					<xsl:with-param name="volt"><xsl:value-of select="$parsetxt2"/></xsl:with-param>
				</xsl:call-template>
				<xsl:text>)</xsl:text>
			</xsl:when>
			<xsl:when test="$id = &apos;1208&apos;">
				 <xsl:call-template name="CLIProbeInvalid">
				      <xsl:with-param name="subCom"><xsl:value-of select="$nametxt"/></xsl:with-param>
					<xsl:with-param name="probeindex"><xsl:value-of select="$parsetxt"/></xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$id = &apos;1209&apos;">
			      <xsl:call-template name="CLIWarnThresh"><xsl:with-param name="subCom"><xsl:value-of select="$nametxt"/></xsl:with-param>
			      </xsl:call-template>
			</xsl:when>
			<xsl:when test="$id = &apos;1210&apos;">
			  <xsl:call-template name="CLIWarnUnavailable">
				<xsl:with-param name="subCom"><xsl:value-of select="$nametxt"/></xsl:with-param>
				<xsl:with-param name="probeindex"><xsl:value-of select="$parsetxt"/></xsl:with-param>
			   </xsl:call-template>
			</xsl:when>
			<xsl:when test="$id = &apos;1211&apos;">
				<!--XLATETHIS-->Error! Flash timeout value should be less than 3600 seconds.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id = '1214'">
				<xsl:call-template name="CLIMaxSetUnavailable"><xsl:with-param name="subCom"><xsl:value-of select="$nametxt"/></xsl:with-param>
			      </xsl:call-template>
			</xsl:when>
			<xsl:when test="$id = '1213'">
				<xsl:call-template name="CLIMinSetUnavailable"><xsl:with-param name="subCom"><xsl:value-of select="$nametxt"/></xsl:with-param>
			      </xsl:call-template>
			</xsl:when>
			<xsl:when test="$id = &apos;1212&apos;">
				<!--XLATESTART-->Error! Remote access User new password (newpw) must match confirm new password (confirmnewpw).<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;1215&apos;">
				<!--XLATESTART-->Error! Remote access encryption key (encryptkey) is not a valid HEX number.<!--XLATESTOP-->
			</xsl:when>

			<xsl:when test="$id = &apos;1216&apos;">
				<!--XLATESTART-->Error! Command not supported. Use the racadm utility.<!--XLATESTOP-->
			</xsl:when>

			<xsl:when test="$id = &apos;1217&apos;">
				<!--XLATESTART-->Error! Username for enabled user cannot be blank.<!--XLATESTOP-->
			</xsl:when>

			<xsl:when test="$id = &apos;1218&apos;">
				<!--XLATESTART-->Error! Remote access encryption key (encryptkey) is more than 20 bytes(40 characters) long.<!--XLATESTOP-->
			</xsl:when>

            <xsl:when test="$id = &apos;1219&apos;">
                <!--XLATESTART-->Error! Remote access ipsource type not supported on this system: <!--XLATESTOP--><xsl:value-of select="$parsetxt"/>
            </xsl:when>
            <xsl:when test="$id = &apos;1220&apos;">
                <!--XLATESTART-->Error! Remote access serial baudrate not supported on this system: <!--XLATESTOP--><xsl:value-of select="$parsetxt"/>
            </xsl:when>
            <xsl:when test="$id = &apos;1221&apos;">
                <!--XLATESTART-->Error! Remote access serial mode not supported on this system: <!--XLATESTOP--><xsl:value-of select="$parsetxt"/>
            </xsl:when>
            <xsl:when test="$id = &apos;1222&apos;">
                <!--XLATESTART-->Error! Remote access serialoverlan baudrate not supported on this system: <!--XLATESTOP--><xsl:value-of select="$parsetxt"/>
            </xsl:when>
            <xsl:when test="$id = &apos;1223&apos;">
                <!--XLATESTART-->Error! Set password for enabling user. <!--XLATESTOP-->
            </xsl:when>
            <xsl:when test="$id = &apos;1224&apos;">
              <xsl:text>Error! This power consumption probe warning threshold must be between </xsl:text>
              <xsl:value-of select="$parsetxt"/>
              <xsl:text> and </xsl:text>
              <xsl:value-of select="$parsetxt2"/>
            </xsl:when>
            <xsl:when test="$id = &apos;1910&apos;">
				    <xsl:call-template name="CLISubCommand">
					    <xsl:with-param name="command">chassis</xsl:with-param>
				    </xsl:call-template>
				        <!--XLATESTART-->Set chassis component properties.<!--XLATESTOP-->
			      </xsl:when>
			      <xsl:when test="$id = &apos;1911&apos;">
				      <!--XLATETHIS-->Error! Flash timeout value should be greater than 0 seconds.<!--XLATETHIS-->
			      </xsl:when>
            <xsl:when test="$id = &apos;1912&apos;">
              <xsl:call-template name="CLISubCommand">
                <xsl:with-param name="command">chassis</xsl:with-param>
              </xsl:call-template>
        		      <!--XLATESTART-->Set chassis component properties.<!--XLATESTOP-->
        		      <xsl:call-template name="printSubcommandDeprecatedExt">
        		        <xsl:with-param name="newCommand">mainsystem</xsl:with-param>
        		        <xsl:with-param name="standalone">false</xsl:with-param>
        		      </xsl:call-template>
            </xsl:when>
            <xsl:when test="$id = &apos;1913&apos;">
              <xsl:call-template name="CLISubCommand">
                <xsl:with-param name="command">mainsystem</xsl:with-param>
              </xsl:call-template>
              <!--XLATESTART-->Set mainsystem component properties.<!--XLATESTOP-->
            </xsl:when>
			<xsl:when test="$id = &apos;3001&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">currents</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set current probe threshold(s).<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;3002&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">currents</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set current probe threshold(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
                <xsl:call-template name="NewLine"/>
				<xsl:text>index=&lt;number&gt;          </xsl:text><!--XLATESTART-->Probe index (must be specified).<!--XLATESTOP-->
                <xsl:call-template name="NewLine"/>
				<xsl:text>minwarnthresh=&lt;number&gt;  </xsl:text><!--XLATESTART-->Minimum warning threshold (3 decimal places).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>maxwarnthresh=&lt;number&gt;  </xsl:text><!--XLATESTART-->Maximum warning threshold (3 decimal places).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>warnthresh=default      </xsl:text><!--XLATESTART-->Set minimum and maximum warning thresholds to default.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;3011&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">fans</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set fan probe threshold(s).<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;3012&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">fans</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set fan probe threshold(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>index=&lt;number&gt;          </xsl:text><!--XLATESTART-->Probe index (must be specified).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>minwarnthresh=&lt;number&gt;  </xsl:text><!--XLATESTART-->Minimum warning threshold.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>maxwarnthresh=&lt;number&gt;  </xsl:text><!--XLATESTART-->Maximum warning threshold.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>warnthresh=default      </xsl:text><!--XLATESTART-->Set minimum and maximum warning thresholds to default.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;3021&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">temps</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set temperature probe threshold(s).<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;3022&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">temps</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set temperature probe threshold(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>index=&lt;number&gt;          </xsl:text><!--XLATESTART-->Probe index (must be specified).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>minwarnthresh=&lt;number&gt;  </xsl:text><!--XLATESTART-->Minimum warning threshold (1 decimal place).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>maxwarnthresh=&lt;number&gt;  </xsl:text><!--XLATESTART-->Maximum warning threshold (1 decimal place).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>warnthresh=default      </xsl:text><!--XLATESTART-->Set minimum and maximum warning thresholds to default.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;3031&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">volts</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Set voltage probe threshold(s).</xsl:text>
			</xsl:when>
			<xsl:when test="$id = &apos;3032&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">volts</xsl:with-param>
				</xsl:call-template>
				<xsl:text>Set voltage probe threshold(s).</xsl:text>
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>index=&lt;number&gt;          </xsl:text><!--XLATESTART-->Probe index (must be specified).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>minwarnthresh=&lt;number&gt;  </xsl:text><!--XLATESTART-->Minimum warning threshold (3 decimal places).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>maxwarnthresh=&lt;number&gt;  </xsl:text><!--XLATESTART-->Maximum warning threshold (3 decimal places).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>warnthresh=default      </xsl:text><!--XLATESTART-->Set minimum and maximum warning thresholds to default.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;3041&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">fancontrol</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set fan control to quiet or max cooling.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;3042&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">fancontrol</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set fan control to quiet or max cooling.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>speed=quiet      </xsl:text><!--XLATESTART-->Set fan speed to quiet mode.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>speed=maxcool    </xsl:text><!--XLATESTART-->Set fan speed to max cooling mode.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;3051&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">acswitch</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set AC switch parameters.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;3052&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">acswitch</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set AC switch parameters.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
                    <xsl:if test="substring($parsetxt, 8, 1) = &apos;1&apos;">
					<xsl:call-template name="NewLine"/>
					<xsl:text>mode=source1              Input source Line 1, on restoration, remain on Line 2</xsl:text>
				</xsl:if>
                    <xsl:if test="substring($parsetxt, 7, 1) = &apos;1&apos;">
					<xsl:call-template name="NewLine"/>
					<xsl:text>mode=source1return        Input source Line 1, on restoration, return to Line 1</xsl:text>
				</xsl:if>
                    <xsl:if test="substring($parsetxt, 6, 1) = &apos;1&apos;">
					<xsl:call-template name="NewLine"/>
					<xsl:text>mode=source2              Input source Line 2, on restoration, remain on Line 1</xsl:text>
				</xsl:if>
                    <xsl:if test="substring($parsetxt, 5, 1) = &apos;1&apos;">
					<xsl:call-template name="NewLine"/>
				     <xsl:text>mode=sourcebreturn        Input source Line 2, on restoration, return to Line 2</xsl:text>
				</xsl:if>
                    <xsl:if test="substring($parsetxt, 4, 1) = &apos;1&apos;">
					<xsl:call-template name="NewLine"/>
					<xsl:text>mode=sourceshare            Shared input mode</xsl:text>
				</xsl:if>

				<xsl:choose>
	                    <xsl:when test="($parsetxt2 != &apos;4&apos;) or ( paramtxt = &apos;1&apos;)">
						<xsl:call-template name="NewLine"/>
					     <xsl:text>redunexpected=&lt;true|false&gt;</xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="substring($parsetxt, 4, 5) = &apos;00000&apos;">
								<xsl:call-template name="NewLine"/>
								<xsl:text>No valid parameters.</xsl:text>
							</xsl:when>
							<xsl:otherwise/>
						</xsl:choose>
					</xsl:otherwise>
				 </xsl:choose>
			</xsl:when>

			<xsl:when test="$id = &apos;3061&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">biossetup</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Configure BIOS setup.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;3062&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">biossetup</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Configure BIOS setup.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>attribute=numlock        setting=&lt;on|off&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>attribute=diskette       setting=&lt;off|auto|writeprotect&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>attribute=NIC            setting=&lt;disabled|enabled|enabledwithpxe|enabledonly|enablednonepxe|enabledwithiscsi&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>attribute=mouse          setting=&lt;on|off&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>attribute=usb            setting=&lt;enabled|disabled&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>attribute=usbb           setting=&lt;enabled|enabledwithbios|disabled&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>attribute=ide            setting=&lt;on|off&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>attribute=onboardscsi    setting=&lt;on|off&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>attribute=secondaryscsi  setting=&lt;on|off&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>attribute=bootsequence   setting=&lt;diskettefirst|hdonly|devicelist|cdromfirst&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>attribute=ppaddress      setting=&lt;off|lpt1|lpt2|lpt3&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>attribute=ppmode         setting=&lt;at|ps2|ecp|epp&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>attribute=serialport1    setting=&lt;off|auto|com1|com3|bmcserial|bmcnic|rac&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>attribute=serialport2    setting=&lt;off|auto|com2|com4&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>attribute=speaker        setting=&lt;on|of&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>attribute=wakeonlan      setting=&lt;disable|expansion|onboard|addin&gt;</xsl:text>
			</xsl:when>

			<xsl:when test="$id = &apos;3141&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">bmc</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Configure Remote Access Information.<!--XLATESTOP-->
				<xsl:call-template name="printSubcommandDeprecated">
					<xsl:with-param name="newCommand">remoteaccess</xsl:with-param>
					<xsl:with-param name="standalone">false</xsl:with-param>
				</xsl:call-template>
			</xsl:when>

			<xsl:when test="$id = &apos;3142&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">bmc</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Configure Remote Access Information.<!--XLATESTOP-->
				<xsl:call-template name="printSubcommandDeprecated">
					<xsl:with-param name="newCommand">remoteaccess</xsl:with-param>
				</xsl:call-template>
<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>config=settodefault</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>config=nic</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	enable=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	enableipmi=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	enablenic=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	nicselection=&lt;shared|sharedfailover|dedicated&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	ipaddress=&lt;IP&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	subnet=&lt;Subnet&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	gateway=&lt;Gateway&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	ipsource=&lt;static|dhcp|systemsoftware&gt;</xsl:text>
				<!--xsl:call-template name="NewLine"/>
				<xsl:text>	communitystr=&lt;text&gt;</xsl:text-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>	vlanenable=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	vlanid=&lt;number&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	vlanpriority=&lt;number&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	privilegelevel=&lt;administrator|operator|user&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	encryptkey=&lt;text&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>config=serial</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	mode=&lt;directbasic|directterminal|directbasicterminal|modembasic|modemterminal|modembasicterminal&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	baudrate=&lt;9600|19200|38400|57600|115200&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	flowcontrol=&lt;none|rtscts&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	privilegelevel=&lt;administrator|operator|user&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<!--xsl:text>	admintext=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	adminmd2=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	adminmd5=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	operatortext=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	operatormd2=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	operatormd5=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	usertext=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	usermd2=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	usermd5=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/-->

				<xsl:text>config=terminalmode</xsl:text>
				<!--xsl:call-template name="NewLine"/>
				<xsl:text>	parameteroperation=&lt;setvolatile|setnonvolatile|copynonvolatile&gt;</xsl:text-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>	lineediting=&lt;enabled|disabled&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	deletecontrol=&lt;outputdel|outputbkspspbksp&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	echocontrol=&lt;enabled|disabled&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	handshakingcontrol=&lt;enabled|disabled&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	newlinesequence=&lt;none|crlf|null|cr|lfcr|lf&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	inputlinesequence=&lt;cr|null&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>config=serialoverlan</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	enable=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	baudrate=&lt;9600|19200|38400|57600|115200&gt;</xsl:text>

				<!--xsl:call-template name="NewLine"/>
				<xsl:text>	nvbaudrate=&lt;9600|19200&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	vbaudrate=&lt;9600|19200&gt;</xsl:text-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>	privilegelevel=&lt;administrator|operator|user&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>

				<xsl:text>config=advsol</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	characcuminterval=&lt;number&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	charsendthreshold=&lt;number&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>

				<xsl:text>config=user</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	id=&lt;number&gt;	enable=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	id=&lt;number&gt;	name=&lt;text&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	id=&lt;number&gt;	newpw=&lt;text&gt; confirmnewpw=&lt;text&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
			     <xsl:text>	id=&lt;number&gt;	lanaccesslevel=&lt;administrator|operator|user|none&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
			     <xsl:text>	id=&lt;number&gt;	serialaccesslevel=&lt;administrator|operator|user|none&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
			    <xsl:text>	id=&lt;number&gt;	enableserialoverlan=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	id=&lt;number&gt;	dracusergroup=&lt;admin|poweruser|guest|none&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	id=&lt;number&gt;	dracusergroup=custom &lt;permission list&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>             where "permission list" is one or more of the following:</xsl:text>
        <xsl:call-template name="NewLine"/>
        <xsl:text>                 &lt;logindrac|loginidrac&gt;, &lt;configuredrac|configureidrac&gt;,</xsl:text>
        <xsl:call-template name="NewLine"/>
        <xsl:text>                 configureusers, clearlogs, executeservercommands, </xsl:text>
        <xsl:call-template name="NewLine"/>
        <xsl:text>                 accessconsoleredir, accessvirtualmedia, testalerts, </xsl:text>
        <xsl:call-template name="NewLine"/>
        <xsl:text>                 executediagcommands.</xsl:text>
        <xsl:call-template name="NewLine"/>
				<xsl:text>             All are true/false values (e.g. "logindrac=true").</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>             Any permissions not listed will default to "false".</xsl:text>
				<xsl:call-template name="NewLine"/>
			</xsl:when>

			<xsl:when test="$id = &apos;3151&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">remoteaccess</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Configure Remote Access Information.<!--XLATESTOP-->
			</xsl:when>

			<xsl:when test="$id = &apos;3152&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">remoteaccess</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Configure Remote Access Information.<!--XLATESTOP-->
<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>config=settodefault</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>config=nic</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	enable=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	enableipmi=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
			        <!--<xsl:text>	enablewebservice=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>-->
				<xsl:text>	enablenic=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	nicselection=&lt;shared|sharedfailover|dedicated&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	ipaddress=&lt;IP&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	subnet=&lt;Subnet&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	gateway=&lt;Gateway&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	ipsource=&lt;static|dhcp|systemsoftware&gt;</xsl:text>
				<!--xsl:call-template name="NewLine"/>
				<xsl:text>	communitystr=&lt;text&gt;</xsl:text-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>	vlanenable=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	vlanid=&lt;number&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	vlanpriority=&lt;number&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	privilegelevel=&lt;administrator|operator|user&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	encryptkey=&lt;text&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<!--xsl:text>	admintext=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	adminmd2=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	adminmd5=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	operatortext=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	operatormd2=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	operatormd5=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	usertext=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	usermd2=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	usermd5=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/-->
				<xsl:text>config=serial</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	mode=&lt;directbasic|directterminal|directbasicterminal|modembasic|modemterminal|modembasicterminal&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	baudrate=&lt;9600|19200|38400|57600|115200&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	flowcontrol=&lt;none|rtscts&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	privilegelevel=&lt;administrator|operator|user&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<!--xsl:text>	admintext=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	adminmd2=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	adminmd5=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	operatortext=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	operatormd2=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	operatormd5=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	usertext=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	usermd2=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	usermd5=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/-->

				<xsl:text>config=terminalmode</xsl:text>
				<!--xsl:call-template name="NewLine"/>
				<xsl:text>	parameteroperation=&lt;setvolatile|setnonvolatile|copynonvolatile&gt;</xsl:text-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>	lineediting=&lt;enabled|disabled&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	deletecontrol=&lt;outputdel|outputbkspspbksp&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	echocontrol=&lt;enabled|disabled&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	handshakingcontrol=&lt;enabled|disabled&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	newlinesequence=&lt;none|crlf|null|cr|lfcr|lf&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	inputlinesequence=&lt;cr|null&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>config=serialoverlan</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	enable=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	baudrate=&lt;9600|19200|38400|57600|115200&gt;</xsl:text>

				<!--xsl:call-template name="NewLine"/>
				<xsl:text>	nvbaudrate=&lt;9600|19200&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	vbaudrate=&lt;9600|19200&gt;</xsl:text-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>	privilegelevel=&lt;administrator|operator|user&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>

				<xsl:text>config=advsol</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	characcuminterval=&lt;number&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	charsendthreshold=&lt;number&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>

				<xsl:text>config=user</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	id=&lt;number&gt;	enable=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	id=&lt;number&gt;	name=&lt;text&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	id=&lt;number&gt;	newpw=&lt;text&gt; confirmnewpw=&lt;text&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
			     <xsl:text>	id=&lt;number&gt;	lanaccesslevel=&lt;administrator|operator|user|none&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
			     <xsl:text>	id=&lt;number&gt;	serialaccesslevel=&lt;administrator|operator|user|none&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
			    <xsl:text>	id=&lt;number&gt;	enableserialoverlan=&lt;true|false&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>	id=&lt;number&gt;	dracusergroup=&lt;admin|poweruser|guest|none&gt;</xsl:text>
        <xsl:call-template name="NewLine"/>
        <xsl:text>	id=&lt;number&gt;	extipmiusergroup=&lt;admin|poweruser|guest|none&gt;</xsl:text>
        <xsl:call-template name="NewLine"/>
				<xsl:text>	id=&lt;number&gt;	dracusergroup=custom &lt;permission list&gt;</xsl:text>
        <xsl:call-template name="NewLine"/>
        <xsl:text>	id=&lt;number&gt;	extipmiusergroup=custom &lt;permission list&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>             where "permission list" is one or more of the following:</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>                 &lt;logindrac|loginidrac&gt;, &lt;configuredrac|configureidrac&gt;,</xsl:text>
        <xsl:call-template name="NewLine"/>
        <xsl:text>                 configureusers, clearlogs, executeservercommands, </xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>                 accessconsoleredir, accessvirtualmedia, testalerts, </xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>                 executediagcommands.</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>             All are true/false values (e.g. "logindrac=true").</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>             Any permissions not listed will default to "false".</xsl:text>
				<xsl:call-template name="NewLine"/>
			</xsl:when>


			<xsl:when test="$id = &apos;3071&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">leds</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->LED configuration.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;3072&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">leds</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->LED configuration.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>led=fault        severity=&lt;warning|critical&gt; Flash on failure level.</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>led=hdfault      action=clear                Clear hard disk fault LED.</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>led=identify     flash=&lt;off|on&gt;              Flash chassis identify LED.</xsl:text>
				<xsl:call-template name="NewLine"/>
    		    <xsl:text>                 timeout=&lt;number&gt;            Flash timeout value ( &gt;0 seconds).</xsl:text>
			</xsl:when>
			<xsl:when test="$id = &apos;3081&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">frontpanel</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Enable or disable front panel buttons.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;3082&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">frontpanel</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set front panel options.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>powerbutton=&lt;enable|disable&gt;      </xsl:text><!--XLATESTART-->Enable/disable power button.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>nmibutton=&lt;enable|disable&gt;        </xsl:text><!--XLATESTART-->Enable/disable NMI button.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
				<xsl:text>lcdindex=&lt;index&gt;                  </xsl:text><!--XLATESTART-->Specifies the LCD line number to set.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>config=&lt;none|default|custom&gt;      </xsl:text><!--XLATESTART-->Sets the LCD text to none, default or custom.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>text=&lt;custom text&gt;                </xsl:text><!--XLATESTART-->If config=custom, sets the LCD custom text.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;3091&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">memory</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Clear memory error count.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '1050'">
			      <xsl:call-template name="CLIPromptText">
					<xsl:with-param name="subCom"><xsl:value-of select="$nametxt"/></xsl:with-param>
     				<xsl:with-param name="paramNam"><xsl:value-of select="$paramtxt"/></xsl:with-param>
     				<xsl:with-param name="parseTxt"><xsl:value-of select="$parsetxt"/></xsl:with-param>
					<xsl:with-param name="stat"><xsl:value-of select="$hipstat"/></xsl:with-param>
				</xsl:call-template>
			</xsl:when>

			<xsl:when test="$id = &apos;3092&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">memory</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Clear memory error count.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>index=&lt;number&gt;      </xsl:text><!--XLATESTART-->Memory device index (must be specified).<!--XLATESTOP-->
                <xsl:call-template name="NewLine"/>
				<xsl:text>errorcount=clear    </xsl:text><!--XLATESTART-->Clear memory error count.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;3101&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">assettag</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set chassis asset tag.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;3102&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">assettag</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set chassis asset tag.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>tag=&lt;text&gt;        </xsl:text><!--XLATESTART-->Asset tag value (up to 10 chars, alphanumeric text only). <!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;3121&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">info</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set chassis information.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;3122&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">info</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set chassis information.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>index=&lt;number&gt;   </xsl:text><!--XLATESTART-->Chassis index (defaults to 0, main system chassis).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
	               <xsl:text>tag=&lt;text&gt;       </xsl:text><!--XLATESTART-->Asset tag value (up to 10 chars, alphanumeric text only). <!--XLATESTOP-->
                    <xsl:call-template name="NewLine"/>
				<xsl:text>name=&lt;text&gt;      </xsl:text><!--XLATESTART-->Set chassis name.<!--XLATESTOP-->
			</xsl:when>

      <xsl:when test="$id = &apos;3153&apos;">
        <xsl:call-template name="CLISubCommand">
          <xsl:with-param name="command">info</xsl:with-param>
        </xsl:call-template>
        <!--XLATESTART-->Set main system information.<!--XLATESTOP-->
      </xsl:when>
      <xsl:when test="$id = &apos;3154&apos;">
        <xsl:call-template name="CLISubCommand">
          <xsl:with-param name="command">info</xsl:with-param>
        </xsl:call-template>
        <!--XLATESTART-->Set main system information.<!--XLATESTOP-->
        <xsl:call-template name="NewLine"/>
        <!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
        <xsl:call-template name="NewLine"/>
        <xsl:text>index=&lt;number&gt;   </xsl:text><!--XLATESTART-->Main system index (defaults to 0, main system).<!--XLATESTOP-->
        <xsl:call-template name="NewLine"/>
        <xsl:text>tag=&lt;text&gt;       </xsl:text><!--XLATESTART-->Asset tag value (up to 10 chars, alphanumeric text only). <!--XLATESTOP-->
        <xsl:call-template name="NewLine"/>
        <xsl:text>name=&lt;text&gt;      </xsl:text><!--XLATESTART-->Set main system name.<!--XLATESTOP-->
      </xsl:when>

			<xsl:when test="$id = &apos;3131&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">memorymode</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set memory redundancy mode.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = &apos;3132&apos;">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">memorymode</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set memory redundancy mode.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>index=&lt;number&gt;                            </xsl:text><!--XLATESTART-->Chassis index (defaults to 0).<!--XLATESTOP-->
                <xsl:call-template name="NewLine"/>
				<xsl:text>redundancy=&lt;spare|mirror|raid5|disabled&gt;  </xsl:text><!--XLATESTART-->Memory redundancy mode.<!--XLATESTOP-->
			</xsl:when>

        <xsl:when test="$id = &apos;3161&apos;">
          <xsl:call-template name="CLISubCommand">
            <xsl:with-param name="command">pwrmonitoring</xsl:with-param>
          </xsl:call-template>
            <!--XLATESTART-->Set power consumption probe threshold(s) and reset reading(s).<!--XLATESTOP-->
        </xsl:when>
        <xsl:when test="$id = &apos;3162&apos;">
          <xsl:call-template name="CLISubCommand">
            <xsl:with-param name="command">pwrmonitoring</xsl:with-param>
          </xsl:call-template>
            <!--XLATESTART-->Set power consumption probe threshold(s) and reset reading(s).<!--XLATESTOP-->
          <xsl:call-template name="NewLine"/>
          <!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
          <xsl:call-template name="NewLine"/>
          <xsl:text>config=probe</xsl:text>
          <xsl:call-template name="NewLine"/>
          <xsl:text>    index=&lt;number&gt;        </xsl:text><!--XLATESTART-->Probe index (must be specified).<!--XLATESTOP-->
          <xsl:call-template name="NewLine"/>
          <xsl:text>    warnthresh=&lt;number&gt;   </xsl:text><!--XLATESTART-->Warning Threshold (in Watts).<!--XLATESTOP-->
          <xsl:call-template name="NewLine"/>
          <xsl:text>    settodefault=&lt;true&gt;   </xsl:text><!--XLATESTART-->Set warning threshold to default.<!--XLATESTOP-->
          <xsl:call-template name="NewLine"/>
          <xsl:text>config=resetreading</xsl:text>
          <xsl:call-template name="NewLine"/>
          <xsl:text>    type=&lt;value&gt;          </xsl:text><!--XLATESTART-->Specify type=energy (for Energy Consumption).<!--XLATESTOP-->
          <xsl:call-template name="NewLine"/>
          <xsl:text>                          </xsl:text><!--XLATESTART-->Specify type=peakpower (for System Peak Power and System Peak Amperage).<!--XLATESTOP-->
          <xsl:call-template name="NewLine"/>
			</xsl:when>

			<xsl:otherwise/>
		</xsl:choose>
		<xsl:call-template name="NewLine"/>
	</xsl:template>
	<xsl:template name="CLISubCommand">
		<xsl:param name="command"/>
		<xsl:if test="$command != &apos;&apos;">
			<xsl:value-of select="$command"/>
			<xsl:call-template name="Spaces">
				<xsl:with-param name="num"><xsl:value-of select="(17) - string-length($command)"/></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<xsl:template name="CLIObjName">
		<xsl:param name="subCom"/>
		<xsl:choose>
			<xsl:when test="$subCom = &apos;fans&apos;"><xsl:text>fan probes</xsl:text></xsl:when>
			<xsl:when test="$subCom = &apos;temps&apos;">
				<!--XLATESTART-->temperature probes<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$subCom = &apos;volts&apos;">
				<!--XLATESTART-->voltage probes<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$subCom = &apos;currents&apos;">
				<!--XLATESTART-->current probes<!--XLATESTOP-->
			</xsl:when>
			<xsl:otherwise/>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="CLIParamFormat">
		<xsl:param name="format"/>
		<xsl:choose>
			<xsl:when test="$format = &apos;1&apos;">
			     <xsl:text>text</xsl:text>
			</xsl:when>
			<xsl:when test="$format = &apos;2&apos;">
			     <xsl:text>text</xsl:text>
			</xsl:when>
			<xsl:when test="$format = &apos;3&apos;">
			     <xsl:text>text (alphanumeric only)</xsl:text>
			</xsl:when>
			<xsl:when test="$format = &apos;4&apos;">
			     <xsl:text>number</xsl:text>
			</xsl:when>
			<xsl:when test="$format = &apos;5&apos;">
			     <xsl:text>&lt;true|false&gt;</xsl:text>
			</xsl:when>
			<xsl:when test="$format = &apos;6&apos;">
			     <xsl:text>number</xsl:text>
			</xsl:when>
			<xsl:when test="$format = &apos;7&apos;">
			     <xsl:text>number</xsl:text>
			</xsl:when>
			<xsl:when test="$format = &apos;8&apos;">
			     <xsl:text>d.d</xsl:text>
			</xsl:when>
			<xsl:when test="$format = &apos;9&apos;">
			     <xsl:text>number</xsl:text>
			</xsl:when>
			<xsl:when test="$format = &apos;10&apos;">
			     <xsl:text>date</xsl:text>
			</xsl:when>
			<xsl:when test="$format = &apos;19&apos;">
			     <xsl:text>percent (0-100)</xsl:text>
			</xsl:when>
			<xsl:when test="$format = &apos;26&apos;">
			     <xsl:text>&lt;text&gt; (alphanumeric only)</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<!--XLATESTART-->value<!--XLATESTOP-->
                    </xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="CLIObjNotFound">
		<xsl:param name="subCom"/>
		<xsl:param name="paramNam"/>
		<xsl:param name="param1"/>
		<xsl:choose>
			<xsl:when test="$subCom = &apos;fans&apos;">
			     <xsl:text>Error! No fan probes found on this system.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = &apos;temps&apos;">
				<!--XLATESTART-->Error! No temperature probes found on this system.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$subCom = &apos;volts&apos;">
				<!--XLATESTART-->Error! No voltage probes found on this system.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$subCom = &apos;pwrmonitoring&apos;">
				<!--XLATESTART-->Error! No power consumption probes found on this system.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$subCom = &apos;batteries&apos;">
				<!--XLATESTART-->Error! No battery probes found on this system.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$subCom = &apos;hwperformance&apos;">
							<!--XLATESTART-->Error! No Hardware Peformance probes found on this system.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$subCom = &apos;acswitch&apos;">
			     <xsl:text>Error! No AC Switch feature found on this system.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = &apos;assettag&apos;">
			     <xsl:text>Error! No Asset tag feature found on this system.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = &apos;biossetup&apos;">
			     <xsl:text>Error! This BIOS setup feature is not present on this system.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = &apos;fancontrol&apos;">
			     <xsl:text>Error! No Fan control feature found on this system.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = &apos;memory&apos;">
			     <xsl:text>Error! No memory feature found on this system.</xsl:text>
			</xsl:when>

			<xsl:when test="$subCom = &apos;memorymode&apos;">
		          <xsl:choose>
					<xsl:when test="$param1 = &apos;0&apos;">
 			               <xsl:text>Error! Specified memory mode not available on this chassis.</xsl:text>
					</xsl:when>
					<xsl:when test="$param1 = &apos;1&apos;">
 			               <xsl:text>Error! Spare bank memory mode not available on this chassis.</xsl:text>
					</xsl:when>
					<xsl:when test="$param1 = &apos;2&apos;">
 			               <xsl:text>Error! Mirror memory mode not available on this chassis.</xsl:text>
					</xsl:when>
					<xsl:when test="$param1 = &apos;3&apos;">
 			               <xsl:text>Error! Raid5 memory mode not available on this chassis.</xsl:text>
					</xsl:when>
  			 	     <xsl:otherwise>
                                <xsl:text>Error! Specified memory mode not available on this chassis.</xsl:text>
                         </xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$subCom = &apos;pwrsupplies&apos;">
			     <xsl:text>Error! No instrumented power supplies found on this system.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'frontpanel'">
			     <xsl:text>Error! No front panel button controls found on this system.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'powerbutton'">
			     <xsl:text>Error! No power button control found on this system.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'nmibutton'">
			     <xsl:text>Error! No NMI button control found on this system.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'nics'">
			     <xsl:text>Error! No Network Interface Card found on this system.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = &apos;leds&apos;">
			     <xsl:text>Error! This LED setting is not supported on this system.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = &apos;intrusion&apos;">
			     <xsl:text>Error! Intrusion information is not found for this system.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = &apos;info&apos;">
				<xsl:choose>
					<xsl:when test="$paramNam = &apos;pmmtag&apos;">
			     		<xsl:text>Error! PMM tag setting unavailable on this system.</xsl:text>
  			          </xsl:when>
					<xsl:when test="$paramNam = &apos;iomtag&apos;">
			     		<xsl:text>Error! IOM tag setting unavailable on this system.</xsl:text>
  			          </xsl:when>
					<xsl:when test="$paramNam = &apos;dsm0tag&apos;">
			     		<xsl:text>Error! DSM0 tag setting unavailable on this system.</xsl:text>
  			          </xsl:when>
					<xsl:when test="$paramNam = &apos;dsm1tag&apos;">
			     		<xsl:text>Error! DSM1 tag setting unavailable on this system.</xsl:text>
  			          </xsl:when>
					<xsl:when test="$paramNam = &apos;dsm2tag&apos;">
			     		<xsl:text>Error! DSM2 tag setting unavailable on this system.</xsl:text>
  			          </xsl:when>
					<xsl:otherwise>
			     		<xsl:text>Error! Chassis info setting unavailable on this system.</xsl:text>
					</xsl:otherwise>
                    </xsl:choose>
			</xsl:when>
			<xsl:when test="$subCom = 'lcd'">
				<xsl:choose>
					<xsl:when test="$paramNam = 'lcdIndex'">
						<xsl:text>Error! Invalid LCD Index.</xsl:text>
						<xsl:choose>
							<xsl:when test="$param1 = '1'">
								<xsl:text> The only valid LCD index for this system is 1.</xsl:text>
							</xsl:when>
							<xsl:when test="$param1 &gt; 1">
								<xsl:text> The LCD index must be between 1 and </xsl:text><xsl:value-of select="$param1"/><xsl:text>.</xsl:text>
							</xsl:when>
						</xsl:choose>
					</xsl:when>
					<xsl:when test="$paramNam = 'lcdLineNotAscii'">
						<xsl:text>Error! Invalid characters found in text. Only ASCII characters are allowed.</xsl:text>
					</xsl:when>
					<xsl:when test="$paramNam = 'lcdLineLength'">
						<xsl:text>Error! The text specified it too long.</xsl:text>
						<xsl:if test="$param1 != ''">
							<xsl:text> The maximum LCD line length is </xsl:text><xsl:value-of select="$param1"/><xsl:text> characters.</xsl:text>
						</xsl:if>
					</xsl:when>
					<xsl:when test="$paramNam = 'lcdObj'">
						<xsl:text>Error! LCD options are not supported on this system.</xsl:text>
					</xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise><!--XLATESTART-->Error! Hardware or feature not present.<!--XLATESTOP--></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="CLIProbeInvalid">
		<xsl:param name="subCom"/>
		<xsl:param name="probeindex"/>
		<xsl:choose>
			<xsl:when test="$subCom = &apos;fans&apos;">
			     <xsl:text>Error! Fan probe warning thresholds unavailable for index value:</xsl:text>
					<xsl:value-of select="$probeindex"/>
			</xsl:when>
			<xsl:when test="$subCom = &apos;temps&apos;">
				<!--XLATESTART-->Error! Temperature probe warning thresholds unavailable for index: <!--XLATESTOP-->
       				<xsl:value-of select="$probeindex"/>
			</xsl:when>
			<xsl:when test="$subCom = &apos;volts&apos;">
				<!--XLATESTART-->Error! Voltage probe warning thresholds unavailable for index: <!--XLATESTOP-->
       				<xsl:value-of select="$probeindex"/>
			</xsl:when>
			<xsl:when test="$subCom = &apos;pwrmonitoring&apos;">
				<!--XLATESTART-->Error! Power consumption probe warning threshold unavailable for index: <!--XLATESTOP-->
       				<xsl:value-of select="$probeindex"/>
			</xsl:when>
			<xsl:otherwise><!--XLATESTART-->Error! Hardware or feature not present.<!--XLATESTOP--></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

<xsl:template name="CLIWarnThresh">
		<xsl:param name="subCom"/>
		<xsl:choose>
			<xsl:when test="$subCom = &apos;fans&apos;">
			     <xsl:text>Error! Cannot set default value and specific value at the same time.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = &apos;temps&apos;">
			     <xsl:text>Error! Cannot set default value and specific value at the same time.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = &apos;volts&apos;">
			     <xsl:text>Error! Cannot set default value and specific value at the same time.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = &apos;pwrmonitoring&apos;">
			     <xsl:text>Error! Cannot set default value and specific value at the same time.</xsl:text>
			</xsl:when>
			<xsl:otherwise><!--XLATESTART-->Error! Hardware or feature not present.<!--XLATESTOP--></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

<xsl:template name="CLIWarnUnavailable">
		<xsl:param name="subCom"/>
		<xsl:param name="probeindex"/>
		<xsl:choose>
			<xsl:when test="$subCom = &apos;fans&apos;">
			     <xsl:text>Error! Default fan threshold setting unavailable </xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = &apos;temps&apos;">
			     <xsl:text>Error! Default temperature threshold setting unavailable </xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = &apos;volts&apos;">
			     <xsl:text>Error! Default voltage threshold setting unavailable </xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = &apos;pwrmonitoring&apos;">
			     <xsl:text>Error! Default power consumption threshold setting unavailable </xsl:text>
			</xsl:when>
			<xsl:otherwise><!--XLATESTART-->Error! Hardware or feature not present.<!--XLATESTOP--></xsl:otherwise>
		</xsl:choose>
			<xsl:text>for index: </xsl:text><xsl:value-of select="$probeindex"/><xsl:text>.</xsl:text>
	</xsl:template>

<xsl:template name="CLIMaxSetUnavailable">
		<xsl:param name="subCom"/>
		<xsl:choose>
			<xsl:when test="$subCom = 'fans'">
			     <xsl:text>Error! Maximum warning fan threshold setting unavailable on this probe.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'temps'">
			     <xsl:text>Error! Maximum warning temperature threshold setting unavailable on this probe.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'volts'">
			     <xsl:text>Error! Maximum warning voltage threshold setting unavailable on this probe.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'pwrmonitoring'">
			     <xsl:text>Error! power consumption warning threshold setting unavailable on this probe.</xsl:text>
			</xsl:when>
			<xsl:otherwise><!--XLATESTART-->Error! Hardware or feature not present.<!--XLATESTOP--></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="CLIMinSetUnavailable">
		<xsl:param name="subCom"/>
		<xsl:choose>
			<xsl:when test="$subCom = 'fans'">
			     <xsl:text>Error! Minimum warning fan threshold setting unavailable on this probe.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'temps'">
			     <xsl:text>Error! Minimum warning temperature threshold setting unavailable on this probe.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'volts'">
			     <xsl:text>Error! Minimum warning voltage threshold setting unavailable on this probe.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'currents'">
			     <xsl:text>Error! Minimum warning current threshold setting unavailable on this probe.</xsl:text>
			</xsl:when>
			<xsl:otherwise><!--XLATESTART-->Error! Hardware or feature not present.<!--XLATESTOP--></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="CLICommandFailed">
		<xsl:param name="subCom"/>
		<xsl:param name="paramNam"/>
		<xsl:param name="stat"/>
		<xsl:choose>
			<xsl:when test="$subCom = &apos;leds&apos;">
			     <xsl:text>Error! This LED setting is not supported on this system.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = &apos;info&apos;">

			<!--MOH&gt;&lt;/MOH-->


			     <xsl:text>Error! Chassis name cannot be changed on this chassis.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = &apos;biossetup&apos;">
				<xsl:choose>
					<xsl:when test="$stat = &apos;256&apos;">
			            		<xsl:text>Error! BIOS setting unavailable.</xsl:text>
				      </xsl:when>
					<xsl:otherwise>
			            		<xsl:text>Error! BIOS setting failed.</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$subCom = &apos;fancontrol&apos;">
				<xsl:choose>
					<xsl:when test="$stat = &apos;256&apos;">
			            		<xsl:text>Error! Fan control setting unavailable on this system.</xsl:text>
				      </xsl:when>
					<xsl:otherwise>
			            		<xsl:text>Error! BIOS setting failed.</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>

			<xsl:when test="$subCom = &apos;memorymode&apos;">
			     <xsl:text>Error! Hardware subsystem reports memory mode setting failed.</xsl:text>
			</xsl:when>

			<xsl:when test="$subCom = 'bmc' or $subCom = 'remoteaccess'">
				<xsl:choose>
					<xsl:when test="$stat = '4300' and $paramNam = 'charsendthreshold'">
						<xsl:text>Error! The value specified is not valid on this system.</xsl:text>
					</xsl:when>

					<xsl:when test="$stat = '4300' and $paramNam = 'characcuminterval'">
						<xsl:text>Error! The value specified is not valid on this system.</xsl:text>
					</xsl:when>

					<xsl:when test="$stat= '8224' or $stat= '4300'">
					     <xsl:text>Error! Username already exists.</xsl:text>
					</xsl:when>
					<xsl:when test="$stat = '16'">	<!-- DATA_OVERRUN -->
						<xsl:text>Error! The text entered exceeded the maximum number of characters.</xsl:text>
					</xsl:when>
					<xsl:when test="$stat = '271'">	<!-- INVALID_PARAMETER -->
						<xsl:text>Error! The value specified is not valid on this system.</xsl:text>
					</xsl:when>
					<xsl:when test="$stat = '8215'">	<!-- RESTORE_DEFAULT_IN_PROGRESS -->
						<xsl:text>Error! Remote Access reset to default in progress.</xsl:text>
					</xsl:when>
					<xsl:otherwise>
			              <xsl:text>Error! This function has either failed or is not supported on this system.</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>

			<xsl:otherwise><!--XLATETHIS-->Error! Hardware subsystem reports command failed. <!--XLATETHIS--></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="ConfigSuccess">
		<xsl:param name="subCom"/>
		<xsl:choose>
			<xsl:when test="$subCom = &apos;fans&apos;">
			     <xsl:text>Fan probe warning threshold(s) set successfully.</xsl:text>
			</xsl:when>

			<xsl:when test="$subCom = &apos;temps&apos;">
				 <xsl:text>Temperature probe warning threshold(s) set successfully.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = &apos;volts&apos;">
				<xsl:text>Voltage probe warning threshold(s) set successfully.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = &apos;acswitch&apos;">
			     <xsl:text>AC Switch configured successfully.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = &apos;info&apos;">
			     <xsl:text>Chassis info set successfully.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = &apos;assettag&apos;">
			     <xsl:text>Asset tag set successfully.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = &apos;biossetup&apos;">
			     <xsl:text>BIOS setup configured successfully. Change will take effect after the next reboot.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = &apos;fancontrol&apos;">
			     <xsl:text>Fan control configured successfully.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = &apos;memory&apos;">
			     <xsl:text>Memory error count cleared successfully.</xsl:text>
			</xsl:when>

			<xsl:when test="$subCom = &apos;memorymode&apos;">
			     <xsl:text>Memory mode set successfully. Change will take effect after the next reboot.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'frontpanel'">
			     <xsl:text>Front Panel button controls configured successfully.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = &apos;leds&apos;">
			     <xsl:text>LED configured successfully.</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<!--XLATESTART-->Command successful.<!--XLATESTOP-->
                    </xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="CLIIndexRange">
		<xsl:param name="subCom"/>
		<xsl:param name="index"/>
		<xsl:choose>
			<xsl:when test="$subCom = &apos;fans&apos;">
			     <xsl:text>Error! Index too large. Maximum fan probe index is: </xsl:text>
				<xsl:value-of select="$index"/>
			</xsl:when>
			<xsl:when test="$subCom = &apos;temps&apos;">
			     <xsl:text>Error! Index too large. Maximum temperature probe index is: </xsl:text>
				<xsl:value-of select="$index"/>
			</xsl:when>
			<xsl:when test="$subCom = &apos;volts&apos;">
			     <xsl:text>Error! Index too large. Maximum voltage probe index is: </xsl:text>
				<xsl:value-of select="$index"/>
			</xsl:when>
			<xsl:when test="$subCom = &apos;pwrmonitoring&apos;">
			     <xsl:text>Error! Index too large. Maximum power consumption probe index is: </xsl:text>
				<xsl:value-of select="$index"/>
			</xsl:when>
			<xsl:when test="$subCom = &apos;slots&apos;">
			     <xsl:text>Error! Index too large. Maximum slots index is: </xsl:text>
				<xsl:value-of select="$index"/>
			</xsl:when>
			<xsl:when test="$subCom = &apos;memory&apos;">
			     <xsl:text>Error! Index too large. Maximum memory index is: </xsl:text>
				<xsl:value-of select="$index"/>
			</xsl:when>
			<xsl:when test="$subCom = &apos;processors&apos;">
			     <xsl:text>Error! Index too large. Maximum processor index is: </xsl:text>
				<xsl:value-of select="$index"/>
			</xsl:when>
			<xsl:when test="$subCom = &apos;info&apos;">
			     <xsl:text>Error! Index too large. Maximum chassis index is: </xsl:text>
				<xsl:value-of select="$index"/>
			</xsl:when>
			<xsl:when test="$subCom = &apos;leds&apos;">
			     <xsl:text>Error! Index too large. Maximum chassis index is: </xsl:text>
				<xsl:value-of select="$index"/>
			</xsl:when>
			<xsl:when test="$subCom = &apos;biossetup&apos;">
			     <xsl:text>Error! biossetup attribute not found.</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>Error! Index too large. Maximum index for this command is: </xsl:text>
				<xsl:value-of select="$index"/>
                    </xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Spaces">
		<xsl:param name="num"/>
		<xsl:if test="$num > 0">
			<xsl:text> </xsl:text>
			<xsl:call-template name="Spaces">
				<xsl:with-param name="num" select="$num - 1"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<xsl:template name="NewLine">
		<xsl:text>
</xsl:text>
	</xsl:template>
		<xsl:template name="prnTemp">
	<xsl:param name="temp"/>
	<xsl:value-of select="format-number($temp div 10,&apos;###.0&apos;)"/>
	</xsl:template>
	<xsl:template name="prnCurrent">
	<xsl:param name="current"/>
	<xsl:value-of select="format-number($current div 1000,&apos;###.000&apos;)"/>
      </xsl:template>
	<xsl:template name="prnVolt">
	<xsl:param name="volt"/>
	<xsl:value-of select="format-number($volt div 1000,&apos;###.000&apos;)"/>
      </xsl:template>

	<xsl:template name="printSubcommandDeprecated">
		<xsl:param name="newCommand"/>
		<xsl:param name="standalone">true</xsl:param>

		<xsl:variable name="numIndentSpaces"><xsl:value-of select="$subCommandIndentSize + 2"/></xsl:variable>

		<xsl:call-template name="NewLine"/>
		<xsl:if test="$standalone = 'true'">
			<xsl:call-template name="NewLine"/>
		</xsl:if>
		<xsl:if test="$standalone = 'false'">
			<xsl:call-template name="Spaces">
				<xsl:with-param name="num"><xsl:value-of select="$numIndentSpaces"/></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		<xsl:text>SUBCOMMAND DEPRECATION WARNING:</xsl:text>
		<xsl:call-template name="NewLine"/>
		<xsl:if test="$standalone = 'false'">
			<xsl:call-template name="Spaces">
				<xsl:with-param name="num"><xsl:value-of select="$numIndentSpaces"/></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		<xsl:text>This subcommand is deprecated and will be discontinued in </xsl:text>
		<xsl:if test="$standalone = 'false'">
			<xsl:call-template name="NewLine"/>
			<xsl:call-template name="Spaces">
				<xsl:with-param name="num"><xsl:value-of select="$numIndentSpaces"/></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		<xsl:text>a subsequent release.</xsl:text>
		<xsl:if test="$standalone = 'true'">
			<xsl:call-template name="NewLine"/>
		</xsl:if>
		<xsl:if test="$newCommand != ''">
			<xsl:if test="$standalone = 'false'">
				<xsl:call-template name="NewLine"/>
			</xsl:if>
			<xsl:if test="$standalone = 'false'">
				<xsl:call-template name="Spaces">
					<xsl:with-param name="num"><xsl:value-of select="$numIndentSpaces"/></xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:text>Use the subcommand "</xsl:text>
			<xsl:value-of select="$newCommand"/>
			<xsl:text>" instead.</xsl:text>
			<xsl:if test="$standalone = 'true'">
				<xsl:call-template name="NewLine"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>

	<xsl:template name="printSubcommandDeprecatedExt">
		<xsl:param name="newCommand"/>
		<xsl:param name="standalone">true</xsl:param>

		<xsl:variable name="numIndentSpaces"><xsl:value-of select="$subCommandIndentSize + 2"/></xsl:variable>

		<xsl:call-template name="printSubcommandDeprecated">
			<xsl:with-param name="newCommand"><xsl:value-of select="$newCommand"/></xsl:with-param>
			<xsl:with-param name="standalone"><xsl:value-of select="$standalone"/></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="NewLine"/>
		<xsl:call-template name="Spaces">
			<xsl:with-param name="num"><xsl:value-of select="$numIndentSpaces"/></xsl:with-param>
		</xsl:call-template>
		<xsl:text>This is applicable on modular systems only.</xsl:text>
		<xsl:if test="$standalone = 'true'">
			<xsl:call-template name="NewLine"/>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
