<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:strip-space elements="*"/>
<xsl:output method="xml"/>
<xsl:template match="/OMA">
	<xsl:choose>
		<xsl:when test="SMStatus != '0'">
			<DataArea>
				<PageTitle>
					<xsl:attribute name="display"><xsl:value-of select="$strSlotsInformation"/></xsl:attribute>
				</PageTitle>
				<TableData>
					<Header>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strError"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strError1"/></xsl:attribute>
						</Data>
					</Header>
					<Row>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strSlotInformationNot"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strSlotInformationNot1"/></xsl:attribute>
						</Data>
					</Row>
				</TableData>
			</DataArea>
		</xsl:when>
		<xsl:otherwise>
			<DataArea>
				<PageTitle>
					<xsl:attribute name="display"><xsl:value-of select="$strSlotsInformation1"/></xsl:attribute>
				</PageTitle>
				<CustomButton>
					<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
						<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.SlotsWebPlugin&amp;poid=2</xsl:attribute>
					</Data>
				</CustomButton>
				<PromptText ignoreoncli="true"><xsl:value-of select="$strClickASlot"/></PromptText>
				<xsl:apply-templates select="SlotsList"/>
			</DataArea>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="SlotsList">
	<TableData name=""><xsl:attribute name="display"><xsl:value-of select="$str"/></xsl:attribute>
		<Header>
			<Data name="" editable="" type="" align="center" ignoreonweb="true">
				<xsl:attribute name="display"><xsl:value-of select="$strIndex"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strIndex1"/></xsl:attribute>
			</Data>
			<Data name="" editable="" type="">
				<xsl:attribute name="display"><xsl:value-of select="$strSlotID"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strSlotID1"/></xsl:attribute>
			</Data>
			<Data name="" editable="" type="">
				<xsl:attribute name="display"><xsl:value-of select="$strAdapter"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strAdapter1"/></xsl:attribute>
			</Data>
			<Data name="" editable="" type="">
				<xsl:attribute name="display"><xsl:value-of select="$strDataBusWidth"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strDataBusWidth1"/></xsl:attribute>
			</Data>
		</Header>
		<xsl:apply-templates select="Slot"/>
	</TableData>
</xsl:template>

<xsl:template match="Slot">
	<Row>
		<Data name=""  editable="false" align="center" ignoreonweb="true"><xsl:attribute name="display"><xsl:value-of select="$str1"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="@index"/></xsl:attribute>
		</Data>
		<Data name=""  editable="false" type="ustring"><xsl:attribute name="display"><xsl:value-of select="$str2"/></xsl:attribute>
			<xsl:attribute name="value">
				<xsl:choose>
               		<xsl:when test="ExtName='Embedded'">
						<xsl:value-of select="$strEmbedded"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="ExtName"/>
					</xsl:otherwise>
            		</xsl:choose>
			</xsl:attribute>
			<xsl:if test="SlotID!='0'">
				<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.SlotWebPlugin&amp;oid=<xsl:value-of select="@oid"/>&amp;help=SlotDevice</xsl:attribute>
				<xsl:attribute name="link">true</xsl:attribute>
			</xsl:if>
		</Data>
		<Data name=""  editable="false" type=""><xsl:attribute name="display"><xsl:value-of select="$str3"/></xsl:attribute>
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="SlotDevice">
						<xsl:choose>
							<xsl:when test="SlotDevice/DeviceDesc = 'ERA'"><xsl:value-of select="$strEmbeddedRemoteAccess"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="SlotDevice/DeviceDesc" /></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise><xsl:value-of select="$strNotOccupied"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:if test="SlotDevice">
				<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.SlotDeviceWebPlugin&amp;poid=<xsl:value-of select="@oid" />&amp;slotid=<xsl:value-of select="SlotID"/>&amp;help=Adapter</xsl:attribute>
				<xsl:attribute name="link">true</xsl:attribute>
			</xsl:if>
		</Data>
		<Data name=""  editable="false" type="ustring"><xsl:attribute name="display"><xsl:value-of select="$str4"/></xsl:attribute>
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="HotPlugSystemSlot/DataBusWidth='1'"><xsl:value-of select="$strOther"/></xsl:when>
					<xsl:when test="HotPlugSystemSlot/DataBusWidth='3'"><xsl:value-of select="$str8Bits"/></xsl:when>
					<xsl:when test="HotPlugSystemSlot/DataBusWidth='4'"><xsl:value-of select="$str16Bits"/></xsl:when>
					<xsl:when test="HotPlugSystemSlot/DataBusWidth='5'"><xsl:value-of select="$str32Bits"/></xsl:when>
					<xsl:when test="HotPlugSystemSlot/DataBusWidth='6'"><xsl:value-of select="$str64Bits"/></xsl:when>
					<xsl:when test="HotPlugSystemSlot/DataBusWidth='7'"><xsl:value-of select="$str128Bits"/></xsl:when>		
					<xsl:when test="HotPlugSystemSlot/DataBusWidth='8'"><xsl:value-of select="$str1xOr1x"/></xsl:when>
					<xsl:when test="HotPlugSystemSlot/DataBusWidth='9'"><xsl:value-of select="$str2xOr2x"/></xsl:when>
					<xsl:when test="HotPlugSystemSlot/DataBusWidth='10'"><xsl:value-of select="$str4xOr4x"/></xsl:when>
					<xsl:when test="HotPlugSystemSlot/DataBusWidth='11'"><xsl:value-of select="$str8xOr8x"/></xsl:when>
					<xsl:when test="HotPlugSystemSlot/DataBusWidth='12'"><xsl:value-of select="$str12xOr12x"/></xsl:when>
					<xsl:when test="HotPlugSystemSlot/DataBusWidth='13'"><xsl:value-of select="$str16xOr16x"/></xsl:when>
					<xsl:when test="HotPlugSystemSlot/DataBusWidth='14'"><xsl:value-of select="$str32xOr32x"/></xsl:when>				
					<xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	</Row>
</xsl:template>

<xsl:template match="*"/>

</xsl:stylesheet>
