<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:strip-space elements="*"/>
<xsl:output method="xml"/>
<xsl:template match="/OMA">
	<DataArea>
		<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strSlots"/></xsl:attribute>
		<xsl:attribute name="backpagetarget">/servlet/DataArea?plugin=com.dell.hip.webplugins.SlotsWebPlugin&amp;poid=2&amp;help=Slots</xsl:attribute>
		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strAdapterInformation"/></xsl:attribute>
		</PageTitle>
		<CustomButton>
			<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.SlotDeviceWebPlugin&amp;poid=<xsl:value-of select="Slot/@oid"/>&amp;id=<xsl:value-of select="Slot/@slotid"/></xsl:attribute>
			</Data>
		</CustomButton>
		<TableData>
			<xsl:choose>
				<xsl:when test="SMStatus[1] = '0' or SMStatus[2] = '0'">
					<Header>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strAttributes"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strAttributes1"/></xsl:attribute>
						</Data>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strValues"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strValues1"/></xsl:attribute>
						</Data>
					</Header>
					<xsl:apply-templates select="SlotDevice"/>
				</xsl:when>
				<xsl:otherwise>
					<Header>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strError"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strError1"/></xsl:attribute>
						</Data>
					</Header>
					<Row>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strSlotInformationNot"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strSlotInformationNot1"/></xsl:attribute>
						</Data>
					</Row>
				</xsl:otherwise>
			</xsl:choose>
		</TableData>
	</DataArea>
</xsl:template>

<xsl:template match="SlotDevice">
	<Row>
		<Data name="DeviceManufacturer"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strAdapterManufacturer"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strAdapterManufacturer1"/></xsl:attribute>
		</Data>
		<Data name="DeviceManufacturer_value"  editable="false" type="ustring">
			<xsl:attribute name="value"><xsl:value-of select="Manufacturer"/></xsl:attribute>
		</Data>
	</Row>
	<Row>
		<Data name="DeviceDesc"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strAdapterDescription"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strAdapterDescription1"/></xsl:attribute>
		</Data>
		<Data name="DeviceDesc_value"  editable="false" type="ustring">
			<xsl:choose>
				<xsl:when test="DeviceDesc = 'ERA'"><xsl:attribute name="value"><xsl:value-of select="$strEmbeddedRemoteAccess"/></xsl:attribute></xsl:when>
				<xsl:otherwise><xsl:attribute name="value"><xsl:value-of select="DeviceDesc"/></xsl:attribute></xsl:otherwise>
			</xsl:choose>
		</Data>
	</Row>
	<Row>
		<Data name="DeviceDataBusWidth"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strAdapterDataBus"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strAdapterDataBus1"/></xsl:attribute>
		</Data>
		<Data name="DeviceDataBusWidth_value"  editable="false" type="ustring">
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="DataBusWidth = '0'"><xsl:value-of select="$strNotObtainedRefer"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="DataBusWidth"/> <xsl:value-of select="$strBits"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	</Row>
	<Row>
		<Data name="DeviceSpeed"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strAdapterSpeed"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strAdapterSpeed1"/></xsl:attribute>
		</Data>
		<Data name="DeviceSpeed_value"  editable="false" type="ustring">
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="Speed='0'"><xsl:value-of select="$strNotObtainedRefer"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="Speed"/><xsl:text> </xsl:text><xsl:value-of select="Speed/@unit"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	</Row>
</xsl:template>

<xsl:template match="*"/>

</xsl:stylesheet>
