<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:strip-space elements="*"/>
<xsl:template match="/OMA">
	<xsl:choose>
		<xsl:when test="SMStatus='0'"><xsl:call-template name="success"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="failure"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="failure">
	<DataArea exportdata="false">
		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strRemoteShutdown"/></xsl:attribute>
		</PageTitle>
		<TableData>
			<Header>
				<Data name="">
					<xsl:attribute name="display"><xsl:value-of select="$strError"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strError1"/></xsl:attribute>
				</Data>
			</Header>
			<Row>
				<Data name="" ><xsl:attribute name="display"><xsl:value-of select="$str"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:call-template name="smstatus">
							<xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param>
						</xsl:call-template>
					</xsl:attribute>
				</Data>
			</Row>
		</TableData>
	</DataArea>
</xsl:template>

<xsl:template name="success">
	<xsl:choose>
		<xsl:when test="@cli='true'"><xsl:call-template name="cli"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="web"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="web">	
	<xsl:choose>
		<xsl:when test="OMAUserRights='7'"><xsl:call-template name="edit"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="view"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="edit">
	<DataArea validate="true" exportdata="false">
		<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.hip.webplugins.shtdwnWebPlugin&amp;oid=<xsl:value-of select="HostControl/@oid"/></xsl:attribute>
		<xsl:attribute name="submitdisplay"><xsl:value-of select="$strShutdown"/></xsl:attribute>
		<xsl:attribute name="email">false</xsl:attribute>
		<xsl:attribute name="printable">false</xsl:attribute>
		
		<CustomButton>
			<Data name="Refresh">
				<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.GetshtdwnWebPlugin&amp;help=Shutdown</xsl:attribute>
			</Data>
		</CustomButton>
			
		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strRemoteShutdown1"/></xsl:attribute>
		</PageTitle>
		<xsl:choose>
			<xsl:when test="(HostControl/Capabilities/OSShutdown='false') and (HostControl/Settings/OSShutdown='false')">
				<PromptText>
					<xsl:attribute name="display"><xsl:value-of select="$strOSShutdownIsDisabled"/></xsl:attribute>
					<xsl:value-of select="$strOSShutdownIsDisabled1"/>
				</PromptText>
			</xsl:when>
			<xsl:otherwise>
				<TableData name="osshutdown">
					<xsl:attribute name="display"><xsl:value-of select="$strOSShutdown"/></xsl:attribute>
					<Header>
						<Data name="">
							<xsl:attribute name="display"><xsl:value-of select="$strOSShutdown1"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strOSShutdown2"/></xsl:attribute>
						</Data>
					</Header>
					<Row>
						<Data>
							<xsl:attribute name="name">os</xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strShutdownOSFirst"/></xsl:attribute>
							<xsl:attribute name="type">checkbox</xsl:attribute>
							<xsl:attribute name="returnvalue">8</xsl:attribute>
							<xsl:attribute name="state">1<!--xsl:call-template name="OSselect"/--></xsl:attribute><!-- 121245 - OS Shutdown First not selected by default under system shutdown -->
						</Data>
					</Row>
				</TableData>			
			</xsl:otherwise>
		</xsl:choose>
		
		<xsl:choose>
			<xsl:when test="(HostControl/Capabilities/Reboot='false') and (HostControl/Settings/Reboot='false') and (HostControl/Capabilities/PwrOff='false') and (HostControl/Settings/PwrOff='false') and (HostControl/Capabilities/PwrCycle='false') and (HostControl/Settings/PwrCycle='false')">				
				<PromptText>
					<xsl:attribute name="display"><xsl:value-of select="$strRemoteShutdownAction"/></xsl:attribute>
					<xsl:value-of select="$strRemoteShutdownAction1"/>
				</PromptText>				
			</xsl:when>
			<xsl:otherwise>
				<TableData name="rshutdownaction">
					<xsl:attribute name="display"><xsl:value-of select="$strRemoteShutdownAction2"/></xsl:attribute>
					<Header>
						<Data name="">
							<xsl:attribute name="display"><xsl:value-of select="$strRemoteShutdownAction3"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strRemoteShutdownAction4"/></xsl:attribute>
						</Data>
					</Header>
					<xsl:call-template name="edit1"/>
				</TableData>
			</xsl:otherwise>
		</xsl:choose>
		
		<script language="javascript">
			function validate(){
				<xsl:choose>				
					<xsl:when test="(HostControl/Capabilities/OSShutdown='false') and (HostControl/Settings/OSShutdown='false')">
						if (confirm("<xsl:value-of select="$strDoYouReally"/>")){
							return true;
						}
						else{
							return false;
						}				
					</xsl:when>
					<xsl:otherwise>
						if (document.getElementById("dataarea").os.checked == true){
							if (confirm("<xsl:value-of select="$strDoYouReally1"/>")){
								return true;
							}
							else{
								return false;
							}	
						}
						else {
							if (confirm("<xsl:value-of select="$strYouHaveSelected"/>")){
								return true;
							}
							else{
								return false;
							}	
						}
						
					</xsl:otherwise>
				</xsl:choose>
				
			}								
		</script>
			
	</DataArea>
</xsl:template>
<xsl:template name="edit1">
	<xsl:if test="HostControl/Capabilities/Reboot='true'">
		<Row>
			<Data type="radio">
				<xsl:attribute name="name">action1</xsl:attribute>
				<xsl:attribute name="returnvalue">1</xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strRebootSystem"/></xsl:attribute>
				<xsl:attribute name="state"><xsl:call-template name="rebootselect1"/></xsl:attribute>
			</Data>
		</Row>
	</xsl:if>	
	<xsl:if test="HostControl/Capabilities/PwrOff='true'">
		<Row>
			<Data type="radio">
				<xsl:attribute name="name">action1</xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strPowerOffSystem"/></xsl:attribute>
				<xsl:attribute name="returnvalue">2</xsl:attribute>
				<xsl:attribute name="state"><xsl:call-template name="poweroffselect1"/></xsl:attribute>
			</Data>
		</Row>
	</xsl:if>	
	<xsl:if test="HostControl/Capabilities/PwrCycle='true'">
		<Row>
			<Data type="radio">
				<xsl:attribute name="name">action1</xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strPowerCycleSystem"/></xsl:attribute>
				<xsl:attribute name="returnvalue">4</xsl:attribute>
				<xsl:attribute name="state"><xsl:call-template name="powercycleselect1"/></xsl:attribute>
			</Data>
		</Row>
	</xsl:if>
</xsl:template>
<xsl:template name="rebootselect1">
<xsl:variable name="setting" select="HostControl/Settings/Reboot"/>
<xsl:variable name="setting1" select="HostControl/Settings/PwrOff"/>
<xsl:variable name="setting2" select="HostControl/Settings/PwrCycle"/>
	<xsl:choose>
		<xsl:when test="$setting='true'">1</xsl:when>
		<xsl:when test="$setting1='false'">
			<xsl:choose>
				<xsl:when test="$setting2='false'">1</xsl:when>
			</xsl:choose>
		</xsl:when>
	</xsl:choose>
</xsl:template>
<xsl:template name="poweroffselect1">
<xsl:variable name="setting" select="HostControl/Settings/PwrOff"/>
	<xsl:if test="$setting='true'">1</xsl:if>
</xsl:template>
<xsl:template name="powercycleselect1">
<xsl:variable name="setting" select="HostControl/Settings/PwrCycle"/>
	<xsl:if test="$setting='true'">1</xsl:if>
</xsl:template>
<xsl:template name="OSselect1">
<xsl:variable name="setting" select="HostControl/Settings/OSShutdown"/>
	<xsl:choose>
		<!-- 107768 Changed the value for otherwise to 0, it was 1 (?) , This was later deemed as incorrect per 121245 -->
		<xsl:when test="$setting='true'">1</xsl:when>
		<xsl:otherwise>1</xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="view">
	<DataArea exportdata="false">
		<CustomButton>
			<Data name="Refresh">
				<xsl:attribute name="display"><xsl:value-of select="$strRefresh1"/></xsl:attribute>
				<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.GetshtdwnWebPlugin&amp;help=Shutdown</xsl:attribute>
			</Data>
		</CustomButton>
		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strShutdown1"/></xsl:attribute>
		</PageTitle>
		<TableData name="osshutdown">
			<xsl:attribute name="display"><xsl:value-of select="$strOSShutdown3"/></xsl:attribute>
			<Header>
				<Data name="">
					<xsl:attribute name="display"><xsl:value-of select="$strOSShutdown4"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strOSShutdown5"/></xsl:attribute>
				</Data>
			</Header>
			<Row>
				<Data>
					<xsl:attribute name="name">os</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strShutdownOSFirst1"/></xsl:attribute>
					<xsl:attribute name="type">checkbox</xsl:attribute>
					<xsl:attribute name="returnvalue">8</xsl:attribute>
					<xsl:attribute name="state">2<!-- DF:111122--><!--xsl:call-template name="OSselect1"/--></xsl:attribute> <!-- 121245 - OS Shutdown First not selected by default under system shutdown -->
				</Data>
			</Row>
		</TableData>
		<TableData name="rshutdownaction">
			<xsl:attribute name="display"><xsl:value-of select="$strRemoteShutdownAction5"/></xsl:attribute>
			<Header>
				<Data name="">
					<xsl:attribute name="display"><xsl:value-of select="$strRemoteShutdownAction6"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strRemoteShutdownAction7"/></xsl:attribute>
				</Data>
			</Header>
			<xsl:call-template name="view1"/>
		</TableData>
	</DataArea>
</xsl:template>
<xsl:template name="view1">
	<xsl:if test="HostControl/Capabilities/Reboot='true'">
	<Row>
		<Data type="radio">
			<xsl:attribute name="name">Reboot</xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strRebootSystem1"/></xsl:attribute>
			<xsl:attribute name="returnvalue">1</xsl:attribute>
			<xsl:attribute name="state"><xsl:call-template name="rebootselect"/></xsl:attribute>
		</Data>
	</Row>
	</xsl:if>
	<xsl:if test="HostControl/Capabilities/PwrOff='true'">
	<Row>
		<Data type="radio">
			<xsl:attribute name="name">PowerOff</xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strPowerOffSystem1"/></xsl:attribute>
			<xsl:attribute name="returnvalue">2</xsl:attribute>
			<xsl:attribute name="state"><xsl:call-template name="poweroffselect"/></xsl:attribute>
		</Data>
	</Row>		
	</xsl:if>
	<xsl:if test="HostControl/Capabilities/PwrCycle='true'">
	<Row>
		<Data type="radio">
			<xsl:attribute name="name">PowerCycle</xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strPowerCycleSystem1"/></xsl:attribute>
			<xsl:attribute name="returnvalue">4</xsl:attribute>
			<xsl:attribute name="state"><xsl:call-template name="powercycleselect"/></xsl:attribute>
		</Data>
	</Row>		
	</xsl:if>	
</xsl:template>
<xsl:template name="rebootselect">
	<xsl:variable name="setting" select="HostControl/Settings/Reboot"/>
	<xsl:variable name="setting1" select="HostControl/Settings/PwrOff"/>
	<xsl:variable name="setting2" select="HostControl/Settings/PwrCycle"/>
	<xsl:choose>
		<xsl:when test="$setting='true'">3</xsl:when>
		<xsl:when test="$setting1='false'">
			<xsl:choose>
				<xsl:when test="$setting2='false'">3</xsl:when>
				<xsl:otherwise>2</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>2</xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="poweroffselect">
	<xsl:variable name="setting" select="HostControl/Settings/PwrOff"/>
	<xsl:choose>
		<xsl:when test="$setting='true'">3</xsl:when>
		<xsl:otherwise>2</xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="powercycleselect">
	<xsl:variable name="setting" select="HostControl/Settings/PwrCycle"/>
	<xsl:choose>
		<xsl:when test="$setting='true'">3</xsl:when>
		<xsl:otherwise>2</xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="OSselect">
	<xsl:variable name="setting" select="HostControl/Settings/OSShutdown"/>
	<xsl:choose>
		<!--107768, changed values to 1 and 0, it was 3 and 3, this was later deemed incorrect per 121245 -->
		<xsl:when test="$setting='true'">1</xsl:when>
		<xsl:otherwise>1</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name="cli">
	<DataArea>
		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strShutdown2"/></xsl:attribute>
		</PageTitle>
		<xsl:choose>
			<xsl:when test="HostControl/Settings/Reboot='false'">
				<xsl:choose>
					<xsl:when test="HostControl/Settings/PwrOff='false'">
						<xsl:choose>
							<xsl:when test="HostControl/Settings/PwrCycle='false'">
								<xsl:choose>
									<xsl:when test="HostControl/Settings/OSShutdown='false'">
										<ListData>
											<Data value="None">
												<xsl:attribute name="display"><xsl:value-of select="$strShutdownActionPending"/></xsl:attribute>
											</Data>
										</ListData>
									</xsl:when>
									<xsl:otherwise>
										<xsl:call-template name="cliotherwise"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="cliotherwise"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="cliotherwise"/>
					</xsl:otherwise>
				</xsl:choose>			
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="cliotherwise"/>				
			</xsl:otherwise>
		</xsl:choose>
	</DataArea>
</xsl:template>


<xsl:template name="cliotherwise">
	<ListData>
		<xsl:for-each select="HostControl/Capabilities/*">
			<xsl:if test=".='true'">
				<xsl:call-template name="cliotherwise1">
					<xsl:with-param name="name1"><xsl:value-of select="name()"/></xsl:with-param>
				</xsl:call-template>
			</xsl:if>	
		</xsl:for-each>
	</ListData>	
</xsl:template>

<xsl:template name="cliotherwise1">
	<xsl:param name="name1"/>
	<xsl:for-each select="/OMA/HostControl/Settings/*">
		<xsl:if test="$name1=name()">
			<xsl:if test=".='true'">
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strShutdownAction"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$name1"/></xsl:attribute>
				</Data>
			</xsl:if>
		</xsl:if>
	</xsl:for-each>
</xsl:template>

<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:param name="mssg"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'"><xsl:value-of select="$strCommandUnsuccessful"/></xsl:when>
			<xsl:when test="$status = '1'"><xsl:value-of select="$strCommandNotImplemented"/></xsl:when>
			<xsl:when test="$status = '2'"><xsl:value-of select="$strBadCommand"/></xsl:when>
			<xsl:when test="$status = '3'"><xsl:value-of select="$strCommandTimeout"/></xsl:when>
			<xsl:when test="$status = '4'"><xsl:value-of select="$strCommandCancelled"/></xsl:when>
			<xsl:when test="$status = '5'"><xsl:value-of select="$strCommandAborted"/></xsl:when>
			<xsl:when test="$status = '6'"><xsl:value-of select="$strCommandPending"/></xsl:when>
			<xsl:when test="$status = '7'"><xsl:value-of select="$strNoSuchDevice"/></xsl:when>
			<xsl:when test="$status = '8'"><xsl:value-of select="$strDeviceBusy"/></xsl:when>
			<xsl:when test="$status = '9'"><xsl:value-of select="$strBadDevice"/></xsl:when>
			<xsl:when test="$status = '10'"><xsl:value-of select="$strSpuriousInterrupt"/></xsl:when>
			<xsl:when test="$status = '11'"><xsl:value-of select="$strResourceLocked"/></xsl:when>
			<xsl:when test="$status = '12'"><xsl:value-of select="$strInvalidIndex"/></xsl:when>
			<xsl:when test="$status = '13'"><xsl:value-of select="$strSMBError"/></xsl:when>
			<xsl:when test="$status = '14'"><xsl:value-of select="$strDataRequestedIs"/></xsl:when>
			<xsl:when test="$status = '15'"><xsl:value-of select="$strDataRequestedIs1"/></xsl:when>
			<xsl:when test="$status = '16'"><xsl:value-of select="$strDataRequestedIs2"/></xsl:when>
			<xsl:when test="$status = '17'"><xsl:value-of select="$strDeviceNotYet"/></xsl:when>
			<xsl:when test="$status = '18'"><xsl:value-of select="$strDeviceDoesNot"/></xsl:when>
			<xsl:when test="$status = '19'"><xsl:value-of select="$strDeviceOutOf"/></xsl:when>
			<xsl:when test="$status = '20'"><xsl:value-of select="$strDeviceAlreadyExists"/></xsl:when>
			<xsl:when test="$status = '256'"><xsl:value-of select="$strObjectNotFound"/></xsl:when>
			<xsl:when test="$status = '257'"><xsl:value-of select="$strObjectMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '258'"><xsl:value-of select="$strObjectAlreadyExists"/></xsl:when>
			<xsl:when test="$status = '260'"><xsl:value-of select="$strINIFileNot"/></xsl:when>
			<xsl:when test="$status = '261'"><xsl:value-of select="$strINIMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '262'"><xsl:value-of select="$strINISectionDoes"/></xsl:when>
			<xsl:when test="$status = '263'"><xsl:value-of select="$strINIKeyDoes"/></xsl:when>
			<xsl:when test="$status = '264'"><xsl:value-of select="$strINIValueMalformed"/></xsl:when>
			<xsl:when test="$status = '270'"><xsl:value-of select="$strInsufficientAccessRights"/></xsl:when>
			<xsl:when test="$status = '271'"><xsl:value-of select="$strInvalidParameterName"/><xsl:value-of select="$mssg"/></xsl:when>
			<xsl:when test="$status = '272'"><xsl:value-of select="$strOutOfMemory"/></xsl:when>
			<xsl:when test="$status = '280'"><xsl:value-of select="$strXMLFileNot"/></xsl:when>
			<xsl:when test="$status = '281'"><xsl:value-of select="$strXMLMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '282'"><xsl:value-of select="$strXMLNodeDoes"/></xsl:when>
			<xsl:when test="$status = '283'"><xsl:value-of select="$strXMLValueMalformed"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$strSMStatus"/><xsl:value-of select="$status"/></xsl:otherwise>
		</xsl:choose>
</xsl:template>

<xsl:template match="*"/>
</xsl:stylesheet>
