<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:strip-space elements="*"/>
<xsl:output method="xml"/>
<xsl:template match="/OMA">
	<DataArea>
		<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strPorts"/></xsl:attribute>
		<xsl:attribute name="backpagetarget">/servlet/DataArea?plugin=com.dell.hip.webplugins.PortsWebPlugin&amp;poid=2</xsl:attribute>
		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strPort"/> <xsl:value-of select="Port/@portid" /><xsl:value-of select="$strDeviceInformation"/></xsl:attribute>
			<xsl:attribute name="status"><xsl:value-of select="PortDevice/@status" /></xsl:attribute>
		</PageTitle>
		<CustomButton>
			<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.PortDeviceWebPlugin&amp;poid=<xsl:value-of select="Port/@oid"/>&amp;id=<xsl:value-of select="Port/@portid"/></xsl:attribute>
			</Data>
		</CustomButton>
		<xsl:apply-templates select="PortDevice"/>
	</DataArea>
</xsl:template>

<xsl:template match="PortDevice">
	<ListData>
		<Data name="Status"  editable="false" type="status-text">
			<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="@status"/></xsl:attribute>
		</Data>
		<xsl:if test="TypeName">
			<Data name="TypeName"  editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strType"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="TypeName"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="TypeName">
			<Data name="Layout"  editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strLayout"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="Layout"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="PointingDevType">
			<Data name="PointingDevType"  editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strPointingDeviceType"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="PointingDevType='1'"><xsl:value-of select="$strOther"/></xsl:when>
						<xsl:when test="PointingDevType='3'"><xsl:value-of select="$strSerial"/></xsl:when>
						<xsl:when test="PointingDevType='4'"><xsl:value-of select="$strPS2"/></xsl:when>
						<xsl:when test="PointingDevType='5'"><xsl:value-of select="$strInfrared"/></xsl:when>
						<xsl:when test="PointingDevType='6'"><xsl:value-of select="$strHPHIL"/></xsl:when>
						<xsl:when test="PointingDevType='6'"><xsl:value-of select="$strBusMouse"/></xsl:when>
						<xsl:when test="PointingDevType='6'"><xsl:value-of select="$strADB"/></xsl:when>
						<xsl:when test="PointingDevType='160'"><xsl:value-of select="$strDB9"/></xsl:when>
						<xsl:when test="PointingDevType='161'"><xsl:value-of select="$strMicroDIN"/></xsl:when>
						<xsl:when test="PointingDevType='162'"><xsl:value-of select="$strAccessBusUSB"/></xsl:when>
						<xsl:when test="PointingDevType='163'"><xsl:value-of select="$strPC98"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$strUnknown"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="NumButtons">
			<Data name="NumButtons"  editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strNumberOfButtons"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="NumButtons"/></xsl:attribute>
			</Data>
		</xsl:if>
	</ListData>
</xsl:template>
<xsl:template match="*"/>

</xsl:stylesheet>
