<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:strip-space elements="*"/>
	<xsl:output method="xml" indent="no"/>
	<xsl:template match="/OMA">
		<xsl:choose>
			<xsl:when test="(SMStatus = '0' ) or (BIOSSetupListCount &gt; 0) ">
				<xsl:call-template name="success"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="failure"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="failure">
		<DataArea>
			<PageTitle>
				<xsl:choose>
					<xsl:when test="SMStatus = '256'">
						<xsl:attribute name="display"><xsl:value-of select="$strErrorNo"/><xsl:call-template name="smstatus"><xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="display"><xsl:value-of select="$strError"/><xsl:call-template name="smstatus"><xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</PageTitle>
		</DataArea>
	</xsl:template>
	<xsl:template name="success">
		<DataArea>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strBIOSSetup"/></xsl:attribute>
			</PageTitle>
			<CustomButton>
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.biossetupWebPlugin&amp;help=BiosSetup</xsl:attribute>
				</Data>
			</CustomButton>
			<TableData>
				<xsl:attribute name="display"><xsl:value-of select="$strGeneral"/></xsl:attribute>
				<SubHeader value="General">
					<xsl:attribute name="display"><xsl:value-of select="$strGeneral"/></xsl:attribute>
				</SubHeader>
			    <xsl:choose>
				    <xsl:when test="OMAUserRights='7'">
					    <PromptText><xsl:value-of select="$strClickEachBIOS"/></PromptText>
				    </xsl:when>
				    <xsl:otherwise/>
			    </xsl:choose>
				<Header>
					<Data columnspacing="true" name="Gereral">	
						<xsl:attribute name="display"><xsl:value-of select="$strAttribute"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strAttribute1"/></xsl:attribute>
					</Data>
					<Data name="">
						<xsl:attribute name="display"><xsl:value-of select="$strSetting"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strSetting1"/></xsl:attribute>
					</Data>
				</Header>
				<xsl:for-each select="BIOSSetupList/BIOSSetup">
					<xsl:choose>
						<xsl:when test="@objtype='264'">
							<xsl:variable name="raidState">
								<xsl:for-each select="/OMA/BIOSSetupList/BIOSSetup">
									<xsl:if test="@objtype='263'"><xsl:value-of select="State"/></xsl:if>
								</xsl:for-each>
							</xsl:variable>
							<xsl:choose>
								<xsl:when test="ObjName='RAID Channel A'">
									<Row>
										<Data>
											<xsl:attribute name="display"><xsl:value-of select="$str"/></xsl:attribute>
											<xsl:attribute name="value"><xsl:value-of select="ObjName"/></xsl:attribute>
										</Data>
										<Data>
											<xsl:attribute name="display"><xsl:value-of select="$str1"/></xsl:attribute>
											<xsl:attribute name="value"><xsl:call-template name="state">
									<xsl:with-param name="type"><xsl:value-of select="@objtype"/></xsl:with-param><xsl:with-param name="state"><xsl:value-of select="State"/></xsl:with-param>									<xsl:with-param name="objname"><xsl:value-of select="ObjName"/></xsl:with-param>
											</xsl:call-template></xsl:attribute>
										</Data>
									</Row>
								</xsl:when>
								<xsl:when test="ObjName='RAID Channel B'">
									<xsl:choose>
										<xsl:when test="($raidState='3') and (Capabilities/Rdonly='false')">
											<Row>
												<Data><xsl:attribute name="display"><xsl:value-of select="$str"/></xsl:attribute>
													<xsl:attribute name="value"><xsl:value-of select="ObjName"/></xsl:attribute>
													<xsl:choose>
														<xsl:when test="/OMA/OMAUserRights='7'">
			<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.biosobjinfoWebPlugin&amp;oid=<xsl:value-of select="@oid"/>&amp;help=BiosSetup</xsl:attribute>
															<xsl:attribute name="link">true</xsl:attribute>
														</xsl:when>
														<xsl:otherwise/>
													</xsl:choose>
												</Data>
												<Data><xsl:attribute name="display"><xsl:value-of select="$str1"/></xsl:attribute>
													<xsl:attribute name="value"><xsl:call-template name="state">
														<xsl:with-param name="type"><xsl:value-of select="@objtype"/></xsl:with-param>
														<xsl:with-param name="state"><xsl:value-of select="State"/></xsl:with-param>
														<xsl:with-param name="objname"><xsl:value-of select="ObjName"/></xsl:with-param>
														</xsl:call-template></xsl:attribute>
												</Data>
											</Row>	
										</xsl:when>
										<xsl:otherwise>
											<Row>
												<Data>
													<xsl:attribute name="display"><xsl:value-of select="$str"/></xsl:attribute>
													<xsl:attribute name="value"><xsl:value-of select="ObjName"/></xsl:attribute>
												</Data>
												<Data name="">
													<xsl:attribute name="display"><xsl:value-of select="$str1"/></xsl:attribute>
													<xsl:attribute name="value"><xsl:call-template name="state">
													<xsl:with-param name="type"><xsl:value-of select="@objtype"/></xsl:with-param>
													<xsl:with-param name="state"><xsl:value-of select="State"/></xsl:with-param>
													<xsl:with-param name="objname"><xsl:value-of select="ObjName"/></xsl:with-param></xsl:call-template></xsl:attribute>
												</Data>
											</Row>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
							</xsl:choose>
						</xsl:when>
						<xsl:when test="@objtype='45057' or @objtype='451'">
						<Row>
								<Data name=""><xsl:attribute name="display"><xsl:value-of select="$str"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="ObjName"/></xsl:attribute>
								</Data>

								<Data name=""><xsl:attribute name="display"><xsl:value-of select="$str1"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:call-template name="state"><xsl:with-param name="type"><xsl:value-of select="@objtype"/></xsl:with-param><xsl:with-param 		name="state"><xsl:value-of select="State"/></xsl:with-param><xsl:with-param name="objname"><xsl:value-of select="ObjName"/></xsl:with-param></xsl:call-template></xsl:attribute>
								</Data>						
						</Row>								
						</xsl:when>						
						<xsl:otherwise>
						   <xsl:if test="(@objtype != '251') and (@objtype != '267') and (@objtype !='271') and (@objtype != '374') and (@objtype != '378') and (@objtype != '379')">
							<Row>
								<Data name=""><xsl:attribute name="display"><xsl:value-of select="$str"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="ObjName"/></xsl:attribute>
									<xsl:choose>
										<xsl:when test="/OMA/OMAUserRights='7'">
											<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.biosobjinfoWebPlugin&amp;oid=<xsl:value-of select="@oid"/>&amp;help=BiosSetup</xsl:attribute>
											<xsl:attribute name="link">true</xsl:attribute>
										</xsl:when>
										<xsl:otherwise/>
									</xsl:choose>
								</Data>
								<Data name=""><xsl:attribute name="display"><xsl:value-of select="$str1"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:call-template name="state"><xsl:with-param name="type"><xsl:value-of select="@objtype"/></xsl:with-param><xsl:with-param 		name="state"><xsl:value-of select="State"/></xsl:with-param><xsl:with-param name="objname"><xsl:value-of select="ObjName"/></xsl:with-param></xsl:call-template></xsl:attribute>
								</Data>
							</Row>
						  </xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</TableData>
			<TableData columnspacing="true" name="SerialComm">	
				<xsl:attribute name="display"><xsl:value-of select="$strSerialCommunications"/></xsl:attribute>
				<SubHeader value="General">
					<xsl:attribute name="display"><xsl:value-of select="$strSerialCommunications"/></xsl:attribute>
				</SubHeader>
			    <xsl:choose>
				    <xsl:when test="OMAUserRights='7'">
					    <PromptText><xsl:value-of select="$strClickEachBIOS"/></PromptText>
				    </xsl:when>
				    <xsl:otherwise/>
			    </xsl:choose>
				<Header>
					<Data name="">
						<xsl:attribute name="display"><xsl:value-of select="$strAttribute"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strAttribute1"/></xsl:attribute>
					</Data>
					<Data name="">
						<xsl:attribute name="display"><xsl:value-of select="$strSetting"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strSetting1"/></xsl:attribute>
					</Data>
				</Header>
			    <xsl:for-each select="BIOSSetupList/BIOSSetup">
				    <xsl:if test="(@objtype='251') or (@objtype='267') or (@objtype='271') or (@objtype='374') or (@objtype='378') or (@objtype='379')">
					    <Row>
						    <Data name=""><xsl:attribute name="display"><xsl:value-of select="$str"/></xsl:attribute>
							    <xsl:attribute name="value"><xsl:value-of select="ObjName"/></xsl:attribute>
							    <xsl:choose>
								    <xsl:when test="/OMA/OMAUserRights='7'">
									    <xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.biosobjinfoWebPlugin&amp;oid=<xsl:value-of select="@oid"/>&amp;help=BiosSetup</xsl:attribute>
									    <xsl:attribute name="link">true</xsl:attribute>
								    </xsl:when>
								    <xsl:otherwise/>
							    </xsl:choose>
						    </Data>
						    <Data name=""><xsl:attribute name="display"><xsl:value-of select="$str1"/></xsl:attribute>
							    <xsl:attribute name="value"><xsl:call-template name="state"><xsl:with-param name="type"><xsl:value-of select="@objtype"/></xsl:with-param><xsl:with-param 		name="state"><xsl:value-of select="State"/></xsl:with-param><xsl:with-param name="objname"><xsl:value-of select="ObjName"/></xsl:with-param></xsl:call-template></xsl:attribute>
						    </Data>
					    </Row>
				    </xsl:if>
				</xsl:for-each>
			</TableData>
		</DataArea>
	</xsl:template>
	<xsl:template name="state">
		<xsl:param name="type"/>
		<xsl:param name="state"/>
		<xsl:param name="objname"/>
		<xsl:choose>
			<xsl:when test="$type='241'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOff"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strAuto"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strWriteProtect"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='242'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown1"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strDisabled"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strEnabledwithPXE"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strEnabledWithoutPXE"/></xsl:when>
					<xsl:when test="$state='4'"><xsl:value-of select="$strEnabledWithISCSI"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='246'">
				<xsl:if test="$objname='Primary SCSI'">
					<xsl:choose>
						<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown2"/></xsl:when>
						<xsl:when test="$state='1'"><xsl:value-of select="$strOff2"/></xsl:when>
						<xsl:when test="$state='2'"><xsl:value-of select="$strOn"/></xsl:when>
					</xsl:choose>
				</xsl:if>
				<xsl:if test="$objname='Secondary SCSI'">
					<xsl:choose>
						<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown3"/></xsl:when>
						<xsl:when test="$state='1'"><xsl:value-of select="$strOff3"/></xsl:when>
						<xsl:when test="$state='2'"><xsl:value-of select="$strOn1"/></xsl:when>
					</xsl:choose>
				</xsl:if>
			</xsl:when>
			<xsl:when test="$type='247'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown4"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strFloppyDisketteFirst"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strHardDiskOnly"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strDeviceList"/></xsl:when>
					<xsl:when test="$state='4'"><xsl:value-of select="$strCDROMFirstThen"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='249'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown5"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOff4"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strLPT1Mode"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strLPT2Mode"/></xsl:when>
					<xsl:when test="$state='4'"><xsl:value-of select="$strLPT3Mode"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='250'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown6"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strATMode"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strPS2Mode"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strECPMode"/></xsl:when>
					<xsl:when test="$state='4'"><xsl:value-of select="$strEPPMode"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='251'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown7"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOff5"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strAuto1"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strCOM1Mode"/></xsl:when>
					<xsl:when test="$state='4'"><xsl:value-of select="$strCOM2Mode"/></xsl:when>
					<xsl:when test="$state='5'"><xsl:value-of select="$strCOM3Mode"/></xsl:when>
					<xsl:when test="$state='6'"><xsl:value-of select="$strCOM4Mode"/></xsl:when>
					<xsl:when test="$state='7'"><xsl:value-of select="$strBMCSerialMode"/></xsl:when>
					<xsl:when test="$state='8'"><xsl:value-of select="$strBMCNicMode"/></xsl:when>
					<xsl:when test="$state='9'"><xsl:value-of select="$strBMCRacMode"/></xsl:when> 
					<xsl:when test="$state='10'"><xsl:value-of select="$strCOM1BMCMode"/></xsl:when> 
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='252'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown8"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOff6"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strOn2"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strLow"/></xsl:when>
					<xsl:when test="$state='4'"><xsl:value-of select="$strMedium"/></xsl:when>
					<xsl:when test="$state='5'"><xsl:value-of select="$strHigh"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='253'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown9"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strDisable"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strEnableWOLFor"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strEnableWOLFor1"/></xsl:when>
					<xsl:when test="$state='4'"><xsl:value-of select="$strEnableWOLFor2"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='244'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown10"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strDisabled1"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strEnabled1"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='260'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown11"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strDisabled2"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strEnabled2"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strEnabledWithBIOS"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='261'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strDisable"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strEnable"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='262'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strDisable"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strEnable"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='263'">
					<xsl:choose>
							<xsl:when test="$state='1'"><xsl:value-of select="$strOff1"/></xsl:when>
							<xsl:when test="$state='2'"><xsl:value-of select="$strSCSI"/></xsl:when>
							<xsl:when test="$state='3'"><xsl:value-of select="$strRAID"/></xsl:when>
					</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='264'">
				<xsl:choose>
						<xsl:when test="$state='1'"><xsl:value-of select="$strSCSI"/></xsl:when>
						<xsl:when test="$state='2'"><xsl:value-of select="$strRAID"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='245'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOff7"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strAuto"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<!--For Dual NIC -->
			<xsl:when test="$type='265'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='41'"><xsl:value-of select="$strOff7"/></xsl:when>
					<xsl:when test="$state='22'"><xsl:value-of select="$strOnBothDualNicPXE"/></xsl:when>
					<xsl:when test="$state='26'"><xsl:value-of select="$strOnDualNic2PXE"/></xsl:when>
					<xsl:when test="$state='38'"><xsl:value-of select="$strOnDualNic1PXE"/></xsl:when>
					<xsl:when test="$state='82'"><xsl:value-of select="$strOnDualNiciSCSIPXE"/></xsl:when>
					<xsl:when test="$state='98'"><xsl:value-of select="$strOnDualNic1iSCSI"/></xsl:when>
					<xsl:when test="$state='138'"><xsl:value-of select="$strOnDualNic2iSCSI"/></xsl:when>
					<xsl:when test="$state='134'"><xsl:value-of select="$strOnDualNicPXEiSCSI"/></xsl:when>
					<xsl:when test="$state='194'"><xsl:value-of select="$strOnBothDualiSCSI"/></xsl:when>
					<xsl:when test="$state='42'"><xsl:value-of select="$strOnDualNicNone"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<!--For Console Redirection -->
			<xsl:when test="$type='267'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOff7"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strSerialPort1"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strSerialPort2"/></xsl:when>
					<xsl:when test="$state='4'"><xsl:value-of select="$strBMCNicMode"/></xsl:when>
					<xsl:when test="$state='5'"><xsl:value-of select="$strmmb"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<!--For AC Power Recovery Mode -->
			<xsl:when test="$type='368'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOff7"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strLast"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strOn"/></xsl:when>
				</xsl:choose>
			</xsl:when>

			<!-- Embedded SATA 2 Controller  -->
			<xsl:when test="$type='369'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOff7"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strSATAcombined"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strSATAata"/></xsl:when>
					<xsl:when test="$state='4'"><xsl:value-of select="$strSATAahci"/></xsl:when>
					<xsl:when test="$state='5'"><xsl:value-of select="$strSATAraid"/></xsl:when>
					<xsl:when test="$state='6'"><xsl:value-of select="$strSATAqdma"/></xsl:when>
				</xsl:choose>
			</xsl:when>

			<!-- Embedded SATA 2 Port  -->
			<xsl:when test="$type='370'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOff7"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strAuto"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			
			<!-- IDE Primary Drive  -->
			<xsl:when test="$type='371'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOff7"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strAuto"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			
			<!--For DBS -->
			<xsl:when test="$type='372'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strDisabled"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strEnabled"/></xsl:when>
				</xsl:choose>
			</xsl:when>

			<!--For Console Redirection FailSafe BAUD Rate -->
			<xsl:when test="$type='271'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strFBRnone"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strFBR115200"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strFBR57600"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strFBR19200"/></xsl:when>
					<xsl:when test="$state='4'"><xsl:value-of select="$strFBR9600"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			
			<!--For Console Redirection After Boot(CRAB) -->
			<xsl:when test="$type='374'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strEnabled"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strDisabled"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			
		    <!--For Serial Communication -->
			<xsl:when test="$type='378'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOff"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strOnWithoutCR"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strOnWithCRCOM1"/></xsl:when>
					<xsl:when test="$state='4'"><xsl:value-of select="$strOnWithCRCOM2"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			
		    <!--For External Serial Connector -->
			<xsl:when test="$type='379'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strCOM1Mode"/></xsl:when>
					<xsl:when test="$state='4'"><xsl:value-of select="$strCOM2Mode"/></xsl:when>
          <xsl:when test="$state='9'"><xsl:value-of select="$strRemoteAccessDevice"/></xsl:when>
        </xsl:choose>
			</xsl:when>

		    <!--For User Accessible USB Ports -->
			<xsl:when test="$type='375'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strAllOff"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strBackOn"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strAllOn"/></xsl:when>
				</xsl:choose>
			</xsl:when>

		    <!--For CPU Virtualization Technology -->
			<xsl:when test="$type='380'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strDisabled"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strEnabled"/></xsl:when>
				</xsl:choose>
			</xsl:when>

		    <!--For CPU HyperThreading -->
			<xsl:when test="$type='381'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strEnabled"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strDisabled"/></xsl:when>
				</xsl:choose>
			</xsl:when>

			<xsl:when test="$type='451'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strDisabled"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strEnabled"/></xsl:when>
				</xsl:choose>
			</xsl:when>


		   <!--For TPM -->	
			<xsl:when test="$type='45057'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strOff1"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOnWithPreBoot"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strOnWithOutPreBoot"/></xsl:when>
      </xsl:choose>
			</xsl:when>
		   <!--For Internal USB -->	
			<xsl:when test="$type='454'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strDisabled"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strEnabled"/></xsl:when>
				</xsl:choose>
			</xsl:when>		
			<!-- HyperVisor -->
			<xsl:when test="$type='455'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strDisabled"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strEnabled"/></xsl:when>
				</xsl:choose>
			</xsl:when>						
		   	<!--For Optical Drive Controller -->	
			<xsl:when test="$type='456'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strEnabled"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strDisabled"/></xsl:when>
				</xsl:choose>
			</xsl:when>
		      <!--Optical Drive Controller -->				
		      <xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOff7"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strOn3"/></xsl:when>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:param name="mssg"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'"><xsl:value-of select="$strCommandUnsuccessful"/></xsl:when>
			<xsl:when test="$status = '1'"><xsl:value-of select="$strCommandNotImplemented"/></xsl:when>
			<xsl:when test="$status = '2'"><xsl:value-of select="$strBadCommand"/></xsl:when>
			<xsl:when test="$status = '3'"><xsl:value-of select="$strCommandTimeout"/></xsl:when>
			<xsl:when test="$status = '4'"><xsl:value-of select="$strCommandCancelled"/></xsl:when>
			<xsl:when test="$status = '5'"><xsl:value-of select="$strCommandAborted"/></xsl:when>
			<xsl:when test="$status = '6'"><xsl:value-of select="$strCommandPending"/></xsl:when>
			<xsl:when test="$status = '7'"><xsl:value-of select="$strNoSuchDevice"/></xsl:when>
			<xsl:when test="$status = '8'"><xsl:value-of select="$strDeviceBusy"/></xsl:when>
			<xsl:when test="$status = '9'"><xsl:value-of select="$strBadDevice"/></xsl:when>
			<xsl:when test="$status = '10'"><xsl:value-of select="$strSpuriousInterrupt"/></xsl:when>
			<xsl:when test="$status = '11'"><xsl:value-of select="$strResourceLocked"/></xsl:when>
			<xsl:when test="$status = '12'"><xsl:value-of select="$strInvalidIndex"/></xsl:when>
			<xsl:when test="$status = '13'"><xsl:value-of select="$strSMBError"/></xsl:when>
			<xsl:when test="$status = '14'"><xsl:value-of select="$strDataRequestedIs"/></xsl:when>
			<xsl:when test="$status = '15'"><xsl:value-of select="$strDataRequestedIs1"/></xsl:when>
			<xsl:when test="$status = '16'"><xsl:value-of select="$strDataRequestedIs2"/></xsl:when>
			<xsl:when test="$status = '17'"><xsl:value-of select="$strDeviceNotYet"/></xsl:when>
			<xsl:when test="$status = '18'"><xsl:value-of select="$strDeviceDoesNot"/></xsl:when>
			<xsl:when test="$status = '19'"><xsl:value-of select="$strDeviceOutOf"/></xsl:when>
			<xsl:when test="$status = '20'"><xsl:value-of select="$strDeviceAlreadyExists"/></xsl:when>
			<xsl:when test="$status = '256'"><xsl:value-of select="$strBIOSSetupFound"/></xsl:when>
			<xsl:when test="$status = '257'"><xsl:value-of select="$strBIOSSetupMalformed"/></xsl:when>
			<xsl:when test="$status = '258'"><xsl:value-of select="$strBIOSSetupAlready"/></xsl:when>
			<xsl:when test="$status = '260'"><xsl:value-of select="$strINIFileNot"/></xsl:when>
			<xsl:when test="$status = '261'"><xsl:value-of select="$strINIMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '262'"><xsl:value-of select="$strINISectionDoes"/></xsl:when>
			<xsl:when test="$status = '263'"><xsl:value-of select="$strINIKeyDoes"/></xsl:when>
			<xsl:when test="$status = '264'"><xsl:value-of select="$strINIValueMalformed"/></xsl:when>
			<xsl:when test="$status = '270'"><xsl:value-of select="$strInsufficientAccessRights"/></xsl:when>
			<xsl:when test="$status = '271'"><xsl:value-of select="$strInvalidParameterName"/><xsl:value-of select="$mssg"/></xsl:when>
			<xsl:when test="$status = '272'"><xsl:value-of select="$strOutOfMemory"/></xsl:when>
			<xsl:when test="$status = '280'"><xsl:value-of select="$strXMLFileNot"/></xsl:when>
			<xsl:when test="$status = '281'"><xsl:value-of select="$strXMLMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '282'"><xsl:value-of select="$strXMLNodeDoes"/></xsl:when>
			<xsl:when test="$status = '283'"><xsl:value-of select="$strXMLValueMalformed"/></xsl:when>
			<xsl:otherwise>SMStatus: <xsl:value-of select="$status"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="*"/>
</xsl:stylesheet>
