<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="xml" omit-xml-declaration="yes"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
		<xsl:call-template name="SystemBIOS"/>
		<xsl:call-template name="Firmware"/>
		<xsl:call-template name="OSInfo"/>
		<xsl:call-template name="OEMInfo"/>
		<xsl:call-template name="DRSCInfo"/>
		<xsl:call-template name="PERCAMAdaptersInfo"/>
		<xsl:call-template name="StorageEnclosuresInfo"/>
		<xsl:call-template name="PERCAdaptersInfo"/>
		<xsl:call-template name="DriverInfo"/>
		<xsl:call-template name="DRAC2Info"/>
	</xsl:template>
	<xsl:template name="SystemBIOS">
		<xsl:if test="count(SystemBIOS) != '0'">
			<Application name="bios" update_href="1">
				<xsl:attribute name="display"><xsl:value-of select="$strBIOS"/></xsl:attribute>
				<xsl:attribute name="version"><xsl:value-of select="SystemBIOS/Version"/></xsl:attribute>
			</Application>
		</xsl:if>
	</xsl:template>
	<xsl:template name="Firmware">
		<xsl:for-each select="FirmwareList/Firmware[ not (FWType = '16') ] ">
			<Application name="firmware" update_href="1">
				<xsl:attribute name="display">
            		<xsl:call-template name="getFWType">
						<xsl:with-param name="type">
							<xsl:value-of select="FWType"/>
						</xsl:with-param>
					</xsl:call-template>
            	</xsl:attribute>
				<xsl:attribute name="version"><xsl:value-of select="FWVersion"/></xsl:attribute>
			</Application>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="OSInfo">
		<xsl:if test="count(OSInfo) != '0'">
			<Application name="osinfo" update_href="1">
				<xsl:attribute name="display"><xsl:value-of select="OSInfo/OSName"/></xsl:attribute>
				<xsl:attribute name="version"><xsl:value-of select="OSInfo/OSVersion"/></xsl:attribute>
			</Application>
		</xsl:if>
	</xsl:template>
	<xsl:template name="OEMInfo">
		<xsl:if test="count(OEM/Name) != '0'">
			<Application name="OMSA" update_href="1">
				<xsl:choose>
					<xsl:when test="OEM/Name/@display = 'Dell'">
						<xsl:attribute name="display">Dell <xsl:value-of select="OEM/ProdName"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="display"><xsl:value-of select="OEM/ProdName"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:attribute name="version"><xsl:value-of select="About/ProductVersion"/></xsl:attribute>
			</Application>
		</xsl:if>
	</xsl:template>
	<xsl:template name="DRSCInfo">
		<xsl:if test="count(DRSIdentificationObj) != '0'">
			<!--xsl:choose>
				<xsl:when test="ADMINISTRATOR = '1'">
					<Application name="DRSC" update_href="javascript:parent.ct.select('RAC','Update', '')">
						<xsl:attribute name="display"><xsl:value-of select="$strRemoteAccessController"/></xsl:attribute>
						<xsl:attribute name="version"><xsl:value-of select="DRSIdentificationObj/VersionInfo"/></xsl:attribute>
					</Application>
				</xsl:when>
				<xsl:otherwise-->
					<Application name="DRSC" update_href="1">
						<xsl:attribute name="display"><xsl:value-of select="$strRemoteAccessController1"/></xsl:attribute>
						<xsl:attribute name="version"><xsl:value-of select="DRSIdentificationObj/VersionInfo"/></xsl:attribute>
					</Application>
				<!--/xsl:otherwise>
			</xsl:choose-->
		</xsl:if>
	</xsl:template>
	<xsl:template name="PERCAMAdaptersInfo">
		<xsl:for-each select="AMADAPTERS/DCStorageObject">
			<Application name="PERCAMAdapters" update_href="1">
				<xsl:attribute name="display"><xsl:value-of select="Name"/><xsl:value-of select="$strFirmware"/></xsl:attribute>
				<xsl:attribute name="version"><xsl:value-of select="FirmwareVer"/></xsl:attribute>
			</Application>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="StorageEnclosuresInfo">
		<!--xsl:for-each select="ENCLOSURES/DCStorageObject">
			<xsl:if test="Type!='1'">
				<Application name="StorageEnclosures" update_href="1">
					<xsl:attribute name="display"><xsl:value-of select="$strStorageEnclosure"/><xsl:value-of select="$strSpace"/><xsl:value-of select="Name"/></xsl:attribute>
					<xsl:attribute name="version"><xsl:value-of select="ProductVer"/></xsl:attribute>
				</Application>
			</xsl:if>
		</xsl:for-each-->
	</xsl:template>
	<xsl:template name="PERCAdaptersInfo">
		<xsl:for-each select="ADAPTERS/Result/Inventory/Entry">
			<Application name="PERCAdapters" update_href="1">
				<xsl:attribute name="display"><xsl:value-of select="@name"/></xsl:attribute>
				<xsl:attribute name="version"><xsl:value-of select="@vendorVersion"/></xsl:attribute>
			</Application>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="DriverInfo">
		<xsl:for-each select="DriverInfo/Result/Inventory/Entry">
			<Application name="Driver" update_href="1">
				<xsl:attribute name="display"><xsl:value-of select="@name"/></xsl:attribute>
				<xsl:attribute name="version"><xsl:value-of select="@vendorVersion"/></xsl:attribute>
			</Application>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="DRAC2Info">
		<xsl:if test="DRAC2/Result/Inventory/Entry/@vendorVersion != 'null'">
		<xsl:if test="DRAC2/Result/Inventory/Entry/@vendorVersion != '0.0'">
			<Application name="DRAC2" update_href="1">
				<xsl:attribute name="display"><xsl:value-of select="DRAC2/Result/Inventory/Entry/@name"/></xsl:attribute>
				<xsl:attribute name="version"><xsl:value-of select="DRAC2/Result/Inventory/Entry/@vendorVersion"/></xsl:attribute>
			</Application>
		</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template name="getFWType">
		<xsl:param name="type"/>
		<xsl:choose>
			<xsl:when test="$type='2'"><xsl:value-of select="FWText"/></xsl:when>
			<xsl:when test="$type='3'"><xsl:value-of select="$strBIOSVersion"/></xsl:when>
			<xsl:when test="$type='4'"><xsl:value-of select="$strESMFirmwareVersion"/></xsl:when>
			<xsl:when test="$type='5'"><xsl:value-of select="$strPowerSupplyParalleling"/></xsl:when>
			<xsl:when test="$type='6'"><xsl:value-of select="$strBackplaneFirmwareVersion"/></xsl:when>
			<xsl:when test="$type='7'"><xsl:value-of select="$strKernelVersion"/></xsl:when>
			<xsl:when test="$type='8'"><xsl:value-of select="$strApplicationVersion"/></xsl:when>
			<xsl:when test="$type='9'"><xsl:value-of select="$strFrontPanelController"/></xsl:when>
			<xsl:when test="$type='10'"><xsl:value-of select="$strBaseboardManagementController"/></xsl:when>
			<xsl:when test="$type='11'"><xsl:value-of select="$strHotPlugPCI"/></xsl:when>
			<xsl:when test="$type='12'"><xsl:value-of select="$strSensorDataRecords"/></xsl:when>
			<xsl:when test="$type='13'"><xsl:value-of select="$strPeripheralBayBackplane"/></xsl:when>
			<xsl:when test="$type='14'"><xsl:value-of select="$strPowerEdge2450Secondary"/></xsl:when>
			<xsl:when test="$type='15'"><xsl:value-of select="$strSecondaryBackPlane"/></xsl:when>
			<xsl:when test="$type='16'"><xsl:value-of select="$strRemoteAccessController"/></xsl:when>			
			<xsl:when test="$type='17'"><xsl:value-of select="$striDRAC"/></xsl:when>			
			<xsl:otherwise><xsl:value-of select="$strUnknownFirmwareVersion"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="*"/>
</xsl:stylesheet>
