<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/OMA">
		<DataArea validate="true" exportdata="false">
			<xsl:if test="onLoad">
				<xsl:attribute name="onLoad">true</xsl:attribute>
				<xsl:attribute name="callerReplace">true</xsl:attribute>
				<xsl:attribute name="paramReplaced">onload</xsl:attribute>
				<xsl:attribute name="paramReplacing">load</xsl:attribute>
			</xsl:if>
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strApplyChanges"/></xsl:attribute>
			<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.hip.webplugins.SetSNMPconfgWebPlugin</xsl:attribute>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strSNMPConfiguration"/></xsl:attribute>
			</PageTitle>
			<PromptText><xsl:value-of select="$strConfigureSNMPRoot"/></PromptText>
			<CustomButton>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.SNMPconfgWebPlugin&amp;help=snmp</xsl:attribute>
				</Data>
			</CustomButton>					
			<ListData type="custom">
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strUser"/></xsl:attribute>
					<xsl:attribute name="value">root</xsl:attribute>
				</Data>
				<Data name="oldpwd" editable="true" id="oldpwd" type="password" align="left" size="15">
					<xsl:attribute name="display"><xsl:value-of select="$strOldRootPassword"/></xsl:attribute>
				</Data>
				<Data name="newpwd" editable="true" id="newpwd" type="password" align="left" size="15">
					<xsl:attribute name="display"><xsl:value-of select="$strNewRootPassword"/></xsl:attribute>
				</Data>
				<Data name="confnewpwd" editable="true" id="confnewpwd" type="password" align="left" size="15">
					<xsl:attribute name="display"><xsl:value-of select="$strConfirmNewRoot"/></xsl:attribute>
				</Data>
			</ListData>
			<ListData>
				<Data  display=" "  type="hidden" state="" align="left">
					<xsl:attribute name="name">caller</xsl:attribute>
					<xsl:attribute name="returnvalue">none</xsl:attribute>
				</Data>
			</ListData>

			
			<TableData>
				<PromptText><xsl:value-of select="$strEnableSNMPsetsTitle"/></PromptText>
				<Header>
					<Data name="">
						<xsl:attribute name="display"><xsl:value-of select="$strSNMPsets"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strSNMPsets"/></xsl:attribute>
					</Data>
				</Header>
				<Row>
					<Data>
						<xsl:attribute name="name">snmp_set</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strEnableSNMPsets"/></xsl:attribute>					
						<xsl:attribute name="event">onClick</xsl:attribute>
						<xsl:attribute name="handler">javascript:unCheck()</xsl:attribute>
						<xsl:attribute name="type">checkbox</xsl:attribute>
						<xsl:attribute name="returnvalue">true</xsl:attribute>
						<xsl:attribute name="state">
							<xsl:if test="SNMPSet='true'">1</xsl:if>
							<xsl:if test="SNMPSet='false'">0</xsl:if>
						</xsl:attribute>
					</Data>
					<Data>
					<xsl:attribute name="name">snmp_set_modified</xsl:attribute>
					<xsl:attribute name="type">hidden</xsl:attribute>
					<xsl:attribute name="returnvalue">false</xsl:attribute>
					</Data>
				</Row>
			</TableData>

			<Table-Data>
				<PromptText><xsl:value-of select="$strEnableSNMPWarning"/></PromptText>
				<Header>
					<Data name="">
						<xsl:attribute name="display"><xsl:value-of select="$strSNMPWarningMessage"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strSNMPWarningMessage1"/></xsl:attribute>
					</Data>
				</Header>
				<Row>
					<Data>
						<xsl:attribute name="name">snmp_warn_msg</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strEnableSNMPWarning1"/></xsl:attribute>					
						<xsl:attribute name="type">checkbox</xsl:attribute>
						<xsl:attribute name="returnvalue">true</xsl:attribute>
					</Data>
				</Row>
			</Table-Data>
			
			<script language="javascript">
			 var accessModified = false;
				<xsl:choose>
				<xsl:when test="onLoad/@pwd='set'">
					function initializationRoutine()
					{
						alert("<xsl:value-of select="$strSNMPRootPassword"/>");
					}
				</xsl:when>
				<xsl:when test="onLoad/@pwd='snmp'">
					function initializationRoutine()
					{
						alert("<xsl:value-of select="$strSNMPsetSuccess"/>");
					}
				</xsl:when>
				<xsl:when test="onLoad/@pwd='both'">
					function initializationRoutine()
					{
						alert("<xsl:value-of select="$strSNMPSuccess"/>");
					}
				</xsl:when>
				</xsl:choose>

				function unCheck()
				{
					accessModified = !(accessModified) ;
				}
				function validate()
				{
					var oldpwd = document.getElementById("oldpwd").value.toLowerCase();
					var newpwd = document.getElementById("newpwd").value.toLowerCase();
					var confnewpwd = document.getElementById("confnewpwd").value.toLowerCase();
					var invalidchar = "&amp;";

					document.getElementById("snmp_set_modified").value = accessModified;
					
					if((accessModified==true) &amp; (oldpwd == "") &amp; (newpwd == "") &amp; (confnewpwd == ""))
					{
						document.getElementById("caller").value=document.location.href;
						return true;
					}
					if (oldpwd == "")
					{
						alert("<xsl:value-of select="$strOldPasswordField"/>");
						document.getElementById("oldpwd").focus();
					}
					else if (newpwd == "")
					{
						alert("<xsl:value-of select="$strNewPasswordField"/>");
						document.getElementById("newpwd").focus();
					}
					else if (confnewpwd == "")
					{
						alert("<xsl:value-of select="$strConfirmNewPassword"/>");
						document.getElementById("confnewpwd").focus();
					}
					else if (oldpwd.indexOf(invalidchar) != -1)
					{
						alert("<xsl:value-of select="$strOldPwdInvalid"/>");
						document.getElementById("oldpwd").value = "";
						document.getElementById("oldpwd").focus();
					}
					else if (newpwd.indexOf(invalidchar) != -1)
					{
						alert("<xsl:value-of select="$strNewPwdInvalid"/>");
						document.getElementById("newpwd").value = "";
						document.getElementById("confnewpwd").value = "";
						document.getElementById("newpwd").focus();
					}
					else if (confnewpwd.indexOf(invalidchar) != -1)
					{
						alert("<xsl:value-of select="$strConfPwdInvalid"/>");
						document.getElementById("confnewpwd").value = "";
						document.getElementById("confnewpwd").focus();
					}
					else 
					{
						if(newpwd != confnewpwd) {	
							alert("<xsl:value-of select="$strNewPasswordFields"/>");
							document.getElementById("confnewpwd").value = "";
							document.getElementById("confnewpwd").focus();						
						}
						else{
							document.getElementById("caller").value=document.location.href;
							document.getElementById("oldpwd").value = oldpwd;
							document.getElementById("newpwd").value = newpwd;
							document.getElementById("confnewpwd").value = confnewpwd;
							return true;
						}						
					}
					return false;
				}
			</script>
		</DataArea>
	</xsl:template>
	<xsl:template match="*"/>	
</xsl:stylesheet>
