<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:strip-space elements="*"/>
	<xsl:output method="xml"/>
	
	<xsl:template match="OMA">
		<xsl:choose>
			<xsl:when test="SMStatus != '0'">
				<DataArea printable="false">
					<PageTitle/>
					<xsl:attribute name="display"><xsl:value-of select="$strPowerSupplies"/></xsl:attribute>
					<TableData>
						<Header>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strError"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strError1"/></xsl:attribute>
							</Data>
						</Header>
						<Row>
							<Data><xsl:attribute name="display"><xsl:value-of select="$str"/></xsl:attribute>
								<xsl:attribute name="value">
									<xsl:call-template name="smstatus">
										<xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param>
									</xsl:call-template>
								</xsl:attribute>
							</Data>
						</Row>
					</TableData>
				</DataArea>
			</xsl:when>
			<xsl:otherwise>
				<DataArea>
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strPowerSupplies1"/></xsl:attribute>
						<xsl:choose>
							<xsl:when test="/OMA/@cli = 'true'">	</xsl:when>
							<xsl:otherwise>
							     <xsl:attribute name="status"><xsl:value-of select="/OMA/ObjStatus"/></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</PageTitle>
					<CustomButton>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
							<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.PowerSupplyWebPlugin&amp;poid=<xsl:value-of select="/OMA/ServletArguments/@POID"/>&amp;help=PowerSupply</xsl:attribute>
						</Data>
					</CustomButton>
					<xsl:choose>
						<xsl:when test="/OMA/@cli = 'true'">
							<xsl:for-each select="Chassis">
								<xsl:call-template name="ChassisPwrSup"/>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise><xsl:call-template name="ChassisPwrSup"/></xsl:otherwise>
	                    	</xsl:choose>
				</DataArea>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="ServletArguments">
		<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.PowerSupplyWebPlugin&amp;poid=<xsl:value-of select="/OMA/ServletArguments/@POID"/>&amp;help=PowerSupply</xsl:attribute>
	</xsl:template>
		
	<xsl:template name="ChassisPwrSup">
		<xsl:choose>
			<xsl:when test="Redundancy !=''">
				<xsl:variable name="redundata"><xsl:value-of select="Redundancy"/></xsl:variable>
				<xsl:choose>
					<xsl:when test="$redundata != '' ">
						<TableData name="reduntable">
							<xsl:attribute name="display"><xsl:value-of select="$strPowerSupplyRedundancy"/></xsl:attribute>
						       <xsl:if test="/OMA/@cli = 'true'">		
	 							     <SubHeader banner='true'>
									<xsl:choose>
			                     			<xsl:when test="(count(PowerSupplyList/PowerSupply)) > 1">
									          <xsl:attribute name="display"><xsl:value-of select="@display"/> Power Supplies </xsl:attribute>
										   <xsl:attribute name="status"><xsl:value-of select="ObjStatus"/></xsl:attribute>
										</xsl:when>
										<xsl:otherwise>
									             <xsl:attribute name="display"><xsl:value-of select="@display"/> Power Supply</xsl:attribute>
											<xsl:attribute name="status"><xsl:value-of select="ObjStatus"/></xsl:attribute>
										</xsl:otherwise>
			                  			</xsl:choose>
							     </SubHeader>
							</xsl:if>
							<SubHeader>
								<xsl:attribute name="display"><xsl:value-of select="$strPowerSupplyRedundancy"/></xsl:attribute>
								<xsl:attribute name="status"><xsl:value-of select="Redundancy/@status"/></xsl:attribute>
							</SubHeader>
							<xsl:apply-templates select="Redundancy"/> 
						</TableData>
						<TableData columnspacing="true" name="probestable">
							<xsl:attribute name="display"><xsl:value-of select="$strIndividualPowerSupply"/></xsl:attribute>
							<xsl:apply-templates select="PowerSupplyList"/>
						</TableData>
					</xsl:when>
					<xsl:otherwise>
						<TableData columnspacing="true" name="probestable">
							<xsl:attribute name="display"><xsl:value-of select="$strPowerSupplies3"/></xsl:attribute>
						    <xsl:if test="/OMA/@cli = 'true'">
							     <SubHeader banner='true'>
									<xsl:choose>
			                     			<xsl:when test="(count(PowerSupplyList/PowerSupply)) > 1">
									          <xsl:attribute name="display"><xsl:value-of select="@display"/> Power Supplies</xsl:attribute>
											<xsl:attribute name="status"><xsl:value-of select="ObjStatus"/></xsl:attribute>
										</xsl:when>
										<xsl:otherwise>
									          <xsl:attribute name="display"><xsl:value-of select="@display"/> Power Supply </xsl:attribute>
											<xsl:attribute name="status"><xsl:value-of select="ObjStatus"/></xsl:attribute>
										</xsl:otherwise>
			                  			</xsl:choose>
							     </SubHeader>
							</xsl:if>
							<xsl:apply-templates select="PowerSupplyList"/>
						</TableData>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<TableData columnspacing="true" name="probestable">
					<xsl:attribute name="display"><xsl:value-of select="@display"/> Power Supplies</xsl:attribute>
					<xsl:attribute name="status"><xsl:value-of select="ObjStatus"/></xsl:attribute>					
					<xsl:if test="/OMA/@cli = 'true'">
					    <SubHeader banner='true'>
							<xsl:choose>
	                     			<xsl:when test="count(PowerSupplyList/PowerSupply) > 1">
							          <xsl:attribute name="display"><xsl:value-of select="@display"/> Power Supplies</xsl:attribute>
									<xsl:attribute name="status"><xsl:value-of select="ObjStatus"/></xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
							          <xsl:attribute name="display"><xsl:value-of select="@display"/> Power Supplies</xsl:attribute>
									<xsl:attribute name="status"><xsl:value-of select="ObjStatus"/></xsl:attribute>
								</xsl:otherwise>
	                  			</xsl:choose>
	                          </SubHeader>
	                      </xsl:if>
					<xsl:apply-templates select="PowerSupplyList"/>
				</TableData>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
		
	<xsl:template match="Redundancy">
		<Header>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strAttribute"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strAttribute1"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strValue"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strValue1"/></xsl:attribute>
			</Data>
		</Header>
		<Row>
			<Data>
				<xsl:attribute name="value"><xsl:value-of select="$strRedundancyStatus"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:call-template name="RedStatus">
					<xsl:with-param name="status">
						<xsl:value-of select="RedunStatus"/>
					</xsl:with-param>
				</xsl:call-template>
			</Data>
		</Row>
		
		<!--check for Yellowstone-->
		<Row>
			
		 <xsl:if test="(RedunCount > '0')">
			<Data>
			     
				<xsl:attribute name="value"><xsl:value-of select="$strNumberOfDevices"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="value"><xsl:value-of select="RedunCount"/></xsl:attribute>
			</Data>
		</xsl:if>	
		</Row>
	</xsl:template>
		
	<xsl:template match="PowerSupplyList">
			<SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strIndividualPowerSupply"/></xsl:attribute>
			</SubHeader>
			<Header>
				<Data ignoreonweb="true">
					<xsl:attribute name="display"><xsl:value-of select="$strIndex"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strIndex"/></xsl:attribute>
				</Data>
				<Data align="center">
					<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strStatus1"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strLocation"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strLocation1"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strType"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strType1"/></xsl:attribute>
				</Data>
        <Data align="center">
					<xsl:attribute name="display"><xsl:value-of select="$strMaximumWattage"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strMaximumWattage1"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strOnlineStatus"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strOnlineStatus1"/></xsl:attribute>
				</Data>
				<Data align="center">
					<xsl:attribute name="display"><xsl:value-of select="$strPowerMonitoringCapable"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strPowerMonitoringCapable"/></xsl:attribute>
				</Data>
			</Header>
			<xsl:apply-templates select="PowerSupply"/>
	</xsl:template>
		
	<xsl:template match="PowerSupply">
		<Row>
			<Data ignoreonweb="true">
				<xsl:attribute name="value"><xsl:value-of select="@index"/></xsl:attribute>
			</Data>
			<Data type="status" align="center">
				<xsl:attribute name="value"><xsl:value-of select="@status"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="value"><xsl:value-of select="PSLocation"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:choose>
					<xsl:when test="Type = 1"><xsl:attribute name="value"><xsl:value-of select="$strOther"/></xsl:attribute></xsl:when>
					<xsl:when test="Type = 2"><xsl:attribute name="value"><xsl:value-of select="$strUnknown"/></xsl:attribute></xsl:when>
					<xsl:when test="Type = 3"><xsl:attribute name="value"><xsl:value-of select="$strLinear"/></xsl:attribute></xsl:when>
					<xsl:when test="Type = 4"><xsl:attribute name="value"><xsl:value-of select="$strSwitching"/></xsl:attribute></xsl:when>
					<xsl:when test="Type = 5"><xsl:attribute name="value"><xsl:value-of select="$strBattery"/></xsl:attribute></xsl:when>
					<xsl:when test="Type = 6"><xsl:attribute name="value"><xsl:value-of select="$strUPS"/></xsl:attribute></xsl:when>
					<xsl:when test="Type = 7"><xsl:attribute name="value"><xsl:value-of select="$strConverter"/></xsl:attribute></xsl:when>
					<xsl:when test="Type = 8"><xsl:attribute name="value"><xsl:value-of select="$strRegulator"/></xsl:attribute></xsl:when>
					<xsl:when test="Type = 9"><xsl:attribute name="value"><xsl:value-of select="$strAC"/></xsl:attribute></xsl:when>
					<xsl:when test="Type = 10"><xsl:attribute name="value"><xsl:value-of select="$strDC"/></xsl:attribute></xsl:when>
					<xsl:when test="Type = 11"><xsl:attribute name="value"><xsl:value-of select="$strVRM"/></xsl:attribute></xsl:when>
					<xsl:otherwise><xsl:attribute name="value"><xsl:value-of select="$strNoValue"/></xsl:attribute></xsl:otherwise>
				</xsl:choose>
			</Data>
			<xsl:choose>
          <xsl:when test="Type = 11">
            <Data align="center">
              <xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
            </Data>
          </xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="OutputWatts &gt; 0">
								<Data align="center">
									<xsl:attribute name="value"><xsl:value-of select="OutputWatts div 10"/><xsl:value-of select="$strWattUnit"/></xsl:attribute>
								</Data>
							</xsl:when>
							<xsl:when test="OutputWatts = ''">
                <Data align="center">
                  <xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute></Data>
							</xsl:when>
							<xsl:otherwise>
                <Data align="center">
                  <xsl:attribute name="value"><xsl:value-of select="$strNoValue1"/></xsl:attribute></Data>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
			</xsl:choose>
			<Data>
				<ValueList>
					<xsl:call-template name="OnlineStatus">
						<xsl:with-param name="psStateNode" select="PSState"/>
					</xsl:call-template>
				</ValueList>
			</Data>
			<Data align="center">
				<xsl:choose>
  				<xsl:when test="PMCapable ='true'">
	  				<xsl:attribute name="value"><xsl:value-of select="$strYes"/></xsl:attribute>
		  		</xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="value"><xsl:value-of select="$strNo"/></xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
			</Data>
		</Row>
	</xsl:template>
	
	<xsl:template name="OnlineStatus">
		<xsl:param name="psStateNode"/>
		<xsl:if test="$psStateNode/PSPresenceDetected='true'">
			<value><xsl:value-of select="$strStatePresenceDetected"/></value>
		</xsl:if>
		<xsl:if test="$psStateNode/PSFailureDetected='true'">
			<value><xsl:value-of select="$strStateFailureDetected"/></value>
		</xsl:if>
		<xsl:if test="$psStateNode/PSPredictiveFailure='true'">
			<value><xsl:value-of select="$strStatePredictiveFailure"/></value>
		</xsl:if>
		<xsl:if test="$psStateNode/PSACLost='true'">
			<value><xsl:value-of select="$strStateAcLost"/></value>
		</xsl:if>
		<xsl:if test="$psStateNode/PSACLostorOutofRange='true'">
			<value><xsl:value-of select="$strStateAcLostOrOutOfRange"/></value>
		</xsl:if>
		<xsl:if test="$psStateNode/PSACPresentorOutofRange='true'">
			<value><xsl:value-of select="$strStateAcOutOfRangePresent"/></value>
		</xsl:if>
		<xsl:if test="$psStateNode/PSConfigError='true'">
			<value><xsl:value-of select="$strStateConfigurationError"/></value>
		</xsl:if>
		<xsl:if test="not($psStateNode/PSPresenceDetected='true' or $psStateNode/PSFailureDetected='true' or $psStateNode/PSPredictiveFailure='true' or $psStateNode/PSACLost='true' or $psStateNode/PSACLostorOutofRange='true' or $psStateNode/PSACPresentorOutofRange='true' or $psStateNode/PSConfigError='true')">
			<value><xsl:value-of select="$strNotAvailable"/></value>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="RedStatus">
		<xsl:param name="status"/>
		<xsl:choose>
			<xsl:when test="$status = 1">
				<xsl:attribute name="value"><xsl:value-of select="$strNoValue2"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status = 2">
				<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status = 3">
				<xsl:attribute name="value"><xsl:value-of select="$strOffline1"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status = 4">
				<xsl:attribute name="value"><xsl:value-of select="$strFull"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status = 5">
				<xsl:attribute name="value"><xsl:value-of select="$strDegraded"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status = 6">
				<xsl:attribute name="value"><xsl:value-of select="$strLost"/></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="value"><xsl:value-of select="$strOther1"/></xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="DataType">
		<xsl:param name="name"/>
		<xsl:param name="display"/>
		<xsl:param name="value"/>
		<xsl:param name="editable"/>
		<xsl:param name="type"/>
		<xsl:param name="link"/>
		<xsl:param name="href"/>
		<Data >
			<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="$display"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$value"/></xsl:attribute>
			<xsl:attribute name="editable"><xsl:value-of select="$editable"/></xsl:attribute>
			<xsl:attribute name="link"><xsl:value-of select="$link"/></xsl:attribute>
			<xsl:attribute name="href"><xsl:value-of select="$href"/></xsl:attribute>
			<xsl:attribute name="type"><xsl:value-of select="$type"/></xsl:attribute>
		</Data>
	</xsl:template>
	
	<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:param name="mssg"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'"><xsl:value-of select="$strCommandUnsuccessful"/></xsl:when>
			<xsl:when test="$status = '0'"><xsl:value-of select="$strCommandSuccessful"/></xsl:when>
			<xsl:when test="$status = '1'"><xsl:value-of select="$strCommandNotImplemented"/></xsl:when>
			<xsl:when test="$status = '2'"><xsl:value-of select="$strBadCommand"/></xsl:when>
			<xsl:when test="$status = '3'"><xsl:value-of select="$strCommandTimeout"/></xsl:when>
			<xsl:when test="$status = '4'"><xsl:value-of select="$strCommandCancelled"/></xsl:when>
			<xsl:when test="$status = '5'"><xsl:value-of select="$strCommandAborted"/></xsl:when>
			<xsl:when test="$status = '6'"><xsl:value-of select="$strCommandPending"/></xsl:when>
			<xsl:when test="$status = '7'"><xsl:value-of select="$strNoSuchDevice"/></xsl:when>
			<xsl:when test="$status = '8'"><xsl:value-of select="$strDeviceBusy"/></xsl:when>
			<xsl:when test="$status = '9'"><xsl:value-of select="$strBadDevice"/></xsl:when>
			<xsl:when test="$status = '10'"><xsl:value-of select="$strSpuriousInterrupt"/></xsl:when>
			<xsl:when test="$status = '11'"><xsl:value-of select="$strResourceLocked"/></xsl:when>
			<xsl:when test="$status = '12'"><xsl:value-of select="$strInvalidIndex"/></xsl:when>
			<xsl:when test="$status = '13'"><xsl:value-of select="$strSMBError"/></xsl:when>
			<xsl:when test="$status = '14'"><xsl:value-of select="$strDataRequestedIs"/></xsl:when>
			<xsl:when test="$status = '15'"><xsl:value-of select="$strDataRequestedIs1"/></xsl:when>
			<xsl:when test="$status = '16'"><xsl:value-of select="$strDataRequestedIs2"/></xsl:when>
			<xsl:when test="$status = '17'"><xsl:value-of select="$strDeviceNotYet"/></xsl:when>
			<xsl:when test="$status = '18'"><xsl:value-of select="$strDeviceDoesNot"/></xsl:when>
			<xsl:when test="$status = '19'"><xsl:value-of select="$strDeviceOutOf"/></xsl:when>
			<xsl:when test="$status = '20'"><xsl:value-of select="$strDeviceAlreadyExists"/></xsl:when>
			<xsl:when test="$status = '256'"><xsl:value-of select="$strPowerSupplyObject"/></xsl:when>
			<xsl:when test="$status = '257'"><xsl:value-of select="$strPowerSupplyObject1"/></xsl:when>
			<xsl:when test="$status = '258'"><xsl:value-of select="$strPowerSupplyObject2"/></xsl:when>
			<xsl:when test="$status = '260'"><xsl:value-of select="$strINIFileNot"/></xsl:when>
			<xsl:when test="$status = '261'"><xsl:value-of select="$strINIMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '262'"><xsl:value-of select="$strINISectionDoes"/></xsl:when>
			<xsl:when test="$status = '263'"><xsl:value-of select="$strINIKeyDoes"/></xsl:when>
			<xsl:when test="$status = '264'"><xsl:value-of select="$strINIValueMalformed"/></xsl:when>
			<xsl:when test="$status = '270'"><xsl:value-of select="$strInsufficientAccessRights"/></xsl:when>
			<xsl:when test="$status = '271'"><xsl:value-of select="$strInvalidParameterName"/><xsl:value-of select="$mssg"/></xsl:when>
			<xsl:when test="$status = '272'"><xsl:value-of select="$strOutOfMemory"/></xsl:when>
			<xsl:when test="$status = '280'"><xsl:value-of select="$strXMLFileNot"/></xsl:when>
			<xsl:when test="$status = '281'"><xsl:value-of select="$strXMLMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '282'"><xsl:value-of select="$strXMLNodeDoes"/></xsl:when>
			<xsl:when test="$status = '283'"><xsl:value-of select="$strXMLValueMalformed"/></xsl:when>
			<xsl:otherwise>SMStatus: <xsl:value-of select="$status"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
