<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:strip-space elements="*"/>
<xsl:output method="xml" indent="no"/>
<xsl:template match="/OMA">
	<xsl:choose>
		<xsl:when test="SMStatus='0'"><xsl:call-template name="success"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="failure"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="failure">
	<DataArea>
		<PageTitle><xsl:attribute name="display"><xsl:value-of select="$strProcessorsInformation"/></xsl:attribute></PageTitle>
		<TableData>
			<Header>
				<Data name="">
					<xsl:attribute name="display"><xsl:value-of select="$strError"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strError1"/></xsl:attribute>
				</Data>
			</Header>
			<Row>
				<Data name="" ><xsl:attribute name="display"><xsl:value-of select="$str"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:call-template name="smstatus">
							<xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param>
						</xsl:call-template>
					</xsl:attribute>
				</Data>
			</Row>
		</TableData>
	</DataArea>
</xsl:template>

<xsl:template name="success">
	<DataArea>
		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strProcessorsInformation1"/></xsl:attribute>
			<xsl:attribute name="status"><xsl:value-of select="/OMA/ObjStatus"/></xsl:attribute>
		</PageTitle>
		<PromptText ignoreoncli="true"><xsl:value-of select="$strClickTheConnector"/></PromptText>
		<CustomButton>
			<Data name="Refresh">
				<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.ProcessorWebPlugin&amp;poid=2&amp;help=Processor</xsl:attribute>
			</Data>
		</CustomButton>	
		<TableData columnspacing="true">
			<Header>
				<Data ignoreonweb="true">
					<xsl:attribute name="display"><xsl:value-of select="$strIndex"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strIndex1"/></xsl:attribute>
				</Data>
				<Data align="left">
					<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strStatus"/></xsl:attribute>
				</Data>
				<Data align="left">
					<xsl:attribute name="display"><xsl:value-of select="$strConnectorName"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strConnectorName1"/></xsl:attribute>
				</Data>
        <xsl:choose>
          <xsl:when test="ProcessorList/ProcessorConn/DevProcessor/Brand=''">
            <Data align="left" width="110">
					    <xsl:attribute name="display"><xsl:value-of select="$strProcessorManufacturer"/></xsl:attribute>
					    <xsl:attribute name="value"><xsl:value-of select="$strProcessorManufacturer1"/></xsl:attribute>
				    </Data>
				    <Data align="left">
					    <xsl:attribute name="display"><xsl:value-of select="$strProcessorFamily"/></xsl:attribute>
					    <xsl:attribute name="value"><xsl:value-of select="$strProcessorFamily1"/></xsl:attribute>
				    </Data>
          </xsl:when>
            <xsl:otherwise>
            <Data align="left" width="300">
					    <xsl:attribute name="display"><xsl:value-of select="$strBrand"/></xsl:attribute>
					    <xsl:attribute name="value"><xsl:value-of select="$strBrand"/></xsl:attribute>
				    </Data>
          </xsl:otherwise>
        </xsl:choose>
				<Data align="left">
					<xsl:attribute name="display"><xsl:value-of select="$strProcessorVersion"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strProcessorVersion1"/></xsl:attribute>
				</Data>
				  <Data align="left">
					  <xsl:attribute name="display"><xsl:value-of select="$strCurrentSpeed"/></xsl:attribute>
					  <xsl:attribute name="value"><xsl:value-of select="$strCurrentSpeed1"/></xsl:attribute>
				  </Data>
        <xsl:if test="ProcessorList/ProcessorConn/DevProcessor/Brand=''">
				  <Data align="left" width="110">
					  <xsl:attribute name="display"><xsl:value-of select="$strExternalClockSpeed"/></xsl:attribute>
					  <xsl:attribute name="value"><xsl:value-of select="$strExternalClockSpeed1"/></xsl:attribute>	
				  </Data>
        </xsl:if>
				<Data align="left">
					<xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strState1"/></xsl:attribute>
				</Data>
				<Data align="left">
					<xsl:attribute name="display"><xsl:value-of select="$strCoreCount"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strCoreCount1"/></xsl:attribute>
				</Data>
      </Header>
			<xsl:for-each select="ProcessorList/ProcessorConn">
				<xsl:if test="IsOccupied='true'">
					<xsl:call-template name="Processor">
						<xsl:with-param name="index"><xsl:value-of select="@index"/></xsl:with-param>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="IsOccupied='false'">
					<xsl:call-template name="Processor1">
						<xsl:with-param name="index"><xsl:value-of select="@index"/></xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
		</TableData>
	</DataArea>
</xsl:template>
<xsl:template name="Processor">
	<xsl:param name="index"/>
		<Row>
			<xsl:variable name="slotStatus">
				<xsl:choose>
         	<xsl:when test="/OMA/CPUStatusProbeList">
				    <!-- Processor Status Probe Obj exists (8G platform) -->
				    		<xsl:call-template name="getSlotStatus">
							<xsl:with-param name="probename"><xsl:value-of select="ExtName"/></xsl:with-param>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise><xsl:value-of select="@status"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<Data ignoreonweb="true">
				<xsl:attribute name="display"><xsl:value-of select="$index"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$index"/></xsl:attribute>
			</Data>
			<Data>
			  <xsl:attribute name="value"><xsl:value-of select="$slotStatus"/></xsl:attribute>
         <xsl:attribute name="type">status</xsl:attribute>
	       <xsl:attribute name="align">center</xsl:attribute>
			</Data>
			<xsl:choose>
			  <!--Only display link if processor is present but not disabled -->
				<xsl:when test="$slotStatus!=3">
					<Data link="true"  align="left">
						<xsl:attribute name="value"><xsl:value-of select="ExtName"/></xsl:attribute>
						<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.CacheWebPlugin&amp;oid=<xsl:value-of select="DevProcessor/@oid"/>&amp;help=Cache</xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data align="left">
						<xsl:attribute name="value"><xsl:value-of select="ExtName"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
      <xsl:choose>
        <xsl:when test="DevProcessor/Brand=''">
			    <Data align="left">
				    <xsl:attribute name="value"><xsl:value-of select="DevProcessor/Manufacturer" /></xsl:attribute>
			    </Data>
			    <Data align="left">
				    <xsl:attribute name="value"><xsl:call-template name="family"/></xsl:attribute>
			    </Data>
        </xsl:when>
        <xsl:otherwise>
          <Data align="left" width="300">
            <xsl:attribute name="value"><xsl:value-of select="DevProcessor/Brand" /></xsl:attribute>
          </Data>
        </xsl:otherwise>
		  </xsl:choose>
      <Data align="left">
				<xsl:attribute name="value"><xsl:value-of select="DevProcessor/Model"/><xsl:text> </xsl:text><xsl:value-of select="DevProcessor/Stepping"/></xsl:attribute>
			</Data>
			  <Data align="left">
			      <xsl:attribute name="value"><xsl:call-template name="cursp"/></xsl:attribute>
			  </Data>
      <xsl:if test="DevProcessor/Brand=''">
			  <Data align="left">
				  <xsl:attribute name="value"><xsl:call-template name="extclksp"/></xsl:attribute>
			  </Data>
      </xsl:if>
			<Data align="left">
         <xsl:if test="/OMA/CPUStatusProbeList">
				    <!-- Processor Status Probe Obj exists (8G platform) -->
				    <xsl:call-template name="getstatus"><xsl:with-param name="probename"><xsl:value-of select="ExtName"/></xsl:with-param></xsl:call-template>
				</xsl:if>
				<xsl:if test="not(/OMA/CPUStatusProbeList)">
					<!-- Processor Status Probe Obj does not exist (non-8G platform) -->
					<xsl:attribute name="display"><xsl:call-template name="imagedesc1"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:call-template name="imagedesc1"/></xsl:attribute>
				</xsl:if>
			</Data>
			<Data align="center">
				<xsl:attribute name="value"><xsl:value-of select="DevProcessor/CoreCount"/></xsl:attribute>
			</Data>
		</Row>
</xsl:template>
<xsl:template name="getstatus">
	<xsl:param name="probename"/>
	<xsl:for-each select="/OMA/CPUStatusProbeList/CPUStatusProbe">
		<xsl:variable name="probelocation"><xsl:value-of select="ProbeLocation"/></xsl:variable>
		<xsl:if test="$probename = $probelocation">
			<xsl:call-template name="getstatusdetail"/>
		</xsl:if>
	</xsl:for-each>
</xsl:template>

<xsl:template name="getSlotStatus">
	<xsl:param name="probename"/>
	<xsl:for-each select="/OMA/CPUStatusProbeList/CPUStatusProbe">
		<xsl:variable name="probelocation"><xsl:value-of select="ProbeLocation"/></xsl:variable>
		<xsl:if test="$probename = $probelocation"><xsl:value-of select="@status"/></xsl:if>
	</xsl:for-each>
</xsl:template>

<xsl:template name="getstatusdetail">
	<xsl:choose>
		<xsl:when test="ProcessorStatus/CPUStatusIErr='true'">
			<xsl:attribute name="display"><xsl:value-of select="$strCPUStatusIErr"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strCPUStatusIErr"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="ProcessorStatus/CPUStatusThermTrip='true'">
			<xsl:attribute name="display"><xsl:value-of select="$strCPUStatusThermTrip"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strCPUStatusThermTrip"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="ProcessorStatus/CPUStatusConfigErr='true'">
			<xsl:attribute name="display"><xsl:value-of select="$strCPUStatusConfigErr"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strCPUStatusConfigErr"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="ProcessorStatus/CPUStatusDisabled='true'">
			<xsl:attribute name="display"><xsl:value-of select="$strCPUStatusDisabled"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strCPUStatusDisabled"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="ProcessorStatus/CPUStatusTermPresenceDetected='true'">
			<xsl:attribute name="display"><xsl:value-of select="$strCPUStatusTermPresenceDetected"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strCPUStatusTermPresenceDetected"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="ProcessorStatus/CPUStatusThrottled='true'">
			<xsl:attribute name="display"><xsl:value-of select="$strCPUStatusThrottled"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strCPUStatusThrottled"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="ProcessorStatus/CPUStatusPresenceDetected='true'">
			<xsl:attribute name="display"><xsl:value-of select="$strCPUStatusPresenceDetected"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strCPUStatusPresenceDetected"/></xsl:attribute>
		</xsl:when>
		<xsl:otherwise>
			<xsl:attribute name="display"><xsl:value-of select="$strUnknown"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strUnknown"/></xsl:attribute>
		</xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="family">
	<xsl:choose>
		<xsl:when test="DevProcessor/Family= '1'"><xsl:value-of select="$strOther"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '2'"><xsl:value-of select="$strUnknown"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '3'"><xsl:value-of select="$str8086"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '4'"><xsl:value-of select="$str80286"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '5'"><xsl:value-of select="$str80386"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '6'"><xsl:value-of select="$str80486"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '7'"><xsl:value-of select="$str8087"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '8'"><xsl:value-of select="$str80287"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '9'"><xsl:value-of select="$str80387"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '10'"><xsl:value-of select="$str80487"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '11'"><xsl:value-of select="$strPentiumFamily"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '12'"><xsl:value-of select="$strPentiumPro"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '13'"><xsl:value-of select="$strPentiumII"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '14'"><xsl:value-of select="$strPentiumMMX"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '15'"><xsl:value-of select="$strCeleron"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '16'"><xsl:value-of select="$strXeon"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '17'"><xsl:value-of select="$strPentiumIII"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '18'"><xsl:value-of select="$strM1Family"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '19'"><xsl:value-of select="$strM2Family"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '24'"><xsl:value-of select="$strAMDDuron"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '25'"><xsl:value-of select="$strK5Family"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '26'"><xsl:value-of select="$strK6Family"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '27'"><xsl:value-of select="$strK6-2"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '28'"><xsl:value-of select="$strK6-3"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '29'"><xsl:value-of select="$strAMDAthlon"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '30'"><xsl:value-of select="$strAMD2900"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '31'"><xsl:value-of select="$strK6-2Plus"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '32'"><xsl:value-of select="$strPowerPCFamily"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '33'"><xsl:value-of select="$strPowerPC601"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '34'"><xsl:value-of select="$strPowerPC603"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '35'"><xsl:value-of select="$strPowerPC6031"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '36'"><xsl:value-of select="$strPowerPC604"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '37'"><xsl:value-of select="$strPowerPC620"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '38'"><xsl:value-of select="$strPowerPCx704"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '39'"><xsl:value-of select="$strPowerPC750"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '48'"><xsl:value-of select="$strAlphaFamily"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '49'"><xsl:value-of select="$strAlpha21064"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '50'"><xsl:value-of select="$strAlpha21066"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '51'"><xsl:value-of select="$strAlpha21164"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '52'"><xsl:value-of select="$strAlpha21164PC"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '53'"><xsl:value-of select="$strAlpha21164a"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '54'"><xsl:value-of select="$strAlpha21264"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '55'"><xsl:value-of select="$strAlpha21364"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '64'"><xsl:value-of select="$strMIPSFamily"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '65'"><xsl:value-of select="$strMIPSR4000"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '66'"><xsl:value-of select="$strMIPSR4200"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '67'"><xsl:value-of select="$strMIPSR4400"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '68'"><xsl:value-of select="$strMIPSR4600"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '69'"><xsl:value-of select="$strMIPSR10000"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '80'"><xsl:value-of select="$strSPARCFamily"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '81'"><xsl:value-of select="$strSuperSPARC"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '82'"><xsl:value-of select="$strmicroSPARCII"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '83'"><xsl:value-of select="$strmicroSPARCIIep"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '84'"><xsl:value-of select="$strUltraSPARC"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '85'"><xsl:value-of select="$strUltraSPARCII"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '86'"><xsl:value-of select="$strUltraSPARCIIi"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '87'"><xsl:value-of select="$strUltraSPARCIII"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '88'"><xsl:value-of select="$strUltraSPARCIIIi"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '96'"><xsl:value-of select="$str68040"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '97'"><xsl:value-of select="$str68xxxFamily"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '98'"><xsl:value-of select="$str68000"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '99'"><xsl:value-of select="$str68010"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '100'"><xsl:value-of select="$str68020"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '101'"><xsl:value-of select="$str68030"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '112'"><xsl:value-of select="$strHobbitFamily"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '120'"><xsl:value-of select="$strCrusoeTM5000"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '121'"><xsl:value-of select="$strCrusoeTM3000"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '122'"><xsl:value-of select="$strEfficeonTM8000"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '128'"><xsl:value-of select="$strWeitek"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '130'"><xsl:value-of select="$strItanium"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '131'"><xsl:value-of select="$strAMDAthlon64"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '132'"><xsl:value-of select="$strAMDOpteron"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '138'"><xsl:value-of select="$strAMDQuadCore"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '139'"><xsl:value-of select="$strAMDThirdGen"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '144'"><xsl:value-of select="$strPARISCFamily"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '145'"><xsl:value-of select="$strPA-RISC8500"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '146'"><xsl:value-of select="$strPA-RISC8000"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '147'"><xsl:value-of select="$strPA-RISC7300LC"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '148'"><xsl:value-of select="$strPA-RISC7200"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '149'"><xsl:value-of select="$strPA-RISC7100LC"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '150'"><xsl:value-of select="$strPA-RISC7100"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '160'"><xsl:value-of select="$strV30Family"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '176'"><xsl:value-of select="$strPentiumIIIXeon"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '177'"><xsl:value-of select="$strPentiumIIIWith"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '178'"><xsl:value-of select="$strPentiumIV"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '179'"><xsl:value-of select="$strXeon1"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '180'"><xsl:value-of select="$strAS400"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '181'"><xsl:value-of select="$strXeonMP"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '182'"><xsl:value-of select="$strAMDAthlonXP"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '183'"><xsl:value-of select="$strAMDAthlonMP"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '184'"><xsl:value-of select="$strItanium2"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '185'"><xsl:value-of select="$strPentiumM"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '186'"><xsl:value-of select="$strCeleronD"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '187'"><xsl:value-of select="$strPentiumD"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '188'"><xsl:value-of select="$strPentiumExtreme"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '200'"><xsl:value-of select="$strIBM390"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '201'"><xsl:value-of select="$strG4"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '202'"><xsl:value-of select="$strG5"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '250'"><xsl:value-of select="$stri860"/></xsl:when>
		<xsl:when test="DevProcessor/Family= '251'"><xsl:value-of select="$stri960"/></xsl:when>
	</xsl:choose>
</xsl:template>
<xsl:template name="type">
	<xsl:choose>
		<xsl:when test="DevProcessor/ProcessorType= '1'"><xsl:value-of select="$strOther1"/></xsl:when>
		<xsl:when test="DevProcessor/ProcessorType= '2'"><xsl:value-of select="$strUnknown1"/></xsl:when>
		<xsl:when test="DevProcessor/ProcessorType= '3'"><xsl:value-of select="$strCentralProcessor"/></xsl:when>
		<xsl:when test="DevProcessor/ProcessorType= '4'"><xsl:value-of select="$strMathProcessor"/></xsl:when>
		<xsl:when test="DevProcessor/ProcessorType= '5'"><xsl:value-of select="$strDSPProcessor"/></xsl:when>
		<xsl:when test="DevProcessor/ProcessorType= '6'"><xsl:value-of select="$strVideoProcessor"/></xsl:when>
	</xsl:choose>
</xsl:template>
<xsl:template name="imagedesc1">
	<xsl:if test="DevProcessor/ProcessorStatus='1'"><xsl:value-of select="$strOther2"/></xsl:if>
	<xsl:if test="DevProcessor/ProcessorStatus='2'"><xsl:value-of select="$strUnknown2"/></xsl:if>
	<xsl:if test="DevProcessor/ProcessorStatus='3'"><xsl:value-of select="$strEnabled"/></xsl:if>
	<xsl:if test="DevProcessor/ProcessorStatus='4'"><xsl:value-of select="$strUserDisabled"/></xsl:if>
	<xsl:if test="DevProcessor/ProcessorStatus='5'"><xsl:value-of select="$strBIOSDisabled"/></xsl:if>
	<xsl:if test="DevProcessor/ProcessorStatus='6'"><xsl:value-of select="$strIdle"/></xsl:if>
</xsl:template>

<xsl:template name="maxsp">
	<xsl:choose>
		<xsl:when test="DevProcessor/MaxSpeed='0'"><xsl:value-of select="$strUnknown3"/></xsl:when>
		<xsl:otherwise><xsl:value-of select="DevProcessor/MaxSpeed"/><xsl:text disable-output-escaping="yes">  </xsl:text><xsl:value-of select="DevProcessor/MaxSpeed/@unit"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="cursp">
	<xsl:choose>
		<xsl:when test="DevProcessor/CurSpeed='0'"><xsl:value-of select="$strUnknown4"/></xsl:when>
		<xsl:otherwise><xsl:value-of select="DevProcessor/CurSpeed"/><xsl:text disable-output-escaping="yes">  </xsl:text><xsl:value-of select="DevProcessor/CurSpeed/@unit"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="extclksp">
	<xsl:choose>
		<xsl:when test="DevProcessor/ExtClockSpeed='0'"><xsl:value-of select="$strUnknown5"/></xsl:when>
		<xsl:otherwise><xsl:value-of select="DevProcessor/ExtClockSpeed"/><xsl:text disable-output-escaping="yes">  </xsl:text><xsl:value-of select="DevProcessor/ExtClockSpeed/@unit"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="upgrade">
	<xsl:choose>
		<xsl:when test="DevProcessor/Upgrade= '1'"><xsl:value-of select="$strOther3"/></xsl:when>
		<xsl:when test="DevProcessor/Upgrade= '2'"><xsl:value-of select="$strUnknown6"/></xsl:when>
		<xsl:when test="DevProcessor/Upgrade= '3'"><xsl:value-of select="$strDaughterBoard"/></xsl:when>
		<xsl:when test="DevProcessor/Upgrade= '4'"><xsl:value-of select="$strZIFSocket"/></xsl:when>
		<xsl:when test="DevProcessor/Upgrade= '5'"><xsl:value-of select="$strReplacementPiggyBack"/></xsl:when>
		<xsl:when test="DevProcessor/Upgrade= '6'"><xsl:value-of select="$strNone"/></xsl:when>
		<xsl:when test="DevProcessor/Upgrade= '7'"><xsl:value-of select="$strLIFSocket"/></xsl:when>
		<xsl:when test="DevProcessor/Upgrade= '8'"><xsl:value-of select="$strSlot1"/></xsl:when>
		<xsl:when test="DevProcessor/Upgrade= '9'"><xsl:value-of select="$strSlot2"/></xsl:when>
		<xsl:when test="DevProcessor/Upgrade= '10'"><xsl:value-of select="$str370PinSocket"/></xsl:when>
	</xsl:choose>
</xsl:template>
<xsl:template name="Processor1">
	<xsl:param name="index"/>
	<Row>
		<Data ignoreonweb="true">
				<xsl:attribute name="display"><xsl:value-of select="$index"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$index"/></xsl:attribute>
		</Data>
		<Data>
			<xsl:attribute name="value">1</xsl:attribute>
          	<xsl:attribute name="type">status</xsl:attribute>
	         	<xsl:attribute name="align">center</xsl:attribute>
		</Data>
		<Data align="left">
			<xsl:attribute name="value"><xsl:value-of select="ExtName"/></xsl:attribute>
		</Data>
		<Data align="left">
			<xsl:attribute name="display"><xsl:value-of select="$strNotOccupied"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strNotOccupied1"/></xsl:attribute>
		</Data>
		<Data  ignoreonweb="true" align="left">
			<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="$strNA1"/></xsl:attribute>
		</Data>
		<Data ignoreonweb="true"  align="left">
			<xsl:attribute name="value"><xsl:value-of select="$strNA2"/></xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="$strNA3"/></xsl:attribute>
		</Data>
		<Data ignoreonweb="true"  align="left"><xsl:attribute name="value"><xsl:value-of select="$strNA4"/></xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="$strNA5"/></xsl:attribute>
		</Data>
		<Data ignoreonweb="true"  align="left">
			<xsl:attribute name="value"><xsl:value-of select="$strNA6"/></xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="$strNA7"/></xsl:attribute>
		</Data>
		<Data  ignoreoncli="true"><xsl:attribute name="value"><xsl:value-of select="$str1"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str2"/></xsl:attribute></Data>
		<Data  ignoreoncli="true"><xsl:attribute name="value"><xsl:value-of select="$str3"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str4"/></xsl:attribute></Data>
		<Data  ignoreoncli="true"><xsl:attribute name="value"><xsl:value-of select="$str5"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str6"/></xsl:attribute></Data>
		<Data  ignoreoncli="true"><xsl:attribute name="value"><xsl:value-of select="$str7"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str8"/></xsl:attribute></Data>
                <xsl:if test="/OMA/ProcessorList/ProcessorConn/DevProcessor/Brand=''">
		    <Data  ignoreoncli="true"><xsl:attribute name="value"><xsl:value-of select="$str9"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str10"/></xsl:attribute></Data>
                </xsl:if>
         <Data  ignoreoncli="true"><xsl:attribute name="value"><xsl:value-of select="$str11"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str12"/></xsl:attribute></Data>
	</Row>
</xsl:template>

<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'"><xsl:value-of select="$strCommandUnsuccessful"/></xsl:when>
			<xsl:when test="$status = '1'"><xsl:value-of select="$strCommandNotImplemented"/></xsl:when>
			<xsl:when test="$status = '2'"><xsl:value-of select="$strBadCommand"/></xsl:when>
			<xsl:when test="$status = '3'"><xsl:value-of select="$strCommandTimeout"/></xsl:when>
			<xsl:when test="$status = '4'"><xsl:value-of select="$strCommandCancelled"/></xsl:when>
			<xsl:when test="$status = '5'"><xsl:value-of select="$strCommandAborted"/></xsl:when>
			<xsl:when test="$status = '6'"><xsl:value-of select="$strCommandPending"/></xsl:when>
			<xsl:when test="$status = '7'"><xsl:value-of select="$strNoSuchDevice"/></xsl:when>
			<xsl:when test="$status = '8'"><xsl:value-of select="$strDeviceBusy"/></xsl:when>
			<xsl:when test="$status = '9'"><xsl:value-of select="$strBadDevice"/></xsl:when>
			<xsl:when test="$status = '10'"><xsl:value-of select="$strSpuriousInterrupt"/></xsl:when>
			<xsl:when test="$status = '11'"><xsl:value-of select="$strResourceLocked"/></xsl:when>
			<xsl:when test="$status = '12'"><xsl:value-of select="$strInvalidIndex"/></xsl:when>
			<xsl:when test="$status = '13'"><xsl:value-of select="$strSMBError"/></xsl:when>
			<xsl:when test="$status = '14'"><xsl:value-of select="$strDataRequestedIs"/></xsl:when>
			<xsl:when test="$status = '15'"><xsl:value-of select="$strDataRequestedIs1"/></xsl:when>
			<xsl:when test="$status = '16'"><xsl:value-of select="$strDataRequestedIs2"/></xsl:when>
			<xsl:when test="$status = '17'"><xsl:value-of select="$strDeviceNotYet"/></xsl:when>
			<xsl:when test="$status = '18'"><xsl:value-of select="$strDeviceDoesNot"/></xsl:when>
			<xsl:when test="$status = '19'"><xsl:value-of select="$strDeviceOutOf"/></xsl:when>
			<xsl:when test="$status = '20'"><xsl:value-of select="$strDeviceAlreadyExists"/></xsl:when>
			<xsl:when test="$status = '256'"><xsl:value-of select="$strProcessorNotFound"/></xsl:when>
			<xsl:when test="$status = '257'"><xsl:value-of select="$strProcessorMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '258'"><xsl:value-of select="$strProcessorAlreadyExists"/></xsl:when>
			<xsl:when test="$status = '260'"><xsl:value-of select="$strINIFileNot"/></xsl:when>
			<xsl:when test="$status = '261'"><xsl:value-of select="$strINIMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '262'"><xsl:value-of select="$strINISectionDoes"/></xsl:when>
			<xsl:when test="$status = '263'"><xsl:value-of select="$strINIKeyDoes"/></xsl:when>
			<xsl:when test="$status = '264'"><xsl:value-of select="$strINIValueMalformed"/></xsl:when>
			<xsl:when test="$status = '270'"><xsl:value-of select="$strInsufficientAccessRights"/></xsl:when>
			<xsl:when test="$status = '271'"><xsl:value-of select="$strInvalidParameterName"/></xsl:when>
			<xsl:when test="$status = '272'"><xsl:value-of select="$strOutOfMemory"/></xsl:when>
			<xsl:when test="$status = '280'"><xsl:value-of select="$strXMLFileNot"/></xsl:when>
			<xsl:when test="$status = '281'"><xsl:value-of select="$strXMLMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '282'"><xsl:value-of select="$strXMLNodeDoes"/></xsl:when>
			<xsl:when test="$status = '283'"><xsl:value-of select="$strXMLValueMalformed"/></xsl:when>
			<xsl:otherwise>SMStatus: <xsl:value-of select="$status"/></xsl:otherwise>
		</xsl:choose>
</xsl:template>
<xsl:template match="*"/>
</xsl:stylesheet>

