<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="OMA">
		
		<xsl:choose>
			<xsl:when test="POSTLog"><xsl:apply-templates select="POSTLog"/></xsl:when>
			<xsl:otherwise><DataArea><PageTitle><xsl:attribute name="display"><xsl:value-of select="$strErrorNoPOST"/></xsl:attribute></PageTitle></DataArea></xsl:otherwise>
		</xsl:choose>
		
	</xsl:template>
	
	<xsl:template match="POSTLog">
		<DataArea>
			<script language="javascript">
				function saveLog()
				{
					document.dataarea.action='/servlet/SubmitForm?plugin=com.dell.oma.webplugins.SaveLogWebPlugin';
					
					// DFCT93265, Clicking on the "Save As" button second time and performing either save or cancel, resulted an Abend on all flavous of Netware.
                                	// The following single line has been added for fixing the problem.
				
					document.getElementById("pageCode").value = "";
					
					document.getElementById("pageCode").value = document.getElementsByTagName("HTML")[0].innerHTML;
					document.dataarea.submit();
				}
			</script>		
			<Header>Header</Header>
			<PageTitle><xsl:attribute name="display"><xsl:value-of select="$strPowerOnSelf"/></xsl:attribute></PageTitle>
			<xsl:choose>
				<xsl:when test="NumRecords = '0'">
					<PromptText><xsl:value-of select="$strPowerOnSelf1"/></PromptText>			
				</xsl:when>
				<xsl:otherwise>
					<PromptText><xsl:value-of select="$strPowerOnSelf2"/></PromptText>			
				</xsl:otherwise>
			</xsl:choose>
			<CustomButton>
				<xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">		
					<Data name="Save"><xsl:attribute name="display"><xsl:value-of select="$strSaveAs"/></xsl:attribute>
						<xsl:attribute name="href">javascript:saveLog()</xsl:attribute>
						<xsl:attribute name="formSubmit">true</xsl:attribute>
					</Data>
				</xsl:if>
				<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.PostLogWebPlugin</xsl:attribute>
				</Data>
			</CustomButton>
			<TableData>
				<Header>
					<Data name="Log"><xsl:attribute name="value"><xsl:value-of select="$strPOSTCodeDescription"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$strPOSTCodeDescription1"/></xsl:attribute></Data>
				</Header>
				<xsl:apply-templates select="LogEntry"/>
			</TableData>
		</DataArea>
	</xsl:template>
	
	<xsl:template match="LogEntry">
		<Row>
			<Data name="description" type="ustring">
				<xsl:attribute name="value"><xsl:value-of select="Description"/></xsl:attribute>
			</Data>
		</Row>
	</xsl:template>
	<xsl:template match="*"/>
</xsl:stylesheet>
