<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">

	<xsl:variable name="sensorTypeWatchdog">35</xsl:variable>
	<xsl:variable name="sensorTypeEventLogDisabled">16</xsl:variable>

	<xsl:template match="/OMA">
		<xsl:choose>
			<xsl:when test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
				<xsl:apply-templates select="EMPPEFEvtFltrListObj/eventFilterListarray/eventFilterList[filterKey = /OMA/PEFType]"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="eventFilterList">
    <xsl:variable name="varPEFFilterKey"><xsl:value-of select="filterKey"/></xsl:variable>
		<xsl:variable name="varPEFName">
			<xsl:call-template name="getPEFName">
				<xsl:with-param name="filterId"><xsl:value-of select="filterKey"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
    <script language="javascript">
      function PowerReductionValidate()
      {	
		if(document.all)
		{
			if(document.all.ShutdownMode.length>4)
			if(document.all.ShutdownMode[4].checked)
				{
                		if(!confirm("<xsl:value-of select="$strPwrReductionConfirm"/>"))
                		{
                 			return;
                 		}
                 		}
		}
		else
		{	
		var count = 0 ;
		var flag = -1 ;
		var no_of_tags = document.getElementsByTagName("input");
		for(count in no_of_tags)
		{	
			var temp;
			temp = document.getElementsByTagName("input")[count];
			if(temp.id == "ShutdownMode")
				{
					if(temp.value == "4")
						flag = count;
				}
		}
	
 	    if(flag != -1)
		{
          		if(document.getElementsByTagName("input")[flag].checked)
          		{
                		if(!confirm("<xsl:value-of select="$strPwrReductionConfirm"/>"))
                 		{
                    	return;
                 		}
			}
          	}
   		}
            document.getElementById("dataarea").action=top.gnv.appendVID("/servlet/SubmitForm?plugin=com.dell.hip.webplugins.SetPEFWebPlugin&amp;oid="<xsl:if test="@oid">+<xsl:value-of select="@oid"/></xsl:if>+"&amp;peftype="+<xsl:value-of select="filterKey"/>);
            document.getElementById("dataarea").submit();
      }
    </script>
    <DataArea validate="true" onLoad="true" exportdata="false">
      <xsl:if test="($varPEFName != $strPEFUnknown)">
        <xsl:attribute name="submit">javascript:PowerReductionValidate();</xsl:attribute>
      </xsl:if>
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strPlatformEvents"/></xsl:attribute>
			<xsl:attribute name="backpagetarget">/servlet/DataArea?plugin=com.dell.hip.webplugins.ListPEFWebPlugin&amp;help=ListPEF&amp;type=<xsl:value-of select="/OMA/Type"/></xsl:attribute>
			<script language="javascript">
				function initializationRoutine()
				{
					//document.getElementById("ShutdownMode").checked = true;
					//document.getElementById("GenerateAlert").checked = true;
				}
				function validate()
				{
					return true;
				}

				function setDefault()
				{
					try
				  {
					  //document.all.ShutdownMode[ 0 ].checked=true;
					  document.getElementById("GenerateAlert").checked = true;
						document.getElementById("ShutdownMode").checked = true;
					}
					catch(e){};	
				}
			</script>

			<PageTitle display="{$strSetPlatformEvents}{$varPEFName}"/>
			<xsl:if test="$varPEFName != $strPEFUnknown">
				<PromptText><xsl:value-of select="$strCheckTheAction"/></PromptText>
				<CustomButton>
					<Data name="default">
						<xsl:attribute name="display"><xsl:value-of select="$strSetToDefault"/></xsl:attribute>
						<xsl:attribute name="href">javascript:setDefault();</xsl:attribute>
					</Data>
					<Data name="Refresh">
						<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
						<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.PEFWebPlugin&amp;oid=<xsl:value-of select="@oid"/>&amp;type=<xsl:value-of select="/OMA/Type"/>&amp;peftype=<xsl:value-of select="filterKey"/>&amp;help=SetPEF</xsl:attribute>
					</Data>
				</CustomButton>
				<xsl:if test="not(sensorType = $sensorTypeWatchdog or sensorType = $sensorTypeEventLogDisabled)">
					<!-- cannot set alert action for automatic system recovery or alert log full-->
					<TableData name="shutdown">
						<xsl:attribute name="display"><xsl:value-of select="$strShutdownAction"/>	</xsl:attribute>
						<Header>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strShutdownAction"/>	</xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strShutdownAction"/>	</xsl:attribute>
							</Data>
						</Header>
						<Row>
							<xsl:element name="Data">
								<xsl:attribute name="name">ShutdownMode</xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$strNone"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strNone"/></xsl:attribute>
								<xsl:attribute name="returnvalue">0</xsl:attribute>
								<xsl:attribute name="type">radio</xsl:attribute>
								<xsl:if test="not((evtFltrActionReset = 'true') or (evtFltrActionPwrCycl = 'true') or (evtFltrActionPwrOff = 'true'))">
									<xsl:attribute name="state">1</xsl:attribute>
								</xsl:if>
								<xsl:attribute name="align">left</xsl:attribute>
							</xsl:element>
						</Row>
						<Row>
							<xsl:element name="Data">
								<xsl:attribute name="name">ShutdownMode</xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$strHardReboot"/>	</xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strHardReboot"/>	</xsl:attribute>
								<xsl:attribute name="returnvalue">1</xsl:attribute>
								<xsl:attribute name="type">radio</xsl:attribute>
								<xsl:if test="evtFltrActionReset = 'true'">
									<xsl:attribute name="state">1</xsl:attribute>
								</xsl:if>
								<xsl:attribute name="align">left</xsl:attribute>
							</xsl:element>
						</Row>
						<Row>
							<xsl:element name="Data">
								<xsl:attribute name="name">ShutdownMode</xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$strHardPowerCycle"/>	</xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strHardPowerCycle"/>	</xsl:attribute>
								<xsl:attribute name="returnvalue">2</xsl:attribute>
								<xsl:attribute name="type">radio</xsl:attribute>
								<xsl:if test="evtFltrActionPwrCycl = 'true'">
									<xsl:attribute name="state">1</xsl:attribute>
								</xsl:if>
								<xsl:attribute name="align">left</xsl:attribute>
							</xsl:element>
						</Row>
						<Row>
							<xsl:element name="Data">
								<xsl:attribute name="name">ShutdownMode</xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$strHardPowerOff"/>	</xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strHardPowerOff"/>	</xsl:attribute>
								<xsl:attribute name="returnvalue">3</xsl:attribute>
								<xsl:attribute name="type">radio</xsl:attribute>
								<xsl:if test="evtFltrActionPwrOff = 'true'">
									<xsl:attribute name="state">1</xsl:attribute>
								</xsl:if>
								<xsl:attribute name="align">left</xsl:attribute>
							</xsl:element>
						</Row>
            <xsl:if test="$varPEFFilterKey= '524547' or $varPEFFilterKey = '1048835'" >
              <Row>
                <xsl:element name="Data">
                  <xsl:attribute name="name">ShutdownMode</xsl:attribute>
                  <xsl:attribute name="display">
                    <xsl:value-of select="$strPwrReduction"/>
                  </xsl:attribute>
                  <xsl:attribute name="value">
                    <xsl:value-of select="$strPwrReduction"/>
                  </xsl:attribute>
                  <xsl:attribute name="returnvalue">4</xsl:attribute>
                  <xsl:attribute name="type">radio</xsl:attribute>
                  <xsl:if test="evtFltrActionOEM = 'true'">
                    <xsl:attribute name="state">1</xsl:attribute>
                  </xsl:if>
                  <xsl:attribute name="align">left</xsl:attribute>
                </xsl:element>
              </Row>
            </xsl:if>
					</TableData>
				</xsl:if>
				<TableData name="alert">
					<xsl:attribute name="display"><xsl:value-of select="$strGenerateAlert"/></xsl:attribute>
					<Header>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strGenerateAlert"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strGenerateAlert"/></xsl:attribute>
						</Data>
					</Header>
					<Row>
						<xsl:element name="Data">
							<xsl:attribute name="name">GenerateAlert</xsl:attribute>
							<xsl:attribute name="display"><xsl:value-of select="$strEnable"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strEnable"/></xsl:attribute>
							<xsl:attribute name="returnvalue">true</xsl:attribute>
							<xsl:attribute name="type">checkbox</xsl:attribute>
							<xsl:if test="evtFltrActionAlert = 'true'">
								<xsl:attribute name="state">1</xsl:attribute>
							</xsl:if>
							<xsl:attribute name="align">left</xsl:attribute>
						</xsl:element>
					</Row>
				</TableData>
			</xsl:if>
		</DataArea>
	</xsl:template>

	<xsl:template name="getPEFName">
		<xsl:param name="filterId"/>
		<xsl:choose>
			<xsl:when test="$filterId = '1048836'"><xsl:value-of select="$strFanProbeFailure"/></xsl:when>
			<xsl:when test="$filterId = '1048834'"><xsl:value-of select="$strVoltageProbeFailure"/></xsl:when>
			<xsl:when test="$filterId = '1049346'"><xsl:value-of select="$strDiscreteVoltageProbeFailure"/></xsl:when>
			<xsl:when test="$filterId = '524545'"> <xsl:value-of select="$strTemperatureProbeWarning"/></xsl:when>
			<xsl:when test="$filterId = '1048833'"><xsl:value-of select="$strTemperatureProbeFailure"/></xsl:when>
			<xsl:when test="$filterId = '1076997'"><xsl:value-of select="$strChassisIntrusionDetected"/></xsl:when>
			<xsl:when test="$filterId = '527359'"> <xsl:value-of select="$strRedundancyDegraded"/></xsl:when>
			<xsl:when test="$filterId = '1051647'"><xsl:value-of select="$strRedundancyLost"/></xsl:when>
			<xsl:when test="$filterId = '552711'"> <xsl:value-of select="$strProcessorWarning"/></xsl:when>
			<xsl:when test="$filterId = '1076999'"><xsl:value-of select="$strProcessorFailure"/></xsl:when>
			<xsl:when test="$filterId = '552712'"> <xsl:value-of select="$strPSVRMD2DWarning"/></xsl:when>
			<xsl:when test="$filterId = '1077000'"><xsl:value-of select="$strPSVRMD2DFailure"/></xsl:when>
			<xsl:when test="$filterId = '1077008'"><xsl:value-of select="$strHardwareLogFailure"/></xsl:when>
			<xsl:when test="$filterId = '1077027'"><xsl:value-of select="$strAutomaticSystemRecovery"/></xsl:when>
			<xsl:when test="$filterId = '552745'"> <xsl:value-of select="$strBatteryWarning"/></xsl:when>
			<xsl:when test="$filterId = '1077033'"><xsl:value-of select="$strBatteryFailure"/></xsl:when>
			<xsl:when test="$filterId = '1109767'"><xsl:value-of select="$strProcessorRemoved"/></xsl:when>
			<xsl:when test="$filterId = '1109768'"><xsl:value-of select="$strPowerSupplyRemoved"/></xsl:when>
      <xsl:when test="$filterId = '524547'"><xsl:value-of select="$strSystemPowerProbeWarning"/></xsl:when>
      <xsl:when test="$filterId = '1048835'"><xsl:value-of select="$strSystemPowerProbeFailure"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$strPEFUnknown"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
