<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="OMA">
		<xsl:choose>
			<xsl:when test="SMStatus != '0' or count(/OMA/BatteryObj) = 0">
				<xsl:apply-templates select="failure"/>
			</xsl:when>
  		    <!--xsl:when test="BatteryObj/@instance >= '0'">
				<xsl:apply-templates select="BatteryObjList"/>
			</xsl:when-->
			<xsl:otherwise>
				<!--xsl:apply-templates select="BatteryObj"/-->
				<xsl:call-template name="ListBatteries"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="failure">
		<DataArea>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strBatteries"/></xsl:attribute>
			</PageTitle>
			<TableData>
				<Header>
					<Data>
						<xsl:attribute name="value"><xsl:value-of select="$strError"/></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strError1"/></xsl:attribute>
					</Data>
				</Header>
				<Row>
					<Data>
						<xsl:attribute name="value"><xsl:value-of select="$strNoBatterySensor"/></xsl:attribute>
					</Data>
				</Row>
			</TableData>
		</DataArea>
	</xsl:template>
	<!--xsl:template match="BatteryObj"-->
	<xsl:template name="ListBatteries">
		<DataArea>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strBatteries"/></xsl:attribute>
				<xsl:attribute name="status"><xsl:value-of select="/OMA/computedobjstatus"/></xsl:attribute>
			</PageTitle>
			<CustomButton>
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.ListBatteryWebPlugin&amp;help=Batteries&amp;poid=<xsl:value-of select="poid"/></xsl:attribute>
				</Data>
			</CustomButton>
			<TableData columnspacing="true">
				<xsl:choose>
					<xsl:when test="/OMA/@cli = 'true'">
						<Header>
							<Data name="index">
								<xsl:attribute name="ignoreonweb">true</xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$strIndex"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strIndex1"/></xsl:attribute>
							</Data>
							<Data name="Status" align="center">
								<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strStatus1"/></xsl:attribute>
							</Data>
							<Data name="ProbeName">
								<xsl:attribute name="display"><xsl:value-of select="$strProbeName"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strProbeName1"/></xsl:attribute>
							</Data>
							<Data name="Reading" align="center">
								<xsl:attribute name="display"><xsl:value-of select="$strReading"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strReading1"/></xsl:attribute>
							</Data>
						</Header>
					</xsl:when>
					<xsl:otherwise>
						<Header>
							<Data name="" ignoreonweb="true">
								<xsl:attribute name="value"><xsl:value-of select="$str"/></xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$str1"/></xsl:attribute>
							</Data>
							<Data name="">
								<xsl:attribute name="value"><xsl:value-of select="$str2"/></xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$str3"/></xsl:attribute>
							</Data>
							<Data name="">
								<xsl:attribute name="value"><xsl:value-of select="$str4"/></xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$str5"/></xsl:attribute>
							</Data>
							<Data name="">
								<xsl:attribute name="value"><xsl:value-of select="$str6"/></xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$str7"/></xsl:attribute>
							</Data>
						</Header>
						<Header>
							<Data name="index">
								<xsl:attribute name="ignoreonweb">true</xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$strIndex2"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strIndex3"/></xsl:attribute>
							</Data>
							<Data name="Status" align="center">
								<xsl:attribute name="display"><xsl:value-of select="$strStatus2"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strStatus3"/></xsl:attribute>
							</Data>
							<Data name="ProbeName">
								<xsl:attribute name="display"><xsl:value-of select="$strProbeName"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strProbeName"/></xsl:attribute>
							</Data>
							<Data name="Reading" align="center">
								<xsl:attribute name="display"><xsl:value-of select="$strReading2"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strReading3"/></xsl:attribute>
							</Data>
						</Header>
					</xsl:otherwise>
				</xsl:choose>

				<SubHeader>
					<xsl:attribute name="display"><xsl:value-of select="$strIndividualBattery"/></xsl:attribute>
				</SubHeader>
				
				<xsl:apply-templates select="/OMA/BatteryObj"/>
					
			</TableData>
		</DataArea>
	</xsl:template>
	
	<xsl:template match="BatteryObj">
		<Row>
			<Data ignoreonweb="true">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="@instance"><xsl:value-of select="@instance"/></xsl:when>
						<xsl:otherwise>0</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
			<Data align="center" type="status" value="{objstatus}"/>
			<Data value="{ProbeLocation}" display="{ProbeLocation}" type="ustring" editable="false"/>
			<Data align="center">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="probeReading='4'"><xsl:value-of select="$strGood"/></xsl:when>
						<xsl:when test="probeReading='2'"><xsl:value-of select="$strFailed"/></xsl:when>
						<xsl:when test="probeReading='1'"><xsl:value-of select="$strPredictiveFailure"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$strUnknownStatus"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
		</Row>
	</xsl:template>
</xsl:stylesheet>
