<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="OMA">
		<xsl:choose>
			<xsl:when test="SMStatus = '0'">
				<xsl:apply-templates select="LRAProtect"/>
			</xsl:when>
			<xsl:otherwise>
				<DataArea exportdata="false">
					<PageTitle>
						<xsl:attribute name="display">
							<xsl:call-template name="smstatus">
								<xsl:with-param name="status"><xsl:value-of select="smstatus/@ass32"/></xsl:with-param>
							</xsl:call-template>
						</xsl:attribute>
					</PageTitle>
				</DataArea>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="LRAProtect">
			<xsl:apply-templates select="lpoConfigSDOArrayarray/lpoConfigSDOArray"/>	
	</xsl:template>
	<xsl:template match="lpoConfigSDOArray">
		<xsl:if test="lrcLraType = 1045">
		<xsl:choose>
			<xsl:when test="/OMA/@cli = 'true'">
				<DataArea exportdata="false">
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strThermalShutdown"/></xsl:attribute>
					</PageTitle>
					<ListData>
						<Data name="LRAProtect">
							<xsl:attribute name="display"><xsl:value-of select="$strThermalProtectShutdown"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:call-template name="cond2txt">
								<xsl:with-param name="condition"><xsl:value-of select="lpcCondition"/></xsl:with-param>
							</xsl:call-template></xsl:attribute>
						</Data>
					</ListData>
				</DataArea>
			</xsl:when>
			<xsl:otherwise>
				<DataArea exportdata="false">
					<xsl:if test="(/OMA/OMAUserRights = '7')">
						<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.hip.webplugins.SetLRAProtectWebPlugin</xsl:attribute>
					</xsl:if>
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strThermalShutdown1"/></xsl:attribute>
					</PageTitle>
					<CustomButton>
						<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
							<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.LRAProtectWebPlugin</xsl:attribute>
						</Data>
					</CustomButton>
					<TableData>
						<Header>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strThermalProtectShutdown1"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strThermalProtectShutdown1"/></xsl:attribute>
							</Data>
						</Header>
						<xsl:choose>
							<xsl:when test="(/OMA/OMAUserRights = '7')">
								<Row>
									<Data name="condition" type="radio">
										<xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute>
										<xsl:attribute name="returnvalue">0</xsl:attribute>
										<xsl:if test="lpcCondition='0'">
											<xsl:attribute name="state">1</xsl:attribute>
										</xsl:if>
									</Data>
								</Row>
								<Row>
									<Data name="condition" type="radio">
										<xsl:attribute name="value"><xsl:value-of select="$strWarning"/></xsl:attribute>
										<xsl:attribute name="returnvalue">1</xsl:attribute>
										<xsl:if test="lpcCondition='1'">
											<xsl:attribute name="state">1</xsl:attribute>
										</xsl:if>
									</Data>
								</Row>
								<Row>
									<Data name="condition" type="radio">
										<xsl:attribute name="value"><xsl:value-of select="$strFailure"/></xsl:attribute>
										<xsl:attribute name="returnvalue">2</xsl:attribute>
										<xsl:if test="lpcCondition='2'">
											<xsl:attribute name="state">1</xsl:attribute>
										</xsl:if>
									</Data>
								</Row>
							</xsl:when>
							<xsl:otherwise>
								<Row>
									<Data name="condition" type="radio">
										<xsl:attribute name="value"><xsl:value-of select="$strDisabled1"/></xsl:attribute>
										<xsl:choose>
											<xsl:when test="lpcCondition='0'"><xsl:attribute name="state">3</xsl:attribute></xsl:when>
											<xsl:otherwise><xsl:attribute name="state">2</xsl:attribute></xsl:otherwise>
										</xsl:choose>
									</Data>
								</Row>
								<Row>
									<Data name="condition" type="radio">
										<xsl:attribute name="value"><xsl:value-of select="$strWarning1"/></xsl:attribute>
										<xsl:choose>
											<xsl:when test="lpcCondition='1'"><xsl:attribute name="state">3</xsl:attribute></xsl:when>
											<xsl:otherwise><xsl:attribute name="state">2</xsl:attribute></xsl:otherwise>
										</xsl:choose>
									</Data>
								</Row>
								<Row>
									<Data name="condition" type="radio">
										<xsl:attribute name="value"><xsl:value-of select="$strFailure1"/></xsl:attribute>
										<xsl:choose>
											<xsl:when test="lpcCondition='2'"><xsl:attribute name="state">3</xsl:attribute></xsl:when>
											<xsl:otherwise><xsl:attribute name="state">2</xsl:attribute></xsl:otherwise>
										</xsl:choose>
									</Data>
								</Row>
							</xsl:otherwise>
						</xsl:choose>
					</TableData>
					<HiddenTable>
						<Data name="oid" type="hidden">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@oid"/></xsl:attribute>
						</Data>
					</HiddenTable>
				</DataArea>
			</xsl:otherwise>
		</xsl:choose>
		</xsl:if>
	</xsl:template>
	<xsl:template name="cond2txt">
		<xsl:param name="condition"/>
		<xsl:choose>
			<xsl:when test="$condition='0'"><xsl:value-of select="$strDisabled2"/></xsl:when>
			<xsl:when test="$condition='1'"><xsl:value-of select="$strWarning2"/></xsl:when>
			<xsl:when test="$condition='2'"><xsl:value-of select="$strFailure2"/></xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'"><xsl:value-of select="$strErrorCommandUnsuccessful"/></xsl:when>
			<xsl:when test="$status = '0'"><xsl:value-of select="$strErrorCommandSuccessful"/></xsl:when>
			<xsl:when test="$status = '1'"><xsl:value-of select="$strErrorCommandNot"/></xsl:when>
			<xsl:when test="$status = '2'"><xsl:value-of select="$strErrorBadCommand"/></xsl:when>
			<xsl:when test="$status = '3'"><xsl:value-of select="$strErrorCommandTimeout"/></xsl:when>
			<xsl:when test="$status = '4'"><xsl:value-of select="$strErrorCommandCancelled"/></xsl:when>
			<xsl:when test="$status = '5'"><xsl:value-of select="$strErrorCommandAborted"/></xsl:when>
			<xsl:when test="$status = '6'"><xsl:value-of select="$strErrorCommandPending"/></xsl:when>
			<xsl:when test="$status = '7'"><xsl:value-of select="$strErrorNoSuch"/></xsl:when>
			<xsl:when test="$status = '8'"><xsl:value-of select="$strErrorDeviceBusy"/></xsl:when>
			<xsl:when test="$status = '9'"><xsl:value-of select="$strErrorBadDevice"/></xsl:when>
			<xsl:when test="$status = '10'"><xsl:value-of select="$strErrorSpuriousInterrupt"/></xsl:when>
			<xsl:when test="$status = '11'"><xsl:value-of select="$strErrorResourceLocked"/></xsl:when>
			<xsl:when test="$status = '12'"><xsl:value-of select="$strErrorInvalidIndex"/></xsl:when>
			<xsl:when test="$status = '13'"><xsl:value-of select="$strErrorSMBError"/></xsl:when>
			<xsl:when test="$status = '14'"><xsl:value-of select="$strErrorDataRequested"/></xsl:when>
			<xsl:when test="$status = '15'"><xsl:value-of select="$strErrorDataRequested1"/></xsl:when>
			<xsl:when test="$status = '16'"><xsl:value-of select="$strErrorDataRequested2"/></xsl:when>
			<xsl:when test="$status = '17'"><xsl:value-of select="$strErrorDeviceNot"/></xsl:when>
			<xsl:when test="$status = '18'"><xsl:value-of select="$strErrorDeviceDoes"/></xsl:when>
			<xsl:when test="$status = '19'"><xsl:value-of select="$strErrorDeviceOut"/></xsl:when>
			<xsl:when test="$status = '20'"><xsl:value-of select="$strErrorDeviceAlready"/></xsl:when>
			<xsl:when test="$status = '256'"><xsl:value-of select="$strErrorThermalProtect"/></xsl:when>
			<xsl:when test="$status = '257'"><xsl:value-of select="$strErrorThermalProtect1"/></xsl:when>
			<xsl:when test="$status = '258'"><xsl:value-of select="$strErrorThermalProtect2"/></xsl:when>
			<xsl:when test="$status = '260'"><xsl:value-of select="$strErrorINIFile"/></xsl:when>
			<xsl:when test="$status = '261'"><xsl:value-of select="$strErrorINIMalformed"/></xsl:when>
			<xsl:when test="$status = '262'"><xsl:value-of select="$strErrorINISection"/></xsl:when>
			<xsl:when test="$status = '263'"><xsl:value-of select="$strErrorINIKey"/></xsl:when>
			<xsl:when test="$status = '264'"><xsl:value-of select="$strErrorINIValue"/></xsl:when>
			<xsl:when test="$status = '270'"><xsl:value-of select="$strErrorInsufficientAccess"/></xsl:when>
			<xsl:when test="$status = '271'"><xsl:value-of select="$strErrorInvalidParameter"/></xsl:when>
			<xsl:when test="$status = '272'"><xsl:value-of select="$strErrorOutOf"/></xsl:when>
			<xsl:when test="$status = '280'"><xsl:value-of select="$strErrorXMLFile"/></xsl:when>
			<xsl:when test="$status = '281'"><xsl:value-of select="$strErrorXMLMalformed"/></xsl:when>
			<xsl:when test="$status = '282'"><xsl:value-of select="$strErrorXMLNode"/></xsl:when>
			<xsl:when test="$status = '283'"><xsl:value-of select="$strErrorXMLValue"/></xsl:when>
			<xsl:otherwise>SMStatus: <xsl:value-of select="$status"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
