<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/OMA">
		<xsl:choose>
			<xsl:when test="SMStatus='0'">
				<xsl:choose>
					<xsl:when test="@cli = 'true'">
						<DataArea>
							<xsl:apply-templates select="ChassisProps2"/>
						</DataArea>
					</xsl:when>
					<xsl:otherwise>
						<DataArea  exportdata="false">
							<xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
								<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.hip.webplugins.SetFanControlWebPlugin&amp;oid=<xsl:value-of select="/OMA/ChassisProps2/@oid"/>&amp;poid=2</xsl:attribute>
							</xsl:if>
							<PageTitle>
								<xsl:attribute name="display"><xsl:value-of select="$strFanControl"/></xsl:attribute>
							</PageTitle>
							<CustomButton>
								<Data>
									<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
									<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.FanControlWebPlugin&amp;poid=2&amp;help=FanControl</xsl:attribute>
								</Data>
							</CustomButton>
							<xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
								<PromptText><xsl:value-of select="$strSelectTheType"/></PromptText>
							</xsl:if>
							<xsl:apply-templates select="ChassisProps2"/>
						</DataArea>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<DataArea  exportdata="false">
					<PageTitle>
						<xsl:attribute name="display">
							<xsl:call-template name="smstatus">
								<xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param>
							</xsl:call-template>
						</xsl:attribute>
					</PageTitle>
				</DataArea>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="ChassisProps2">
		<xsl:apply-templates select="FanControl"/>
	</xsl:template>
	<xsl:template match="FanControl">
		<xsl:choose>
			<xsl:when test="/OMA/@cli = 'true'">
				<xsl:choose>
					<xsl:when test=".='0'">
						<PageTitle><xsl:attribute name="display"><xsl:value-of select="$strErrorFanControl"/></xsl:attribute></PageTitle>
					</xsl:when>
					<xsl:otherwise>
						<PageTitle>
							<xsl:attribute name="display"><xsl:value-of select="$strFanControl1"/></xsl:attribute>
						</PageTitle>
						<ListData>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strCoolingLevel"/></xsl:attribute>
								<xsl:if test=".='1'">
									<xsl:attribute name="value"><xsl:value-of select="$strQuietMode"/></xsl:attribute>
								</xsl:if>
								<xsl:if test=".='2'">
									<xsl:attribute name="value"><xsl:value-of select="$strMaxCoolingMode"/></xsl:attribute>
								</xsl:if>
							</Data>
						</ListData>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test=".='0'">
						<ListData type="custom">
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strFanControl2"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
							</Data>
						</ListData>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
								<TableData>
									<Header>
									<Data>
										<xsl:attribute name="display"><xsl:value-of select="$strCoolingLevel1"/></xsl:attribute>
										<xsl:attribute name="value"><xsl:value-of select="$strCoolingLevel1"/></xsl:attribute>
									</Data>
									</Header>
									<Row>
										<Data name="FanControl" type="radio" returnvalue="1">
											<xsl:attribute name="value"><xsl:value-of select="$strQuietMode1"/></xsl:attribute>
											<xsl:if test=".='1'">
												<xsl:attribute name="state">1</xsl:attribute>
											</xsl:if>
										</Data>
									</Row>
									<Row>
										<Data name="FanControl" type="radio" returnvalue="2">
											<xsl:attribute name="value"><xsl:value-of select="$strMaxCoolingMode1"/></xsl:attribute>
											<xsl:if test=".='2'">
												<xsl:attribute name="state">1</xsl:attribute>
											</xsl:if>
										</Data>
									</Row>
								</TableData>
							</xsl:when>
							<xsl:otherwise>
								<ListData type="custom">
									<Data width="250">
										<xsl:attribute name="display"><xsl:value-of select="$strCoolingLevel2"/></xsl:attribute>
										<xsl:if test=".='1'">
											<xsl:attribute name="value"><xsl:value-of select="$strQuietMode2"/></xsl:attribute>
										</xsl:if>
										<xsl:if test=".='2'">
											<xsl:attribute name="value"><xsl:value-of select="$strMaxCoolingMode2"/></xsl:attribute>
										</xsl:if>
									</Data>
								</ListData>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'"><xsl:value-of select="$strErrorCommandUnsuccessful"/></xsl:when>
			<xsl:when test="$status = '0'"><xsl:value-of select="$strErrorCommandSuccessful"/></xsl:when>
			<xsl:when test="$status = '1'"><xsl:value-of select="$strErrorCommandNot"/></xsl:when>
			<xsl:when test="$status = '2'"><xsl:value-of select="$strErrorBadCommand"/></xsl:when>
			<xsl:when test="$status = '3'"><xsl:value-of select="$strErrorCommandTimeout"/></xsl:when>
			<xsl:when test="$status = '4'"><xsl:value-of select="$strErrorCommandCancelled"/></xsl:when>
			<xsl:when test="$status = '5'"><xsl:value-of select="$strErrorCommandAborted"/></xsl:when>
			<xsl:when test="$status = '6'"><xsl:value-of select="$strErrorCommandPending"/></xsl:when>
			<xsl:when test="$status = '7'"><xsl:value-of select="$strErrorNoSuch"/></xsl:when>
			<xsl:when test="$status = '8'"><xsl:value-of select="$strErrorDeviceBusy"/></xsl:when>
			<xsl:when test="$status = '9'"><xsl:value-of select="$strErrorBadDevice"/></xsl:when>
			<xsl:when test="$status = '10'"><xsl:value-of select="$strErrorSpuriousInterrupt"/></xsl:when>
			<xsl:when test="$status = '11'"><xsl:value-of select="$strErrorResourceLocked"/></xsl:when>
			<xsl:when test="$status = '12'"><xsl:value-of select="$strErrorInvalidIndex"/></xsl:when>
			<xsl:when test="$status = '13'"><xsl:value-of select="$strErrorSMBError"/></xsl:when>
			<xsl:when test="$status = '14'"><xsl:value-of select="$strErrorDataRequested"/></xsl:when>
			<xsl:when test="$status = '15'"><xsl:value-of select="$strErrorDataRequested1"/></xsl:when>
			<xsl:when test="$status = '16'"><xsl:value-of select="$strErrorDataRequested2"/></xsl:when>
			<xsl:when test="$status = '17'"><xsl:value-of select="$strErrorDeviceNot"/></xsl:when>
			<xsl:when test="$status = '18'"><xsl:value-of select="$strErrorDeviceDoes"/></xsl:when>
			<xsl:when test="$status = '19'"><xsl:value-of select="$strErrorDeviceOut"/></xsl:when>
			<xsl:when test="$status = '20'"><xsl:value-of select="$strErrorDeviceAlready"/></xsl:when>
			<xsl:when test="$status = '256'"><xsl:value-of select="$strErrorNoFan"/></xsl:when>
			<xsl:when test="$status = '257'"><xsl:value-of select="$strErrorFanControl1"/></xsl:when>
			<xsl:when test="$status = '258'"><xsl:value-of select="$strErrorFanControl2"/></xsl:when>
			<xsl:when test="$status = '260'"><xsl:value-of select="$strErrorINIFile"/></xsl:when>
			<xsl:when test="$status = '261'"><xsl:value-of select="$strErrorINIMalformed"/></xsl:when>
			<xsl:when test="$status = '262'"><xsl:value-of select="$strErrorINISection"/></xsl:when>
			<xsl:when test="$status = '263'"><xsl:value-of select="$strErrorINIKey"/></xsl:when>
			<xsl:when test="$status = '264'"><xsl:value-of select="$strErrorINIValue"/></xsl:when>
			<xsl:when test="$status = '270'"><xsl:value-of select="$strErrorInsufficientAccess"/></xsl:when>
			<xsl:when test="$status = '271'"><xsl:value-of select="$strErrorInvalidParameter"/></xsl:when>
			<xsl:when test="$status = '272'"><xsl:value-of select="$strErrorOutOf"/></xsl:when>
			<xsl:when test="$status = '280'"><xsl:value-of select="$strErrorXMLFile"/></xsl:when>
			<xsl:when test="$status = '281'"><xsl:value-of select="$strErrorXMLMalformed"/></xsl:when>
			<xsl:when test="$status = '282'"><xsl:value-of select="$strErrorXMLNode"/></xsl:when>
			<xsl:when test="$status = '283'"><xsl:value-of select="$strErrorXMLValue"/></xsl:when>
			<xsl:otherwise>SMStatus: <xsl:value-of select="$status"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
