<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA/OMAUserRights"/>	
	
	<xsl:template match="OMA">	
		<xsl:variable name="IsLocalRacadmDisabled">
		  	<xsl:choose>
			      <xsl:when test="/OMA/EMPObj/localCommandDisableStatus= '1' or /OMA/EMPObj/localCommandDisableStatus= '3'">true</xsl:when>
			      <xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

	<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>
		<DataArea validate="false" onLoad="true">
			<!--xsl:if test="$usrights='7'"-->
			<xsl:if test="(($usrights='7')and ($IsLocalRacadmDisabled!='true'))">
					<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.hip.webplugins.SetBmcSolWebPlugin</xsl:attribute>
			</xsl:if>

			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strSerialOverLAN"/></xsl:attribute>
			</PageTitle>

			<xsl:if test="$IsLocalRacadmDisabled = 'true'">
				<PromptText><xsl:value-of select="$strInbandMessage"/></PromptText>
			</xsl:if>

			<xsl:if test="EMPObj/defaultRestoreStatus = '0'">
				<xsl:if test="EMPObj/defaultRestoreSupport = '1'">
				<PromptText><xsl:value-of select="$HIPLSTR_strResetToDefault"/></PromptText>
				</xsl:if>
			</xsl:if>

			<CustomButton>
				<Data name=""><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.BMCSOLWebPlugin&amp;help=RemoteAccessSol</xsl:attribute>
				</Data>
			</CustomButton>
				<CustomButton>				
					<Data name="advanced"><xsl:attribute name="display"><xsl:value-of select="$strAdvancedSettings"/></xsl:attribute>
						<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.BMCSOLAdvWebPlugin&amp;help=RemoteAccessSolAd</xsl:attribute>
					</Data>
				</CustomButton>

	<TableData  columnspacing="true" name="tabSOLConfiguration"><xsl:attribute name="display"><xsl:value-of select="$strSerialOverLAN"/></xsl:attribute>
		<SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strSerialOverLAN"/></xsl:attribute>
		</SubHeader>
		<Header>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strAttribute"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strAttribute"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strValue"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strValue"/></xsl:attribute>
			</Data>
		</Header>


		<Row>
			<Data type="ustring" editable="false" width="250">
				<xsl:attribute name="value"><xsl:value-of select="$strEnableSOL"/></xsl:attribute>
			</Data>
			<Data name="EnableSOL" type="checkbox" editable="true" align="left">
				<xsl:if test="EMPSOLConfigObj/SOLEnable='1'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
		</Row>

		<Row>
			<Data type="ustring" editable="false" width="200">
				<xsl:attribute name="value"><xsl:value-of select="$strBitRateVolatile"/></xsl:attribute>
			</Data>
			<Data name="BitRateVolatile" type="select" editable="true">
				<xsl:variable name="selectedBitrate" select="EMPSOLConfigObj/SOLBitRateVolatile"/>
				<xsl:variable name="bitrateCapNode" select="EMPSOLConfigObj/bitRateCapabilities"/>
				<xsl:if test="$bitrateCapNode/bitrate_9600 = 'true'">
					<Choice returnvalue="6" value="{$str9600bps}">
						<xsl:if test="$selectedBitrate = 6"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
					</Choice>
				</xsl:if>
				<xsl:if test="$bitrateCapNode/bitrate_19200 = 'true'">
					<Choice returnvalue="7" value="{$str19200bps}">
						<xsl:if test="$selectedBitrate = 7"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
					</Choice>
				</xsl:if>
				<xsl:if test="$bitrateCapNode/bitrate_38400 = 'true'">
					<Choice returnvalue="8" value="{$str38400bps}">
						<xsl:if test="$selectedBitrate = 8"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
					</Choice>
				</xsl:if>
				<xsl:if test="$bitrateCapNode/bitrate_57600 = 'true'">
					<Choice returnvalue="9" value="{$str57600bps}">
						<xsl:if test="$selectedBitrate = 9"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
					</Choice>
				</xsl:if>
				<xsl:if test="$bitrateCapNode/bitrate_115200 = 'true'">
					<Choice returnvalue="10" value="{$str115200kbps}">
						<xsl:if test="$selectedBitrate = 10"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
					</Choice>
				</xsl:if>
			</Data>
		</Row>

			<Row>
			<Data type="ustring" editable="false" width="200">
				<xsl:attribute name="value"><xsl:value-of select="$strMaximumUserPrivilege"/></xsl:attribute>
			</Data>
			<Data name="MaxUserPriv" type="select" editable="true">
				<Choice returnvalue="4">
					<xsl:attribute name="value"><xsl:value-of select="$strAdministrator"/></xsl:attribute>
					<xsl:if test="EMPSOLConfigObj/SOLAuthenPrivilegeLevel='4'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="3">
					<xsl:attribute name="value"><xsl:value-of select="$strOperator"/></xsl:attribute>
					<xsl:if test="EMPSOLConfigObj/SOLAuthenPrivilegeLevel='3'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>

				<Choice returnvalue="2">
					<xsl:attribute name="value"><xsl:value-of select="$strUser"/></xsl:attribute>
					<xsl:if test="EMPSOLConfigObj/SOLAuthenPrivilegeLevel='2'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</Data>
		</Row>


	</TableData>	

		<script language="javascript">
			var usrights = '<xsl:value-of select="/OMA/OMAUserRights"/>'

				function initializationRoutine()
				{
				var LocalRacadm = '<xsl:value-of select="$IsLocalRacadmDisabled"/>';
				EnableSettingsAccordingtoUserRights()				
				if (LocalRacadm == "true")
        				DisableControls();
				}
			
				function EnableSOLSettings()
				{
				<!--
						document.getElementById("BitRateNonvolatile").disabled =(!(document.getElementById("EnableSOL").checked));
--> 
						document.getElementById("BitRateVolatile").disabled =(!(document.getElementById("EnableSOL").checked)); 
						document.getElementById("MaxUserPriv").disabled =(!(document.getElementById("EnableSOL").checked)); 
				}
				
			function DisableControls()
				{		
						document.getElementById("EnableSOL").disabled=true;
						<!--
						document.getElementById("BitRateNonvolatile").disabled =true; 
						-->
						document.getElementById("BitRateVolatile").disabled =true; 
						document.getElementById("MaxUserPriv").disabled =true; 

				}
				
				
			function EnableSettingsAccordingtoUserRights()
				{		
					if (usrights != 7 )
					{
						document.getElementById("EnableSOL").disabled=true;
						<!--
						document.getElementById("BitRateNonvolatile").disabled =true; 
						-->
						document.getElementById("BitRateVolatile").disabled =true; 
						document.getElementById("MaxUserPriv").disabled =true; 
					}
				}

		</script>
		</DataArea>
	</xsl:template>	
</xsl:stylesheet>