<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA/OMAUserRights"/>	

	<xsl:template match="OMA">	
	<xsl:variable name="IsLocalRacadmDisabled">
	  	<xsl:choose>
		      <xsl:when test="/OMA/EMPObj/localCommandDisableStatus= '1' or /OMA/EMPObj/localCommandDisableStatus= '3'">true</xsl:when>
		      <xsl:otherwise>false</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>
		<DataArea onLoad="true">
			<!--xsl:if test="$usrights='7'"-->
			<xsl:if test="(($usrights='7')and ($IsLocalRacadmDisabled!='true'))">
				<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.hip.webplugins.SetBmcSerAdvWebPlugin</xsl:attribute>
			</xsl:if>
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strSerialPortConf"/></xsl:attribute>
			<xsl:attribute name="backpagetarget">/servlet/DataArea?plugin=com.dell.hip.webplugins.BMCSerialWebPlugin&amp;help=RemoteAccessSer</xsl:attribute>


			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strSerialPortConfAdv"/></xsl:attribute>
			</PageTitle>

			<xsl:if test="$IsLocalRacadmDisabled = 'true'">
				<PromptText><xsl:value-of select="$strInbandMessage"/></PromptText>
			</xsl:if>

			<xsl:if test="EMPObj/defaultRestoreStatus = '0'">
				<xsl:if test="EMPObj/defaultRestoreSupport = '1'">
				<PromptText><xsl:value-of select="$HIPLSTR_strResetToDefault"/></PromptText>
				</xsl:if>
			</xsl:if>
			<CustomButton>
				<Data name=""><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.BMCSerialAdvWebPlugin&amp;help=RemoteAccessSerAd</xsl:attribute>
				</Data>
			</CustomButton>


	<TableData  columnspacing="true" name="tabSerialConfiguration"><xsl:attribute name="display"><xsl:value-of select="$strTerminalModeConf"/></xsl:attribute>
		<SubHeader value="User Rights">
			<xsl:attribute name="display"><xsl:value-of select="$strTerminalModeConf"/></xsl:attribute>
		</SubHeader>
						<xsl:if test="/OMA/@cli = 'true'">
				<Header>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strAttribute"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strAttribute"/></xsl:attribute>
					</Data>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strValue"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strValue"/></xsl:attribute>
					</Data>
				</Header>
				</xsl:if>
		<Row>
			<Data type="ustring" editable="false" width="200">
				<xsl:attribute name="value"><xsl:value-of select="$strLineEditing"/></xsl:attribute>
			</Data>
			<Data name="LineEditing" type="select" editable="true">
				<Choice returnvalue="1">
					<xsl:attribute name="value"><xsl:value-of select="$strEnabled"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeLineEditing='1'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="0">
					<xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeLineEditing='0'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</Data>
		</Row>
		<Row>
			<Data type="ustring" editable="false" width="200">
				<xsl:attribute name="value"><xsl:value-of select="$strDeleteControl"/></xsl:attribute>
			</Data>
			<Data name="DeleteControl" type="select" editable="true">
				<Choice returnvalue="0">
					<xsl:attribute name="value"><xsl:value-of select="$strBMCoutputsadel"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeDeleteControl='0'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="1">
					<xsl:attribute name="value"><xsl:value-of select="$strBMCoutputsabksp"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeDeleteControl='1'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</Data>
		</Row>
		

		<Row>
			<Data type="ustring" editable="false" width="200">
				<xsl:attribute name="value"><xsl:value-of select="$strEchoControl"/></xsl:attribute>
			</Data>
			<Data name="EchoControl" type="select" editable="true">
				<Choice returnvalue="1">
					<xsl:attribute name="value"><xsl:value-of select="$strEcho"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeEcho='1'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="0">
					<xsl:attribute name="value"><xsl:value-of select="$strNoEcho"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeEcho='0'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</Data>
		</Row>
		<Row>
			<Data type="ustring" editable="false" width="200">
				<xsl:attribute name="value"><xsl:value-of select="$strHandshakingControl"/></xsl:attribute>
			</Data>
			<Data name="HandshakingControl" type="select" editable="true">
				<Choice returnvalue="1">
					<xsl:attribute name="value"><xsl:value-of select="$strEnabled"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeHandshake='1'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="0">
					<xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeHandshake='0'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</Data>
		</Row>
		
		<Row>
			<Data type="ustring" editable="false" width="200">
				<xsl:attribute name="value"><xsl:value-of select="$strNewLineSequence"/></xsl:attribute>
			</Data>
			<Data name="NewLine" type="select" editable="true">
				<Choice returnvalue="0">
					<xsl:attribute name="value"><xsl:value-of select="$strNone"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeNLSeq='0'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="1">
					<xsl:attribute name="value"><xsl:value-of select="$strCRLF"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeNLSeq='1'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="2">
					<xsl:attribute name="value"><xsl:value-of select="$strNULL"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeNLSeq='2'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="3">
					<xsl:attribute name="value"><xsl:value-of select="$strCR"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeNLSeq='3'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="4">
					<xsl:attribute name="value"><xsl:value-of select="$strLFCR"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeNLSeq='4'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="5">
					<xsl:attribute name="value"><xsl:value-of select="$strLF"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeNLSeq='5'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</Data>
		</Row>

		<Row>
			<Data type="ustring" editable="false" width="200">
				<xsl:attribute name="value"><xsl:value-of select="$strInputNewLine"/></xsl:attribute>
			</Data>
			<Data name="InputNewLine" type="select" editable="true">
				<Choice returnvalue="1">
					<xsl:attribute name="value"><xsl:value-of select="$strCR"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeInputNLSeq='1'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="2">
					<xsl:attribute name="value"><xsl:value-of select="$strNULL"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeInputNLSeq='2'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>

			</Data>
		</Row>
				<script language="javascript">
			var usrights = '<xsl:value-of select="/OMA/OMAUserRights"/>'

				function initializationRoutine()
				{
					var LocalRacadm = '<xsl:value-of select="$IsLocalRacadmDisabled"/>';
					EnableSettingsAccordingtoUserRights();
					if (LocalRacadm == "true")
	        			DisableControls();
					
				}

				function DisableControls()
				{		
					document.getElementById("LineEditing").disabled  =true;
					document.getElementById("DeleteControl").disabled  =true;
					document.getElementById("EchoControl").disabled  =true;
					document.getElementById("HandshakingControl").disabled  =true;				
					document.getElementById("NewLine").disabled  =true; 
					document.getElementById("InputNewLine").disabled  =true; 

				}


				
				function EnableSettingsAccordingtoUserRights()
				{		
					if (usrights != 7 ) 
					{
						document.getElementById("LineEditing").disabled  =true;
						document.getElementById("DeleteControl").disabled  =true;
						document.getElementById("EchoControl").disabled  =true;
						document.getElementById("HandshakingControl").disabled  =true;				
						document.getElementById("NewLine").disabled  =true; 
						document.getElementById("InputNewLine").disabled  =true; 
					}
				}
				</script>
		</TableData>	
		</DataArea>
	</xsl:template>
</xsl:stylesheet>