<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA/OMAUserRights"/>
	<xsl:variable name="IsIMCPresent">
	    <xsl:choose>
	      <xsl:when test="/OMA/EMPObj/type &gt; '7'">true</xsl:when>
	      <xsl:otherwise>false</xsl:otherwise>
	    </xsl:choose>
  	</xsl:variable>

  	<xsl:variable name="IsLocalRacadmDisabled">
  	<xsl:choose>
	      <xsl:when test="/OMA/EMPObj/localCommandDisableStatus= '1' or /OMA/EMPObj/localCommandDisableStatus= '3'">true</xsl:when>
	      <xsl:otherwise>false</xsl:otherwise>
	</xsl:choose>
  	</xsl:variable>

	<xsl:template match="OMA">
	<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>
		<DataArea validate="true" onLoad="true" ipbox="true">
			<xsl:if test="(($usrights='7')and ($IsLocalRacadmDisabled!='true'))">
					<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.hip.webplugins.SetBmcNicWebPlugin</xsl:attribute>
			</xsl:if>
			<PageTitle><xsl:attribute name="display"><xsl:value-of select="$strLANConfiguration"/></xsl:attribute></PageTitle>

			<xsl:if test="$IsLocalRacadmDisabled = 'true'">
				<PromptText><xsl:value-of select="$strInbandMessage"/></PromptText>
			</xsl:if>

			<xsl:if test="EMPObj/defaultRestoreStatus = '0'">
				<xsl:if test="EMPObj/defaultRestoreSupport = '1'">
				<PromptText><xsl:value-of select="$HIPLSTR_strResetToDefault"/></PromptText>
				</xsl:if>
			</xsl:if>
			<xsl:if test="EMPLANConfigObj/IPMIMessagingAccessMode = '2'">
        <xsl:choose>
          <xsl:when test="EMPNICConfigObj/teamingModeCapabilities/NIC1TeamedNIC2='true'">
			<PromptText><xsl:value-of select="$strWarning9G"/></PromptText>
          </xsl:when>
          <xsl:otherwise>
				    <PromptText><xsl:value-of select="$strWarning"/></PromptText>
          </xsl:otherwise>
        </xsl:choose>
			</xsl:if>
			<xsl:if test="EMPLANConfigObj/IPAddrSourceMsg/StaticOnly = 'true'">
				<PromptText><xsl:value-of select="$strWarningGlacier"/></PromptText>
			</xsl:if>

			<CustomButton>
				<Data name=""><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.BMCNICWebPlugin&amp;help=RemoteAccessLan</xsl:attribute>
				</Data>
			</CustomButton>



			<TableData  columnspacing="true" name="tabNICConfiguration"><xsl:attribute name="display"><xsl:value-of select="$strNICConfiguration"/></xsl:attribute>
				<SubHeader>
					<xsl:attribute name="display"><xsl:value-of select="$strNICConfiguration"/></xsl:attribute>
				</SubHeader>
				<Header>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strAttribute"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strAttribute"/></xsl:attribute>
					</Data>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strValue"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strValue"/></xsl:attribute>
					</Data>
				</Header>

				<xsl:apply-templates select="EMPRACObj"/>
	            <xsl:apply-templates select="EMPNICConfigObj"/>
	            <xsl:apply-templates select="EMPLANConfigObj"/>
	            <xsl:apply-templates select="EMPChSecKeyListObj"/>

			</TableData>
	<xsl:if test="EMPLANConfigObj/VLANID != '-1'" >
	<TableData  columnspacing="true" name="tabVLANTag"><xsl:attribute name="display"><xsl:value-of select="$strVLANTag"/></xsl:attribute>
		<SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strVLANTag"/></xsl:attribute>
		</SubHeader>
		<Header>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strAttribute"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strAttribute"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strValue"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strValue"/></xsl:attribute>
			</Data>
		</Header>

		<Row>
			<Data type="ustring" editable="false" width="250">
				<xsl:attribute name="value"><xsl:value-of select="$strEnableVLANID"/></xsl:attribute>
			</Data>
			<Data name="VLANEnable" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPLANConfigObj/VLANIDEnable='1'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>

		</Row>
		<Row>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strVLANID"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strVLANID"/></xsl:attribute>
			</Data>
			<Data name="VLANIDString" type="editbox" editable="true">
				<xsl:attribute name="display"><xsl:value-of select="EMPLANConfigObj /VLANID"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="EMPLANConfigObj /VLANID"/></xsl:attribute>
			</Data>
		</Row>
		<Row>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strPriority"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strPriority"/></xsl:attribute>
			</Data>
			<Data name="PriorityString" type="editbox" editable="true">
				<xsl:attribute name="display"><xsl:value-of select="EMPLANConfigObj/VLANPriority"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="EMPLANConfigObj/VLANPriority"/></xsl:attribute>
			</Data>
		</Row>

	</TableData>
	</xsl:if>
      <!-- Start changes for the enable or disable the IMC gui 
      <xsl:if test="$IsIMCPresent='true'" >
        <TableData  columnspacing="true" name="tabIMCTag">
          <xsl:attribute name="display"><xsl:value-of select="$strIMCTag"/></xsl:attribute>
          <SubHeader>
            <xsl:attribute name="display"><xsl:value-of select="$strIMCTag"/></xsl:attribute>
          </SubHeader>
          <Header>
            <Data>
              <xsl:attribute name="display"><xsl:value-of select="$strAttribute"/></xsl:attribute>
              <xsl:attribute name="value"><xsl:value-of select="$strAttribute"/></xsl:attribute>
            </Data>
            <Data>
              <xsl:attribute name="display">
                <xsl:value-of select="$strValue"/>
              </xsl:attribute>
              <xsl:attribute name="value">
                <xsl:value-of select="$strValue"/>
              </xsl:attribute>
            </Data>
          </Header>

          <Row>
            <Data type="ustring" editable="false">
              <xsl:attribute name="value">
                <xsl:value-of select="$strEnableIMCGUI"/>
              </xsl:attribute>
            </Data>
            <Data name="EnableIMCGUI" type="checkbox" editable="true" align="left" >
              <xsl:if test="EMPObj/uiStatus=''">
                <xsl:attribute name="state">1</xsl:attribute>
              </xsl:if>
            </Data>
          </Row>
        </TableData>
      </xsl:if>

 end changes for the enable or disable the IMC gui -->

	    <!--TableData  columnspacing="true" name="tabUserConfiguration"><xsl:attribute name="display"><xsl:value-of select="$strUserAuthenticationType"/></xsl:attribute>
		<SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strUserAuthenticationType"/></xsl:attribute>
		</SubHeader>
		<Header>
			<Data name="" editable="" type="">
				<xsl:attribute name="display"><xsl:value-of select="$strAuthTypes"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strAuthTypes"/></xsl:attribute>
			</Data>
			<Data name="" editable="" type="">
				<xsl:attribute name="display"><xsl:value-of select="$strAdministrator"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strAdministrator"/></xsl:attribute>
			</Data>
			<Data name="" editable="" type="">
				<xsl:attribute name="display"><xsl:value-of select="$strOperator"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strOperator"/></xsl:attribute>
			</Data>
			<Data name="" editable="" type="">
				<xsl:attribute name="display"><xsl:value-of select="$strUser"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strUser"/></xsl:attribute>
			</Data>
		</Header>
			<Row>
			<Data type="ustring" editable="false" width="250">
				<xsl:attribute name="value"><xsl:value-of select="$strStraightPassword"/></xsl:attribute>
			</Data>
			<Data name="AdmAuthText" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPLANConfigObj/authenTypeEnableAdmin/Text='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
			<Data name="OpAuthText" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPLANConfigObj/authenTypeEnableOperator/Text='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
			<Data name="UserAuthText" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPLANConfigObj/authenTypeEnableUser/Text='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
		</Row>

			<Row>
			<Data type="ustring" editable="false" width="250">
				<xsl:attribute name="value"><xsl:value-of select="$strMD2"/></xsl:attribute>
			</Data>
			<Data name="AdmAuthMD2" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPLANConfigObj/authenTypeEnableAdmin/MD2='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
			<Data name="OpAuthMD2" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPLANConfigObj/authenTypeEnableOperator/MD2='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
			<Data name="UserAuthMD2" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPLANConfigObj/authenTypeEnableUser/MD2='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
		</Row>
		<Row>
			<Data type="ustring" editable="false" width="250">
				<xsl:attribute name="value"><xsl:value-of select="$strMD5"/></xsl:attribute>
			</Data>
			<Data name="AdmAuthMD5" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPLANConfigObj/authenTypeEnableAdmin/MD5='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
			<Data name="OpAuthMD5" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPLANConfigObj/authenTypeEnableOperator/MD5='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>

			<Data name="UserAuthMD5" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPLANConfigObj/authenTypeEnableUser/MD5='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>

		</Row>
	</TableData-->

			<script language="javascript">
			var usrights = '<xsl:value-of select="/OMA/OMAUserRights"/>'
      var vlansupport = '<xsl:value-of select="/OMA/EMPLANConfigObj/VLANID"/>'
        function initializationRoutine()
        {
	var LocalRacadm = '<xsl:value-of select="$IsLocalRacadmDisabled"/>';
        EnableNicDHCPSettings();
        EnableSettingsAccordingtoUserRights();
        if (LocalRacadm == "true")
        	DisableControls();

        }


        function DisableControls()
        {
        if (document.dataarea.EnableNIC != null)
        document.getElementById("EnableNIC").disabled  =true;
        document.getElementById("ipAddressSource").disabled =true;
        document.getElementById("IPAddressBox1").disabled  =true;
        document.getElementById("SubnetAddrBox1").disabled  =true;
        document.getElementById("GatewayAddrBox1").disabled  =true;

        if (document.dataarea.enableRACnic != null)
        document.dataarea.enableRACnic.disabled = true;

        if (document.dataarea.NicSelection != null)
        document.dataarea.NicSelection.disabled = true;

        if (document.dataarea.VLANEnable != null)
        document.dataarea.VLANEnable.disabled = true;

        if (document.dataarea.EnableIMCGUI != null)
        document.dataarea.EnableIMCGUI.disabled = true;

        if (document.dataarea.VLANIDString != null)
        document.dataarea.VLANIDString.disabled = true;

        if (document.dataarea.PriorityString != null)
        document.dataarea.PriorityString.disabled = true;

        if (document.dataarea.EncryptionKey != null)
	document.dataarea.EncryptionKey.disabled=true;

        document.getElementById("MaxAuth").disabled=true;
        }


        function EnableSettingsAccordingtoUserRights()
        {
        if (usrights != 7 )

        {
        document.getElementById("EnableNIC").disabled  =true;
        document.getElementById("ipAddressSource").disabled =true;
        document.getElementById("IPAddressBox1").disabled  =true;
        document.getElementById("SubnetAddrBox1").disabled  =true;
        document.getElementById("GatewayAddrBox1").disabled  =true;

        if (document.dataarea.enableRACnic != null)
        document.dataarea.enableRACnic.disabled = true;

        if (document.dataarea.NicSelection != null)
        document.dataarea.NicSelection.disabled = true;

        if (document.dataarea.VLANEnable != null)
        document.dataarea.VLANEnable.disabled = true;

        if (document.dataarea.VLANIDString != null)
        document.dataarea.VLANIDString.disabled = true;

        if (document.dataarea.PriorityString != null)
        document.dataarea.PriorityString.disabled = true;

        document.getElementById("MaxAuth").disabled  =true;
        }
        }

        function tonum(obj){
        return parseInt(obj, 10);
        }


        function validate()
        {
        var invalidIP = false;
        var errorFound = false;
        var errorMsg = "";
        var validHexChar = "1234567890abcdefABCDEF";
        var encryptionKeyValue;
        var charIndex;
        if (document.dataarea.EncryptionKey != null)
        {
        encryptionKeyValue = document.dataarea.EncryptionKey.value;
        if (encryptionKeyValue == "")
        {
        if (errorMsg != "") errorMsg += "\n";
        errorMsg += "<xsl:value-of select="$ErrorBlankEncryptionKey"/>";
        errorFound = true;
        }
        else if ((encryptionKeyValue.length % 2) == 1)
        {
        if (errorMsg != "")
        {
        errorMsg += "\n";
        }
        errorMsg += "<xsl:value-of select="$ErrorOddEncryptionKey"/>";
        errorFound = true;
        }
        else
        {
        for (charIndex = 0; charIndex &lt; encryptionKeyValue.length; charIndex++)
        {
        if (validHexChar.indexOf(encryptionKeyValue.charAt(charIndex))== -1)
        {
        if (errorMsg != "")
        {
        errorMsg += "\n";
        }
        errorMsg += "<xsl:value-of select="$ErrorInvalidEncryptionKey"/>";
        errorFound = true;
        break;
        }
        }
        }
        if (errorFound == true)
        {
        alert (errorMsg);
        return false;
        }
        }
        if (vlansupport != -1)
        {
        var priority = document.getElementById("PriorityString").value;
        var lastval = <xsl:value-of select="/OMA/EMPLANConfigObj/VLANPriority"/>;
						var minval = 0;
						var maxval = 7;

						var vlanid = document.getElementById("VLANIDString").value;
						var lastvalid = <xsl:value-of select="EMPLANConfigObj/VLANID"/>;
						var minvalid = 1;
						var maxvalid = 4094;


						if(priority.indexOf(".") != -1)
						{
							alert("<xsl:value-of select="$strErrorPriority"/>");
							document.getElementById("PriorityString").value = lastval;
							document.getElementById("PriorityString").focus();
							return false;
						}
						if (document.getElementById("PriorityString").value== "" ){
							alert("<xsl:value-of select="$strPleaseSpecifyPriority"/>");
							document.getElementById("PriorityString").value = lastval;
							document.getElementById("PriorityString").focus();
							return false;
						}
						else{
							if(isNaN(priority) == true){
									alert("<xsl:value-of select="$strPriorityNumber"/>");
									document.getElementById("PriorityString").value = lastval;
									document.getElementById("PriorityString").focus();
									return false;
							}
							else if(!((tonum(priority) &gt;= minval)&amp;&amp;(tonum(priority) &lt;= maxval))){
									alert(<xsl:value-of select="$strPriorityRange"/>);
									document.getElementById("PriorityString").value = lastval;
									document.getElementById("PriorityString").focus();
									return false;
							}
						}

						if(vlanid .indexOf(".") != -1)
						{
							alert("<xsl:value-of select="$strErrorVlanID"/>");
							document.getElementById("VLANIDString").value = lastvalid;
							document.getElementById("VLANIDString").focus();
							return false;
						}
						if (document.getElementById("VLANIDString").value== "" ){
							alert("<xsl:value-of select="$strPleaseSpecifyVlanID"/>");
							document.getElementById("VLANIDString").value = lastvalid;
							document.getElementById("VLANIDString").focus();
								return false;
						}
						else{
							if(isNaN(vlanid) == true){
								alert("<xsl:value-of select="$strVlanIDNumber"/>");
									document.getElementById("VLANIDString").value = lastvalid;
									document.getElementById("VLANIDString").focus();
									return false;
							}
							else if(!((tonum(vlanid) &gt;= minvalid)&amp;&amp;(tonum(vlanid) &lt;= maxvalid))){
									alert(<xsl:value-of select="$strVlanIDRange"/>);
        document.getElementById("VLANIDString").value = lastvalid;
        document.getElementById("VLANIDString").focus();
        return false;
        }
        }

        }
        var tmpIPAddressBox1 = document.getElementById("IPAddressBox1").value;
        document.getElementById("IPAddressBox1").value = trim(tmpIPAddressBox1);
        var IPAddressBox1 = document.getElementById("IPAddressBox1").value;

        var tmpSubnetAddrBox1 = document.getElementById("SubnetAddrBox1").value;
        document.getElementById("SubnetAddrBox1").value = trim(tmpSubnetAddrBox1);
        var SubnetAddrBox1 = document.getElementById("SubnetAddrBox1").value;

        var tmpGatewayAddrBox1 = document.getElementById("GatewayAddrBox1").value;
        document.getElementById("GatewayAddrBox1").value = trim(tmpGatewayAddrBox1);
        var GatewayAddrBox1 = document.getElementById("GatewayAddrBox1").value;

        if(Valid_IPV4("IPAddressBox1",0,223) != true)
        {
        errorMsg += <xsl:value-of select="$strInvalidStaticIP"/>
        invalidIP = true;
        }
        if(Valid_IPV4_Subnet("SubnetAddrBox1",0,255) != true)
        {
        errorMsg += <xsl:value-of select="$strInvalidStaticSubnet"/>
        invalidIP = true;
        }

        if(Valid_IPV4("GatewayAddrBox1",0,223) != true)
        {
        errorMsg += <xsl:value-of select="$strInvalidStaticGateway"/>
						invalidIP = true;
					}
					if (invalidIP == true)
					{
						alert(errorMsg)
						return false;
					}
					else
					{
						return true;
					}
				}

				function trimIPAddress(ipboxname , length)
				{
					for (i =1 ; i &lt;= length ; i++) {
						var ipbox = ipboxname + i;
						try
						{
							var ipboxval = document.getElementById(ipbox).value;
							document.getElementById(ipbox).value = trim(ipboxval);
						}
						catch(e){};
					}
				}

				function ltrim ( s )
				{
					return s.replace( /^\s*/, "" )
				}

				function rtrim ( s )
				{
					return s.replace( /\s*$/, "" );
				}

				//Combine the rtrim() and ltrim() functions to make the trim() function, which just wraps both calls together:

				function trim ( s )
				{
					return rtrim(ltrim(s));
				}

				function EnableNicSettings()
				{
						document.getElementById("ipAddressSource").disabled =(!(document.getElementById("EnableNIC").checked));

						document.getElementById("IPAddressBox1").disabled  =(!(document.getElementById("EnableNIC").checked));

						document.getElementById("SubnetAddrBox1").disabled  =(!(document.getElementById("EnableNIC").checked));

						try {
							document.getElementById("VLANEnable").disabled  =(!(document.getElementById("EnableNIC").checked));
						}
						catch(e){};
						document.getElementById("MaxAuth").disabled  =(!(document.getElementById("EnableNIC").checked));
						<!--
						document.getElementById("AdmAuthMD2").disabled  =(!(document.getElementById("EnableNIC").checked));
						document.getElementById("AdmAuthMD5").disabled  =(!(document.getElementById("EnableNIC").checked));
						document.getElementById("OpAuthMD2").disabled  =(!(document.getElementById("EnableNIC").checked));
						document.getElementById("OpAuthMD5").disabled  =(!(document.getElementById("EnableNIC").checked));
						document.getElementById("UserAuthMD2").disabled  =(!(document.getElementById("EnableNIC").checked));
						document.getElementById("UserAuthMD5").disabled  =(!(document.getElementById("EnableNIC").checked));
						-->
        EnableNicDHCPSettings();
        try {
        EnableVLAN()
        }
        catch(e){};

        }
        function EnableVLAN()
        {
        document.getElementById("VLANIDString").disabled  =(!(document.getElementById("VLANEnable").checked) || !(document.getElementById("EnableNIC").checked));
        document.getElementById("PriorityString").disabled  =(!(document.getElementById("VLANEnable").checked) || !(document.getElementById("EnableNIC").checked));

        }

        function EnableNicDHCPSettings()
        {

        document.getElementById("IPAddressBox1").disabled  =!(document.getElementById("ipAddressSource").value == "1");
        document.getElementById("SubnetAddrBox1").disabled  =!(document.getElementById("ipAddressSource").value =="1");
        document.getElementById("GatewayAddrBox1").disabled  =!(document.getElementById("ipAddressSource").value =="1");

        }

        function Compare_Strings(str1, str2)
        {
        ret_val = true;
        if(str1.length != str2.length)
        return false;

        for (var i = 0; i &lt;= str1.length; i++)
				    {
				        curChar1 = str1.charCodeAt(i);
				        curChar2 = str2.charCodeAt(i);
				        if ( curChar1 == curChar2)
				        {
				            continue;
				        }
					  else
				        {
				            ret_val = false;
				            break;
				        }
				    }

				    return ret_val;
				}

				function Valid_Number(value, exact, min, max)
				{
				    var nASCII_0 = 48;
				    var nASCII_9 = 57;

				    if (exact != -1 &amp;&amp; value != exact)
				    	  return false;
				    else if (exact != -1 &amp;&amp; value == exact)
					  return true;

				    if (value == null || value == "")
				        return false;
				    var str = new String(value);
				    for (var i = 0; i &lt; str.length; i++)
				    {
				        if (str.charCodeAt(i) &lt; nASCII_0 || str.charCodeAt(i) &gt; nASCII_9)
			            return false;
				    }

				    if (Math.floor(str) &lt; Math.floor(min) || Math.floor(str) &gt; Math.floor(max))
				       return false;
				    else
				        return true;
				}

				function Valid_IPV4(objstr,min,max)
				{
				    var nASCII_0 = 48;
				    var nASCII_9 = 57;
				    var nASCII_dot = 46;
				    var curNumber = "";
				    var iCount = 0;
				    var jCount = 0;
				    var limitedMask = 255;
                                    var str = document.getElementById(objstr).value;
                                    var tempstr = eval("document.dataarea." + objstr);
                                    if (tempstr.disabled == true)
                                        return true;
				    if(str.length == 0 || str == "")
				        return false;

				    if (Compare_Strings(str, '0.0.0.0'))
				        return false;

				    if (Compare_Strings(str, '255.255.255.255'))
				       return false;

				    for (var i = 0; i &lt; str.length; i++)
				    {
				        curChar = str.charCodeAt(i);
				        curNum = str.charAt(i);
				        if (curChar == nASCII_dot)
				        {

				            iCount++;
				            jCount = 0;

				            if (iCount == 1)
						{
						    if (curNumber &lt; 1 || curNumber == 127)
						        return false;
				                ret_code = Valid_Number(curNumber,-1,min,max);
						}
				            else
					           ret_code = Valid_Number(curNumber,-1,min,limitedMask);

					       if (ret_code != 1)
					           return false;

					       curNumber = "";
					       continue;
					   }
					   else if (curChar &gt;= nASCII_0 &amp;&amp; curChar &lt;= nASCII_9 &amp;&amp; jCount &lt;= 3)
				        {
				            jCount++;
				            curNumber += curNum;
				        }
				        else
				        {
				            return false;
				        }
    				    }

				    ret_code = Valid_Number(curNumber,-1,min,limitedMask);
				    if (ret_code != 1)
				        return false;

				    if (iCount != 3)
				        return false;

				    return true;
				}
				function Valid_SubnetOctet(value)
				{
				    if ((value == 0) || (value == 128) || (value == 192)
				       || (value == 224) || (value == 240) || (value==248) || (value ==252)
				       || (value == 254))
			        	  return true;
				    else
				        return false;
				}
				function Valid_IPV4_Subnet(objstr,min,max)
				{
				    var nASCII_0 = 48;
				    var nASCII_9 = 57;
				    var nASCII_dot = 46;
				    var curNumber = "";
				    var iCount = 0;
				    var jCount = 0;
				    var limitedMask = 255;
				    var octet0 = 0;
				    var octet1 = 0;
				    var octet2 = 0;
				    var octet3 = 0;
                                    var str = document.getElementById(objstr).value;

                                    var tempstr = eval("document.dataarea." + objstr);
                                    if (tempstr.disabled == true)
                                        return true;

				    if(str.length == 0 || str == "")
				        return false;

				    if (Compare_Strings(str, '0.0.0.0'))
				        return false;

				    if (Compare_Strings(str, '255.255.255.255'))
				       return false;

				    for (var i = 0; i &lt; str.length; i++)
				    {
				        curChar = str.charCodeAt(i);
				        curNum = str.charAt(i);
				        if (curChar == nASCII_dot)
				        {

				            iCount++;
				            jCount = 0;

				            ret_code = Valid_Number(curNumber,-1,min,limitedMask);
				            if (ret_code != 1)
				                return false;

				            if (iCount == 1)
				                octet0 = curNumber;
				            else if (iCount == 2)
				                octet1 = curNumber;
				            else if (iCount == 3)
				                octet2 = curNumber;
				            else
						return false;

				            curNumber = "";
				            continue;
        				}
				      else if (curChar &gt;= nASCII_0 &amp;&amp;  curChar &lt;= nASCII_9 &amp;&amp; jCount &lt;=3)
				      {
				            jCount++;
				            curNumber += curNum;
				      }
				      else
				      {
				            return false;
				      }

    			        }
				  octet3 = curNumber;
				  ret_code = Valid_Number(curNumber,-1,min,limitedMask);
				  if (ret_code != 1)
				        return false;

				  if (iCount != 3)
				        return false;

			        if( octet0 == 255 &amp;&amp; octet1 == 255 &amp;&amp; octet2 == 255 )
        			  {
			            if(Valid_SubnetOctet(octet3) == true)
            			{
						return true;
            			}

        			  }
				  else if( octet0 == 255 &amp;&amp;
				            octet1 == 255 )
        			  {
			            if( Valid_SubnetOctet(octet2 ) &amp;&amp;  octet3 == 0 )
            		  	{
						return true;
            			}
        			  }
			        else if( octet0 == 255 )
        			  {
			            if( Valid_SubnetOctet(octet1 ) &amp;&amp;  octet2 == 0 &amp;&amp;  octet3 == 0)
            			{
						return true;
            			}

        			  }
			        else if( Valid_SubnetOctet(octet0 ) &amp;&amp;  octet1 == 0 &amp;&amp;   octet2 == 0 &amp;&amp;
            				octet3 == 0 )
        			  {
					return true;
       			  }

				  return false;
			}

		</script>
		</DataArea>
	</xsl:template>

	<xsl:template match="EMPNICConfigObj">
		<Row>
		    <Data type="ustring" editable="false" width="200">
			    <xsl:attribute name="value"><xsl:value-of select="$strNicSelection"/></xsl:attribute>
		    </Data>

		    <Data name="NicSelection" type="select" editable="true">
		        <xsl:if test="teamingModeCapabilities/NIC1Only='true'">
			        <Choice returnvalue="1">
				        <xsl:attribute name="value"><xsl:value-of select="$strNicSelection1"/></xsl:attribute>
				        <xsl:if test="teamingModeSettings/NIC1Only='true'">
					        <xsl:attribute name="default">true</xsl:attribute>
				        </xsl:if>
			        </Choice>
			    </xsl:if>
		        <xsl:if test="teamingModeCapabilities/NIC1TeamedNIC2='true'">
			        <Choice returnvalue="3">
				        <xsl:attribute name="value"><xsl:value-of select="$strNicSelection3"/></xsl:attribute>
				        <xsl:if test="teamingModeSettings/NIC1TeamedNIC2='true'">
					        <xsl:attribute name="default">true</xsl:attribute>
				        </xsl:if>
			        </Choice>
				</xsl:if>
		        <xsl:if test="teamingModeCapabilities/Dedicated='true'">
			        <Choice returnvalue="4">
				        <xsl:attribute name="value"><xsl:value-of select="$strNicSelection4"/></xsl:attribute>
				        <xsl:if test="teamingModeSettings/Dedicated='true'">
					        <xsl:attribute name="default">true</xsl:attribute>
					    </xsl:if>
			        </Choice>
				</xsl:if>
		    </Data>
		  </Row>

    </xsl:template>

	<xsl:template match="EMPLANConfigObj">
        <Row>
            <Data>
                <xsl:attribute name="display"><xsl:value-of select="$strMACAddress"/></xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="$strMACAddress"/></xsl:attribute>
            </Data>
            <Data>
                <xsl:attribute name="display"><xsl:value-of select="MACAddress"/></xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="MACAddress"/></xsl:attribute>
            </Data>
        </Row>

		<Row>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strEnableLAN"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strEnableLAN"/></xsl:attribute>
			</Data>
			<Data name="EnableNIC" type="checkbox" editable="true" align="left">
				<xsl:if test="IPMIMessagingAccessMode ='2'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>

			</Data>
		</Row>

		<Row>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strIPAddressSource"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strIPAddressSource"/></xsl:attribute>
			</Data>
			<Data name="ipAddressSource" type="select" editable="true" event="onChange" handler="javascript:EnableNicDHCPSettings()">
				<xsl:if test="IPAddrSourceSupport/Unspecified='true'">
				<Choice returnvalue="0">
					<xsl:attribute name="display"><xsl:value-of select="$strNone"/></xsl:attribute>
 					<xsl:attribute name="value"><xsl:value-of select="$strNone"/></xsl:attribute>
					<xsl:if test="IPAddrSource=0">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				</xsl:if>
				<xsl:if test="IPAddrSourceSupport/Static='true'">
				<Choice returnvalue="1">
					<xsl:attribute name="display"><xsl:value-of select="$strStaticAddress"/></xsl:attribute>
 					<xsl:attribute name="value"><xsl:value-of select="$strStaticAddress"/></xsl:attribute>
					<xsl:if test="IPAddrSource!=2">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				</xsl:if>
				<xsl:if test="IPAddrSourceSupport/DHCP='true'">
				<Choice returnvalue="2">
					<xsl:attribute name="display"><xsl:value-of select="$strAddressobtainedby"/></xsl:attribute>
 					<xsl:attribute name="value"><xsl:value-of select="$strAddressobtainedby"/></xsl:attribute>
					<xsl:if test="IPAddrSource=2">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				</xsl:if>
				<xsl:if test="IPAddrSourceSupport/BIOS='true'">
				<Choice returnvalue="3">
					<xsl:attribute name="display"><xsl:value-of select="$strBIOS"/></xsl:attribute>
 					<xsl:attribute name="value"><xsl:value-of select="$strBIOS"/></xsl:attribute>
					<xsl:if test="IPAddrSource=3">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				</xsl:if>

			</Data>
		</Row>

		<Row>
			<xsl:call-template name="ShowIPAddrBox">
				<xsl:with-param name="Address">
					<xsl:value-of select="IPAddress"/>
				</xsl:with-param>
				<xsl:with-param name="IPCtrlName">IPAddressBox1</xsl:with-param>
				<xsl:with-param name="DisplayStr"><xsl:value-of select="$strStaticIPAddress"/></xsl:with-param>
			</xsl:call-template>
		</Row>
		<Row>
			<xsl:call-template name="ShowIPAddrBox">
				<xsl:with-param name="Address">
					<xsl:value-of select="SubnetMask"/>
				</xsl:with-param>
				<xsl:with-param name="IPCtrlName">SubnetAddrBox1</xsl:with-param>
				<xsl:with-param name="DisplayStr"><xsl:value-of select="$strStaticSubnetMask"/></xsl:with-param>
			</xsl:call-template>
		</Row>
		<Row>
			<xsl:call-template name="ShowIPAddrBox">
				<xsl:with-param name="Address">
					<xsl:value-of select="DefaultGateway"/>
				</xsl:with-param>
				<xsl:with-param name="IPCtrlName">GatewayAddrBox1</xsl:with-param>
				<xsl:with-param name="DisplayStr"><xsl:value-of select="$strStaticGatewayAddress"/></xsl:with-param>
			</xsl:call-template>
		</Row>
		<!--Row>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strCommunityString"/></xsl:attribute>
 				<xsl:attribute name="value"><xsl:value-of select="$strCommunityString"/></xsl:attribute>
			</Data>
			<Data name="CommunityString" type="editbox" editable="true">
					<xsl:attribute name="maxlength">18</xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="CommunityString"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="CommunityString"/></xsl:attribute>
			</Data>
		</Row-->
				<Row>
			<Data type="ustring" editable="false" width="200">
				<xsl:attribute name="value"><xsl:value-of select="$strMaximumUserPrivileges"/></xsl:attribute>
			</Data>
		<Data name="MaxAuth" type="select" editable="true">
				<Choice returnvalue="4">
					<xsl:attribute name="value"><xsl:value-of select="$strAdministrator"/></xsl:attribute>
					<xsl:if test="channelAccessLevel=4">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="3">
					<xsl:attribute name="value"><xsl:value-of select="$strOperator"/></xsl:attribute>
					<xsl:if test="channelAccessLevel=3">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>

				<Choice returnvalue="2">
					<xsl:attribute name="value"><xsl:value-of select="$strUser"/></xsl:attribute>
					<xsl:if test="channelAccessLevel=2">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</Data>
		</Row>
	</xsl:template>
<xsl:template match="EMPRACObj">
		<Row>
			        <Data>
				        <xsl:attribute name="display"><xsl:value-of select="$strEnableNIC"/></xsl:attribute>
				        <xsl:attribute name="value"><xsl:value-of select="$strEnableNIC"/></xsl:attribute>
			        </Data>
			<Data name="enableRACnic" type="checkbox" editable="true" align="left">
			        	<xsl:if test="nicEnable ='true'">
					        <xsl:attribute name="state">1</xsl:attribute>
			        	</xsl:if>
			        </Data>
		        </Row>
	</xsl:template>

    <xsl:template match="EMPChSecKeyListObj">
        <xsl:if test="/OMA/OMAUserRights='7'">
            <xsl:for-each select="keyListarray/keyList">
                <xsl:if test="keyID='1'">
                    <Row>
	                    <Data type="ustring" editable="false">
		                    <xsl:attribute name="value"><xsl:value-of select="$strEncryptionKey"/></xsl:attribute>
	                    </Data>
	                    <Data name="EncryptionKey" type="editbox" editable="true" size="58" maxlength="40">
		                    <xsl:attribute name="value"><xsl:value-of select="KeyValue"/></xsl:attribute>
	                    </Data>
                    </Row>
                </xsl:if>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>

	<xsl:template name="ShowIPAddrBox">
		<xsl:param name="Address"/>
		<xsl:param name="IPCtrlName"/>
		<xsl:param name="DisplayStr"/>
		<Data type="ustring" editable="false">
			<xsl:attribute name="value"><xsl:value-of select="$DisplayStr"/></xsl:attribute>
		</Data>
		<Data type="editbox" editable="true" size="12">
			<xsl:attribute name="name"><xsl:value-of select="$IPCtrlName"/></xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="$Address"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$Address"/></xsl:attribute>
		</Data>
	</xsl:template>
	<xsl:template name="chkIPValue">
		<xsl:param name="IPAddress1"/>
		<xsl:value-of select="$IPAddress1"/>
	</xsl:template>
</xsl:stylesheet>
