<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
  <xsl:variable name="IsIMCPresent">
    <xsl:choose>
      <xsl:when test="/OMA/EMPObj/type &gt; '7'">true</xsl:when>
      <xsl:otherwise>false</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
	<xsl:template match="OMA/OMAUserRights"/>	

	<xsl:variable name="userIndex"><xsl:value-of select="/OMA/index"/></xsl:variable>
	<xsl:variable name="dracUserPrivEnabled">
		<xsl:choose>
			<!-- if EMPRACObj object is present: -->
			<xsl:when test="/OMA/EMPRACObj">true</xsl:when>
			<xsl:otherwise>false</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="dracDropdownName">RacPrivilege</xsl:variable>
	<xsl:variable name="dracAdminBitmask">511</xsl:variable>
	<xsl:variable name="dracPowerUserBitmask">249</xsl:variable>
	<xsl:variable name="dracGuestBitmask">1</xsl:variable>
	<xsl:variable name="dracNoneBitmask">0</xsl:variable>
	<xsl:variable name="dracCustomBitmask">0</xsl:variable>
	<xsl:variable name="dracAdminDropdownVal">4</xsl:variable>
	<xsl:variable name="dracPowerUserDropdownVal">3</xsl:variable>
	<xsl:variable name="dracGuestDropdownVal">2</xsl:variable>
	<xsl:variable name="dracNoneDropdownVal">0</xsl:variable>
	<xsl:variable name="dracCustomDropdownVal">15</xsl:variable>

	<xsl:template match="OMA">
	<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>

	<DataArea validate="true" onLoad="true" ipbox="true" exportdata="false">
			<xsl:if test="$usrights='7' or $usrights='3'">
					<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.hip.webplugins.SetBmcUserEntryWebPlugin&amp;index=<xsl:value-of select="/OMA/index"/>&amp;help=RemoteAccessUser</xsl:attribute>
			</xsl:if>
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strUserConfiguration"/></xsl:attribute>
			<xsl:attribute name="backpagetarget">/servlet/DataArea?plugin=com.dell.hip.webplugins.BMCUserWebPlugin&amp;help=RemoteAccessUsers</xsl:attribute>

			<PageTitle><xsl:attribute name="display"><xsl:value-of select="$strBMCUserConfiguration"/></xsl:attribute></PageTitle>
			<xsl:if test="EMPObj/defaultRestoreStatus = '0'">
				<xsl:if test="EMPObj/defaultRestoreSupport = '1'">
				<PromptText><xsl:value-of select="$HIPLSTR_strResetToDefault"/></PromptText>
				</xsl:if>
			</xsl:if>
			<CustomButton>
				<Data name=""><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.BMCGetUserEntry&amp;index=<xsl:value-of select="/OMA/index"/>&amp;help=RemoteAccessUser</xsl:attribute>
				</Data>
			</CustomButton>
						
			<script language="javascript">
				var	resetMsg = "<xsl:value-of select="$Thisoperationcaused"/>";
				var	index=<xsl:value-of select="/OMA/index"/>;
				
				

				function initializationRoutine()
				{
					if ( index == 1) 
					{
					     document.getElementById("uname").disabled = true;
					}
					document.getElementById("enableChangePass").checked = false;
					enableChangePassword();
					enableUser(document.dataarea.EnableUser);
				}
				function enableChangePassword()
				{
					if (document.dataarea.enableChangePass != null)
					{
						if (document.dataarea.enableChangePass.checked == true)
						{
							document.dataarea.Password.disabled = false;
							document.dataarea.ConfirmPassword.disabled = false;
						}
						else
						{
							document.dataarea.Password.disabled = true;
							document.dataarea.ConfirmPassword.disabled = true;
						}
					}

				}
				
				
				function duplicateUserNames()
				{
				    var usersListLit  = [  <xsl:for-each select="EMPUserListObj/userListarray/userList">'<xsl:value-of select="UserName"/>',  </xsl:for-each>  0 ];

                        var userName = "";
                        userName = document.dataarea.uname.value;
                        var userList = new Array();
                         usersList = usersListLit;
					var dupMsg = "";
					var status = true;
					var numUsers = usersList.length - 1;
					var userId = 0;
                         var existingStr ="";

					if (dupMsg != "")
					{
					     dupMsg += "\n";
					}

                         for ( userId = 0; userId &lt; numUsers; userId++ )
                         {
                                if ( (userId +1) != index )
                                {
                                        existingStr =  usersListLit[ userId ] ;
 
                                        if ( ( existingStr  != null ) &amp;&amp; ( existingStr  != "" ) )
                                        {
	                                        if ( ( userName != null ) &amp;&amp; ( userName != "" ) )
	                                        {
                                                    //alert( "userId =" + userId  + "  userName=!" + userName +  "!   existingStr =!" + existingStr + "!");
	                                              if ( userName   == existingStr )
	                                               {
					                                dupMsg += "<xsl:value-of select="$strDuplicateUserName"/>" + " " +userName;
					                                dupMsg += "\n" + "<xsl:value-of select="$strDuplicateUserIndex"/>" + " " + (userId +1);
	                                                    alert ( dupMsg );	
	                                                    status = false;
	                                                    break;
	                                               }
	                                        }
                                        }
                                }
                         }
				     return (status);
				}
				
				function isAsciiText(s)
				{
				  var i;
				  for (i=0; s.length >i; i++)
				    {
				      var val=s.charCodeAt(i);
				      if (val > 127)
					      return false;
				    }
				  return true;
				}
				
				function validateUserName()
				{
					var status = true;
    					 var nullUserName = "<xsl:value-of select="$strNullUserName"/>";
                       	var userName = "";

                        userName = document.dataarea.uname.value;

				    if (document.dataarea.EnableUser.checked == true )
				    {
				          if ( ( userName == null )  || (userName == "") )
						{
						     alert( nullUserName );
						     status = false;
						}
				     }
				     
				     
				if (isAsciiText(userName)==false)
				{
					var errorUserName = "<xsl:value-of select="$strErrorUserName"/>";
					alert (errorUserName);
					status =false;
				}
				
					return (status);
                    }


			function enableUser(chkbox)
			{
				var warning = "false"; 
				warning = "<xsl:value-of select="/OMA/EMPUserListObj/userListarray/userList[userID=$userIndex]/EnableWarning"/>";
				if ( chkbox.checked )
				{		
					if ( (warning=="true") &amp;&amp; (!document.getElementById("enableChangePass").checked) )
					{
						document.getElementById("enableChangePass").checked = true;
						document.dataarea.Password.disabled = false;
						document.dataarea.ConfirmPassword.disabled = false;						
						return false;
					}
				}
				return true;
			}


			function checkNullPassword()
			{
				if (!enableUser(document.dataarea.EnableUser))
				{		
					alert ("<xsl:value-of select="$NullPwdWarn"/>");
					return false;
				}
				return true;
			} 

				function validate()
				{
					var errorMsg = "";
					var errorFound = false;

					if ( validateUserName() == false )
					{
						return false;
					}


				
					if (document.dataarea.Password.disabled == false &amp;&amp; document.dataarea.ConfirmPassword.disabled == false)
					{
						if (document.dataarea.Password.value == "")
						{
							if (errorMsg != "") errorMsg += "\n";
							errorMsg += "<xsl:value-of select="$Passwordfieldname"/>";
						 	errorFound = true;
						}
						if (document.dataarea.ConfirmPassword.value == "")
						{
							if (errorMsg != "") errorMsg += "\n";
							errorMsg += "<xsl:value-of select="$Confirmpasswordfield"/>";
						 	errorFound = true;
						}
						if (document.dataarea.ConfirmPassword.value != document.dataarea.Password.value)
						{
							if (errorMsg != "") errorMsg += "\n";
							errorMsg += "<xsl:value-of select="$Passwordsdonot"/>";
						 	errorFound = true;
						}
						if (errorFound == true)	
						{
							alert (errorMsg);					
							return false;
						}
					}

					if (checkNullPassword()==false)
					{
						return false;
					}

				
					return true;
					
				}
				
				<xsl:if test="$dracUserPrivEnabled = 'true'or $IsIMCPresent='true'">
				var DRAC_ADMIN_ROLE_BITMASK = <xsl:value-of select="$dracAdminBitmask"/>, DRAC_ADMIN_DROPDOWN_VALUE = <xsl:value-of select="$dracAdminDropdownVal"/>;
				var DRAC_POWERUSER_ROLE_BITMASK = <xsl:value-of select="$dracPowerUserBitmask"/>, DRAC_POWERUSER_DROPDOWN_VALUE = <xsl:value-of select="$dracPowerUserDropdownVal"/>;
				var DRAC_GUEST_ROLE_BITMASK = <xsl:value-of select="$dracGuestBitmask"/>, DRAC_GUEST_DROPDOWN_VALUE = <xsl:value-of select="$dracGuestDropdownVal"/>;
				var DRAC_CUSTOM_ROLE_BITMASK = <xsl:value-of select="$dracCustomBitmask"/>, DRAC_CUSTOM_DROPDOWN_VALUE = <xsl:value-of select="$dracCustomDropdownVal"/>;
				// use slightly modified version of bitmask for None, so we can tell the difference between it and custom:
				var DRAC_NONE_ROLE_BITMASK = 0x80000000, DRAC_NONE_DROPDOWN_VALUE = <xsl:value-of select="$dracNoneDropdownVal"/>;

				// make sure these are in ascending order by bitmask position:
				var arrDracCheckboxeIDs = new Array("loginDrac",				// 0x0001
												"configureDrac",				// 0x0002
												"configureDracUsers",			// 0x0004
												"clearDracLogs",				// 0x0008
												"executeDracServerControls",	// 0x0010
												"accessDracConsole",			// 0x0020
												"accessDracMedia",				// 0x0040
												"testDracAlerts",				// 0x0080
												"executeDracDiags");			// 0x0100

				function DracDropdownChanged() {
					var dropdown = document.getElementById("<xsl:value-of select="$dracDropdownName"/>");
					var value = parseInt(dropdown.options[dropdown.selectedIndex].value);
					if(value == DRAC_ADMIN_DROPDOWN_VALUE) {
						DracSetCheckboxes(DRAC_ADMIN_ROLE_BITMASK);
					} else if (value == DRAC_POWERUSER_DROPDOWN_VALUE) {
						DracSetCheckboxes(DRAC_POWERUSER_ROLE_BITMASK);
					} else if (value == DRAC_GUEST_DROPDOWN_VALUE) {
						DracSetCheckboxes(DRAC_GUEST_ROLE_BITMASK);
					} else if (value == DRAC_NONE_DROPDOWN_VALUE) {
						DracSetCheckboxes(DRAC_NONE_ROLE_BITMASK);
					} else if (value == DRAC_CUSTOM_DROPDOWN_VALUE) {
						DracSetCheckboxes(DRAC_CUSTOM_ROLE_BITMASK);
					}
				}

				function DracCheckboxChanged() {
					var chkboxesBitmask = DracGetCheckboxes();
					switch (chkboxesBitmask) {
						case DRAC_ADMIN_ROLE_BITMASK:
							DracSetDropdown(DRAC_ADMIN_DROPDOWN_VALUE);
							break;
						case DRAC_POWERUSER_ROLE_BITMASK:
							DracSetDropdown(DRAC_POWERUSER_DROPDOWN_VALUE);
							break;
						case DRAC_GUEST_ROLE_BITMASK:
							DracSetDropdown(DRAC_GUEST_DROPDOWN_VALUE);
							break;
						case DRAC_NONE_ROLE_BITMASK:
							DracSetDropdown(DRAC_NONE_DROPDOWN_VALUE);
							break;
						default:	// default to Custom
							DracSetDropdown(DRAC_CUSTOM_DROPDOWN_VALUE);
					}
				}

				function DracSetDropdown(selectValue) {
					var dropdown = document.getElementById("<xsl:value-of select="$dracDropdownName"/>");
					for (var i = 0; i &lt; dropdown.options.length; ++i) {
						if (dropdown.options[i].value == selectValue) {
							dropdown.selectedIndex = i;
							break;
						}
					}
				}

				function DracGetCheckboxes() {
					var i, bitmask = 0x00000000, bit, chkbox;
					for (i = 0; i &lt; arrDracCheckboxeIDs.length; ++i) {
						chkbox = document.getElementById(arrDracCheckboxeIDs[i]);
						if (chkbox != null) {
							bit = 1 &lt;&lt; i;
							if (chkbox.checked == true) {
								bitmask |= bit;
							}
						}
					}
					if (bitmask == 0x00000000) {
						bitmask = DRAC_NONE_ROLE_BITMASK;
					}
					return bitmask;
				}

				function DracSetCheckboxes(bitmask) {
					var i, bit, chkbox;
					for (i = 0; i &lt; arrDracCheckboxeIDs.length; ++i) {
						chkbox = document.getElementById(arrDracCheckboxeIDs[i]);
						if (chkbox != null) {
							bit = 1 &lt;&lt; i;
							if ((bitmask &amp; bit) == bit) {
								chkbox.checked = true;
							} else {
								chkbox.checked = false;
							}
						}
					}
				}
				</xsl:if>
				</script>
				<xsl:apply-templates select="EMPUserListObj"/>

			<HiddenTable>
				<!-- add hidden field to store whether or not SOL is allowed: -->
				<Data name="allowEnableSol">
					<xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/EMPUserAccessListObj/userAccessListarray/userAccessList[userID=$userIndex and channelMediumType='4']/payloadAccessCapabilities/SOL"/></xsl:attribute>
				</Data>
			</HiddenTable>
		</DataArea>
		
	</xsl:template>

	<xsl:template match="EMPUserListObj ">
		<xsl:variable name="maxUserNameLength">
			<xsl:choose>
				<xsl:when test="userListarray/userList[userID=$userIndex]/maxUserNameLength">
					<xsl:value-of select="userListarray/userList[userID=$userIndex]/maxUserNameLength"/>
				</xsl:when>
				<xsl:otherwise>16</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="maxPasswordLength">
			<xsl:choose>
				<xsl:when test="userListarray/userList[userID=$userIndex]/maxPasswordLength">
					<xsl:value-of select="userListarray/userList[userID=$userIndex]/maxPasswordLength"/>
				</xsl:when>
				<xsl:otherwise>16</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<TableData name="TableGeneralConf"><xsl:attribute name="display"><xsl:value-of select="$strGeneral"/></xsl:attribute>
			<SubHeader value="General"><xsl:attribute name="display"><xsl:value-of select="$strGeneral"/></xsl:attribute></SubHeader>
			<Header>
				<Data name="Property" value="Property" editable="false" ignoreonweb="true" type="usting"><xsl:attribute name="display"><xsl:value-of select="$strProperty"/></xsl:attribute></Data>
				<Data name="Value" value="Value" editable="false" ignoreonweb="true" type="usting"><xsl:attribute name="display"><xsl:value-of select="$strValue"/></xsl:attribute></Data>
			</Header>
			<xsl:variable name="currentstate">
				<xsl:apply-templates select="userListarray/userList">
					<xsl:with-param name="userid"><xsl:value-of select="/OMA/index"/></xsl:with-param>
					<xsl:with-param name="nameorstate">state</xsl:with-param>
				</xsl:apply-templates>
			</xsl:variable>


			<Row>
				<Data type="ustring" editable="false" width="190">
					<xsl:attribute name="value"><xsl:value-of select="$strUserID"/></xsl:attribute>
				</Data>
				<Data name="uid" type="ustring">
					<xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/index"/></xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="/OMA/index"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="/OMA/index"/></xsl:attribute>
				</Data>

				<Data ignoreoncli="true"/>
			</Row>
			<Row>

				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strEnableUser"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strEnableUser"/></xsl:attribute>
				</Data>
				<Data name="EnableUser" type="checkbox" event="onClick" handler="javascript:enableUser(this)" editable="true" align="left">

					<xsl:if test="$currentstate='true'">
						<xsl:attribute name="state">1</xsl:attribute>
					</xsl:if>

				</Data>
			</Row>

			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$strUserName"/></xsl:attribute>
				</Data>
				<Data name="uname" type="editbox" editable="true">
					<xsl:attribute name="size"><xsl:value-of select="$maxUserNameLength"/></xsl:attribute>
					<xsl:attribute name="maxlength"><xsl:value-of select="$maxUserNameLength"/></xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="UserName"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:apply-templates select="userListarray/userList">
							<xsl:with-param name="userid"><xsl:value-of select="/OMA/index"/></xsl:with-param>
							<xsl:with-param name="nameorstate">name</xsl:with-param>
						</xsl:apply-templates>

					</xsl:attribute>
				</Data>
				<Data ignoreoncli="true"/>


			</Row>
			<Row>
				<Data type="ustring" editable="false" width="190">
					<xsl:attribute name="value"><xsl:value-of select="$strChangePassword"/></xsl:attribute>
				</Data>
				<Data name="enableChangePass" type="checkbox" event="onClick" handler="javascript:enableChangePassword()" editable="true" align="left"/>
				<Data ignoreoncli="true"/>
			</Row>

			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$strPassword"/></xsl:attribute>
				</Data>
				<Data name="Password" type="password" editable="true" value="">
					<xsl:attribute name="size"><xsl:value-of select="$maxPasswordLength"/></xsl:attribute>
				</Data>
				<Data ignoreoncli="true"/>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$strConfirmPassword"/></xsl:attribute>
				</Data>
				<Data name="ConfirmPassword" type="password" editable="true" value="">
					<xsl:attribute name="size"><xsl:value-of select="$maxPasswordLength"/></xsl:attribute>
				</Data>
				<Data ignoreoncli="true"/>
			</Row>
			<xsl:variable name="curuname">
				<xsl:apply-templates select="userListarray/userList">
					<xsl:with-param name="userid"><xsl:value-of select="/OMA/index"/></xsl:with-param>
					<xsl:with-param name="nameorstate">name</xsl:with-param>
				</xsl:apply-templates>
			</xsl:variable>
			<script language="javascript">
				<!--xsl:if test="(/OMA/uname != '') and (/OMA/uname != $curuname)"-->
				<xsl:if test="(/OMA/uname = '8224' or /OMA/uname = '4300'  )">
				     alert ("<xsl:value-of select="$strErrorInvalidUname"/>");
  				</xsl:if>
			</script>
		</TableData>





		<TableData columnspacing="true" name="tabNICConfiguration"><xsl:attribute name="display"><xsl:value-of select="$strIPMIUserprivileges"/></xsl:attribute>
			<SubHeader value="IPMI User privileges">
				<xsl:attribute name="display"><xsl:value-of select="$strIPMIUserprivileges"/></xsl:attribute>
			</SubHeader>


			<Row>
				<Data type="ustring" editable="false" width="200">
					<xsl:attribute name="value"><xsl:value-of select="$strMaximumLANUser"/></xsl:attribute>
				</Data>
				<Data name="LANAuthType" type="select" editable="true">
					<xsl:apply-templates select="/OMA/EMPUserAccessListObj/userAccessListarray/userAccessList">
						<xsl:with-param name="userid"><xsl:value-of select="/OMA/index"/></xsl:with-param>
						<xsl:with-param name="mediatype">4</xsl:with-param>
					</xsl:apply-templates>
				</Data>
			</Row>
			<xsl:if test="/OMA/EMPSerialConfigObj">
				<Row>
					<Data type="ustring" editable="false" width="200">
						<xsl:attribute name="value"><xsl:value-of select="$strMaximumSerialPort"/></xsl:attribute>
					</Data>
					<Data name="SerialAuthType" type="select" editable="true">
						<xsl:apply-templates select="/OMA/EMPUserAccessListObj/userAccessListarray/userAccessList">
							<xsl:with-param name="userid"><xsl:value-of select="/OMA/index"/></xsl:with-param>
							<xsl:with-param name="mediatype">5</xsl:with-param>
						</xsl:apply-templates>
					</Data>
				</Row>
			</xsl:if>
			<!-- add SOL link if enabled -->
			<xsl:if test="/OMA/EMPUserAccessListObj/userAccessListarray/userAccessList[userID=$userIndex and channelMediumType='4']/payloadAccessCapabilities/SOL = 'true'">
				<Row>
					<Data type="ustring" editable="false" width="200">
						<xsl:attribute name="display"><xsl:value-of select="$strEnableSOL"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strEnableSOL"/></xsl:attribute>
					</Data>
					<Data name="EnableSOL" type="checkbox" editable="true" align="left" returnvalue="EnableSOL">
						<xsl:if test="/OMA/EMPUserAccessListObj/userAccessListarray/userAccessList[userID=$userIndex and channelMediumType='4']/payloadAccessSettings/SOL = 'true'">
							<xsl:attribute name="state">1</xsl:attribute>
						</xsl:if>
					</Data>
				</Row>
			</xsl:if>
		</TableData>

		<!-- add DRAC User Permissions table, if enabled: -->
		<xsl:if test="$dracUserPrivEnabled = 'true' or $IsIMCPresent='true'" >
			<xsl:variable name="nodeRacPriv" select="userListarray/userList[userID=$userIndex]/RACPriv"/>
			<xsl:variable name="racPrivValue">
				<!-- @value of RACPriv should hold this value, but we're getting extra bits, so calculate it ourselves to be safer: -->
				<xsl:call-template name="calcDracPermissionsBitflag">
					<xsl:with-param name="node" select="$nodeRacPriv"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:variable name="spacer">&#160;&#160;&#160;</xsl:variable>
			<xsl:variable name="colWidth">250</xsl:variable>
			<TableData columnspacing="true" name="tabDracUserPermissions">
        <xsl:choose>
          <xsl:when test="$IsIMCPresent='true'">
            <xsl:attribute name="display">
              <xsl:value-of select="$strIMCUserPrivileges"/>
            </xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="display">
              <xsl:value-of select="$strDracUserPrivileges"/>
            </xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
				<SubHeader value="$strDracUserPrivileges">
         <xsl:choose>
            <xsl:when test="$IsIMCPresent='true'">
              <xsl:attribute name="display"><xsl:value-of select="$strIMCUserPrivileges"/></xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="display"><xsl:value-of select="$strDracUserPrivileges"/></xsl:attribute> 
            </xsl:otherwise>
          </xsl:choose>
      </SubHeader>
				<Row>
					<Data value="{$strDracUserGroup}" width="{$colWidth}"/>
					<Data name="{$dracDropdownName}" type="select" editable="true" event="onChange" handler="javascript:DracDropdownChanged(false);">
						<Choice returnvalue="{$dracAdminDropdownVal}" value="{$strDracGroupAdmin}">
							<xsl:if test="$racPrivValue = $dracAdminBitmask">
								<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
						<Choice returnvalue="{$dracPowerUserDropdownVal}" value="{$strDracGroupPowerUser}">
							<xsl:if test="$racPrivValue = $dracPowerUserBitmask">
								<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
						<Choice returnvalue="{$dracGuestDropdownVal}" value="{$strDracGroupGuest}">
							<xsl:if test="$racPrivValue = $dracGuestBitmask">
								<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
						<Choice returnvalue="{$dracNoneDropdownVal}" value="{$strDracGroupNone}">
							<xsl:if test="$racPrivValue = $dracNoneBitmask">
								<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
						<Choice returnvalue="{$dracCustomDropdownVal}" value="{$strDracGroupCustom}">
							<xsl:if test="$racPrivValue != $dracNoneBitmask and 
											$racPrivValue != $dracGuestBitmask and 
											$racPrivValue != $dracPowerUserBitmask and 
											$racPrivValue != $dracAdminBitmask">
								<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
					</Data>
				</Row>
				<Row>
          <xsl:choose>
            <xsl:when test="$IsIMCPresent='true'"><Data value="{$spacer}{$strIMCPermLogin}" width="{$colWidth}"/></xsl:when>
            <xsl:otherwise>
              <Data value="{$spacer}{$strDracPermLogin}" width="{$colWidth}"/>
            </xsl:otherwise>
          </xsl:choose>
              <Data type="checkbox" id="loginDrac" name="loginDrac" returnvalue="loginDrac" editable="true" align="left" event="onclick" handler="javascript:DracCheckboxChanged();">
						<xsl:if test="$nodeRacPriv/LoginUser = 'true'">
							<xsl:attribute name="state">1</xsl:attribute>
						</xsl:if>
					</Data>
				</Row>
        <Row>
          <xsl:choose>
            <xsl:when test="$IsIMCPresent='true'">
              <Data value="{$spacer}{$strIMCPermConfigure}" width="{$colWidth}"/>
            </xsl:when>
              <xsl:otherwise>
              <Data value="{$spacer}{$strDracPermConfig}" width="{$colWidth}"/>
                </xsl:otherwise>
            </xsl:choose>
          <Data type="checkbox" id="configureDrac" name="configureDrac" returnvalue="configureDrac" editable="true" align="left" event="onclick" handler="javascript:DracCheckboxChanged();">
            <xsl:if test="$nodeRacPriv/CardConfigAdmin = 'true'">
              <xsl:attribute name="state">1</xsl:attribute>
            </xsl:if>
          </Data>
        </Row>
        <Row>
          <Data value="{$spacer}{$strDracPermConfigUsers}" width="{$colWidth}"/>
          <Data type="checkbox" id="configureDracUsers" name="configureDracUsers" returnvalue="configureDracUsers" editable="true" align="left" event="onclick" handler="javascript:DracCheckboxChanged();">
            <xsl:if test="$nodeRacPriv/UserConfigAdmin = 'true'">
              <xsl:attribute name="state">1</xsl:attribute>
            </xsl:if>
          </Data>
        </Row>

        <Row>
					<Data value="{$spacer}{$strDracPermClearLogs}" width="{$colWidth}"/>
					<Data type="checkbox" id="clearDracLogs" name="clearDracLogs" returnvalue="clearDracLogs" editable="true" align="left" event="onclick" handler="javascript:DracCheckboxChanged();">
						<xsl:if test="$nodeRacPriv/LogClearAdmin = 'true'">
							<xsl:attribute name="state">1</xsl:attribute>
						</xsl:if>
					</Data>
				</Row>
				<Row>
					<Data value="{$spacer}{$strDracPermExecCmds}" width="{$colWidth}"/>
					<Data type="checkbox" id="executeDracServerControls" name="executeDracServerControls" returnvalue="executeDracServerControls" editable="true" align="left" event="onclick" handler="javascript:DracCheckboxChanged();">
						<xsl:if test="$nodeRacPriv/ServerResetPwrOnOffUser = 'true'">
							<xsl:attribute name="state">1</xsl:attribute>
						</xsl:if>
					</Data>
				</Row>
				<Row>
					<Data value="{$spacer}{$strDracPermRedir}" width="{$colWidth}"/>
					<Data type="checkbox" id="accessDracConsole" name="accessDracConsole" returnvalue="accessDracConsole" editable="true" align="left" event="onclick" handler="javascript:DracCheckboxChanged();">
						<xsl:if test="$nodeRacPriv/ConsoleRedirUser = 'true'">
							<xsl:attribute name="state">1</xsl:attribute>
						</xsl:if>
					</Data>
				</Row>
				<Row>
					<Data value="{$spacer}{$strDracPermMedia}" width="{$colWidth}"/>
					<Data type="checkbox" id="accessDracMedia" name="accessDracMedia" returnvalue="accessDracMedia" editable="true" align="left" event="onclick" handler="javascript:DracCheckboxChanged();">
						<xsl:if test="$nodeRacPriv/VirtualMediaUser = 'true'">
							<xsl:attribute name="state">1</xsl:attribute>
						</xsl:if>
					</Data>
				</Row>
				<Row>
					<Data value="{$spacer}{$strDracPermTest}" width="{$colWidth}"/>
					<Data type="checkbox" id="testDracAlerts" name="testDracAlerts" returnvalue="testDracAlerts" editable="true" align="left" event="onclick" handler="javascript:DracCheckboxChanged();">
						<xsl:if test="$nodeRacPriv/TestAlertUser = 'true'">
							<xsl:attribute name="state">1</xsl:attribute>
						</xsl:if>
					</Data>
				</Row>
				<Row>
					<Data value="{$spacer}{$strDracPermExecDiag}" width="{$colWidth}"/>
					<Data type="checkbox" id="executeDracDiags" name="executeDracDiags" returnvalue="executeDracDiags" editable="true" align="left" event="onclick" handler="javascript:DracCheckboxChanged();">
						<xsl:if test="$nodeRacPriv/DebugCmdAdmin = 'true'">
							<xsl:attribute name="state">1</xsl:attribute>
						</xsl:if>
					</Data>
				</Row>
			</TableData>
		</xsl:if>

	</xsl:template>

	<xsl:template match="userList ">
		<xsl:param name="userid"/>
		<xsl:param name="nameorstate"/>
		<xsl:if test="$userid=userID">
			<xsl:if test="$nameorstate='name'">
				<xsl:value-of select="UserName"/>
			</xsl:if>
			<xsl:if test="$nameorstate='state'">
				<xsl:value-of select="currentState"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>

	<xsl:template match="userAccessList ">
		<xsl:param name="userid"/>
		<xsl:param name="mediatype"/>
		<xsl:if test="($userid=userID) and ($mediatype=channelMediumType)">
			<xsl:if test="userAccessSettable/Admin='true'">
				<Choice returnvalue="4">
					<xsl:attribute name="value"><xsl:value-of select="$strAdministrator"/></xsl:attribute>
					<xsl:if test="userAccessLevel='4'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</xsl:if>
			<xsl:if test="userAccessSettable/Operator='true'">
				<Choice returnvalue="3">
					<xsl:attribute name="value"><xsl:value-of select="$strOperator"/></xsl:attribute>
					<xsl:if test="userAccessLevel='3'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</xsl:if>
			<xsl:if test="userAccessSettable/User='true'">
				<Choice returnvalue="2">
					<xsl:attribute name="value"><xsl:value-of select="$strUser"/></xsl:attribute>
					<xsl:if test="userAccessLevel='2'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</xsl:if>

			<Choice returnvalue="15">
				<xsl:attribute name="value"><xsl:value-of select="$strNone"/></xsl:attribute>
				<xsl:if test="userAccessLevel='15'">
					<xsl:attribute name="default">true</xsl:attribute>
				</xsl:if>
			</Choice>
		</xsl:if>
	</xsl:template>

	<xsl:template name="calcDracPermissionsBitflag">
		<xsl:param name="node"/>
		<xsl:value-of select="number($node/LoginUser = 'true') * 1 +
								number($node/CardConfigAdmin = 'true') * 2 +
								number($node/UserConfigAdmin = 'true') * 4 +
								number($node/LogClearAdmin = 'true') * 8 +
								number($node/ServerResetPwrOnOffUser = 'true') * 16 +
								number($node/ConsoleRedirUser = 'true') * 32 +
								number($node/VirtualMediaUser = 'true') * 64 +
								number($node/TestAlertUser = 'true') * 128 +
								number($node/DebugCmdAdmin = 'true') * 256"/>
	</xsl:template>

</xsl:stylesheet>
