<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml" />
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
		<xsl:variable name="displaytype"><xsl:value-of select="Arguments"/></xsl:variable>
		<xsl:choose>
			<xsl:when test="SMStatus != '0'">
				<DataArea printable="false">
					<PromptText>
						<xsl:call-template name="smstatus">
							<xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param>
							<xsl:with-param name="mssg"><xsl:value-of select="SMStatus/@mssg"/></xsl:with-param>
						</xsl:call-template>
					</PromptText>
				</DataArea>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="(OMAUserRights = '7') or (OMAUserRights = '3')">
						<xsl:choose>
							<xsl:when test="$displaytype = 'list'">
								<DataArea exportdata="false">
									<PageTitle>
										<xsl:attribute name="display"><xsl:value-of select="$strAssetInformation"/></xsl:attribute>
									</PageTitle>
									<PromptText ignoreoncli="true"><xsl:value-of select="$strClickTheIndividual"/></PromptText>
									<CustomButton>
										<Data name=""><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
											<xsl:attribute name="display"><xsl:value-of select="$strRefresh1"/></xsl:attribute>
											<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.AssetInfoWebPlugin&amp;cmd=<xsl:value-of select="Arguments"/>&amp;help=AssetInfo</xsl:attribute>
										</Data>
									</CustomButton>
									<xsl:call-template name="List"/>
								</DataArea>
							</xsl:when>
							<xsl:when test="$displaytype = 'summary'">
								<DataArea backpagetarget="/servlet/DataArea?plugin=com.dell.hip.webplugins.AssetInfoWebPlugin&amp;cmd=list&amp;help=AssetInfo">
									<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strAssetSections"/></xsl:attribute>
									<PageTitle>
										<xsl:attribute name="display"><xsl:value-of select="$strSummaryOfAsset"/></xsl:attribute>
									</PageTitle>
									<PromptText ignoreoncli="true"><xsl:value-of select="$strClickTheIndividual1"/></PromptText>
									<CustomButton>
										<Data>
											<xsl:attribute name="display"><xsl:value-of select="$strRefresh2"/></xsl:attribute>
											<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.AssetInfoWebPlugin&amp;cmd=<xsl:value-of select="Arguments"/>&amp;help=AssetSummary</xsl:attribute>
										</Data>
									</CustomButton>
									<SummaryData>
										<xsl:apply-templates select="AssetInfo"/>
										<xsl:call-template name="OwnerInfo"/>
									</SummaryData>
								</DataArea>
							</xsl:when>
							<xsl:otherwise>
								<DataArea backpagetarget="/servlet/DataArea?plugin=com.dell.hip.webplugins.AssetInfoWebPlugin&amp;cmd=list&amp;help=AssetInfo" validate="true" exportdata="false">
									<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strAssetSections1"/></xsl:attribute>
									<xsl:choose>
										<xsl:when test="(Arguments ='acquisition') or (Arguments ='extwarranty') or (Arguments ='warranty') or (Arguments ='lease') or (Arguments 		='maintenance')">
											<xsl:attribute name="date">true</xsl:attribute>
											<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.hip.webplugins.SetAssetInfoWebPlugin&amp;cmd=<xsl:value-of 	select="Arguments"/>	</xsl:attribute>
										</xsl:when>
										<xsl:when test="Arguments ='lease'"></xsl:when>
										<xsl:when test="Arguments ='support'">
											<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.hip.webplugins.SetAssetInfoWebPlugin&amp;cmd=<xsl:value-of 	select="Arguments"/>	</xsl:attribute>
										</xsl:when>
										<xsl:when test="Arguments ='maintenance'"></xsl:when>
										<xsl:when test="Arguments ='system'">
											<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.hip.webplugins.SetAssetInfoWebPlugin&amp;cmd=<xsl:value-of 	select="Arguments"/>	</xsl:attribute>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.hip.webplugins.SetAssetInfoWebPlugin&amp;cmd=<xsl:value-of 	select="Arguments"/>	</xsl:attribute>
										</xsl:otherwise>
									</xsl:choose>
									<PageTitle >
										<xsl:attribute name="display">
											<xsl:choose>
												<xsl:when test="DisplayString='Acquisition'"><xsl:value-of select="$strAcquisition"/></xsl:when>
												<xsl:when test="DisplayString='Depreciation'"><xsl:value-of select="$strDepreciation"/></xsl:when>
												<xsl:when test="DisplayString='Extended Warranty Information'"><xsl:value-of select="$strExtendedWarrantyInformation"/></xsl:when>
												<xsl:when test="DisplayString='Lease Information'"><xsl:value-of select="$strLeaseInformation"/></xsl:when>
												<xsl:when test="DisplayString='Maintenance Information'"><xsl:value-of select="$strMaintenanceInformation"/></xsl:when>
												<xsl:when test="DisplayString='Out Source Information'"><xsl:value-of select="$strOutSourceInformation"/></xsl:when>
												<xsl:when test="DisplayString='Owner Information'"><xsl:value-of select="$strOwnerInformation"/></xsl:when>
												<xsl:when test="DisplayString='Service Contract'"><xsl:value-of select="$strServiceContract"/></xsl:when>
												<xsl:when test="DisplayString='Support Information'"><xsl:value-of select="$strSupportInformation"/></xsl:when>
												<xsl:when test="DisplayString='System Information'"><xsl:value-of select="$strSystemInformation"/></xsl:when>
												<xsl:when test="DisplayString='Warranty Information'"><xsl:value-of select="$strWarrantyInformation"/></xsl:when>
											</xsl:choose>
										</xsl:attribute>
									</PageTitle>
									<xsl:variable name="helpattrib">
										<xsl:choose>
											<xsl:when test="Arguments='acquisition'">Acquisition</xsl:when>
											<xsl:when test="Arguments='extwarranty'">ExtWarranty</xsl:when>															<xsl:when test="Arguments='warranty'">Warranty</xsl:when>
											<xsl:when test="Arguments='outsource'">OutSource</xsl:when>
											<xsl:when test="Arguments='owner'">Owner</xsl:when>
											<xsl:when test="Arguments='depreciation'">Depreciation</xsl:when>
											<xsl:when test="Arguments='servicecontract'">Service</xsl:when>
											<xsl:when test="Arguments='lease'">Lease</xsl:when>
											<xsl:when test="Arguments='maintenance'">Maintenance</xsl:when>
											<xsl:when test="Arguments='support'">Support</xsl:when>
											<xsl:when test="Arguments='system'">SystemInfo</xsl:when>
											<xsl:when test="Arguments='summary'">AssetSummary</xsl:when>
										</xsl:choose>
									</xsl:variable>
									<CustomButton>
										<Data>
											<xsl:attribute name="display"><xsl:value-of select="$strRefresh3"/></xsl:attribute>
											<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.AssetInfoWebPlugin&amp;cmd=<xsl:value-of select="Arguments"/>&amp;help=<xsl:value-of select="$helpattrib"/></xsl:attribute>
										</Data>
									</CustomButton>
									
									<HiddenTable>
										<Data>
											<xsl:attribute name="name">ClientGmtOffset</xsl:attribute>
											<xsl:attribute name="type">hidden</xsl:attribute>
											<xsl:attribute name="value"><xsl:value-of select="'0'"/></xsl:attribute>
										</Data>
									</HiddenTable>
									
									<xsl:apply-templates/>
									<script>
										function validate()
										{
											var section = "<xsl:value-of select="Arguments"/>";
											<xsl:variable name="arg"><xsl:value-of select="Arguments"/></xsl:variable>

											//Client's GMT offset
											var offdate = new Date( new Number( 10000000000 ) );
											document.getElementById("ClientGmtOffset").value = offdate.getTimezoneOffset();

											<xsl:choose>
												<xsl:when test="$arg = 'acquisition'">
													var tempacqpcost 		= document.getElementById("acqpcost").value;
													var tempacqwbillnum 	= document.getElementById("acqwbillnum").value;
													var tempacqponum		= document.getElementById("acqponum").value;
													var tempacqsignauth		= document.getElementById("acqsignauth").value;
													var tempcstctr				= document.getElementById("cstctr").value;

													<!-- 1. Purchase Cost -->
													if(tempacqpcost != '')
													{
														// do error checking for 1.strings 2.-ve numbers and 3.floats
														if( (isWholeNumber(tempacqpcost) == true) || (tempacqpcost &lt; 0) || (tempacqpcost.indexOf(".") != "-1") )
														{
															alert(<xsl:value-of select="$strErrorWholeNumber"/>);
															document.getElementById("acqpcost").focus();
															document.getElementById("acqpcost").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue"/>");
														document.getElementById("acqpcost").focus();
														document.getElementById("acqpcost").select();
														return false;
													}

													<!-- 2. Way Bill Num -->
													if(tempacqwbillnum != '')
													{
														// do error checking for 1.strings 2.-ve numbers and 3.floats
														if((isWholeNumber(tempacqwbillnum) == true) || (tempacqwbillnum &lt; 0) || (tempacqwbillnum.indexOf(".") != "-1"))
														{
															alert(<xsl:value-of select="$strErrorWholeNumber1"/>);
															document.getElementById("acqwbillnum").focus();
															document.getElementById("acqwbillnum").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue1"/>");
														document.getElementById("acqwbillnum").focus();
														document.getElementById("acqwbillnum").select();
														return false;
													}

													<!-- 3. PO Num -->
													if(tempacqponum != '')
													{
														// do error checking for 1.strings 2.-ve numbers and 3.floats
														if((isWholeNumber(tempacqponum) == true) || (tempacqponum &lt; 0) || (tempacqponum.indexOf(".") != "-1"))
														{
															alert(<xsl:value-of select="$strErrorWholeNumber2"/>);
															document.getElementById("acqponum").focus();
															document.getElementById("acqponum").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue2"/>");
														document.getElementById("acqponum").focus();
														document.getElementById("acqponum").select();
														return false;
													}

													<!-- 4. Who Signed for -->
													if(tempacqsignauth != '')
													{
														if( ! isAlphaNumeric(tempacqsignauth, "<xsl:value-of select="$strWhoSignedFor"/>"))
														{
															document.getElementById("acqsignauth").focus();
															document.getElementById("acqsignauth").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue3"/>");
														document.getElementById("acqsignauth").focus();
														document.getElementById("acqsignauth").select();
														return false;
													}

													<!-- 5. Cost Center -->
													if(tempcstctr != '')
													{
														if( ! isAlphaNumeric(tempcstctr, "<xsl:value-of select="$strCostCenter"/>"))
														{
															document.getElementById("cstctr").focus();
															document.getElementById("cstctr").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue4"/>");
														document.getElementById("cstctr").focus();
														document.getElementById("cstctr").select();
														return false;
													}
												</xsl:when>
												<xsl:when test="$arg = 'extwarranty'">
													var tempextwcost		= document.getElementById("extwcost").value;
													var tempextwprovider	= document.getElementById("extwprovider").value;
													var tempextwsdate		= document.getElementById("extwsdate").value;
													var tempextwedate		= document.getElementById("extwedate").value;
													if(tempextwcost != '')
													{
														// do error checking for 1.strings 2.-ve numbers and 3.floats
														if((isWholeNumber(tempextwcost) == true) || (tempextwcost &lt; 0) || (tempextwcost.indexOf(".") != "-1"))
														{
															alert(<xsl:value-of select="$strErrorWholeNumber3"/>);
															document.getElementById("extwcost").focus();
															document.getElementById("extwcost").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue5"/>");
														document.getElementById("extwcost").focus();
														document.getElementById("extwcost").select();
														return false;
													}

													if(tempextwprovider != '')
													{
														if( ! isAlphaNumeric(tempextwprovider, "<xsl:value-of select="$strProvider"/>"))
														{
															document.getElementById("extwprovider").focus();
															document.getElementById("extwprovider").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue6"/>");
														document.getElementById("extwprovider").focus();
														document.getElementById("extwprovider").select();
														return false;
													}
													
												

												</xsl:when>
												<xsl:when test="$arg = 'warranty'">
													var tempwduration	= document.getElementById("wduration").value;
													var tempwcost		= document.getElementById("wcost").value;

													if(tempwduration != '')
													{
														// do error checking for 1.strings 2.-ve numbers and 3.floats
														if((isWholeNumber(tempwduration) == true) || (tempwduration &lt; 0) || (tempwduration.indexOf(".") != "-1"))
														{
															alert(<xsl:value-of select="$strErrorWholeNumber4"/>);
															document.getElementById("wduration").focus();
															document.getElementById("wduration").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue7"/>");
														document.getElementById("wduration").focus();
														document.getElementById("wduration").select();
														return false;
													}

													if(tempwcost != '')
													{
														// do error checking for 1.strings 2.-ve numbers and 3.floats
														if((isWholeNumber(tempwcost) == true) || (tempwcost &lt; 0) || (tempwcost.indexOf(".") != "-1"))
														{
															alert(<xsl:value-of select="$strErrorWholeNumber5"/>);
															document.getElementById("wcost").focus();
															document.getElementById("wcost").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue8"/>");
														document.getElementById("wcost").focus();
														document.getElementById("wcost").select();
														return false;
													}
												</xsl:when>
												<xsl:when test="$arg = 'outsource'">
													var tempoutsservfee 		= document.getElementById("outsservfee").value;
													var tempoutsprovfee		= document.getElementById("outsprovfee").value;
													var tempoutsprobcomp	= document.getElementById("outsprobcomp").value;
													var tempoutssigna		= document.getElementById("outssigna").value;
													var tempoutsslalvl		= document.getElementById("outsslalvl").value;

													if(tempoutsservfee != '')
													{
														// do error checking for 1.strings 2.-ve numbers and 3.floats
														if( (isWholeNumber(tempoutsservfee) == true) || (tempoutsservfee &lt; 0) || (tempoutsservfee.indexOf(".") != "-1") )
														{
															alert(<xsl:value-of select="$strErrorWholeNumber11"/>);
															document.getElementById("outsservfee").focus();
															document.getElementById("outsservfee").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue9"/>");
														document.getElementById("outsservfee").focus();
														document.getElementById("outsservfee").select();
														return false;
													}
													
													if(tempoutsprovfee != '')
													{
														// do error checking for 1.strings 2.-ve numbers and 3.floats
														if( (isWholeNumber(tempoutsprovfee) == true) || (tempoutsprovfee &lt; 0) || (tempoutsprovfee.indexOf(".") != "-1") )
														{
															alert(<xsl:value-of select="$strErrorWholeNumber12"/>);
															document.getElementById("outsprovfee").focus();
															document.getElementById("outsprovfee").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue10"/>");
														document.getElementById("outsprovfee").focus();
														document.getElementById("outsprovfee").select();
														return false;
													}

													if(tempoutsprobcomp != '')
													{
														if( ! isAlphaNumeric(tempoutsprobcomp, "<xsl:value-of select="$strProblemComponent"/>"))
														{
															document.getElementById("outsprobcomp").focus();
															document.getElementById("outsprobcomp").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue11"/>");
														document.getElementById("outsprobcomp").focus();
														document.getElementById("outsprobcomp").select();
														return false;
													}

													if(tempoutssigna != '')
													{
														if( ! isAlphaNumeric(tempoutssigna, "<xsl:value-of select="$strWhoSignedFor1"/>"))
														{
															document.getElementById("outssigna").focus();
															document.getElementById("outssigna").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue12"/>");
														document.getElementById("outssigna").focus();
														document.getElementById("outssigna").select();
														return false;
													}

													if(tempoutsslalvl != '')
													{
														if( ! isAlphaNumeric(tempoutsslalvl, "<xsl:value-of select="$strSLALevel"/>"))
														{
															document.getElementById("outsslalvl").focus();
															document.getElementById("outsslalvl").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue13"/>");
														document.getElementById("outsslalvl").focus();
														document.getElementById("outsslalvl").select();
														return false;
													}
												</xsl:when>
												<xsl:when test="$arg = 'owner'">
													var tempcorpownername = document.getElementById("corpownername").value;
													var tempinsurancecomp = document.getElementById("insurancecomp").value;

													if(tempcorpownername != '')
													{
														if( ! isAlphaNumeric(tempcorpownername, "<xsl:value-of select="$strOwnerName"/>"))
														{
															document.getElementById("corpownername").focus();
															document.getElementById("corpownername").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue14"/>");
														document.getElementById("corpownername").focus();
														document.getElementById("corpownername").select();
														return false;
													}

													if(tempinsurancecomp != '')
													{
														if( ! isAlphaNumeric(tempinsurancecomp, "<xsl:value-of select="$strInsuranceCompany"/>"))
														{
															document.getElementById("insurancecomp").focus();
															document.getElementById("insurancecomp").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue15"/>");
														document.getElementById("insurancecomp").focus();
														document.getElementById("insurancecomp").select();
														return false;
													}
												</xsl:when>
												<xsl:when test="$arg = 'depreciation'">
													var tempdeprduration	= document.getElementById("deprduration").value;
													var tempdeprpercent 	= document.getElementById("deprpercent").value;
													var tempdeprmethod  	= document.getElementById("deprmethod").value;

													if(tempdeprduration != '')
													{
														// do error checking for 1.strings 2.-ve numbers and 3.floats
														if((isWholeNumber(tempdeprduration) == true) || (tempdeprduration &lt; 0) || (tempdeprduration.indexOf(".") != "-1"))
														{
															alert(<xsl:value-of select="$strErrorWholeNumber6"/>);
															document.getElementById("deprduration").focus();
															document.getElementById("deprduration").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue16"/>");
														document.getElementById("deprduration").focus();
														document.getElementById("deprduration").select();
														return false;
													}

													if(tempdeprpercent != '')
													{
														// do error checking for 1.strings 2.-ve numbers and 3.floats
														if((isWholeNumber(tempdeprpercent) == true) || (tempdeprpercent &lt; 0) || (tempdeprpercent.indexOf(".") != "-1") || (tempdeprpercent &gt; 100))
														{
															alert(<xsl:value-of select="$strErrorWholeNumber7"/>);
															document.getElementById("deprpercent").focus();
															document.getElementById("deprpercent").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue17"/>");
														document.getElementById("deprpercent").focus();
														document.getElementById("deprpercent").select();
														return false;
													}

													if(tempdeprmethod != '')
													{
														if( ! isAlphaNumeric(tempdeprmethod, "<xsl:value-of select="$strMethod"/>"))
														{
															document.getElementById("deprmethod").focus();
															document.getElementById("deprmethod").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue18"/>");
														document.getElementById("deprmethod").focus();
														document.getElementById("deprmethod").select();
														return false;
													}
												</xsl:when>
												<xsl:when test="$arg = 'servicecontract'">
													var tempsrvcnttype		= document.getElementById("srvcnttype").value;
													var tempsrvcntvendor	= document.getElementById("srvcntvendor").value;

													if(tempsrvcnttype != '')
													{
														if( ! isAlphaNumeric(tempsrvcnttype, "<xsl:value-of select="$strType"/>"))
														{
															document.getElementById("srvcnttype").focus();
															document.getElementById("srvcnttype").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue19"/>");
														document.getElementById("srvcnttype").focus();
														document.getElementById("srvcnttype").select();
														return false;
													}

													if(tempsrvcntvendor != '')
													{
														if( ! isAlphaNumeric(tempsrvcntvendor, "<xsl:value-of select="$strVendor"/>"))
														{
															document.getElementById("srvcntvendor").focus();
															document.getElementById("srvcntvendor").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue20"/>");
														document.getElementById("srvcntvendor").focus();
														document.getElementById("srvcntvendor").select();
														return false;
													}
												</xsl:when>
												<xsl:when test="$arg = 'lease'">
													var templeasebyoamt	= document.getElementById("leasebyoamt").value;
													var templeasertfact		= document.getElementById("leasertfact").value;
													var tempeasefrmrktval	= document.getElementById("leasefrmrktval").value;
													var templeaselessor		= document.getElementById("leaselessor").value;

													if(templeasebyoamt != '')
													{
														// do error checking for 1.strings 2.-ve numbers and 3.floats
														if((isWholeNumber(templeasebyoamt) == true) || (templeasebyoamt &lt; 0) || (templeasebyoamt.indexOf(".") != "-1"))
														{
															alert(<xsl:value-of select="$strErrorWholeNumber8"/>);
															document.getElementById("leasebyoamt").focus();
															document.getElementById("leasebyoamt").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue21"/>");
														document.getElementById("leasebyoamt").focus();
														document.getElementById("leasebyoamt").select();
														return false;
													}

													if(templeasertfact != '')
													{
														// do error checking for 1.strings 2.-ve numbers and 3.floats
														if((isWholeNumber(templeasertfact) == true) || (templeasertfact &lt; 0) || (templeasertfact.indexOf(".") != "-1"))
														{
															alert(<xsl:value-of select="$strErrorWholeNumber9"/>);
															document.getElementById("leasertfact").focus();
															document.getElementById("leasertfact").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue22"/>");
														document.getElementById("leasertfact").focus();
														document.getElementById("leasertfact").select();
														return false;
													}

													if(tempeasefrmrktval != '')
													{
														// do error checking for 1.strings 2.-ve numbers and 3.floats
														if((isWholeNumber(tempeasefrmrktval) == true) || (tempeasefrmrktval &lt; 0) || (tempeasefrmrktval.indexOf(".") != "-1"))
														{
															alert(<xsl:value-of select="$strErrorWholeNumber10"/>);
															document.getElementById("leasefrmrktval").focus();
															document.getElementById("leasefrmrktval").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue23"/>");
														document.getElementById("leasefrmrktval").focus();
														document.getElementById("leasefrmrktval").select();
														return false;
													}

													if(templeaselessor != '')
													{
														if( ! isAlphaNumeric(templeaselessor, "<xsl:value-of select="$strLessor"/>"))
														{
															document.getElementById("leaselessor").focus();
															document.getElementById("leaselessor").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue24"/>");
														document.getElementById("leaselessor").focus();
														document.getElementById("leaselessor").select();
														return false;
													}
												</xsl:when>
												<xsl:when test="$arg = 'maintenance'">
													var tempmaintprovider	= document.getElementById("maintprovider").value;
													var tempmaintrest		= document.getElementById("maintrest").value;
													var tempextwsdate 		= document.getElementById("maintsdate").value;
													var tempextwedate 		= document.getElementById("maintedate").value;
													
													if(tempmaintprovider != '')
													{
														if( ! isAlphaNumeric(tempmaintprovider, "<xsl:value-of select="$strProvider1"/>"))
														{
															document.getElementById("maintprovider").focus();
															document.getElementById("maintprovider").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue25"/>");
														document.getElementById("maintprovider").focus();
														document.getElementById("maintprovider").select();
														return false;
													}

													if(tempmaintrest != '')
													{
														if( ! isAlphaNumeric(tempmaintrest, "<xsl:value-of select="$strRestrictions"/>"))
														{
															document.getElementById("maintrest").focus();
															document.getElementById("maintrest").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue26"/>");
														document.getElementById("maintrest").focus();
														document.getElementById("maintrest").select();
														return false;
													}
												</xsl:when>
												<xsl:when test="$arg = 'support'">
													var tempsuphlpdesk	= document.getElementById("suphlpdesk").value;
													var tempsupautofix	= document.getElementById("supautofix").value;

													if(tempsuphlpdesk != '')
													{
														if( ! isAlphaNumeric(tempsuphlpdesk, "<xsl:value-of select="$strHelpDesk"/>"))
														{
															document.getElementById("suphlpdesk").focus();
															document.getElementById("suphlpdesk").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue27"/>");
														document.getElementById("suphlpdesk").focus();
														document.getElementById("suphlpdesk").select();
														return false;
													}

													if(tempsupautofix != '')
													{
														if( ! isAlphaNumeric(tempsupautofix, "<xsl:value-of select="$strAutomaticFix"/>"))
														{
															document.getElementById("supautofix").focus();
															document.getElementById("supautofix").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue28"/>");
														document.getElementById("supautofix").focus();
														document.getElementById("supautofix").select();
														return false;
													}
												</xsl:when>
												<xsl:when test="$arg = 'system'">
													var tempsyspuserphone	= document.getElementById("syspuserphone").value;
													var tempsyslocation		= document.getElementById("syslocation").value;
													var tempsyspusername	= document.getElementById("syspusername").value;

													if(tempsyspuserphone != '') 
													{
														if(tempsyspuserphone != "Please set the value")
														{
															if( ! isAlphaNumericPhone(tempsyspuserphone, "<xsl:value-of select="$strPrimaryUserPhone"/>"))
															{
																document.getElementById("syspuserphone").focus();
																document.getElementById("syspuserphone").select();
																return false;
															}
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue29"/>");
														document.getElementById("syspuserphone").focus();
														document.getElementById("syspuserphone").select();
														return false;
													}

													if(tempsyslocation != '')
													{
														if( ! isAlphaNumeric(tempsyslocation, "<xsl:value-of select="$strSystemLocation"/>"))
														{
															document.getElementById("syslocation").focus();
															document.getElementById("syslocation").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue30"/>");
														document.getElementById("syslocation").focus();
														document.getElementById("syslocation").select();
														return false;
													}

													if(tempsyspusername != '')
													{
														if( ! isAlphaNumeric(tempsyspusername, "<xsl:value-of select="$strPrimaryUserName"/>"))
														{
															document.getElementById("syspusername").focus();
															document.getElementById("syspusername").select();
															return false;
														}
													}
													else
													{
														alert("<xsl:value-of select="$strEnterTheValue31"/>");
														document.getElementById("syspusername").focus();
														document.getElementById("syspusername").select();
														return false;
													}
												</xsl:when>
											</xsl:choose>

											return true;
										}

										function isAlphaNumeric(text, varname)
										{
											var returnvalue = true;
											<!-- var regexp = /[\@\`\#\^\&\|\\\{\}\<\>\"]/g -->
											var regexp = &#47;&#91;&#92;&#64;&#92;&#96;&#92;&#35;&#92;&#94;&#92;&#38;&#92;&#124;&#92;&#92;&#92;&#123;&#92;&#125;&#92;&#60;&#92;&#62;&#92;&#34;&#93;&#47;g
											if ( text.match (regexp) )
											{
												alert(<xsl:value-of select="$strErrorInvalidValue"/>);
												returnvalue = false;
											}
											if(text.length > 63)
											{
												alert(<xsl:value-of select="$strVarnameCannotBe"/>);
												returnvalue = false;
											}
											return returnvalue;
										}
										
										// pp [03/03/2003] DFCT77294:added new function to check for whole number. JavaScript function isNaN accepts 'e' and 'x' 
										// for numbers in hex and scientific notation.
										
										function isWholeNumber(text)
										{
											var validValue = "0123456789";
											var temp;
											
											//Eliminate the spaces at the end
											while(''+text.charAt(text.length-1)==' ')
											{
												text = text.substring(0,text.length-1);
											}
											
											//pp [04/01/2003] check if value has been changed from default 'Please set the value'
											if ( text != "Please set the value" )
											{									
												for (var i=0; i&lt;text.length; i++)
												{
													temp = "" + text.substring(i, i+1);
													if (validValue.indexOf(temp) == "-1")
													{
															return true;												
													}
												}
												return false;
											}
										}

										<xsl:if test="$arg = 'system'">
											function isAlphaNumericPhone(text, varname)
											{
												var validValue = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
												var ok = "yes";
												var temp;

												//Eliminate the spaces at the end
												while(''+text.charAt(text.length-1)==' ')
												{
													text = text.substring(0,text.length-1);
												}

												for (var i=0; i&lt;text.length; i++)
												{
													temp = "" + text.substring(i, i+1);
													if (validValue.indexOf(temp) == "-1")
													{
														if(temp != " ")
														{
															ok = "no";
														}
													}
												}
												if (ok == "no")
												{
													alert(<xsl:value-of select="$strErrorInvalidValue"/>);
													return false;
												}
												return true;
											}
										</xsl:if>
									</script>
								</DataArea>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<DataArea>
							<PageTitle>
								<xsl:attribute name="display"><xsl:value-of select="$strSummaryOfAsset1"/></xsl:attribute>
							</PageTitle>
							<PromptText ignoreoncli="true"><xsl:value-of select="$strClickTheIndividual2"/></PromptText>
							<CustomButton>
								<Data>
									<xsl:attribute name="display"><xsl:value-of select="$strRefresh4"/></xsl:attribute>
									<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.AssetInfoWebPlugin&amp;cmd=summary&amp;help=AssetSummary</xsl:attribute>
								</Data>
							</CustomButton>
							<SummaryData>
								<xsl:apply-templates select="AssetInfo"/>
								<xsl:call-template name="OwnerInfo"/>
							</SummaryData>
						</DataArea>
					</xsl:otherwise>
		</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="List">
		<TableData>
			<Header>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strAssetSections2"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strAssetSections3"/></xsl:attribute>
				</Data>
			</Header>
			<Row>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="$strAcquisition1"/></xsl:attribute>
					<xsl:attribute name="link">true</xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.AssetInfoWebPlugin&amp;cmd=acquisition&amp;help=Acquisition</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="$strDepreciation1"/></xsl:attribute>
					<xsl:attribute name="link">true</xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.AssetInfoWebPlugin&amp;cmd=depreciation&amp;help=Depreciation</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="$strExtendedWarrantyInformation1"/></xsl:attribute>
					<xsl:attribute name="link">true</xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.AssetInfoWebPlugin&amp;cmd=extwarranty&amp;help=ExtWarranty</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="$strLeaseInformation1"/></xsl:attribute>
					<xsl:attribute name="link">true</xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.AssetInfoWebPlugin&amp;cmd=lease&amp;help=Lease</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="$strMaintenanceInformation1"/></xsl:attribute>
					<xsl:attribute name="link">true</xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.AssetInfoWebPlugin&amp;cmd=maintenance&amp;help=Maintenance</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="$strOutSourceInformation1"/></xsl:attribute>
					<xsl:attribute name="link">true</xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.AssetInfoWebPlugin&amp;cmd=outsource&amp;help=OutSource</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="$strOwnerInformation1"/></xsl:attribute>
					<xsl:attribute name="link">true</xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.AssetInfoWebPlugin&amp;cmd=owner&amp;help=Owner</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="$strServiceContract1"/></xsl:attribute>
					<xsl:attribute name="link">true</xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.AssetInfoWebPlugin&amp;cmd=servicecontract&amp;help=Service</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="$strSummary"/></xsl:attribute>
					<xsl:attribute name="link">true</xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.AssetInfoWebPlugin&amp;cmd=summary&amp;help=AssetSummary</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="$strSupportInformation1"/></xsl:attribute>
					<xsl:attribute name="link">true</xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.AssetInfoWebPlugin&amp;cmd=support&amp;help=Support</xsl:attribute>						</Data>
			</Row>
			<Row>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="$strSystemInformation1"/></xsl:attribute>
					<xsl:attribute name="link">true</xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.AssetInfoWebPlugin&amp;cmd=system&amp;help=SystemInfo</xsl:attribute>
				</Data>
			</Row>
			<Row>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="$strWarrantyInformation1"/></xsl:attribute>
					<xsl:attribute name="link">true</xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.AssetInfoWebPlugin&amp;cmd=warranty&amp;help=Warranty</xsl:attribute>
				</Data>
			</Row>
		</TableData>
	</xsl:template>
	<xsl:template match="AssetInfo">
		<xsl:apply-templates />
	</xsl:template>
	<xsl:template match="Acquisition">
		<xsl:variable name="displaytype"><xsl:value-of select="/OMA/Arguments"/></xsl:variable>
		<xsl:choose>
			<xsl:when test="(/OMA/OMAUserRights = '1') or ($displaytype = 'summary') or ($displaytype = '')">
				<Section name="Acquisition"><xsl:attribute name="display"><xsl:value-of select="$strAcquisition2"/></xsl:attribute>
					<ListData>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strPurchaseCost"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="PurchaseCost"/></xsl:attribute>
						</Data>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strReferenceToDelivery"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="WayBillNum"/></xsl:attribute>
						</Data>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strReferenceToPO"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="PONum"/></xsl:attribute>
						</Data>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strWhoSignedFor2"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="SignAuthority"/></xsl:attribute>
						</Data>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strInstallationDate"/></xsl:attribute>
							<xsl:attribute name="value">
								<xsl:call-template name="DisplayDate">
									<xsl:with-param name="dateName"><xsl:value-of select="DateOfInstallation"/></xsl:with-param>
								</xsl:call-template>
							</xsl:attribute>
						</Data>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strPurchaseDate"/></xsl:attribute>
							<xsl:attribute name="value">
								<xsl:call-template name="DisplayDate">
									<xsl:with-param name="dateName"><xsl:value-of select="DateOfPurchase"/></xsl:with-param>
								</xsl:call-template>
							</xsl:attribute>
						</Data>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strVendor1"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="/OMA/AssetInfo/OMConfig/Vendor"/></xsl:attribute>
						</Data>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strExpensed"/></xsl:attribute>
							<xsl:choose>
								<xsl:when test="/OMA/AssetInfo/OMConfig/Expensed ='true'">
									<xsl:attribute name="value"><xsl:value-of select="$strYes"/></xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="value"><xsl:value-of select="$strNo"/></xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
						</Data>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strCostCenter1"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="/OMA/AssetInfo/CostCenter/CostCenter"/></xsl:attribute>
						</Data>
					</ListData>
				</Section>
			</xsl:when>
			<xsl:otherwise>
				<ListData>
					<Data type="editbox" name="acqpcost" size="29" maxlength="9">
						<xsl:attribute name="display"><xsl:value-of select="$strPurchaseCost1"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="PurchaseCost"/></xsl:attribute>
					</Data>
					<Data type="editbox" name="acqwbillnum" size="29" maxlength="9">
						<xsl:attribute name="display"><xsl:value-of select="$strReferenceToDelivery1"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="WayBillNum"/></xsl:attribute>
					</Data>
					<Data type="editbox" name="acqponum" size="29" maxlength="9">
						<xsl:attribute name="display"><xsl:value-of select="$strReferenceToPO1"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="PONum"/></xsl:attribute>
					</Data>
					<Data type="editbox" name="acqsignauth" size="29" maxlength="63">
						<xsl:attribute name="display"><xsl:value-of select="$strWhoSignedFor3"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="SignAuthority"/></xsl:attribute>
					</Data>
					<Data type="date" name="acqinstalldate">
						<xsl:attribute name="display"><xsl:value-of select="$strInstallationDate1"/></xsl:attribute>
						<xsl:attribute name="value">
							<xsl:call-template name="DisplayDate">
								<xsl:with-param name="dateName"><xsl:value-of select="DateOfInstallation"/></xsl:with-param>
							</xsl:call-template>
						</xsl:attribute>
					</Data>
					<Data type="date" name="acqprchsedate">
						<xsl:attribute name="display"><xsl:value-of select="$strPurchaseDate1"/></xsl:attribute>
						<xsl:attribute name="value">
							<xsl:call-template name="DisplayDate">
								<xsl:with-param name="dateName"><xsl:value-of select="DateOfPurchase"/></xsl:with-param>
							</xsl:call-template>
						</xsl:attribute>
					</Data>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strVendor2"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="/OMA/AssetInfo/OMConfig/Vendor"/></xsl:attribute>
					</Data>
					<Data type="radio" name="omcnfgexpnsd" splcase="true">
						<xsl:attribute name="display"><xsl:value-of select="$strExpensed1"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strYes"/></xsl:attribute>
						<xsl:attribute name="returnvalue">true</xsl:attribute>
						<xsl:if test="/OMA/AssetInfo/OMConfig/Expensed ='true'">
							<xsl:attribute name="state">1</xsl:attribute>
						</xsl:if>
						<ExtraItem type="radio" name="omcnfgexpnsd">
							<xsl:attribute name="value"><xsl:value-of select="$strNo"/></xsl:attribute>
							<xsl:attribute name="returnvalue">false</xsl:attribute>
							<xsl:if test="/OMA/AssetInfo/OMConfig/Expensed ='false'">
								<xsl:attribute name="state">1</xsl:attribute>
							</xsl:if>
						</ExtraItem>
					</Data>
					<Data type="editbox" name="cstctr" size="29" maxlength="63">
						<xsl:attribute name="display"><xsl:value-of select="$strCostCenter2"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="/OMA/AssetInfo/CostCenter/CostCenter"/></xsl:attribute>
					</Data>
					<Data type="hidden" name="acqoid">
						<xsl:attribute name="returnvalue"><xsl:value-of select="@oid"/></xsl:attribute>
					</Data>
					<Data type="hidden" name="omcnfgoid">
						<xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/AssetInfo/OMConfig/@oid"/></xsl:attribute>
					</Data>
					<Data type="hidden" name="cstctroid">
						<xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/AssetInfo/CostCenter/@oid"/></xsl:attribute>
					</Data>
				</ListData>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="Warranty">
		<xsl:variable name="displaytype"><xsl:value-of select="/OMA/Arguments"/></xsl:variable>
		<xsl:if test="$displaytype != 'acquisition'">
			<xsl:choose>
				<xsl:when test="(/OMA/OMAUserRights = '1') or ($displaytype = 'summary') or ($displaytype = '')">
					<Section name="Warranty"><xsl:attribute name="display"><xsl:value-of select="$strWarranty"/></xsl:attribute>
						<ListData>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strDuration"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="Duration"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strUnitType"/></xsl:attribute>
								<xsl:attribute name="value">
									<xsl:choose>
										<xsl:when test="UnitType ='0'"><xsl:value-of select="$strDays"/></xsl:when>
										<xsl:when test="UnitType ='1'"><xsl:value-of select="$strMonths"/></xsl:when>
										<xsl:otherwise><xsl:value-of select="$strOther"/></xsl:otherwise>
									</xsl:choose>
								</xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strEndDate"/></xsl:attribute>
								<xsl:attribute name="value">
									<xsl:call-template name="DisplayDate">
										<xsl:with-param name="dateName"><xsl:value-of select="EndDate"/></xsl:with-param>
									</xsl:call-template>
								</xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strCost"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="Cost"/></xsl:attribute>
							</Data>
						</ListData>
					</Section>
				</xsl:when>
				<xsl:otherwise>
					<ListData>
						<Data type="hidden" name="woid">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@oid"/></xsl:attribute>
						</Data>
						<Data type="editbox" name="wduration" size="29" maxlength="9">
							<xsl:attribute name="display"><xsl:value-of select="$strDuration1"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Duration"/></xsl:attribute>
						</Data>
						<Data type="select" name="wunittype">
							<xsl:attribute name="display"><xsl:value-of select="$strUnitType1"/></xsl:attribute>
							<xsl:choose>
								<xsl:when test="(UnitType ='0') or (UnitType ='1')">
									<Choice>
										<xsl:attribute name="value"><xsl:value-of select="$strDays"/></xsl:attribute>
										<xsl:attribute name="returnvalue">0</xsl:attribute>
										<xsl:if test="UnitType = '0'"><xsl:attribute name="default">true</xsl:attribute>
										</xsl:if>
									</Choice>
									<Choice>
										<xsl:attribute name="value"><xsl:value-of select="$strMonths"/></xsl:attribute>
										<xsl:attribute name="returnvalue">1</xsl:attribute>
										<xsl:if test="UnitType = '1'"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
									</Choice>
								</xsl:when>
								<xsl:otherwise>
									<Choice>
										<xsl:attribute name="value"><xsl:value-of select="$strDays"/></xsl:attribute>
										<xsl:attribute name="returnvalue">0</xsl:attribute>
									</Choice>
									<Choice>
										<xsl:attribute name="value"><xsl:value-of select="$strMonths"/></xsl:attribute>
										<xsl:attribute name="returnvalue">1</xsl:attribute>
									</Choice>
									<Choice>
										<xsl:attribute name="value">Other</xsl:attribute>
										<xsl:attribute name="returnvalue"><xsl:value-of select="UnitType"/></xsl:attribute>
										<xsl:attribute name="default">true</xsl:attribute>
									</Choice>
								</xsl:otherwise>
							</xsl:choose>
						</Data>
						<Data type="date" name="wedate">
							<xsl:attribute name="display"><xsl:value-of select="$strEndDate1"/></xsl:attribute>
							<xsl:attribute name="value">
								<xsl:call-template name="DisplayDate">
									<xsl:with-param name="dateName"><xsl:value-of select="EndDate"/></xsl:with-param>
								</xsl:call-template>
							</xsl:attribute>
						</Data>
						<Data type="editbox" name="wcost" size="29" maxlength="9">
							<xsl:attribute name="display"><xsl:value-of select="$strCost1"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Cost"/></xsl:attribute>
						</Data>
					</ListData>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	<xsl:template match="ExtWarranty">
		<xsl:variable name="displaytype"><xsl:value-of select="/OMA/Arguments"/></xsl:variable>
		<xsl:if test="$displaytype != 'acquisition'">
			<xsl:choose>
				<xsl:when test="(/OMA/OMAUserRights = '1') or ($displaytype = 'summary') or ($displaytype = '')">
					<Section name="ExtWarranty"><xsl:attribute name="display"><xsl:value-of select="$strExtendedWarranty"/></xsl:attribute>
						<ListData>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strCost2"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="Cost"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strProvider2"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="Provider"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strStartDate"/></xsl:attribute>
								<xsl:attribute name="value">
								<xsl:call-template name="DisplayDate">
									<xsl:with-param name="dateName"><xsl:value-of select="StartDate"/></xsl:with-param>
								</xsl:call-template>
								</xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strEndDate2"/></xsl:attribute>
								<xsl:attribute name="value">
								<xsl:call-template name="DisplayDate">
									<xsl:with-param name="dateName"><xsl:value-of select="EndDate"/></xsl:with-param>
								</xsl:call-template>
								</xsl:attribute>
							</Data>
						</ListData>
					</Section>
				</xsl:when>
				<xsl:otherwise>
					<ListData>
						<Data type="editbox" name="extwcost" size="29" maxlength="9"><xsl:attribute name="display"><xsl:value-of select="$strCost3"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Cost"/></xsl:attribute>
						</Data>
						<Data type="editbox" name="extwprovider" size="29" maxlength="63"><xsl:attribute name="display"><xsl:value-of select="$strProvider3"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Provider"/></xsl:attribute>
						</Data>
						<Data type="date" name="extwsdate" state="2"><xsl:attribute name="display"><xsl:value-of select="$strStartDate1"/></xsl:attribute>
							<xsl:attribute name="value">
								<xsl:call-template name="DisplayDate">
									<xsl:with-param name="dateName"><xsl:value-of select="StartDate"/></xsl:with-param>
								</xsl:call-template>
							</xsl:attribute>
						</Data>
						<Data type="date" name="extwedate" state="2"><xsl:attribute name="display"><xsl:value-of select="$strEndDate3"/></xsl:attribute>
							<xsl:attribute name="value">
								<xsl:call-template name="DisplayDate">
									<xsl:with-param name="dateName"><xsl:value-of select="EndDate"/></xsl:with-param>
								</xsl:call-template>
							</xsl:attribute>
						</Data>
						<Data type="hidden" name="extwoid">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@oid"/></xsl:attribute>
						</Data>
					</ListData>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	<xsl:template name="OwnerInfo">
		<Section name="owner"><xsl:attribute name="display"><xsl:value-of select="$strOwner"/></xsl:attribute>
			<ListData>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strType1"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:call-template name="OwnerType">
							<xsl:with-param name="type"><xsl:value-of select="/OMA/AssetInfo/OwnerShipCodes/Type"/></xsl:with-param>
						</xsl:call-template>
					</xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strOwnerName1"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="/OMA/AssetInfo/CorporateOwner/OwnerName"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strInsuranceCompany1"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="/OMA/AssetInfo/Insurance/InsuranceCompany"/></xsl:attribute>
				</Data>
			</ListData>
		</Section>
	</xsl:template>
	<xsl:template match="Owner">
		<xsl:variable name="displaytype"><xsl:value-of select="/OMA/Arguments"/></xsl:variable>
			<xsl:choose>
				<xsl:when test="(/OMA/OMAUserRights = '1') or ($displaytype = 'summary') or ($displaytype = '')">
					<Section name="Owner"><xsl:attribute name="display"><xsl:value-of select="$strOwner1"/></xsl:attribute>
						<ListData>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strType2"/></xsl:attribute>
								<xsl:attribute name="value">
									<xsl:call-template name="OwnerType">
										<xsl:with-param name="type"><xsl:value-of select="OwnerShipCodes/Type"/></xsl:with-param>
									</xsl:call-template>
								</xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strOwnerName2"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="CorporateOwner/OwnerName"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strInsuranceCompany2"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="Insurance/InsuranceCompany"/></xsl:attribute>
							</Data>
						</ListData>
					</Section>
				</xsl:when>
				<xsl:otherwise>
					<ListData>
						<Data type="select" name="ownershiptype">
							<xsl:attribute name="display"><xsl:value-of select="$strType3"/></xsl:attribute>
							<xsl:call-template name="OwnerType">
								<xsl:with-param name="type"><xsl:value-of select="OwnerShipCodes/Type"/></xsl:with-param>
								<xsl:with-param name="edit">true</xsl:with-param>
							</xsl:call-template>
						</Data>
						<Data type="editbox" name="corpownername" size="29" maxlength="63">
							<xsl:attribute name="display"><xsl:value-of select="$strOwnerName3"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="CorporateOwner/OwnerName"/></xsl:attribute>
						</Data>
						<Data type="editbox" name="insurancecomp"  size="29" maxlength="63">
							<xsl:attribute name="display"><xsl:value-of select="$strInsuranceCompany3"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Insurance/InsuranceCompany"/></xsl:attribute>
						</Data>
						<Data type="hidden" name="ownershipoid">
							<xsl:attribute name="returnvalue"><xsl:value-of select="OwnerShipCodes/@oid"/></xsl:attribute>
						</Data>
						<Data type="hidden" name="corpowneroid">
							<xsl:attribute name="returnvalue"><xsl:value-of select="CorporateOwner/@oid"/></xsl:attribute>
						</Data>
						<Data type="hidden" name="insuranceoid">
							<xsl:attribute name="returnvalue"><xsl:value-of select="Insurance/@oid"/></xsl:attribute>
						</Data>
						<Data type="hidden" name="chassisprops1oid">
							<xsl:attribute name="returnvalue"><xsl:value-of select="ChassisInfo/ChassisProps1/@oid"/></xsl:attribute>
						</Data>
					</ListData>
					<HiddenTable>
						<Data name="oldownershiptype">
							<xsl:attribute name="returnvalue"><xsl:value-of select="OwnerShipCodes/Type"/></xsl:attribute>
						</Data>
						<Data name="oldcorpownername">
							<xsl:attribute name="returnvalue"><xsl:value-of select="CorporateOwner/OwnerName"/></xsl:attribute>
						</Data>
						<Data name="oldinsurancecomp">
							<xsl:attribute name="returnvalue"><xsl:value-of select="Insurance/InsuranceCompany"/></xsl:attribute>
						</Data>
					</HiddenTable>
				</xsl:otherwise>
			</xsl:choose>
	</xsl:template>
	<xsl:template match="Depreciation">
		<xsl:variable name="displaytype"><xsl:value-of select="/OMA/Arguments"/></xsl:variable>
		<xsl:if test="$displaytype != 'acquisition'">
			<xsl:choose>
				<xsl:when test="(/OMA/OMAUserRights = '1') or ($displaytype = 'summary') or ($displaytype = '')">
					<Section name="Depreciation"><xsl:attribute name="display"><xsl:value-of select="$strDepreciation2"/></xsl:attribute>
						<ListData>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strMethod1"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="Method"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strDuration2"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="Duration"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strDurationUnitType"/></xsl:attribute>
								<xsl:attribute name="value">
									<xsl:call-template name="DurationUnitType">
										<xsl:with-param name="unit"><xsl:value-of select="Unit"/></xsl:with-param>
									</xsl:call-template>
								</xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strPercentage"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="Percentage"/></xsl:attribute>
							</Data>
						</ListData>
					</Section>
				</xsl:when>
				<xsl:otherwise>
					<ListData>
						<Data type="hidden" name="deproid">
								<xsl:attribute name="returnvalue"><xsl:value-of select="@oid"/></xsl:attribute>
						</Data>
						<Data type="editbox" name="deprmethod"  size="29" maxlength="63">
							<xsl:attribute name="display"><xsl:value-of select="$strMethod2"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Method"/></xsl:attribute>
						</Data>
						<Data type="editbox" name="deprduration"  size="29" maxlength="9">
							<xsl:attribute name="display"><xsl:value-of select="$strDuration3"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Duration"/></xsl:attribute>
						</Data>
						<Data type="select" name="depcdutype">
							<xsl:attribute name="display"><xsl:value-of select="$strDurationUnitType1"/></xsl:attribute>
							<xsl:call-template name="DurationUnitType">
								<xsl:with-param name="unit"><xsl:value-of select="Unit"/></xsl:with-param>
								<xsl:with-param name="edit">true</xsl:with-param>
							</xsl:call-template>
						</Data>
						<Data type="editbox" name="deprpercent"  size="29" maxlength="9">
							<xsl:attribute name="display"><xsl:value-of select="$strPercentage1"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Percentage"/></xsl:attribute>
						</Data>
					</ListData>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	<xsl:template match="SupportInfo">
		<xsl:variable name="displaytype"><xsl:value-of select="/OMA/Arguments"/></xsl:variable>
		<xsl:if test="$displaytype != 'acquisition'">
			<xsl:choose>
				<xsl:when test="(/OMA/OMAUserRights = '1') or ($displaytype = 'summary') or ($displaytype = '')">
					<Section name="SupportInfo"><xsl:attribute name="display"><xsl:value-of select="$strSupport"/></xsl:attribute>
						<ListData>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strOutsourced"/></xsl:attribute>
								<xsl:choose>
									<xsl:when test="Outsourced='true'">
										<xsl:attribute name="value"><xsl:value-of select="$strYes"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="value"><xsl:value-of select="$strNo"/></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strType4"/></xsl:attribute>
								<xsl:attribute name="value">
									<xsl:call-template name="SupportType">
										<xsl:with-param name="type"><xsl:value-of select="Type"/></xsl:with-param>
									</xsl:call-template>
								</xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strHelpDesk1"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="HelpDesk"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strAutomaticFix1"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="AutomaticFix"/></xsl:attribute>
							</Data>
						</ListData>
					</Section>
				</xsl:when>
				<xsl:otherwise>
					<ListData>
						<Data type="radio" name="supoutsrc" splcase="true">
							<xsl:attribute name="display"><xsl:value-of select="$strOutsourced1"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strYes"/></xsl:attribute>
							<xsl:attribute name="returnvalue">true</xsl:attribute>
							<xsl:if test="Outsourced ='true'">
								<xsl:attribute name="state">1</xsl:attribute>
							</xsl:if>
							<ExtraItem type="radio" name="supoutsrc">
								<xsl:attribute name="value"><xsl:value-of select="$strNo"/></xsl:attribute>
								<xsl:attribute name="returnvalue">false</xsl:attribute>
								<xsl:if test="Outsourced ='false'">
									<xsl:attribute name="state">1</xsl:attribute>
								</xsl:if>
							</ExtraItem>
						</Data>
						<Data name="suptype" type="select">
							<xsl:attribute name="display"><xsl:value-of select="$strType5"/></xsl:attribute>
							<xsl:call-template name="SupportType">
								<xsl:with-param name="type"><xsl:value-of select="Type"/></xsl:with-param>
								<xsl:with-param name="edit">true</xsl:with-param>
							</xsl:call-template>
						</Data>
						<Data name="suphlpdesk" type="editbox" size="29" maxlength="63">
							<xsl:attribute name="display"><xsl:value-of select="$strHelpDesk2"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="HelpDesk"/></xsl:attribute>
						</Data>
						<Data name="supautofix" type="editbox" size="29" maxlength="63">
							<xsl:attribute name="display"><xsl:value-of select="$strAutomaticFix2"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="AutomaticFix"/></xsl:attribute>
						</Data>
						<Data type="hidden" name="supoid">
								<xsl:attribute name="returnvalue"><xsl:value-of select="@oid"/></xsl:attribute>
						</Data>
					</ListData>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	<xsl:template match="Outsourcing">
		<xsl:variable name="displaytype"><xsl:value-of select="/OMA/Arguments"/></xsl:variable>
		<xsl:if test="$displaytype != 'acquisition'">
			<xsl:choose>
				<xsl:when test="(/OMA/OMAUserRights = '1') or ($displaytype = 'summary') or ($displaytype = '')">
					<Section name="Outsourcing"><xsl:attribute name="display"><xsl:value-of select="$strOutSource"/></xsl:attribute>
						<ListData>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strProblemComponent1"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="SysComponent"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strServiceFee1"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="ServiceFee"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strWhoSignedFor4"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="SignAuthority"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strProviderFee1"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="ProviderFee"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strSLALevel1"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="Levels"/></xsl:attribute>
							</Data>
						</ListData>
					</Section>
				</xsl:when>
				<xsl:otherwise>
				<ListData>
						<Data type="editbox" name="outsprobcomp" size="29" maxlength="63">
							<xsl:attribute name="display"><xsl:value-of select="$strProblemComponent2"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="SysComponent"/></xsl:attribute>
						</Data>
						<Data type="editbox" name="outsservfee" size="29" maxlength="63">
							<xsl:attribute name="display"><xsl:value-of select="$strServiceFee2"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="ServiceFee"/></xsl:attribute>
						</Data>
						<Data type="editbox" name="outssigna" size="29" maxlength="63">
							<xsl:attribute name="display"><xsl:value-of select="$strWhoSignedFor5"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="SignAuthority"/></xsl:attribute>
						</Data>
						<Data type="editbox" name="outsprovfee" size="29" maxlength="63">
							<xsl:attribute name="display"><xsl:value-of select="$strProviderFee2"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="ProviderFee"/></xsl:attribute>
						</Data>
						<Data type="editbox" name="outsslalvl" size="29" maxlength="63">
							<xsl:attribute name="display"><xsl:value-of select="$strSLALevel2"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Levels"/></xsl:attribute>
						</Data>
						<Data type="hidden" name="outsoid">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@oid"/></xsl:attribute>
						</Data>
					</ListData>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	<xsl:template match="ServiceContract">
		<xsl:variable name="displaytype"><xsl:value-of select="/OMA/Arguments"/></xsl:variable>
		<xsl:if test="$displaytype != 'acquisition'">
			<xsl:choose>
				<xsl:when test="(/OMA/OMAUserRights = '1') or ($displaytype = 'summary') or ($displaytype = '')">
					<Section name="Service Contract"><xsl:attribute name="display"><xsl:value-of select="$strServiceContract2"/></xsl:attribute>
						<ListData>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strRenewed"/></xsl:attribute>
								<xsl:choose>
									<xsl:when test="Renewed='true'">
										<xsl:attribute name="value"><xsl:value-of select="$strYes"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="value"><xsl:value-of select="$strNo"/></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strType6"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="Type"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strVendor3"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="Vendor"/></xsl:attribute>
							</Data>
						</ListData>
					</Section>
				</xsl:when>
				<xsl:otherwise>
					<ListData >
						<Data type="radio" name="srvcntrenewed" splcase="true">
							<xsl:attribute name="display"><xsl:value-of select="$strRenewed1"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strYes"/></xsl:attribute>
							<xsl:attribute name="returnvalue">true</xsl:attribute>
							<xsl:if test="Renewed ='true'">
								<xsl:attribute name="state">1</xsl:attribute>
							</xsl:if>
							<ExtraItem type="radio" name="srvcntrenewed">
								<xsl:attribute name="value"><xsl:value-of select="$strNo"/></xsl:attribute>
								<xsl:attribute name="returnvalue">false</xsl:attribute>
								<xsl:if test="Renewed ='false'">
									<xsl:attribute name="state">1</xsl:attribute>
								</xsl:if>
							</ExtraItem>
						</Data>
						<Data name="srvcnttype" type="editbox"  size="29" maxlength="63">
							<xsl:attribute name="display"><xsl:value-of select="$strType7"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Type"/></xsl:attribute>
						</Data>
						<Data name="srvcntvendor" type="editbox" size="29" maxlength="63">
							<xsl:attribute name="display"><xsl:value-of select="$strVendor4"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Vendor"/></xsl:attribute>
						</Data>
						<Data type="hidden" name="servcroid">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@oid"/></xsl:attribute>
						</Data>
					</ListData>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	<xsl:template match="LeaseInfo">
		<xsl:variable name="displaytype"><xsl:value-of select="/OMA/Arguments"/></xsl:variable>
		<xsl:if test="$displaytype != 'acquisition'">
			<xsl:choose>
				<xsl:when test="(/OMA/OMAUserRights = '1') or ($displaytype = 'summary') or ($displaytype = '')">
					<Section name="LeaseInfo"><xsl:attribute name="display"><xsl:value-of select="$strLease"/></xsl:attribute>
						<ListData>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strMultipleSchedules"/></xsl:attribute>
								<xsl:choose>
									<xsl:when test="IsMultiSchedules='true'">
										<xsl:attribute name="value"><xsl:value-of select="$strYes"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="value"><xsl:value-of select="$strNo"/></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strBuyoutAmount"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="BuyoutAmt"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strRateFactor"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="RateFactor"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strEndDate4"/></xsl:attribute>
								<xsl:attribute name="value">
								<xsl:call-template name="DisplayDate">
									<xsl:with-param name="dateName"><xsl:value-of select="EndDate"/></xsl:with-param>
								</xsl:call-template>
								</xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strFairMarketValue"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="FairMarketVal"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strLessor1"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="Lessor"/></xsl:attribute>
							</Data>
						</ListData>
					</Section>
				</xsl:when>
				<xsl:otherwise>
					<ListData>
						<Data type="radio" name="leasemschd" splcase="true">
							<xsl:attribute name="display"><xsl:value-of select="$strMultipleSchedules1"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strYes"/></xsl:attribute>
							<xsl:attribute name="returnvalue">true</xsl:attribute>
							<xsl:if test="IsMultiSchedules ='true'">
								<xsl:attribute name="state">1</xsl:attribute>
							</xsl:if>
							<ExtraItem type="radio" name="leasemschd">
								<xsl:attribute name="value"><xsl:value-of select="$strNo"/></xsl:attribute>
								<xsl:attribute name="returnvalue">false</xsl:attribute>
								<xsl:if test="IsMultiSchedules ='false'">
									<xsl:attribute name="state">1</xsl:attribute>
								</xsl:if>
							</ExtraItem>
						</Data>
						<Data type="editbox" name="leasebyoamt" size="29" maxlength="9">
							<xsl:attribute name="display"><xsl:value-of select="$strBuyoutAmount1"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="BuyoutAmt"/></xsl:attribute>
						</Data>
						<Data type="editbox" name="leasertfact" size="29" maxlength="9">
							<xsl:attribute name="display"><xsl:value-of select="$strRateFactor1"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="RateFactor"/></xsl:attribute>
						</Data>
						<Data type="date" name="leaseedate">
							<xsl:attribute name="display"><xsl:value-of select="$strEndDate5"/></xsl:attribute>
							<xsl:attribute name="value">
								<xsl:call-template name="DisplayDate">
									<xsl:with-param name="dateName"><xsl:value-of select="EndDate"/></xsl:with-param>
								</xsl:call-template>
							</xsl:attribute>
						</Data>
						<Data type="editbox" name="leasefrmrktval" size="29" maxlength="9">
							<xsl:attribute name="display"><xsl:value-of select="$strFairMarketValue1"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="FairMarketVal"/></xsl:attribute>
						</Data>
						<Data type="editbox" name="leaselessor" size="29" maxlength="63">
							<xsl:attribute name="display"><xsl:value-of select="$strLessor2"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Lessor"/></xsl:attribute>
						</Data>
						<Data type="hidden" name="leaseoid">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@oid"/></xsl:attribute>
						</Data>
					</ListData>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	<xsl:template match="MaintInfo">
		<xsl:variable name="displaytype"><xsl:value-of select="/OMA/Arguments"/></xsl:variable>
		<xsl:if test="$displaytype != 'acquisition'">
			<xsl:choose>
				<xsl:when test="(/OMA/OMAUserRights = '1') or ($displaytype = 'summary') or ($displaytype = '')">
					<Section name="MaintInfo"><xsl:attribute name="display"><xsl:value-of select="$strMaintenance"/></xsl:attribute>
						<ListData>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strProvider4"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="Provider"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strRestrictions1"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="Restrictions"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strStartDate2"/></xsl:attribute>
								<xsl:attribute name="value">
								<xsl:call-template name="DisplayDate">
									<xsl:with-param name="dateName"><xsl:value-of select="StartDate"/></xsl:with-param>
								</xsl:call-template>
								</xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strEndDate6"/></xsl:attribute>
								<xsl:attribute name="value">
								<xsl:call-template name="DisplayDate">
									<xsl:with-param name="dateName"><xsl:value-of select="EndDate"/></xsl:with-param>
								</xsl:call-template>
								</xsl:attribute>
							</Data>
						</ListData>
					</Section>
				</xsl:when>
				<xsl:otherwise>
					<ListData>
						<Data type="editbox" name="maintprovider" size="29" maxlength="63">
							<xsl:attribute name="display"><xsl:value-of select="$strProvider5"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Provider"/></xsl:attribute>
						</Data>
						<Data type="editbox" name="maintrest" size="29" maxlength="63">
							<xsl:attribute name="display"><xsl:value-of select="$strRestrictions2"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Restrictions"/></xsl:attribute>
						</Data>
						<Data type="date" name="maintsdate">
							<xsl:attribute name="display"><xsl:value-of select="$strStartDate3"/></xsl:attribute>
							<xsl:attribute name="value">
							<xsl:call-template name="DisplayDate">
								<xsl:with-param name="dateName"><xsl:value-of select="StartDate"/></xsl:with-param>
							</xsl:call-template>
							</xsl:attribute>
						</Data>
						<Data type="date" name="maintedate">
							<xsl:attribute name="display"><xsl:value-of select="$strEndDate7"/></xsl:attribute>
							<xsl:attribute name="value">
							<xsl:call-template name="DisplayDate">
								<xsl:with-param name="dateName"><xsl:value-of select="EndDate"/></xsl:with-param>
							</xsl:call-template>
							</xsl:attribute>
						</Data>
						<Data type="hidden" name="maintoid">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@oid"/></xsl:attribute>
						</Data>
					</ListData>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	<xsl:template match="SystemInfo">
		<xsl:variable name="displaytype"><xsl:value-of select="/OMA/Arguments"/></xsl:variable>
		<xsl:if test="$displaytype != 'acquisition'">
			<xsl:choose>
				<xsl:when test="(/OMA/OMAUserRights = '1') or ($displaytype = 'summary') or ($displaytype = '')">
					<Section name="SystemInfo"><xsl:attribute name="display"><xsl:value-of select="$strSystem"/></xsl:attribute>
						<ListData>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strSystemBootupTime"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="SystemBootupTime"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strSystemTime"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="SystemTime"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strSystemName"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="SystemName"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strSystemLocation1"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="SystemLocation"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strPrimaryUserName1"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="PrimaryUserName"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strPrimaryUserTelephone"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="PrimaryUserPhone"/></xsl:attribute>
							</Data>
						</ListData>
					</Section>
				</xsl:when>
				<xsl:otherwise>
					<ListData>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strSystemBootupTime1"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="SystemBootupTime"/></xsl:attribute>
						</Data>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strSystemTime1"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="SystemTime"/></xsl:attribute>
						</Data>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strSystemName1"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="SystemName"/></xsl:attribute>
						</Data>
						<Data type="editbox" name="syslocation" size="29" maxlength="63">
							<xsl:attribute name="display"><xsl:value-of select="$strSystemLocation2"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="SystemLocation"/></xsl:attribute>
						</Data>
						<Data type="editbox" name="syspusername" size="29" maxlength="63">
							<xsl:attribute name="display"><xsl:value-of select="$strPrimaryUserName2"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="PrimaryUserName"/></xsl:attribute>
						</Data>
						<Data type="editbox" name="syspuserphone" size="29" maxlength="63">
							<xsl:attribute name="display"><xsl:value-of select="$strPrimaryUserTelephone1"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="PrimaryUserPhone"/></xsl:attribute>
						</Data>
						<Data type="hidden" name="sysoid">
							<xsl:attribute name="returnvalue"><xsl:value-of select="@oid"/></xsl:attribute>
						</Data>
					</ListData>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	<xsl:template name="DurationUnitType">
		<xsl:param name="unit"/>
		<xsl:param name="edit"/>
		<xsl:choose>
			<xsl:when test="$edit = 'true'">
				<Choice returnvalue="0">
					<xsl:attribute name="value"><xsl:value-of select="$strMonths1"/></xsl:attribute>
					<xsl:if test="$unit = '0'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="1">
					<xsl:attribute name="value"><xsl:value-of select="$strYears"/></xsl:attribute>
					<xsl:if test="$unit = '1'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$unit = '0'"><xsl:value-of select="$strMonths2"/></xsl:when>
					<xsl:when test="$unit = '1'"><xsl:value-of select="$strYears1"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strNoValue"/></xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="SupportType">
		<xsl:param name="type"/>
		<xsl:param name="edit"/>
			<xsl:choose>
				<xsl:when test="$edit = 'true'">
					<xsl:choose>
						<xsl:when test="($type = '0') or ($type = '1')">
							<Choice returnvalue="0">
								<xsl:attribute name="value"><xsl:value-of select="$strNetwork"/></xsl:attribute>
								<xsl:if test="$type = '0'"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
							</Choice>
							<Choice  returnvalue="1">
								<xsl:attribute name="value"><xsl:value-of select="$strStorage"/></xsl:attribute>
								<xsl:if test="$type = '1'"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
							</Choice>
						</xsl:when>
						<xsl:otherwise>
							<Choice default="true">
								<xsl:attribute name="value"><xsl:value-of select="$type"/></xsl:attribute>
								<xsl:attribute name="returnvalue"><xsl:value-of select="$type"/></xsl:attribute>
							</Choice>
							<Choice  returnvalue="0">
								<xsl:attribute name="value"><xsl:value-of select="$strNetwork1"/></xsl:attribute>
							</Choice>
							<Choice  returnvalue="1">
								<xsl:attribute name="value"><xsl:value-of select="$strStorage1"/></xsl:attribute>
							</Choice>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="$type = '0'"><xsl:value-of select="$strNetwork2"/></xsl:when>
						<xsl:when test="$type = '1'"><xsl:value-of select="$strStorage2"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$type"/></xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
	</xsl:template>
	<xsl:template name="OwnerType">
		<xsl:param name="type"/>
		<xsl:param name="edit"/>
		<xsl:choose>
			<xsl:when test="$edit = 'true'">
				<xsl:choose>
					<xsl:when test="($type = '0') or ($type = '1') or ($type = '2') or ($type = '3') or ($type = '4')">
						<Choice returnvalue="0">
							<xsl:attribute name="value"><xsl:value-of select="$strOwned"/></xsl:attribute>
							<xsl:if test="$type = '0'"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
						</Choice>
						<Choice returnvalue="1">
							<xsl:attribute name="value"><xsl:value-of select="$strLeased"/></xsl:attribute>
							<xsl:if test="$type = '1'"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
						</Choice>
						<Choice returnvalue="2">
							<xsl:attribute name="value"><xsl:value-of select="$strRented"/></xsl:attribute>
							<xsl:if test="$type = '2'"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
						</Choice>
						<Choice returnvalue="3">
							<xsl:attribute name="value"><xsl:value-of select="$strOffLease"/></xsl:attribute>
							<xsl:if test="$type = '3'"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
						</Choice>
						<Choice returnvalue="4">
							<xsl:attribute name="value"><xsl:value-of select="$strTransfer"/></xsl:attribute>
							<xsl:if test="$type = '4'"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
						</Choice>
					</xsl:when>
					<xsl:otherwise>
						<Choice default="true">
							<xsl:attribute name="value"><xsl:value-of select="$type"/></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="$type"/></xsl:attribute>
						</Choice>
						<Choice returnvalue="0">
							<xsl:attribute name="value"><xsl:value-of select="$strOwned1"/></xsl:attribute>
						</Choice>
						<Choice returnvalue="1">
							<xsl:attribute name="value"><xsl:value-of select="$strLeased1"/></xsl:attribute>
						</Choice>
						<Choice returnvalue="2">
							<xsl:attribute name="value"><xsl:value-of select="$strRented1"/></xsl:attribute>
						</Choice>
						<Choice returnvalue="3">
							<xsl:attribute name="value"><xsl:value-of select="$strOffLease"/></xsl:attribute>
						</Choice>
						<Choice returnvalue="4">
							<xsl:attribute name="value"><xsl:value-of select="$strTransfer"/></xsl:attribute>
						</Choice>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$type = '0'"><xsl:value-of select="$strOwned2"/></xsl:when>
					<xsl:when test="$type = '1'"><xsl:value-of select="$strLeased2"/></xsl:when>
					<xsl:when test="$type = '2'"><xsl:value-of select="$strRented2"/></xsl:when>
					<xsl:when test="$type = '3'"><xsl:value-of select="$strOffLease"/></xsl:when>
					<xsl:when test="$type = '4'"><xsl:value-of select="$strTransfer"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$type"/></xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="SystemClass">
		<xsl:param name="class"/>
		<xsl:param name="edit"/>
		<xsl:choose>
			<xsl:when test="$edit = 'true'">
				<Choice>
					<xsl:attribute name="value"><xsl:value-of select="$strWorkstation"/></xsl:attribute>
					<xsl:attribute name="returnvalue">3</xsl:attribute>
					<xsl:if test="$class = '3'"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
				</Choice>
				<Choice>
					<xsl:attribute name="value"><xsl:value-of select="$strServer"/></xsl:attribute>
					<xsl:attribute name="returnvalue">4</xsl:attribute>
					<xsl:if test="$class = '4'"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
				</Choice>
				<Choice>
					<xsl:attribute name="value"><xsl:value-of select="$strDesktop"/></xsl:attribute>
					<xsl:attribute name="returnvalue">5</xsl:attribute>
					<xsl:if test="$class = '5'"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
				</Choice>
				<Choice>
					<xsl:attribute name="value"><xsl:value-of select="$strPortable"/></xsl:attribute>
					<xsl:attribute name="returnvalue">6</xsl:attribute>
					<xsl:if test="$class = '6'"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
				</Choice>
				<Choice>
					<xsl:attribute name="value"><xsl:value-of select="$strNetPC"/></xsl:attribute>
					<xsl:attribute name="returnvalue">7</xsl:attribute>
					<xsl:if test="$class = '7'"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
				</Choice>
				<Choice>
					<xsl:attribute name="value"><xsl:value-of select="$strStorage3"/></xsl:attribute>
					<xsl:attribute name="returnvalue">8</xsl:attribute>
					<xsl:if test="$class = '8'"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
				</Choice>
				<Choice>
					<xsl:attribute name="value"><xsl:value-of select="$strReserved"/></xsl:attribute>
					<xsl:attribute name="returnvalue">0</xsl:attribute>
					<xsl:if test="$class = '0'"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
				</Choice>
				<Choice>
					<xsl:attribute name="value"><xsl:value-of select="$strOther1"/></xsl:attribute>
					<xsl:attribute name="returnvalue">1</xsl:attribute>
					<xsl:if test="$class = '1'"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
				</Choice>
				<Choice>
					<xsl:attribute name="value"><xsl:value-of select="$strNoValue1"/></xsl:attribute>
					<xsl:attribute name="returnvalue">2</xsl:attribute>
					<xsl:if test="($class = '2') or ($class > '8') or ('0' > $class)"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
				</Choice>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$class = '0'"><xsl:value-of select="$strReserved1"/></xsl:when>
					<xsl:when test="$class = '1'"><xsl:value-of select="$strOther2"/></xsl:when>
					<xsl:when test="$class = '3'"><xsl:value-of select="$strWorkstation1"/></xsl:when>
					<xsl:when test="$class = '4'"><xsl:value-of select="$strServer1"/></xsl:when>
					<xsl:when test="$class = '5'"><xsl:value-of select="$strDesktop1"/></xsl:when>
					<xsl:when test="$class = '6'"><xsl:value-of select="$strPortable1"/></xsl:when>
					<xsl:when test="$class = '7'"><xsl:value-of select="$strNetPC1"/></xsl:when>
					<xsl:when test="$class = '8'"><xsl:value-of select="$strStorage4"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strNoValue"/></xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:param name="mssg"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'"><xsl:value-of select="$strCommandUnsuccessful"/></xsl:when>
			<xsl:when test="$status = '0'"><xsl:value-of select="$strCommandSuccessful"/></xsl:when>
			<xsl:when test="$status = '1'"><xsl:value-of select="$strCommandNotImplemented"/></xsl:when>
			<xsl:when test="$status = '2'"><xsl:value-of select="$strBadCommand"/></xsl:when>
			<xsl:when test="$status = '3'"><xsl:value-of select="$strCommandTimeout"/></xsl:when>
			<xsl:when test="$status = '4'"><xsl:value-of select="$strCommandCancelled"/></xsl:when>
			<xsl:when test="$status = '5'"><xsl:value-of select="$strCommandAborted"/></xsl:when>
			<xsl:when test="$status = '6'"><xsl:value-of select="$strCommandPending"/></xsl:when>
			<xsl:when test="$status = '7'"><xsl:value-of select="$strNoSuchDevice"/></xsl:when>
			<xsl:when test="$status = '8'"><xsl:value-of select="$strDeviceBusy"/></xsl:when>
			<xsl:when test="$status = '9'"><xsl:value-of select="$strBadDevice"/></xsl:when>
			<xsl:when test="$status = '10'"><xsl:value-of select="$strSpuriousInterrupt"/></xsl:when>
			<xsl:when test="$status = '11'"><xsl:value-of select="$strResourceLocked"/></xsl:when>
			<xsl:when test="$status = '12'"><xsl:value-of select="$strInvalidIndex"/></xsl:when>
			<xsl:when test="$status = '13'"><xsl:value-of select="$strSMBError"/></xsl:when>
			<xsl:when test="$status = '14'"><xsl:value-of select="$strDataRequestedIs"/></xsl:when>
			<xsl:when test="$status = '15'"><xsl:value-of select="$strDataRequestedIs1"/></xsl:when>
			<xsl:when test="$status = '16'"><xsl:value-of select="$strDataRequestedIs2"/></xsl:when>
			<xsl:when test="$status = '17'"><xsl:value-of select="$strDeviceNotYet"/></xsl:when>
			<xsl:when test="$status = '18'"><xsl:value-of select="$strDeviceDoesNot"/></xsl:when>
			<xsl:when test="$status = '19'"><xsl:value-of select="$strDeviceOutOf"/></xsl:when>
			<xsl:when test="$status = '20'"><xsl:value-of select="$strDeviceAlreadyExists"/></xsl:when>
			<xsl:when test="$status = '256'"><xsl:value-of select="$strAssetInfoObject"/></xsl:when>
			<xsl:when test="$status = '257'"><xsl:value-of select="$strAssetInfoObject1"/></xsl:when>
			<xsl:when test="$status = '258'"><xsl:value-of select="$strAssetInfoObject2"/></xsl:when>
			<xsl:when test="$status = '260'"><xsl:value-of select="$strINIFileNot"/></xsl:when>
			<xsl:when test="$status = '261'"><xsl:value-of select="$strINIMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '262'"><xsl:value-of select="$strINISectionDoes"/></xsl:when>
			<xsl:when test="$status = '263'"><xsl:value-of select="$strINIKeyDoes"/></xsl:when>
			<xsl:when test="$status = '264'"><xsl:value-of select="$strINIValueMalformed"/></xsl:when>
			<xsl:when test="$status = '270'"><xsl:value-of select="$strInsufficientAccessRights"/></xsl:when>
			<xsl:when test="$status = '271'"><xsl:value-of select="$strInvalidParameterName"/><xsl:value-of select="$mssg"/></xsl:when>
			<xsl:when test="$status = '272'"><xsl:value-of select="$strOutOfMemory"/></xsl:when>
			<xsl:when test="$status = '280'"><xsl:value-of select="$strXMLFileNot"/></xsl:when>
			<xsl:when test="$status = '281'"><xsl:value-of select="$strXMLMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '282'"><xsl:value-of select="$strXMLNodeDoes"/></xsl:when>
			<xsl:when test="$status = '283'"><xsl:value-of select="$strXMLValueMalformed"/></xsl:when>
			<xsl:otherwise>SMStatus: <xsl:value-of select="$status"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="*"/>

	<xsl:template name="DisplayDate">
		<xsl:param name="dateName"/>
		<xsl:choose>
			<xsl:when test="($dateName= '-1') or ($dateName='0')">
			     <xsl:text>Please set the value</xsl:text>
			</xsl:when>
			<xsl:otherwise><xsl:value-of select="$dateName"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
