<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
  <xsl:template match="/EventLog">
		<xsl:variable name="varSortKey"><xsl:value-of select="/EventLog/SortKey"/></xsl:variable>
		<xsl:variable name="varOrder"><xsl:value-of select="/EventLog/Order"/></xsl:variable>
		<xsl:variable name="varDataType"><xsl:value-of select="/EventLog/DataType"/></xsl:variable>
		<DataArea onLoad="true">
			<script language="javascript">
				function clearLog()
				{
					document.dataarea.action=top.gnv.appendVID(&apos;/servlet/SubmitForm?plugin=com.dell.hip.webplugins.ClearAlertLogWebPlugin&apos;);
					//[pp 01/0804 - DFCT102605 Prompt user to confirm before deleting log
					if(confirm(&apos;<xsl:value-of select="$strAreYouSure"/>&apos;))
						document.dataarea.submit();
				}
				function initializationRoutine()
				{
					document.getElementById(&quot;prompttext&quot;).innerHTML= &quot;<xsl:value-of select="$strAlertLogContains"/>&quot;;
				}
				function saveLog()
				{
					document.dataarea.action=top.gnv.appendVID(&apos;/servlet/SubmitForm?plugin=com.dell.oma.webplugins.SaveLogWebPlugin&apos;);
			
					// DFCT93265, Clicking on the &quot;Save As&quot; button second time and performing either save or cancel, resulted an Abend on all flavous of Netware.
                                			// The following single line has been added for fixing the problem.
		
					document.getElementById(&quot;pageCode&quot;).value = &quot;&quot;;
					
					document.getElementById(&quot;pageCode&quot;).value = document.getElementsByTagName(&quot;HTML&quot;)[0].innerHTML;
					document.dataarea.submit();
				}
				
                function showEventHint(eventHintFile)
                {
                    if (checkModal () == false)
                    {
                        var detailWin; 
                        var hostURL;
                        
                        eventHintFile = "https://" + location.host + "/" + eventHintFile;   
                        detailWin = window.open(eventHintFile, 0, config='height=450,width=630,scrollbars=yes,toolbar=no,menubar=no,resizable=yes,location=no,directories=no,status=no');

                        // this brings the window to the front.
                        detailWin.focus();
                    }
                }
                
                function checkModal()
                {
	                var modal = false;

	                try
	                {
		                modal = window.top.body.frames["ct"].g_bModal;
	                }
	                catch(e)
	                {
		                try 
		                {
			                modal = window.top.body.g_bModal;
		                }	
		                catch(e) 
		                {

		                }
	                }
	                return modal;
                }
			</script>
			<Header><xsl:value-of select="$strPageHeader"/></Header>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strAlertLog"/></xsl:attribute>
			</PageTitle>
			<PromptText><xsl:value-of select="$strAlertLogContains1"/></PromptText>
				<CustomButton>
					<xsl:if test="(/EventLog/OMAUserRights = '7')">
						<Data name="Clear"><xsl:attribute name="display"><xsl:value-of 	select="$strClearLog"/></xsl:attribute>
							<xsl:attribute name="href">javascript:clearLog()</xsl:attribute>
							<xsl:attribute name="formSubmit">true</xsl:attribute>
						</Data>
					</xsl:if>
					<xsl:if test="(/EventLog/OMAUserRights = '7') or (/EventLog/OMAUserRights = '3')">
						<Data name="Save"><xsl:attribute name="display"><xsl:value-of 	select="$strSaveAs"/></xsl:attribute>
							<xsl:attribute name="href">javascript:saveLog()</xsl:attribute>
							<xsl:attribute name="formSubmit">true</xsl:attribute>
						</Data>
					</xsl:if>
					<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
<xsl:attribute name="href"><xsl:text>/servlet/DataArea?plugin=com.dell.oma.webplugins.AlertLogWebPlugin&amp;refresh=true&amp;newsortkey=</xsl:text><xsl:value-of select="$varSortKey"/><xsl:text>&amp;oldsortkey=</xsl:text><xsl:value-of select="$varSortKey"/><xsl:text>&amp;order=</xsl:text><xsl:value-of select="$varOrder"/></xsl:attribute>
					</Data>
				</CustomButton>
			<TableData columnspacing="true" nouniqueids="true">
				<Header>
					<Data align="center" name="Severity" width="80" link="true"><xsl:attribute name="href"><xsl:text>/servlet/DataArea?plugin=com.dell.oma.webplugins.AlertLogWebPlugin&amp;newsortkey=Type&amp;oldsortkey=</xsl:text><xsl:value-of select="$varSortKey"/><xsl:text>&amp;order=</xsl:text><xsl:value-of select="$varOrder"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strSeverity"/></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strSeverity1"/></xsl:attribute>
					</Data>
					<Data name="ID" link="true"><xsl:attribute name="href"><xsl:text>/servlet/DataArea?plugin=com.dell.oma.webplugins.AlertLogWebPlugin&amp;newsortkey=ID&amp;oldsortkey=</xsl:text><xsl:value-of select="$varSortKey"/><xsl:text>&amp;order=</xsl:text><xsl:value-of select="$varOrder"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strID"/></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strID1"/></xsl:attribute>
					</Data>
					<Data name="DateTime" width="110" link="true"><xsl:attribute name="href"><xsl:text>/servlet/DataArea?plugin=com.dell.oma.webplugins.AlertLogWebPlugin&amp;newsortkey=TimeStamp&amp;oldsortkey=</xsl:text><xsl:value-of select="$varSortKey"/><xsl:text>&amp;order=</xsl:text><xsl:value-of select="$varOrder"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strDateAmpTime"/></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strDateAmpTime1"/></xsl:attribute>
					</Data>

					<Data name="Category" link="true"><xsl:attribute name="href"><xsl:text>/servlet/DataArea?plugin=com.dell.oma.webplugins.AlertLogWebPlugin&amp;newsortkey=Category&amp;oldsortkey=</xsl:text><xsl:value-of select="$varSortKey"/><xsl:text>&amp;order=</xsl:text><xsl:value-of select="$varOrder"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strCategory"/></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strCategory1"/></xsl:attribute>
					</Data><!--Data name=&quot;Category&quot; link=&quot;true&quot;&gt;&lt;xsl:attribute name=&quot;href&quot;&gt;&lt;xsl:text&gt;/servlet/DataArea?plugin=com.dell.oma.webplugins.AlertLogWebPlugin&amp;newsortkey=Category&amp;oldsortkey=&lt;/xsl:text&gt;&lt;xsl:value-of select=&quot;$varSortKey&quot;/&gt;&lt;xsl:text&gt;&amp;order=&lt;/xsl:text&gt;&lt;xsl:value-of select=&quot;$varOrder&quot;/&gt;&lt;/xsl:attribute&gt;
						&lt;xsl:attribute name=&quot;value&quot;&gt;&lt;xsl:value-of select=&quot;$strCategory&quot;/&gt;&lt;/xsl:attribute&gt;
						&lt;xsl:attribute name=&quot;display&quot;&gt;&lt;xsl:value-of select=&quot;$strCategory1&quot;/&gt;&lt;/xsl:attribute&gt;
					&lt;/Data-->					
					<Data name="Description" link="true">
					   <xsl:attribute name="href"><xsl:text>/servlet/DataArea?plugin=com.dell.oma.webplugins.AlertLogWebPlugin&amp;newsortkey=Description&amp;oldsortkey=</xsl:text><xsl:value-of select="$varSortKey"/><xsl:text>&amp;order=</xsl:text><xsl:value-of select="$varOrder"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strDescription"/></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strDescription1"/></xsl:attribute>
					</Data>
					
				</Header>
				<xsl:apply-templates select="LogEntry">
					<xsl:sort select="*[name()=$varSortKey]" data-type="{$varDataType}" order="{$varOrder}"/>
				</xsl:apply-templates>
			</TableData>
		</DataArea>
	</xsl:template>
	
	<xsl:template match="LogEntry">
			<Row>
				<Data name="severity" type="status" align="center">
					<xsl:attribute name="value">
						<xsl:call-template name="alert-status2omsa">
							<xsl:with-param name="Status"><xsl:value-of select="Type"/>	</xsl:with-param>
                        </xsl:call-template>
           	        </xsl:attribute>
				</Data>
				
				<xsl:choose>
				    <xsl:when test="Link !=''">
				        <Data name="ID" link="true">
				            <xsl:attribute name="href">javascript:showEventHint("<xsl:value-of select="Link"/>")</xsl:attribute>
				   	        <xsl:attribute name="display"><xsl:value-of select="ID"/></xsl:attribute>
					        <xsl:attribute name="value"><xsl:value-of select="ID"/></xsl:attribute>
				        </Data>
				    </xsl:when>
				    <xsl:otherwise>
					    <Data name="ID"> 
				   	        <xsl:attribute name="display"><xsl:value-of select="ID"/></xsl:attribute>
					        <xsl:attribute name="value"><xsl:value-of select="ID"/></xsl:attribute>
					    </Data>
				    </xsl:otherwise>
				</xsl:choose>

				<Data name="DateTime">
					<xsl:attribute name="display"><xsl:value-of select="TimeStamp"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="DateTime"/></xsl:attribute>
				</Data>
				
				<Data name="Category">
					<xsl:attribute name="display"><xsl:value-of select="Category"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="Category"/></xsl:attribute>
				</Data><!--Data name=&quot;Category&quot;&gt;
					&lt;xsl:attribute name=&quot;display&quot;&gt;&lt;xsl:value-of select=&quot;Category&quot;&gt;&lt;/xsl:value-of&gt;&lt;/xsl:attribute&gt;
					&lt;xsl:attribute name=&quot;value&quot;&gt;&lt;xsl:value-of select=&quot;Category&quot;&gt;&lt;/xsl:value-of&gt;&lt;/xsl:attribute&gt;
				&lt;/Data-->
				
				<Data name="description">
					<xsl:attribute name="display"><xsl:value-of select="Description"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="Description"/></xsl:attribute>
				</Data>
			</Row>
	</xsl:template>

	<xsl:template name="alert-status2omsa">
		<xsl:param name="Status"/>
		<xsl:choose>
			<xsl:when test="$Status=0">0</xsl:when>
			<xsl:when test="$Status=1">4</xsl:when>
			<xsl:when test="$Status=2">3</xsl:when>
			<xsl:when test="$Status=4">2</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>