<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output method="xml" />
<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
		<xsl:choose>
			<xsl:when test="SMStatus != '0'">
				<DataArea printable="false">
					<PageTitle><xsl:attribute name="display"><xsl:value-of select="$strACPowerSwitch"/></xsl:attribute></PageTitle>
					<TableData>
						<Header>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strError"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strError1"/></xsl:attribute>
							</Data>
						</Header>
						<Row>
							<Data>
								<xsl:attribute name="display">
									<xsl:call-template name="smstatus">
										<xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param>
									</xsl:call-template>
								</xsl:attribute>
								<xsl:attribute name="value">
									<xsl:call-template name="smstatus">
										<xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param>
									</xsl:call-template>
								</xsl:attribute>
							</Data>
						</Row>
					</TableData>
				</DataArea>
			</xsl:when>
			<xsl:otherwise>
				<!--xsl:choose>
					<xsl:when test="(OMAUserRights = '7') or (OMAUserRights = '3')">
						<DataArea>
							<xsl:if test="(Redundancy/RedunStatus!='4') or (ACSwitchObj/Capabilities &gt; '1') or (/OMA/ACSwitchObj/RedundancyExpected = '1')">
								<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.hip.webplugins.SetACSwitchWebPlugin&amp;oid=<xsl:value-of select="ACSwitchObj/@oid"/>&amp;poid=<xsl:value-of select="/OMA/ServletArguments/@POID"/></xsl:attribute>
							</xsl:if>
							<PageTitle>
    							<xsl:attribute name="display">
    								<xsl:choose>
    									<xsl:when test="ACSwitchObj/ACSwitchName='AC Failover Switch'"><xsl:value-of select="$strACFailoverSwitch"/></xsl:when>
    									<xsl:otherwise><xsl:value-of select="ACSwitchObj/ACSwitchName"/></xsl:otherwise>
    								</xsl:choose>
                                </xsl:attribute>
								<xsl:attribute name="status"><xsl:value-of select="ObjStatus"/></xsl:attribute>
							</PageTitle>
							<CustomButton>
								<Data>
									<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
									<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.ACSwitchWebPlugin&amp;poid=<xsl:value-of select="ServletArguments/@POID"/></xsl:attribute>
								</Data>
							</CustomButton>
							<xsl:if test="ACSwitchObj/RedundancyExpected != '1'">
								<SubHeader>
										<xsl:attribute name="display"><xsl:value-of select="$strACSwitchRedundancy"/></xsl:attribute>
										<xsl:attribute name="status"><xsl:value-of select="Redundancy/@status"/></xsl:attribute>
								</SubHeader>
							</xsl:if>
							<ListData>
								<xsl:if test="ACSwitchObj/RedundancyExpected != '1'">
									<xsl:apply-templates select="Redundancy"/>
								</xsl:if>
								<xsl:apply-templates select="ACSwitchObj"/>
							</ListData>
							<xsl:apply-templates select="ACCordList"/>
							<script language="javascript">
								<xsl:if test="((/OMA/Redundancy/RedunStatus != '4') or (/OMA/ACSwitchObj/RedundancyExpected = '1'))">
									function setRedundancy()
									{
										document.getElementById("redundancy").value = "true";
									}
								</xsl:if>
								<xsl:if test="ACSwitchObj/Capabilities &gt; '1'">
									function setCapabilities()
									{
										document.getElementById("capabilities").value = "true";
									}
								</xsl:if>
							</script>
						</DataArea>
					</xsl:when>
					<xsl:otherwise-->
						<DataArea>
							<PageTitle>
								<xsl:attribute name="display"><xsl:value-of select="ACSwitchObj/ACSwitchName"/></xsl:attribute>
								<xsl:attribute name="status"><xsl:value-of select="ObjStatus"/></xsl:attribute>
							</PageTitle>
							<CustomButton>
								<Data>
									<xsl:attribute name="display"><xsl:value-of select="$strRefresh1"/></xsl:attribute>
									<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.hip.webplugins.ACSwitchWebPlugin&amp;poid=<xsl:value-of select="ServletArguments/@POID"/></xsl:attribute>
								</Data>
							</CustomButton>
							<xsl:if test="ACSwitchObj/RedundancyExpected != '1'">
								<SubHeader>
									<xsl:attribute name="display"><xsl:value-of select="$strACSwitchRedundancy1"/></xsl:attribute>
									<xsl:attribute name="status"><xsl:value-of select="Redundancy/@status"/></xsl:attribute>
								</SubHeader>
							</xsl:if>
							<ListData>
								<xsl:if test="ACSwitchObj/RedundancyExpected != '1'">
									<xsl:apply-templates select="Redundancy"/>
								</xsl:if>
								<xsl:apply-templates select="ACSwitchObj"/>
							</ListData>
							<xsl:apply-templates select="ACCordList"/>
						</DataArea>
					<!--/xsl:otherwise>
				</xsl:choose-->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="Redundancy">
		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strRedundancyStatus"/></xsl:attribute>
			<xsl:call-template name="RedStatus">
				<xsl:with-param name="status"><xsl:value-of select="RedunStatus"/></xsl:with-param>
			</xsl:call-template>
		</Data>
		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strNumberOfDevices"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="RedunCount"/></xsl:attribute>
		</Data>
	</xsl:template>
	<xsl:template match="ACSwitchObj">
		<xsl:call-template name="ACMode">
			<xsl:with-param name="mode"><xsl:value-of select="RedundancyExpected"/></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="ACConfig">
			<xsl:with-param name="settings"><xsl:value-of select="Settings"/></xsl:with-param>
			<xsl:with-param name="capabilities"><xsl:value-of select="Capabilities"/></xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="ACCordList">
		<TableData>
			<SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strACPowerLines"/></xsl:attribute>
			</SubHeader>
			<Header>
				<Data ignoreonweb="true">
					<xsl:attribute name="display"><xsl:value-of select="$strIndex"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strIndex1"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strStatus1"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strLocation"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strLocation1"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strACPresent"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strACPresent1"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strActiveSource"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strActiveSource1"/></xsl:attribute>
				</Data>
			</Header>
			<xsl:apply-templates select="ACCord"/>
		</TableData>
	</xsl:template>
	<xsl:template match="ACCord">
		<Row>
			<Data ignoreonweb="true" type="index">
				<xsl:attribute name="value"><xsl:value-of select="@index"/></xsl:attribute>
			</Data>
			<Data type="status">
				<xsl:attribute name="value"><xsl:value-of select="@status"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="value"><xsl:value-of select="ACCordName"/></xsl:attribute>
			</Data>
			<xsl:call-template name="ACPower">
				<xsl:with-param name="present"><xsl:value-of select="ACPresent"/></xsl:with-param>
			</xsl:call-template>
			<xsl:call-template name="ACActive">
				<xsl:with-param name="active"><xsl:value-of select="ACActiveSrc"/></xsl:with-param>
			</xsl:call-template>
		</Row>
	</xsl:template>
	<xsl:template name="ACPower">
	<xsl:param name="present"/>
		<xsl:choose>
			<xsl:when test="$present = 1">
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="$strPowerPresent"/></xsl:attribute>
				</Data>
			</xsl:when>
			<xsl:otherwise>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="$strPowerAbsent"/></xsl:attribute>
				</Data>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="ACActive">
	<xsl:param name="active"/>
		<xsl:choose>
			<xsl:when test="$active = 1">
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="$strActive"/></xsl:attribute>
				</Data>
			</xsl:when>
			<xsl:otherwise>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="$strNotActive"/></xsl:attribute>
				</Data>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="RedStatus">
		<xsl:param name="status"/>
		<xsl:choose>
			<xsl:when test="$status = 1">
				<xsl:attribute name="value"><xsl:value-of select="$strUnknown"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status = 2">
				<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status = 3">
				<xsl:attribute name="value"><xsl:value-of select="$strOffline"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status = 4">
				<xsl:attribute name="value"><xsl:value-of select="$strFull"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status = 5">
				<xsl:attribute name="value"><xsl:value-of select="$strDegraded"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status = 6">
				<xsl:attribute name="value"><xsl:value-of select="$strLost"/></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="value"><xsl:value-of select="$strOther"/></xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="ACMode">
		<xsl:param name="mode"/>
		<!--xsl:choose-->
			<!--xsl:when test="(((/OMA/OMAUserRights='7') or (/OMA/OMAUserRights='3')) and ((/OMA/Redundancy/RedunStatus != '4') or (/OMA/ACSwitchObj/RedundancyExpected = '1')))">
				<Data type="radio" name="select_redunmode">
					<xsl:attribute name="event">onClick</xsl:attribute>
					<xsl:attribute name="handler">javascript:setRedundancy()</xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strRedundancyMode"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strRedundant"/></xsl:attribute>
					<xsl:attribute name="returnvalue">2</xsl:attribute>
					<xsl:if test="$mode = '2'">
						<xsl:attribute name="state">1</xsl:attribute>
					</xsl:if>
				</Data>
				<Data type="radio" name="select_redunmode">
					<xsl:attribute name="event">onClick</xsl:attribute>
					<xsl:attribute name="handler">javascript:setRedundancy()</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strNotRedundant"/></xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="$mode"/></xsl:attribute>
					<xsl:attribute name="returnvalue">1</xsl:attribute>
					<xsl:if test="$mode='1'">
						<xsl:attribute name="state">1</xsl:attribute>
					</xsl:if>
				</Data>
				<Data type="hidden" name="redundancy" returnvalue="false"/>
			</xsl:when>
			<xsl:otherwise-->
				<xsl:choose>
					<xsl:when test="$mode = '1'">
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strRedundancyMode1"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strNotRedundant1"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:when test="$mode = '2'">
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strRedundancyMode2"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strRedundant1"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strRedundancyMode3"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strUnknown1"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
				<Data type="hidden" name="redundancy" returnvalue="false"/>
			<!--/xsl:otherwise-->
		<!--/xsl:choose-->
	</xsl:template>
	<xsl:template name="ACConfig">
		<xsl:param name="settings"/>
		<xsl:param name="capabilities"/>
		<!--xsl:choose>
			<xsl:when test="(/OMA/OMAUserRights='7') or (/OMA/OMAUserRights='3')">
				<xsl:choose>
					<xsl:when test="$capabilities= '15'">
						<Data type="radio" name="select_redunconfig">
							<xsl:attribute name="event">onClick</xsl:attribute>
							<xsl:attribute name="handler">javascript:setCapabilities()</xsl:attribute>
							<xsl:attribute name="display"><xsl:value-of select="$strRedundancyConfiguration"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strInputSourceLine"/></xsl:attribute>
							<xsl:attribute name="returnvalue">1</xsl:attribute>
							<xsl:if test="$settings = '1'"><xsl:attribute name="state">1</xsl:attribute></xsl:if>
						</Data>
						<Data type="radio" name="select_redunconfig">
							<xsl:attribute name="event">onClick</xsl:attribute>
							<xsl:attribute name="handler">javascript:setCapabilities()</xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strInputSourceLine1"/></xsl:attribute>
							<xsl:attribute name="returnvalue">2</xsl:attribute>
							<xsl:if test="$settings = '2'"><xsl:attribute name="state">1</xsl:attribute></xsl:if>
						</Data>
						<Data type="radio" name="select_redunconfig">
							<xsl:attribute name="event">onClick</xsl:attribute>
							<xsl:attribute name="handler">javascript:setCapabilities()</xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strInputSourceLine2"/></xsl:attribute>
							<xsl:attribute name="returnvalue">4</xsl:attribute>
							<xsl:if test="$settings = '4'"><xsl:attribute name="state">1</xsl:attribute></xsl:if>
						</Data>
						<Data type="radio" name="select_redunconfig">
							<xsl:attribute name="event">onClick</xsl:attribute>
							<xsl:attribute name="handler">javascript:setCapabilities()</xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strInputSourceLine3"/></xsl:attribute>
							<xsl:attribute name="returnvalue">8</xsl:attribute>
							<xsl:if test="$settings = '8'"><xsl:attribute name="state">1</xsl:attribute></xsl:if>
						</Data>
						<Data type="hidden" name="capabilities" returnvalue="false"/>
					</xsl:when>
					<xsl:when test="$capabilities= '7'">
						<Data type="radio" name="select_redunconfig">
							<xsl:attribute name="event">onClick</xsl:attribute>
							<xsl:attribute name="handler">javascript:setCapabilities()</xsl:attribute>
							<xsl:attribute name="display"><xsl:value-of select="$strRedundancyConfiguration1"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strInputSourceLine4"/></xsl:attribute>
							<xsl:attribute name="returnvalue">1</xsl:attribute>
							<xsl:if test="$settings = '1'"><xsl:attribute name="state">1</xsl:attribute></xsl:if>
						</Data>
						<Data type="radio" name="select_redunconfig">
							<xsl:attribute name="event">onClick</xsl:attribute>
							<xsl:attribute name="handler">javascript:setCapabilities()</xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strInputSourceLine5"/></xsl:attribute>
							<xsl:attribute name="returnvalue">2</xsl:attribute>
							<xsl:if test="$settings = '2'"><xsl:attribute name="state">1</xsl:attribute></xsl:if>
						</Data>
						<Data type="radio" name="select_redunconfig">
							<xsl:attribute name="event">onClick</xsl:attribute>
							<xsl:attribute name="handler">javascript:setCapabilities()</xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strInputSourceLine6"/></xsl:attribute>
							<xsl:attribute name="returnvalue">4</xsl:attribute>
							<xsl:if test="$settings = '4'"><xsl:attribute name="state">1</xsl:attribute></xsl:if>
						</Data>
						<Data type="hidden" name="capabilities" returnvalue="false"/>
					</xsl:when>
					<xsl:when test="$capabilities= '3'">
						<Data type="radio" name="select_redunconfig">
							<xsl:attribute name="event">onClick</xsl:attribute>
							<xsl:attribute name="handler">javascript:setCapabilities()</xsl:attribute>
							<xsl:attribute name="display"><xsl:value-of select="$strRedundancyConfiguration2"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strInputSourceLine7"/></xsl:attribute>
							<xsl:attribute name="returnvalue">1</xsl:attribute>
							<xsl:if test="$settings = '1'"><xsl:attribute name="state">1</xsl:attribute></xsl:if>
						</Data>
						<Data type="radio" name="select_redunconfig">
							<xsl:attribute name="event">onClick</xsl:attribute>
							<xsl:attribute name="handler">javascript:setCapabilities()</xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strInputSourceLine8"/></xsl:attribute>
							<xsl:attribute name="returnvalue">2</xsl:attribute>
							<xsl:if test="$settings = '2'"><xsl:attribute name="state">1</xsl:attribute></xsl:if>
						</Data>
						<Data type="hidden" name="capabilities" returnvalue="false"/>
					</xsl:when>
					<xsl:otherwise>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strRedundancyConfiguration3"/></xsl:attribute>
							<xsl:choose>
								<xsl:when test="$settings = '16'">
									<xsl:attribute name="value"><xsl:value-of select="$strSharedInputMode"/></xsl:attribute>
								</xsl:when>
								<xsl:when test="$settings = '2'">
									<xsl:attribute name="value"><xsl:value-of select="$strInputSourceLine9"/></xsl:attribute>
								</xsl:when>
								<xsl:when test="$settings = '4'">
									<xsl:attribute name="value"><xsl:value-of select="$strInputSourceLine10"/></xsl:attribute>
								</xsl:when>
								<xsl:when test="$settings = '8'">
									<xsl:attribute name="value"><xsl:value-of select="$strInputSourceLine11"/></xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="value"><xsl:value-of select="$strInputSourceLine12"/></xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
						</Data>
						<Data type="hidden" name="capabilities" returnvalue="false"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise-->
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strRedundancyConfiguration4"/></xsl:attribute>
							<xsl:choose>
								<xsl:when test="$settings = '16'">
									<xsl:attribute name="value"><xsl:value-of select="$strSharedInputMode1"/></xsl:attribute>
								</xsl:when>
								<xsl:when test="$settings = '2'">
									<xsl:attribute name="value"><xsl:value-of select="$strInputSourceLine13"/></xsl:attribute>
								</xsl:when>
								<xsl:when test="$settings = '4'">
									<xsl:attribute name="value"><xsl:value-of select="$strInputSourceLine14"/></xsl:attribute>
								</xsl:when>
								<xsl:when test="$settings = '8'">
									<xsl:attribute name="value"><xsl:value-of select="$strInputSourceLine15"/></xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="value"><xsl:value-of select="$strInputSourceLine16"/></xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
				</Data>
				<Data type="hidden" name="capabilities" returnvalue="false"/>
			<!--/xsl:otherwise>
		</xsl:choose-->
	</xsl:template>
	<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:param name="mssg"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'"><xsl:value-of select="$strCommandUnsuccessful"/></xsl:when>
			<xsl:when test="$status = '0'"><xsl:value-of select="$strCommandSuccessful"/></xsl:when>
			<xsl:when test="$status = '1'"><xsl:value-of select="$strCommandNotImplemented"/></xsl:when>
			<xsl:when test="$status = '2'"><xsl:value-of select="$strBadCommand"/></xsl:when>
			<xsl:when test="$status = '3'"><xsl:value-of select="$strCommandTimeout"/></xsl:when>
			<xsl:when test="$status = '4'"><xsl:value-of select="$strCommandCancelled"/></xsl:when>
			<xsl:when test="$status = '5'"><xsl:value-of select="$strCommandAborted"/></xsl:when>
			<xsl:when test="$status = '6'"><xsl:value-of select="$strCommandPending"/></xsl:when>
			<xsl:when test="$status = '7'"><xsl:value-of select="$strNoSuchDevice"/></xsl:when>
			<xsl:when test="$status = '8'"><xsl:value-of select="$strDeviceBusy"/></xsl:when>
			<xsl:when test="$status = '9'"><xsl:value-of select="$strBadDevice"/></xsl:when>
			<xsl:when test="$status = '10'"><xsl:value-of select="$strSpuriousInterrupt"/></xsl:when>
			<xsl:when test="$status = '11'"><xsl:value-of select="$strResourceLocked"/></xsl:when>
			<xsl:when test="$status = '12'"><xsl:value-of select="$strInvalidIndex"/></xsl:when>
			<xsl:when test="$status = '13'"><xsl:value-of select="$strSMBError"/></xsl:when>
			<xsl:when test="$status = '14'"><xsl:value-of select="$strDataRequestedIs"/></xsl:when>
			<xsl:when test="$status = '15'"><xsl:value-of select="$strDataRequestedIs1"/></xsl:when>
			<xsl:when test="$status = '16'"><xsl:value-of select="$strDataRequestedIs2"/></xsl:when>
			<xsl:when test="$status = '17'"><xsl:value-of select="$strDeviceNotYet"/></xsl:when>
			<xsl:when test="$status = '18'"><xsl:value-of select="$strDeviceDoesNot"/></xsl:when>
			<xsl:when test="$status = '19'"><xsl:value-of select="$strDeviceOutOf"/></xsl:when>
			<xsl:when test="$status = '20'"><xsl:value-of select="$strDeviceAlreadyExists"/></xsl:when>
			<xsl:when test="$status = '256'"><xsl:value-of select="$strACPowerSwitch1"/></xsl:when>
			<xsl:when test="$status = '257'"><xsl:value-of select="$strACPowerSwitch2"/></xsl:when>
			<xsl:when test="$status = '258'"><xsl:value-of select="$strACPowerSwitch3"/></xsl:when>
			<xsl:when test="$status = '260'"><xsl:value-of select="$strINIFileNot"/></xsl:when>
			<xsl:when test="$status = '261'"><xsl:value-of select="$strINIMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '262'"><xsl:value-of select="$strINISectionDoes"/></xsl:when>
			<xsl:when test="$status = '263'"><xsl:value-of select="$strINIKeyDoes"/></xsl:when>
			<xsl:when test="$status = '264'"><xsl:value-of select="$strINIValueMalformed"/></xsl:when>
			<xsl:when test="$status = '270'"><xsl:value-of select="$strInsufficientAccessRights"/></xsl:when>
			<xsl:when test="$status = '271'"><xsl:value-of select="$strInvalidParameterName"/><xsl:value-of select="$mssg"/></xsl:when>
			<xsl:when test="$status = '272'"><xsl:value-of select="$strOutOfMemory"/></xsl:when>
			<xsl:when test="$status = '280'"><xsl:value-of select="$strXMLFileNot"/></xsl:when>
			<xsl:when test="$status = '281'"><xsl:value-of select="$strXMLMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '282'"><xsl:value-of select="$strXMLNodeDoes"/></xsl:when>
			<xsl:when test="$status = '283'"><xsl:value-of select="$strXMLValueMalformed"/></xsl:when>
			<xsl:otherwise>SMStatus: <xsl:value-of select="$status"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
