<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" />
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
		<xsl:choose>
			<xsl:when test="SMStatus != '0'">
				<DataArea>
					<PageTitle>
						<xsl:attribute name="display"><!--XLATESTART-->Error: <!--XLATESTOP--><xsl:call-template name="smstatus"><xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</PageTitle>
				</DataArea>
			</xsl:when>
			<xsl:otherwise>
				<DataArea>
					<PageTitle>
						<xsl:attribute name="display"><!--XLATESTART-->Informaci&#243;n de chasis<!--XLATESTOP--></xsl:attribute>
					</PageTitle>
					<ListData>
						<Data>
							<xsl:attribute name="display"><!--XLATESTART-->&#205;ndice<!--XLATESTOP--></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Chassis/@index"/></xsl:attribute>
						</Data>
						<Data>
							<xsl:attribute name="display"><!--XLATESTART-->Nombre de chasis<!--XLATESTOP--></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Chassis/@display"/></xsl:attribute>
						</Data>
						<xsl:apply-templates select="ChassisInfo"/>
					</ListData>
				</DataArea>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="ChassisInfo">
		<xsl:if test="SystemInfo/SystemName">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->Nombre de host<!--XLATESTOP--></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="SystemInfo/SystemName"/></xsl:attribute>
			</Data>			
		</xsl:if>
		<xsl:if test="FirmwareList">
			<xsl:for-each select="FirmwareList/Firmware">
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="FWText"/><!--XLATESTART--> Versi&#243;n<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="FWVersion"/></xsl:attribute>
				</Data>
			</xsl:for-each>			
		</xsl:if>
		<xsl:if test="ChassisProps1/ChassModel">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->Modelo de chasis<!--XLATESTOP--></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="ChassisProps1/ChassModel"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="ChassisProps1/ChassLockPresent">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->Seguro del chasis<!--XLATESTOP--></xsl:attribute>
				<xsl:choose>
					<xsl:when test="ChassisProps1/ChassLockPresent = 'true'">
						<xsl:attribute name="value"><!--XLATESTART-->Presente<!--XLATESTOP--></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><!--XLATESTART-->No presente<!--XLATESTOP--></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
		</xsl:if>
		<xsl:if test="ChassisProps2/ServiceTag">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->Etiqueta de servicio<!--XLATESTOP--></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="ChassisProps2/ServiceTag"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="ChassisProps2/AssetTag">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->Etiqueta de propiedad<!--XLATESTOP--></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="ChassisProps2/AssetTag"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="ChassisProps2/FaultLEDControl != '0'">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->LED de falla parpadea con nivel de gravedad<!--XLATESTOP--></xsl:attribute>
				<xsl:choose>
					<xsl:when test="ChassisProps2/FaultLEDControl = '8'">
						<xsl:attribute name="value"><!--XLATESTART-->Advertencia<!--XLATESTOP--></xsl:attribute>
					</xsl:when>
					<xsl:when test="ChassisProps2/FaultLEDControl = '16'">
						<xsl:attribute name="value"><!--XLATESTART-->Cr&#237;tico<!--XLATESTOP--></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><!--XLATESTART-->No definido<!--XLATESTOP--></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
		</xsl:if>
		<xsl:if test="BaseBoardList/@count > '0'">
			<xsl:call-template name="BaseBoard"/>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="BaseBoard">
		<xsl:for-each select="/OMA/BaseBoardList/BaseBoard">
			<xsl:if test="FeatureFlags/HostingBoard='true'">
				<Data name="BladeServiceTag" type="ustring">
					<xsl:attribute name="display"><!--XLATESTART-->Etiqueta de servicio de Blade<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="ServiceTag"/></xsl:attribute>
				</Data>
				<Data name="BladeServiceTag" type="ustring">
					<xsl:attribute name="display"><!--XLATESTART-->Etiqueta de propiedad de Blade<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="AssetTag"/></xsl:attribute>
				</Data>
				<Data name="BladeLocation" type="ustring">
					<xsl:attribute name="display"><!--XLATESTART-->Ubicaci&#243;n de Blade<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="BoardLocation"/></xsl:attribute>
				</Data>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:param name="mssg"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'"><!--XLATESTART-->Comando no satisfactorio<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '0'"><!--XLATESTART-->Comando satisfactorio<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '1'"><!--XLATESTART-->Comando no implementado<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '2'"><!--XLATESTART-->Comando err&#243;neo<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '3'"><!--XLATESTART-->Tiempo de espera de comando<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '4'"><!--XLATESTART-->Comando cancelado<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '5'"><!--XLATESTART-->Comando anulado<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '6'"><!--XLATESTART-->Comando pendiente<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '7'"><!--XLATESTART-->No existe ese dispositivo<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '8'"><!--XLATESTART-->Dispositivo ocupado<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '9'"><!--XLATESTART-->Dispositivo err&#243;neo<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '10'"><!--XLATESTART-->Interrupci&#243;n falsa<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '11'"><!--XLATESTART-->Recurso bloqueado<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '12'"><!--XLATESTART-->&#205;ndice no v&#225;lido<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '13'"><!--XLATESTART-->Error SMB<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '14'"><!--XLATESTART-->Los datos solicitados no est&#225;n disponibles<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '15'"><!--XLATESTART-->Los datos solicitados son m&#225;s que los disponibles<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '16'"><!--XLATESTART-->Los datos solicitados son menos que los disponibles<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '17'"><!--XLATESTART-->El dispositivo no est&#225; listo para aceptar comandos. Int&#233;ntelo m&#225;s tarde<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '18'"><!--XLATESTART-->El dispositivo no tiene datos<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '19'"><!--XLATESTART-->El dispositivo se ha quedado sin memoria<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '20'"><!--XLATESTART-->El dispositivo ya existe<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '256'"><!--XLATESTART-->No se encuentra el objeto<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '257'"><!--XLATESTART-->Objeto mal formado, da&#241;ado o err&#243;neo<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '258'"><!--XLATESTART-->El objeto ya existe<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '260'"><!--XLATESTART-->No se encuentra el archivo INI<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '261'"><!--XLATESTART-->INI mal formado, da&#241;ado o err&#243;neo<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '262'"><!--XLATESTART-->La secci&#243;n de INI no existe<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '263'"><!--XLATESTART-->La clave de INI no existe<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '264'"><!--XLATESTART-->Valor de INI mal formado, da&#241;ado o err&#243;neo<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '270'"><!--XLATESTART-->Derechos de acceso insuficientes<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '271'"><!--XLATESTART-->Valor o nombre de par&#225;metro no v&#225;lido: <!--XLATESTOP--><xsl:value-of select="$mssg"/></xsl:when>
			<xsl:when test="$status = '272'"><!--XLATESTART-->Sin memoria<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '280'"><!--XLATESTART-->No se encuentra el archivo XML<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '281'"><!--XLATESTART-->XML mal formado, da&#241;ado o err&#243;neo<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '282'"><!--XLATESTART-->El nodo de XML no existe<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '283'"><!--XLATESTART-->Valor de XML mal formado, da&#241;ado o err&#243;neo<!--XLATESTOP--></xsl:when>
		<xsl:otherwise>SMStatus: <xsl:value-of select="$status"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>