<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:strip-space elements="*"/>
<xsl:template match="/OMA">
	<xsl:choose>
		<xsl:when test="SMStatus='0'"><xsl:call-template name="success"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="failure"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="failure">
	<DataArea>
		<PageTitle>
			<xsl:attribute name="display"><!--XLATESTART-->Chassis List<!--XLATESTOP--></xsl:attribute>
		</PageTitle>
		<TableData>
			<Header>
				<Data name="">
					<xsl:attribute name="display"><!--XLATESTART-->Chassis List<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><!--XLATESTART-->Chassis List<!--XLATESTOP--></xsl:attribute>
				</Data>
			</Header>
			<Row>
				<Data name=""  display="">
					<xsl:attribute name="value">
						<xsl:call-template name="smstatus">
							<xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param>
						</xsl:call-template>
					</xsl:attribute>
				</Data>
			</Row>
		</TableData>
	</DataArea>
</xsl:template>

<xsl:template name="success">
	<DataArea>
		<PageTitle>
			<xsl:attribute name="display"><!--XLATESTART-->Chassis List<!--XLATESTOP--></xsl:attribute>
		</PageTitle>
		<TableData>
		<SubHeader>
			<xsl:attribute name="display"><!--XLATESTART-->Type the command with index to view the chassis details<!--XLATESTOP--></xsl:attribute>
		</SubHeader>
		
		<Header>
			<Data ignoreonweb="true">
				<xsl:attribute name="display"><!--XLATESTART-->Index<!--XLATESTOP--></xsl:attribute>
				<xsl:attribute name="value"><!--XLATESTART-->Index<!--XLATESTOP--></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->Status<!--XLATESTOP--></xsl:attribute>
				<xsl:attribute name="value"><!--XLATESTART-->Status<!--XLATESTOP--></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->Chassis Name<!--XLATESTOP--></xsl:attribute>
				<xsl:attribute name="value"><!--XLATESTART-->Chassis Name<!--XLATESTOP--></xsl:attribute>
			</Data>
		</Header>
		
		<xsl:for-each select="ChassisList/Chassis">
			<Row>
				<Data ignoreonweb="true">
					<xsl:attribute name="display"><xsl:value-of select="@index"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="@index"/></xsl:attribute>
				</Data>
				<Data name=""  display="" type="icon" align="left">
					<xsl:attribute name="alt"><xsl:call-template name="imagedesc"/></xsl:attribute>
				</Data>
				<Data name=""  display="" type="">
					<xsl:attribute name="value">
						<xsl:call-template name="chassisname">
							<xsl:with-param name="name"><xsl:value-of select="@display"/></xsl:with-param>
							<xsl:with-param name="index"><xsl:value-of select="@index"/></xsl:with-param>
						</xsl:call-template>
					</xsl:attribute>
				</Data>
			</Row>
		</xsl:for-each>
	</TableData>
	</DataArea>
</xsl:template>

<xsl:template name="imagedesc">
	<xsl:if test="@status='0'"><!--XLATESTART-->Other<!--XLATESTOP--></xsl:if>
	<xsl:if test="@status='1'"><!--XLATESTART-->Unknown<!--XLATESTOP--></xsl:if>
	<xsl:if test="@status='2'"><!--XLATESTART-->OK<!--XLATESTOP--></xsl:if>
	<xsl:if test="@status='3'"><!--XLATESTART-->Non-Critical<!--XLATESTOP--></xsl:if>
	<xsl:if test="@status='4'"><!--XLATESTART-->Critical<!--XLATESTOP--></xsl:if>
	<xsl:if test="@status='5'"><!--XLATESTART-->Non-Recoverable<!--XLATESTOP--></xsl:if>
</xsl:template>

<xsl:template name="chassisname">
	<xsl:param name="name"/>
	<xsl:param name="index"/>
	<xsl:choose>
		<xsl:when test="$name=''"><!--XLATESTART-->Chassis<!--XLATESTOP--> ( <xsl:value-of select="$index"/> )</xsl:when>
		<xsl:otherwise><xsl:value-of select="$name"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'"><!--XLATESTART-->Command Unsuccessful<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '1'"><!--XLATESTART-->Command Not Implemented<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '2'"><!--XLATESTART-->Bad Command<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '3'"><!--XLATESTART-->Command Timeout<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '4'"><!--XLATESTART-->Command Cancelled<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '5'"><!--XLATESTART-->Command Aborted<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '6'"><!--XLATESTART-->Command Pending<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '7'"><!--XLATESTART-->No such device<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '8'"><!--XLATESTART-->Device busy<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '9'"><!--XLATESTART-->Bad device<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '10'"><!--XLATESTART-->Spurious Interrupt<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '11'"><!--XLATESTART-->Resource locked<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '12'"><!--XLATESTART-->Invalid index<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '13'"><!--XLATESTART-->SMB error<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '14'"><!--XLATESTART-->Data requested is not available<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '15'"><!--XLATESTART-->Data requested is more than data available<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '16'"><!--XLATESTART-->Data requested is less than data available<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '17'"><!--XLATESTART-->Device not yet ready to accept commands. Try later<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '18'"><!--XLATESTART-->Device does not have data<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '19'"><!--XLATESTART-->Device out of memory<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '20'"><!--XLATESTART-->Device already exists<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '256'"><!--XLATESTART-->object not found<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '257'"><!--XLATESTART-->object malformed, corrupt or bad<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '258'"><!--XLATESTART-->object already exists<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '260'"><!--XLATESTART-->INI file not found<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '261'"><!--XLATESTART-->INI malformed, corrupt or bad<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '262'"><!--XLATESTART-->INI section does not exist<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '263'"><!--XLATESTART-->INI key does not exist<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '264'"><!--XLATESTART-->INI value malformed, corrupt or bad<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '270'"><!--XLATESTART-->Insufficient access rights<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '271'"><!--XLATESTART-->Invalid parameter name or value: <!--XLATESTOP--><xsl:value-of select="$mssg"/></xsl:when>
			<xsl:when test="$status = '272'"><!--XLATESTART-->Out of memory<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '280'"><!--XLATESTART-->XML file not found<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '281'"><!--XLATESTART-->XML malformed, corrupt or bad<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '282'"><!--XLATESTART-->XML node does not exist<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '283'"><!--XLATESTART-->XML value malformed, corrupt or bad<!--XLATESTOP--></xsl:when>
			<xsl:otherwise>SMStatus: <xsl:value-of select="$status"/></xsl:otherwise>
		</xsl:choose>
</xsl:template>
<xsl:template match="*"/>
</xsl:stylesheet>
