<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA/OMAUserRights"/>	
	
	<xsl:template match="OMA">	
	<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>
	<DataArea>
		<xsl:if test="$usrights='7'">
			<PromptText><xsl:value-of select="$Clickonuser"/></PromptText>
		</xsl:if>

		<PageTitle><xsl:attribute name="display"><xsl:value-of select="$ConfigureRemoteAccess"/></xsl:attribute></PageTitle>
		
		<CustomButton>
			<xsl:choose>
				<xsl:when test="DRSCUserList/NumValidEntries='16'">
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="$usrights='7'">
					<Data name="Add"><xsl:attribute name="display"><xsl:value-of select="$Add"/></xsl:attribute>
						<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCGetUserEntry&amp;oid=<xsl:value-of select="DRSCUserList/NextAvailableUserEntry/@oid"/>&amp;help=adcfgru&amp;app=drsc</xsl:attribute>
					</Data>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>

			<Data name=""><xsl:attribute name="display"><xsl:value-of select="$Refresh"/></xsl:attribute>
				<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCUsers</xsl:attribute>
			</Data>
		</CustomButton>

		<xsl:apply-templates select="DRSCUserList"/>
	</DataArea>
	</xsl:template>
	
	<xsl:template match="DRSCUserList">
		<TableData columnspacing="true" name="tab2" display=" ">
			<SubHeader><xsl:attribute name="display"><xsl:value-of select="$ListofRemote"/></xsl:attribute></SubHeader>
			<Header>
				<Data ignoreonweb="true">
					<xsl:attribute name="display"><xsl:value-of select="$Index"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$Index1"/></xsl:attribute>
				</Data>
				<Data name="UserName" editable="false" type="usting"><xsl:attribute name="display"><xsl:value-of select="$UserName"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$UserName1"/></xsl:attribute>
				</Data>
			</Header>				
		<xsl:apply-templates select="DRSCUserEntry"/>
		</TableData>
	</xsl:template>
	
	<xsl:template match="DRSCUserEntry">
	<xsl:variable name="usrights"><xsl:value-of select="/OMA/OMAUserRights"/></xsl:variable>
		<Row>
			<xsl:element name="Data">
				<xsl:attribute name="ignoreonweb">true</xsl:attribute>
				<xsl:attribute name="display"><xsl:value-of select="@index"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="@index"/></xsl:attribute>
			</xsl:element>
			<Data>
				<xsl:choose>
					<xsl:when test="$usrights='7'">
						<xsl:attribute name="link">true</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="link">false</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:attribute name="value">
					<xsl:value-of select="UserName"/>
				</xsl:attribute>
				<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCGetUserEntry&amp;oid=<xsl:value-of select="@oid"/>&amp;help=adcfgru&amp;app=drsc&amp;c=<xsl:value-of select="/OMA/DRSCUserList/NumValidEntries" /></xsl:attribute>
			</Data>
		</Row>
	</xsl:template>
</xsl:stylesheet>