<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" omit-xml-declaration="yes"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
		<Summary>
			<xsl:apply-templates/>
		</Summary>
	</xsl:template>
	<xsl:template match="DRSCSummaryObj">
		<Section>
			<xsl:attribute name="name"><xsl:value-of select="$RemoteAccessController"/></xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="$RemoteAccessController1"/></xsl:attribute>
				<ListData>
					<xsl:attribute name="name"><xsl:value-of select="$RemoteAccessController2"/></xsl:attribute>
					<Data name="ProductInfo" type="ustring" editable="false"><xsl:attribute name="display"><xsl:value-of select="$Product"/></xsl:attribute>
						<xsl:attribute name="value">
							 <xsl:value-of select="DRSIdentificationObj/ProductInfo"/>
						</xsl:attribute>
					</Data>
				
					<Data name="VersionInfo" type="ustring" editable="false"><xsl:attribute name="display"><xsl:value-of select="$Version"/></xsl:attribute>
						<xsl:attribute name="value">
							 <xsl:value-of select="DRSIdentificationObj/VersionInfo"/>
						</xsl:attribute>
					</Data>
					<Data name="CurrentIPAddress" type="ustring" editable="false"><xsl:attribute name="display"><xsl:value-of select="$CurrentIPAddress"/></xsl:attribute>
						<xsl:attribute name="value">
							 <xsl:value-of select="CurrentLanNetworkingObj/NicCurrentIpAddress"/>
						</xsl:attribute>
					</Data>
					<Data name="Current IP Mask" type="ustring" editable="false"><xsl:attribute name="display"><xsl:value-of select="$CurrentIPSubnet"/></xsl:attribute>
						<xsl:attribute name="value">
							 <xsl:value-of select="CurrentLanNetworkingObj/NicCurrentNetMask"/>
						</xsl:attribute>
					</Data>
					<Data name="Current IP Gateway" type="ustring" editable="false"><xsl:attribute name="display"><xsl:value-of select="$CurrentIPGateway"/></xsl:attribute>
						<xsl:attribute name="value">
							 <xsl:value-of select="CurrentLanNetworkingObj/NicCurrentNetGateway"/>
						</xsl:attribute>
					</Data>
					<Data name="PCMCIA Card Information" type="ustring" editable="false"><xsl:attribute name="display"><xsl:value-of select="$PCMCIACardInformation"/></xsl:attribute>
						<xsl:attribute name="value">
							 <xsl:value-of select="DRSIdentificationObj/PcmciaInfo"/>
						</xsl:attribute>
					</Data>	
				</ListData>
		</Section> 
	</xsl:template>
	<xsl:template match="*"/>
</xsl:stylesheet>