<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA/OMAUserRights"/>	
	<xsl:template match="OMA">
	<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>
		<DataArea ipbox="true" validate="true" onLoad="true">
			<xsl:if test="$usrights='7'">
					<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.drsc.webplugins.SetRemoteInfo</xsl:attribute>
			</xsl:if>
			<PageTitle><xsl:attribute name="display"><xsl:value-of select="$ConfigureRemoteProperties"/></xsl:attribute></PageTitle>
			<CustomButton>
				<Data name=""><xsl:attribute name="display"><xsl:value-of select="$Refresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCRemoteFeatures</xsl:attribute>
				</Data>
			</CustomButton>

			<TableData columnspacing="true" name="tabRemoteBootConfiguration"><xsl:attribute name="display"><xsl:value-of select="$RemoteBootConfiguration"/></xsl:attribute>
			<SubHeader value="Remote Boot Configuration"><xsl:attribute name="display"><xsl:value-of select="$RemoteBootConfiguration1"/></xsl:attribute></SubHeader>

				<Header>
					<Data name="Property" value="Property" editable="false" ignoreonweb="true" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Property"/></xsl:attribute></Data>
					<Data name="Value" value="Value" editable="false" ignoreonweb="true" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Value"/></xsl:attribute></Data>
				</Header>

			<xsl:call-template name="RemoteBootParams">
			</xsl:call-template>
			
			</TableData>
			<TableData columnspacing="true" name="tabRemoteFirmwareUpdateConfiguration"><xsl:attribute name="display"><xsl:value-of select="$RemoteFirmwareUpdate"/></xsl:attribute>
				<SubHeader value="Remote Firmware Update Configuration"><xsl:attribute name="display"><xsl:value-of select="$RemoteFirmwareUpdate1"/></xsl:attribute></SubHeader>
				<PromptText><xsl:value-of select="$EntertheIP"/></PromptText>
				<Header>
					<Data name="Property" value="Property" editable="false" ignoreonweb="true" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Property1"/></xsl:attribute></Data>
					<Data name="Value" value="Value" editable="false" ignoreonweb="true" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Value1"/></xsl:attribute></Data>
				</Header>

			<xsl:call-template name="RemoteFwUpdateParams">
			</xsl:call-template>
			</TableData>
			<script type="text/javascript" src="/drsc/js/utility.js"/>
			<script language="javascript">
			
				var usrights = '<xsl:value-of select="/OMA/OMAUserRights"/>';
				var	resetMsg = "<xsl:value-of select="$Thisoperationcaused"/>";
						
				function initializationRoutine()
				{
					if (usrights != 7 )
					{
							document.dataarea.EnableFloppy.disabled = true;
							document.dataarea.FloppyAddrBox1.disabled = true; 
							document.dataarea.FloppyAddrBox2.disabled = true; 
							document.dataarea.FloppyAddrBox3.disabled = true; 
							document.dataarea.FloppyAddrBox4.disabled = true; 
							document.dataarea.RemoteFloppyTFTPPath.disabled = true; 

							document.dataarea.FWAddrBox1.disabled = true; 
							document.dataarea.FWAddrBox2.disabled = true; 
							document.dataarea.FWAddrBox3.disabled = true; 
							document.dataarea.FWAddrBox4.disabled = true;
							document.dataarea.RemoteFirmwareUpdatePath.disabled = true;
					}
					else EnableRemoteBootSettings();
				}

				function EnableRemoteBootSettings()
				{
					document.dataarea.FloppyAddrBox1.disabled =(!(document.dataarea.EnableFloppy.checked)); 
					document.dataarea.FloppyAddrBox2.disabled =(!(document.dataarea.EnableFloppy.checked)); 
					document.dataarea.FloppyAddrBox3.disabled =(!(document.dataarea.EnableFloppy.checked)); 
					document.dataarea.FloppyAddrBox4.disabled =(!(document.dataarea.EnableFloppy.checked)); 
					document.dataarea.RemoteFloppyTFTPPath.disabled =(!(document.dataarea.EnableFloppy.checked)); 
				}


				function chkIPAddress(objName, Octet1MaxVal,Octet4MinVal,Octet4MaxVal)
				{
					var octet1 = eval("document.dataarea." + objName + "1");
					var octet2 = eval("document.dataarea." + objName + "2");
					var octet3 = eval("document.dataarea." + objName + "3");
					var octet4 = eval("document.dataarea." + objName + "4");
					
					if (octet1.disabled == true) return true
					else
					{
						if (octet1.value == null || octet1.value == "" || octet1.value.indexOf(".") &gt;= 0) return false;
						else if (isNaN(octet1.value)) return false;
						else octet1 = parseInt(octet1.value);

						if (octet2.value == null || octet2.value == "" || octet2.value.indexOf(".") &gt;= 0) return false;
						else if (isNaN(octet2.value)) return false;
						else octet2 = parseInt(octet2.value);

						if (octet3.value == null || octet3.value == "" || octet3.value.indexOf(".") &gt;= 0) return false;
						else if (isNaN(octet3.value)) return false;
						else octet3 = parseInt(octet3.value);

						if (octet4.value == null || octet4.value == "" || octet4.value.indexOf(".") &gt;= 0) return false;
						else if (isNaN(octet4.value)) return false;
						else octet4 = parseInt(octet4.value);

						if (octet1 &lt; 1  || octet1 &gt; Octet1MaxVal) return false;
						else if (octet2 &lt; 0  || octet2 &gt; 255) return false;
						else if (octet3 &lt; 0  || octet3 &gt; 255) return false;
						else if (octet4 &lt; Octet4MinVal   || octet4 &gt; Octet4MaxVal) return false;
						else return true;
					}
				}

				function validate()
				{
					var invalidIP = false;
					var errorMsg = "";
					
					
					if (chkIPAddress("FloppyAddrBox", 254, 1, 254) == false) 
					{
						errorMsg += "<xsl:value-of select="$Invalidremotefloppy"/>";
						invalidIP = true;
					}
					
					if (chkIPAddress("FWAddrBox", 254, 1, 254) == false) 
					{
						if (errorMsg != "") errorMsg += "\n";
						errorMsg += "<xsl:value-of select="$Invalidremotefirmware"/>";
						invalidIP = true;
					}
					
					var pathTextBox = document.dataarea.RemoteFloppyTFTPPath;
					
					if (pathTextBox.disabled == false &amp;&amp; pathTextBox.value == "")
					{
						if (errorMsg != "") errorMsg += "\n";
						errorMsg += "<xsl:value-of select="$RemotefloppyTFTP"/>";
						invalidIP = true;
					}
					else if (!testUnicode(pathTextBox.value))
					{
						if (errorMsg != "") errorMsg += "\n";
						errorMsg += "<xsl:value-of select="$RemotefloppyTFTP1"/>";
						invalidIP = true;
					}

					pathTextBox = document.dataarea.RemoteFirmwareUpdatePath; 
					if (pathTextBox.disabled == false &amp;&amp; !testUnicode(pathTextBox.value))
					{
						if (errorMsg != "") errorMsg += "\n";
						errorMsg += "<xsl:value-of select="$Remotefirmwareupdate"/>";
						invalidIP = true;
					}

					if (invalidIP == true)
					{
						alert(errorMsg)
						return false;
					}
					else
					{
						alert(resetMsg);
						trimIPAddress("FloppyAddrBox" , 4);
						trimIPAddress("FWAddrBox" , 4);
						return true;
					}					
				}
				
				function trimIPAddress(ipboxname , length){
					for (i =1 ; i &lt;= length ; i++) {
						var ipbox = ipboxname + i;
						try
						{
							var ipboxval = document.getElementById(ipbox).value;
							document.getElementById(ipbox).value = trim(ipboxval);
						}
						catch(e){};
					}
				}
			</script>
		</DataArea>
		
	</xsl:template>
	<xsl:template name="RemoteBootParams">
			<Row>
				<Data type="ustring" editable="false" width="210">
					<xsl:attribute name="value"><xsl:value-of select="$EnableRemoteFloppy"/></xsl:attribute>
				</Data>
				<Data name="EnableFloppy" display="" type="checkbox" editable="true" event="onClick" handler="javascript:EnableRemoteBootSettings()">
					<xsl:if test="RemoteHostObj/RhostsFloppyTftpEnable='true'">
						<xsl:attribute name="state">1</xsl:attribute>
					</xsl:if>
				</Data>

			</Row> 
			<Row>
				<xsl:call-template name="ShowIPAddrBox">
					<xsl:with-param name="Address"><xsl:value-of select="RemoteHostObj/RhostsFloppyTftpIpAddr"/></xsl:with-param>
					<xsl:with-param name="DisplayStr"><xsl:value-of select="$RemoteFloppyTFTP"/></xsl:with-param>
					<xsl:with-param name="IPCtrlName">FloppyAddrBox</xsl:with-param>
				</xsl:call-template>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$RemoteFloppyTFTP1"/></xsl:attribute>
				</Data>
				<Data name="RemoteFloppyTFTPPath" type="editbox" editable="true" maxlength="200">
					<xsl:attribute name="value"><xsl:value-of select="RemoteHostObj/RhostsFloppyTftpPath"/></xsl:attribute>
				</Data>
			</Row>		

	</xsl:template>

	<xsl:template name="RemoteFwUpdateParams">
			<Row>
				<xsl:call-template name="ShowIPAddrBox">
					<xsl:with-param name="Address"><xsl:value-of select="RemoteHostObj/RhostsFwUpdateIpAddr"/></xsl:with-param>
					<xsl:with-param name="DisplayStr"><xsl:value-of select="$RemoteFirmwareTFTP"/></xsl:with-param>
					<xsl:with-param name="IPCtrlName">FWAddrBox</xsl:with-param>
				</xsl:call-template>
			</Row>
			<Row>
				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$RemoteFirmwareUpdate2"/></xsl:attribute>
				</Data>
				<Data name="RemoteFirmwareUpdatePath" type="editbox" editable="true" maxlength="235">
					<xsl:attribute name="value"><xsl:value-of select="RemoteHostObj/RhostsFwUpdatePath"/></xsl:attribute>
				</Data>
			</Row>		
	</xsl:template>
		
		<xsl:template name="ShowIPAddrBox">
		<xsl:param name="Address"/>
		<xsl:param name="DisplayStr"/>
		<xsl:param name="IPCtrlName"/>


				<Data type="ustring" editable="false">
					<xsl:attribute name="value"><xsl:value-of select="$DisplayStr"/></xsl:attribute>
				</Data>
				<Data type="ipaddrbox" autocursoroff="false">
					<xsl:attribute name="name"><xsl:value-of select="$IPCtrlName"/></xsl:attribute>
					<xsl:attribute name="sep">.</xsl:attribute>
					
					<xsl:variable name="var1"><xsl:value-of select="substring-before($Address,'.')"/></xsl:variable>
					<xsl:variable name="holdString1"><xsl:value-of select="substring-after($Address,'.')"/></xsl:variable>
					<xsl:variable name="var2"><xsl:value-of select="substring-before($holdString1,'.')"/></xsl:variable>
					<xsl:variable name="holdString2"><xsl:value-of select="substring-after($holdString1,'.')"/></xsl:variable>
					<xsl:variable name="var3"><xsl:value-of select="substring-before($holdString2,'.')"/></xsl:variable>
					<xsl:variable name="holdString3"><xsl:value-of select="substring-after($holdString2,'.')"/></xsl:variable>
					<xsl:variable name="var4"><xsl:value-of select="$holdString3"/></xsl:variable>
					
					<xsl:attribute name="value1"><xsl:value-of select="$var1"/></xsl:attribute>
					<xsl:attribute name="value2"><xsl:value-of select="$var2"/></xsl:attribute>
					<xsl:attribute name="value3"><xsl:value-of select="$var3"/></xsl:attribute>
					<xsl:attribute name="value4"><xsl:value-of select="$var4"/></xsl:attribute>
				</Data>
	</xsl:template>

</xsl:stylesheet>