<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA/OMAUserRights"/>	
	<xsl:template match="OMA">	
	<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>	
		<DataArea validate="true" onLoad="true">		
			<xsl:if test="$usrights='7'">
				<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.drsc.webplugins.SetDRSCModem</xsl:attribute>
			</xsl:if>
			<PageTitle><xsl:attribute name="display"><xsl:value-of select="$ConfigureModemProperties"/></xsl:attribute></PageTitle>
			<PromptText/>
			<CustomButton>
				<Data name=""><xsl:attribute name="display"><xsl:value-of select="$Refresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCModem</xsl:attribute>
				</Data>
			</CustomButton>
			<TableData columnspacing="true">			
				<xsl:apply-templates select="DialUpNetworkingObj"/>
				<Header>
					<Data name="Property" editable="false" type="usting"><xsl:attribute name="display"><xsl:value-of select="$Property"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$ModemProperty"/></xsl:attribute>
					</Data>
					<Data name="Value" editable="false" type="usting" colspan="1"><xsl:attribute name="display"><xsl:value-of select="$Value"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$Value1"/></xsl:attribute>
					</Data>
				</Header>
			</TableData>	
			<script type="text/javascript" src="/drsc/js/utility.js"/>
			<script language="javascript">		

				var usrights = '<xsl:value-of select="/OMA/OMAUserRights"/>'
				var	resetMsg = "<xsl:value-of select="$Thisoperationcaused"/>";

				function UpdateInitString()
				{
					document.dataarea.ModemInitString.value=document.dataarea.CountryName.value;
				}
				
				function initializationRoutine()
				{
					EnableModemSettings();
				}
				
				function EnableModemSettings()
				{
					if (usrights != 7 )
					{
							document.dataarea.radioDialMode.disabled =true;
							document.dataarea.ModemInitString.disabled =true; 
							document.dataarea.CountryName.disabled =true; 
							document.dataarea.DialInAuthentication.disabled =true; 
					}
				}
				
				function validate()
				{
					if (document.dataarea.ModemInitString.value == "")
					{
						var errorMsg = "<xsl:value-of select="$Modeminitializationstring"/>";
						alert(errorMsg);
						return false;
					}
					else if (!testUnicode(document.dataarea.ModemInitString.value))
					{
						var errorMsg = "<xsl:value-of select="$Modeminitializationstring1"/>";
						alert(errorMsg);
						return false;
					}
					else
					{
						alert(resetMsg);
						return true;
					}
				}


			</script>		
		</DataArea>
	</xsl:template>
	<xsl:template match="DialUpNetworkingObj">	
		<Row>
			<Data type="ustring" editable="false" width="150">
				<xsl:attribute name="value"><xsl:value-of select="$DialType"/></xsl:attribute>
			</Data>
			<Data name="radioDialMode" type="select" editable="true">
				<Choice returnvalue="0">
					<xsl:attribute name="value"><xsl:value-of select="$Pulse"/></xsl:attribute>
					<xsl:if test="DialupDialType=0">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="1">
					<xsl:attribute name="value"><xsl:value-of select="$Tone"/></xsl:attribute>
					<xsl:if test="DialupDialType=1">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</Data>
		</Row>
		
		<Row>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$CountryCode"/></xsl:attribute>
			</Data>
			<Data name="CountryName" type="select" editable="true" event="onChange" handler="javascript:UpdateInitString()"><xsl:attribute name="display"><xsl:value-of select="$baud"/></xsl:attribute>
				<Choice returnvalue="AT">
					<xsl:attribute name="value"><xsl:value-of select="$NotAvailable"/></xsl:attribute>
					<xsl:choose>
						<xsl:when test="contains(DialupModemInitString,'GCI=09')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=0A')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=0F')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=1B')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=20')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=26')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=2E')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=31')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=3C')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=3D')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=42')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=46')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=50')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=51')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=53')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=57')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=58')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=59')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=00')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=61')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=69')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=73')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=7B')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=7E')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=82')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=89')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=8A')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=8B')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=B8')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=9C')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=A0')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=A5')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=A6')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=FE')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=B4')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(DialupModemInitString,'GCI=B5')">
							<xsl:attribute name="default">false</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="default">true</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</Choice>
				<Choice returnvalue="AT+GCI=09">
					<xsl:attribute name="value"><xsl:value-of select="$Australia"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=09')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=0A">
					<xsl:attribute name="value"><xsl:value-of select="$Austria"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=0A')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=0F">
					<xsl:attribute name="value"><xsl:value-of select="$Belgium"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=0F')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=1B">
					<xsl:attribute name="value"><xsl:value-of select="$Bulgaria"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=1B')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=20">
					<xsl:attribute name="value"><xsl:value-of select="$Canada"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=20')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=26">
					<xsl:attribute name="value"><xsl:value-of select="$China"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=26')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=2E">
					<xsl:attribute name="value"><xsl:value-of select="$CzechandSlavak"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=2E')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=31">
					<xsl:attribute name="value"><xsl:value-of select="$Denmark"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=31')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=3C">
					<xsl:attribute name="value"><xsl:value-of select="$Finland"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=3C')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=3D">
					<xsl:attribute name="value"><xsl:value-of select="$France"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=3D')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=42">
					<xsl:attribute name="value"><xsl:value-of select="$Germany"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=42')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=46">
					<xsl:attribute name="value"><xsl:value-of select="$Greece"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=46')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=50">
					<xsl:attribute name="value"><xsl:value-of select="$HongKong"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=50')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=51">
					<xsl:attribute name="value"><xsl:value-of select="$Hungary"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=51')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=53">
					<xsl:attribute name="value"><xsl:value-of select="$India"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=53')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=57">
					<xsl:attribute name="value"><xsl:value-of select="$Ireland"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=57')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=58">
					<xsl:attribute name="value"><xsl:value-of select="$Israel"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=58')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=59">
					<xsl:attribute name="value"><xsl:value-of select="$Italy"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=59')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=00">
					<xsl:attribute name="value"><xsl:value-of select="$Japan"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=00')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=61">
					<xsl:attribute name="value"><xsl:value-of select="$Korea"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=61')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=69">
					<xsl:attribute name="value"><xsl:value-of select="$Luxembourg"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=69')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=73">
					<xsl:attribute name="value"><xsl:value-of select="$Mexico"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=73')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=7B">
					<xsl:attribute name="value"><xsl:value-of select="$Netherlands"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=7B')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=7E">
					<xsl:attribute name="value"><xsl:value-of select="$NewZealand"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=7E')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=82">
					<xsl:attribute name="value"><xsl:value-of select="$Norway"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=82')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=89">
					<xsl:attribute name="value"><xsl:value-of select="$Philippines"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=89')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=8A">
					<xsl:attribute name="value"><xsl:value-of select="$Poland"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=8A')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=8B">
					<xsl:attribute name="value"><xsl:value-of select="$Portugal"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=8B')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=B8">
					<xsl:attribute name="value"><xsl:value-of select="$Russia"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=B8')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=9C">
					<xsl:attribute name="value"><xsl:value-of select="$Singapore"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=9C')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=A0">
					<xsl:attribute name="value"><xsl:value-of select="$Spain"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=A0')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=A5">
					<xsl:attribute name="value"><xsl:value-of select="$Sweden"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=A5')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=A6">
					<xsl:attribute name="value"><xsl:value-of select="$Switzerland"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=A6')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=FE">
					<xsl:attribute name="value"><xsl:value-of select="$Taiwan"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=FE')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=B4">
					<xsl:attribute name="value"><xsl:value-of select="$UnitedKingdom"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=B4')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="AT+GCI=B5">
					<xsl:attribute name="value"><xsl:value-of select="$UnitedStates"/></xsl:attribute>
					<xsl:if test="contains(DialupModemInitString,'GCI=B5')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</Data>
		</Row>

		<Row>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$InitializationString"/></xsl:attribute>
			</Data>
			<Data name="ModemInitString" type="editbox" editable="true">
				<xsl:attribute name="value">
					 <xsl:value-of select="DialupModemInitString"/>
				</xsl:attribute>
			</Data>

		</Row>

		<Row>
			<Data type="ustring" editable="false">
				<xsl:attribute name="value"><xsl:value-of select="$BaudRate"/></xsl:attribute>
			</Data>
			<Data type="select" name="DialInAuthentication" editable="true"><xsl:attribute name="display"><xsl:value-of select="$DialInAuthentication"/></xsl:attribute>
				<Choice returnvalue="38400">
					<xsl:attribute name="value"><xsl:value-of select="$Default1"/></xsl:attribute>
				</Choice>
				<Choice value="2400" returnvalue="2400">
					<xsl:if test="DialupModemBaudRate='2400'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice value="4800" returnvalue="4800">
					<xsl:if test="DialupModemBaudRate='4800'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>				
				</Choice>
				<Choice value="7200" returnvalue="7200">
					<xsl:if test="DialupModemBaudRate='7200'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>				
				</Choice>
				<Choice value="9600" returnvalue="9600">
					<xsl:if test="DialupModemBaudRate='9600'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>				
				</Choice>
				<Choice value="19200" returnvalue="19200">
					<xsl:if test="DialupModemBaudRate='19200'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>				
				</Choice>
				<Choice value="38400" returnvalue="38400">
					<xsl:if test="DialupModemBaudRate='38400'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>				
				</Choice>
				<Choice value="57600" returnvalue="57600">
					<xsl:if test="DialupModemBaudRate='57600'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</Data>
		</Row>
		
	</xsl:template>
</xsl:stylesheet>