<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA/OMAUserRights"/>	
	
	<xsl:template match="OMA">	
	<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>
		<DataArea>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$ConfigureDemandDialOut"/></xsl:attribute>
			</PageTitle>
			<xsl:if test="$usrights='7'">
				<PromptText><xsl:value-of select="$ClickonIP"/></PromptText>
			</xsl:if>			
			<CustomButton>
				<xsl:choose>
					<xsl:when test="DemandDialObjList/NumValidEntries='16'">
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="$usrights='7'">
						<Data name="Add"><xsl:attribute name="display"><xsl:value-of select="$Add"/></xsl:attribute>
							<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCGetDialOutEntry&amp;help=acddo&amp;app=drsc</xsl:attribute>
						</Data>
						</xsl:if>					
					</xsl:otherwise>
				</xsl:choose>
				<Data name=""><xsl:attribute name="display"><xsl:value-of select="$Refresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCDemandDialOutUsers</xsl:attribute>
				</Data>
			</CustomButton>
			<xsl:apply-templates select="DemandDialObjList"/>
		</DataArea>
	</xsl:template>

	<xsl:template match="DemandDialObjList">	
		<TableData name="DemandDialOutUsers" columnspacing="true"><xsl:attribute name="display"><xsl:value-of select="$DialOutUsers"/></xsl:attribute>				
		<SubHeader><xsl:attribute name="display"><xsl:value-of select="$DemandDialOutEntries"/></xsl:attribute></SubHeader>
			<Header>
				<Data ignoreonweb="true">
					<xsl:attribute name="display"><xsl:value-of select="$Index"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$Index1"/></xsl:attribute>
				</Data>
				<Data editable="false" type="usting">
					<xsl:attribute name="display"><xsl:value-of select="$MaskedIPAddress"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$MaskedIPAddress1"/></xsl:attribute>
				</Data>
				<Data ignoreoncli="true" editable="false" type="usting">
					<xsl:attribute name="display"><xsl:value-of select="$UserName"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$UserName1"/></xsl:attribute>
				</Data>
				<Data ignoreoncli="true" editable="false" type="usting">
					<xsl:attribute name="display"><xsl:value-of select="$PhoneNumber"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$PhoneNumber1"/></xsl:attribute>
				</Data>
				<Data ignoreoncli="true" editable="false" type="usting">
					<xsl:attribute name="display"><xsl:value-of select="$Authentication"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$Authentication1"/></xsl:attribute>
				</Data>
			</Header>				
			<xsl:apply-templates select="DemandDialObj"/> 
		</TableData>
	</xsl:template>
	
	<xsl:template match="DemandDialObj">
	<xsl:variable name="usrights"><xsl:value-of select="/OMA/OMAUserRights"/></xsl:variable>
		<Row>
			<Data ignoreonweb="true">
				<xsl:attribute name="display"><xsl:value-of select="@index"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="@index"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:choose>
					<xsl:when test="$usrights='7'">
						<xsl:attribute name="link">true</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="link">false</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>

				<xsl:attribute name="value"><xsl:value-of select="DemandDialIpAddr"/></xsl:attribute>
				<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCGetDialOutEntry&amp;oid=<xsl:value-of select="@oid"/>&amp;help=acddo&amp;app=drsc</xsl:attribute>
			</Data>
			<Data ignoreoncli="true">
				<xsl:attribute name="value"><xsl:value-of select="DemandDialPppUserName"/></xsl:attribute>
			</Data>							
			<Data ignoreoncli="true">
				<xsl:attribute name="value"><xsl:value-of select="DemandDialPhoneNumber"/></xsl:attribute>
			</Data>							
			<Data ignoreoncli="true">
				<xsl:choose>
					<xsl:when test="DemandDialAuthType='0'">
						<xsl:attribute name="value"><xsl:value-of select="$Any"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="DemandDialAuthType='1'">
						<xsl:attribute name="value"><xsl:value-of select="$Encrypted"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><xsl:value-of select="$Mschap"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
			</Row>
	</xsl:template>
</xsl:stylesheet>