<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA/OMAUserRights"/>	
	<xsl:template match="/OMA">	
	<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>
		<DataArea>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$ConfigureDialInUsers"/></xsl:attribute>
			</PageTitle>
			<xsl:if test="$usrights='7'">
					<PromptText><xsl:value-of select="$Clickonuser"/></PromptText>
			</xsl:if>
			
			<CustomButton>
				<xsl:choose>
					<xsl:when test="DialInUsersObjList/NumValidEntries='16'">
					</xsl:when>
					<xsl:otherwise>
					<xsl:if test="$usrights='7'">
						<Data name="Add"><xsl:attribute name="display"><xsl:value-of select="$Add"/></xsl:attribute>
							<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCGetDialInUserEntry&amp;help=dialinu&amp;app=drsc</xsl:attribute>
						</Data>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
				<Data name=""><xsl:attribute name="display"><xsl:value-of select="$Refresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCDialInUsers</xsl:attribute>
				</Data>
			</CustomButton>
			<xsl:apply-templates select="DialInUsersObjList">
			</xsl:apply-templates>
		</DataArea>
	</xsl:template>
	
	<xsl:template match="DialInUsersObjList">	
		<TableData name="tab2" columnspacing="true"><xsl:attribute name="display"><xsl:value-of select="$UserList"/></xsl:attribute>				
			<SubHeader><xsl:attribute name="display"><xsl:value-of select="$ListofDialIn"/></xsl:attribute></SubHeader>
			<Header>
				<Data ignoreonweb="true">
					<xsl:attribute name="display"><xsl:value-of select="$Index"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$Index1"/></xsl:attribute>
				</Data>
				<Data editable="false" type="usting">
					<xsl:attribute name="display"><xsl:value-of select="$UserName"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$UserName1"/></xsl:attribute>
				</Data>
				<Data ignoreoncli="true" editable="false" type="usting">
					<xsl:attribute name="display"><xsl:value-of select="$CallbackNumber"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$CallbackNumber1"/></xsl:attribute>
				</Data>
			</Header>		
		
			<xsl:apply-templates select="DialInUsersObj">
			</xsl:apply-templates>

				
		</TableData>
	</xsl:template>
		
	<xsl:template match="DialInUsersObj">
		<xsl:variable name="usrights"><xsl:value-of select="/OMA/OMAUserRights"/></xsl:variable>
			<Row>
				<xsl:element name="Data">
					<xsl:attribute name="ignoreonweb">true</xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="@index"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="@index"/></xsl:attribute>
				</xsl:element>
				<Data>
					<xsl:choose>
					<xsl:when test="$usrights='7'">
						<xsl:attribute name="link">true</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="link">false</xsl:attribute>
					</xsl:otherwise>
					</xsl:choose>

					<xsl:attribute name="value"><xsl:value-of select="DialinUsrPppUserName"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.drsc.webplugins.DRSCGetDialInUserEntry&amp;oid=<xsl:value-of select="@oid"/>&amp;help=dialinu&amp;app=drsc</xsl:attribute>
				</Data>
				<Data ignoreoncli="true">
					<xsl:choose>
						<xsl:when test="DialinUsrCallbackNumber=''">
							<xsl:attribute name="value"><xsl:value-of select="$NA"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="value"><xsl:value-of select="DialinUsrCallbackNumber"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</Data>
			</Row>			
	</xsl:template>
	
</xsl:stylesheet>