<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA/OMAUserRights"/>	
	<xsl:template match="/OMA">	
		<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>		
		<DataArea onLoad="true">
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$CSRNext"/></xsl:attribute>
			<xsl:attribute name="submit">javascript:submit()</xsl:attribute>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$CSRManagement"/></xsl:attribute>
			</PageTitle>
			<PromptText><xsl:value-of select="$CSRPrompt"/></PromptText>
			<TableData>
				<Header>
					<Data name="">
						<xsl:attribute name="display"><xsl:value-of select="$CSRTitle"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$CSRTitle"/></xsl:attribute>
					</Data>
				</Header>
				<Row>
					<Data name="option" display=" " returnvalue ="1" editable="true" type="radio" state="1" align="left">
						<xsl:attribute name="value"><xsl:value-of select="$CSRGenerate"/></xsl:attribute>
					</Data>
				</Row>
				<Row>
					<Data name="option" display=" " returnvalue ="2" editable="true" type="radio" align="left">
						<xsl:attribute name="value"><xsl:value-of select="$CSRUpload"/></xsl:attribute>
					</Data>
				</Row>
				<Row>
					<Data name="option" display=" " returnvalue ="3" editable="true" type="radio" align="left">
						<xsl:attribute name="value"><xsl:value-of select="$CSRViewServerCert"/></xsl:attribute>
					</Data>
				</Row>
				<Row>
					<Data name="option" display=" " returnvalue ="4" editable="true" type="radio" align="left">
						<xsl:attribute name="value"><xsl:value-of select="$CSRViewCACert"/></xsl:attribute>
					</Data>
				</Row>
			</TableData>
			<script language="javascript">
				
				var userRights = '<xsl:value-of select="/OMA/OMAUserRights"/>'

				function initializationRoutine()
				{
					if (userRights != 7 )
					{
						optionVariable = document.getElementsByName("option");
						optionVariable[0].disabled = true;
						optionVariable[1].disabled = true;
						optionVariable[2].checked = true;
					}
				}
				
				function submit()
				{
					optionVariable = document.getElementsByName("option");
					if (optionVariable[0].checked == true)
						document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.drsc.webplugins.RACCSRGenerate&amp;help=gencert");
					else if (optionVariable[1].checked == true)
						document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.drsc.webplugins.RACCSRUpload&amp;help=uploadcert");
					else if (optionVariable[2].checked == true)
						document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.drsc.webplugins.RACCSRView&amp;certType=1&amp;help=viewcert");
					else if (optionVariable[3].checked == true)
						document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.drsc.webplugins.RACCSRView&amp;certType=2&amp;help=viewcert");
				}
				
			</script>
		</DataArea>
	</xsl:template>
</xsl:stylesheet>


