<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA/OMAUserRights"/>
	<xsl:template match="/OMA">
		<xsl:variable name="status"><xsl:value-of select="SMStatus"/></xsl:variable>
		<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>
		<DataArea validate="true" onLoad="true">
			<xsl:if test="$usrights='7'">
				<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.drsc.webplugins.RACSetAuthConfig</xsl:attribute>
			</xsl:if>

			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$AuthConfigTitle"/></xsl:attribute>
			</PageTitle>
			
			<PromptText></PromptText>

			<TableData name="AuthOptionsTable" display="AuthOptionsTable">
				<Header>
					
					<Data name="Property"    display="Property"    value="Property" editable="false" ignoreonweb="true" type="usting" colspan="1" />
					<Data name="Value"      display="Value"        value="Value" ignoreonweb="true" editable="false" type="usting" />
					<Data name="Property"      display="Property"        value="Property" ignoreoncli="true" ignoreonweb="true" editable="false" type="usting" />
				</Header>
				<Row>
					<Data type="ustring" ignoreonweb="true" editable="false" width="100%">
						<xsl:attribute name="value"><xsl:value-of select="$AuthConfigRAC"/></xsl:attribute>
					</Data>
					<Data state="3" name="RACAuth" type="checkbox" editable="true" align="left" width="20" />
					<Data type="ustring" ignoreoncli="true" editable="false" width="100%">
						<xsl:attribute name="value"><xsl:value-of select="$AuthConfigRAC"/></xsl:attribute>
					</Data>
				</Row>
				<Row>
					<Data type="ustring" ignoreonweb="true" editable="false" width="100%">
						<xsl:attribute name="value"><xsl:value-of select="$AuthConfigOS"/></xsl:attribute>
					</Data>
					<Data name="osAuth" type="checkbox" editable="true" align="left" width="20">
                  <xsl:choose>
	            <xsl:when test="RACAuthLocalAllowed='0'">

							<xsl:attribute name="state">2</xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
						<xsl:if test="RACAuthLocalOSEnable='1'">
							<xsl:attribute name="state">1</xsl:attribute>
						</xsl:if>
                    </xsl:otherwise>
                    </xsl:choose>
					</Data>
					<Data type="ustring" ignoreoncli="true" editable="false" width="100%">
						<xsl:attribute name="value"><xsl:value-of select="$AuthConfigOS"/></xsl:attribute>
					</Data>
				</Row> 
			</TableData>

			<script language="javascript">
				var userRights = '<xsl:value-of select="/OMA/OMAUserRights"/>'

				function initializationRoutine()
				{
					if (userRights != 7) document.dataarea.osAuth.disabled = true;
				}
				
				function validate() { return true; }
				
			</script>
		</DataArea>
	</xsl:template>
	<xsl:template match="*"/>	
</xsl:stylesheet>