<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/OMA">
		<DataArea validate="true">
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strRestartToActivate"/></xsl:attribute>
			<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.oma.webplugins.RstServiceWebPlugin&amp;help=Certificate&amp;app=oma&amp;closeBrowserOnly=true</xsl:attribute>
			<xsl:choose>
				<xsl:when test="MakeActive/@mode = 'generate'">
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strMakeX509Certificate"/></xsl:attribute>
					</PageTitle>
				</xsl:when>
				<xsl:when test="MakeActive/@mode = 'import'">
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strMakeX509Trusted"/></xsl:attribute>
					</PageTitle>
				</xsl:when>
			</xsl:choose>
			<PromptText status="3"><xsl:value-of select="$strClickOnThe"/></PromptText>
			<TableData>
				<Header>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strStepsToRestore"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strStepsToRestore1"/></xsl:attribute>
					</Data>
				</Header>
				<Row>
					<Data>
					<xsl:attribute name="value"><xsl:value-of select="$str1StopThe"/></xsl:attribute>
					</Data>
				</Row>
				<Row>
					<Data><xsl:attribute name="value"><xsl:value-of select="$str"/></xsl:attribute></Data>
				</Row>
				<Row>
					<Data>
						<xsl:choose>
							<xsl:when test="(MakeActive/@os='1') or (MakeActive/@os='2')">
								<xsl:attribute name="value"><xsl:value-of select="$str2DeleteFile"/><xsl:value-of select="MakeActive/@path"/>\config\keystore.db</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="value"><xsl:value-of select="$str2DeleteFile1"/><xsl:value-of select="MakeActive/@path"/>/config/keystore.db</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</Data>
				</Row>
				<Row>
					<Data><xsl:attribute name="value"><xsl:value-of select="$str1"/></xsl:attribute></Data>
				</Row>
				<Row>
					<Data>
						<xsl:choose>
							<xsl:when test="(MakeActive/@os='1') or (MakeActive/@os='2')">
								<xsl:attribute name="value"><xsl:value-of select="$str3RenameFile"/><xsl:value-of select="MakeActive/@path"/>\config\keystore.db.bak<xsl:value-of select="$strTo"/><xsl:value-of select="MakeActive/@path"/>\config\keystore.db</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="value"><xsl:value-of select="$str3RenameFile1"/><xsl:value-of select="MakeActive/@path"/>/config/keystore.db.bak<xsl:value-of select="$strTo1"/><xsl:value-of select="MakeActive/@path"/>/config/keystore.db</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</Data>
				</Row>
				<Row>
					<Data><xsl:attribute name="value"><xsl:value-of select="$str2"/></xsl:attribute></Data>
				</Row>
				<Row>
					<Data>
						<xsl:attribute name="value"><xsl:value-of select="$str4StartThe"/></xsl:attribute>
					</Data>					
				</Row>
			</TableData>
			<script language="javascript">
				function validate()
				{
					alert("<xsl:value-of select="$strThisWillRestart"/>");
					return true;
				}
			</script>
		</DataArea>
	</xsl:template>
	<xsl:template match="*"/>	
</xsl:stylesheet>
