<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/OMA">
		<DataArea exportdata="false">
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strNext"/></xsl:attribute>
			<xsl:attribute name="submit">/servlet/SubmitForm?plugin=security.X509.webplugins.GetoptionWebPlugin</xsl:attribute>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strX509CertificateManagement"/></xsl:attribute>
			</PageTitle>
			<PromptText>
				<xsl:choose>
					<xsl:when test="Selection/@reuse='true'">
						<xsl:choose>
							<xsl:when test="WriteAccess">
								<xsl:attribute name="status">4</xsl:attribute>
								<xsl:choose>
									<xsl:when test="WriteAccess/@mode='generate'"><xsl:value-of select="$strKeystoredbIsWriteprotected"/>
									</xsl:when>
									<xsl:otherwise><xsl:value-of select="$strKeystoredbIsWriteprotected1"/></xsl:otherwise>
								</xsl:choose>							
							</xsl:when>
							<xsl:otherwise><xsl:value-of select="$strSelectOneOf"/>
							</xsl:otherwise>
						</xsl:choose>						
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="WriteAccess">
								<xsl:attribute name="status">4</xsl:attribute>
								<xsl:choose>
									<xsl:when test="WriteAccess/@mode='generate'"><xsl:value-of select="$strKeystoredbIsWriteprotected2"/></xsl:when>
									<xsl:otherwise><xsl:value-of select="$strKeystoredbIsWriteprotected3"/></xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise><xsl:value-of select="$strThereIsNo"/></xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</PromptText>
			<TableData columnspacing="true">
				<Header>
					<Data name="">
						<xsl:attribute name="display"><xsl:value-of select="$strX509CertificateOption"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strX509CertificateOption1"/></xsl:attribute>
					</Data>
				</Header>
				<xsl:choose>
					<xsl:when test="WriteAccess"></xsl:when>
					<xsl:otherwise>
						<Row>
							<Data name="option" returnvalue ="gen" editable="true" type="radio" state="1" align="left"><xsl:attribute name="display"><xsl:value-of select="$str"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strGenerateANew"/></xsl:attribute>
							</Data>
						</Row>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:if test="Selection/@reuse='true'">
					<Row>
						<Data name="option" returnvalue ="reuse" editable="true" type="radio" align="left"><xsl:attribute name="display"><xsl:value-of select="$str1"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strReuseAnExisting"/></xsl:attribute>
							<xsl:attribute name="state"><xsl:if test="WriteAccess">1</xsl:if></xsl:attribute>
						</Data>
					</Row>
					<Row>
						<Data name="option" returnvalue ="importroot" editable="true" type="radio" align="left"><xsl:attribute name="display"><xsl:value-of select="$str2"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strImportARoot"/></xsl:attribute>
						</Data>
					</Row>
					<xsl:choose>
						<xsl:when test="WriteAccess"></xsl:when>
						<xsl:otherwise>
							<Row>
								<Data name="option" returnvalue ="importchain" editable="true" type="radio" align="left"><xsl:attribute name="display"><xsl:value-of select="$str3"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="$strImportACertificate"/></xsl:attribute>
								</Data>
							</Row>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</TableData>
		</DataArea>
	</xsl:template>
	<xsl:template match="*"/>
</xsl:stylesheet>

