function testUnicode(sValue)
{
	var sStr = new String(sValue);
	for (var i = 0; i < sStr.length; i++)
	{
		if (sStr.charCodeAt(i) < 32 || sStr.charCodeAt(i) > 254 || sStr.charCodeAt(i) == 127) return false;
	}
	return true;
}

function ltrim(s) 
{ 
	return s.replace(/^\s*/, "");
} 
		
function rtrim(s) 
{ 
	return s.replace(/\s*$/, ""); 
} 
		
function trim(s) 
{ 
	return rtrim(ltrim(s)); 
}

var DELIM_ALPHA_NUMERIC = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
var DELIM_COMMON_NAME = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_.";
var DELIM_ORGANIZATION = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_. ";
var DELIM_LOCALE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789 ";
var DELIM_FILE_NAME = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_'$,.!%():[]=/\\+~@ ";
var DELIM_EMAIL = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_.@";

function checkString(text, delim)
{
	var validValue = new String(delim);
	text = new String(trim(text));
						
	for (var i = 0; i < text.length; i++)
	{
		if (validValue.indexOf(text.charAt(i)) < 0) return false;
	}
	
	return true;
}

function addToErrorMsg(errStr, msg)
{
	if (errStr == null || errStr == "") return msg;
	else return errStr + "\n" + msg;
}