#!/bin/sh

ldConfFile=/etc/ld.so.conf
smFolder=/opt/dell/openmanage/sm
delvlFolder=/opt/dell/openmanage/sm/dellvl
omaFolder=/opt/dell/openmanage/oma/bin

soList="one.so two.so"
emptyList=
soSuffix=so


# change directory to the storage management folder


#################
# CREATING LINKS#
#################
cd $omaFolder
echo "Creating link for libclpsup32"
ln -sf libclpsup32.so.2 libclpsup32.so.1

echo "Creating link for libomadb32"
ln -sf libomadb32.so.2 libomadb32.so.1

echo "Creating link for libomcldb32"
ln -sf libomcldb32.so.2 libomcldb32.so.1

cd $smFolder
echo "Creating link for libmegalib"
ln -sf libmegalib.so.5.* libmegalib.so.5
ln -sf libmegalib.so.5   libmegalib.so

echo "Creating link for libqueue"
ln -sf libqueue.so.1.* libqueue.so.1
ln -sf libqueue.so.1 libqueue.so

echo "Creating link for libval"
ln -sf libval.so.1.* libval.so.1
ln -sf libval.so.1 libval.so

echo "Creating link for libral32"
ln -sf libral32.so.1.* libral32.so.1
ln -sf libral32.so.1 libral32.so

echo "Creating link for libdcsif32"
ln -sf libdcsif32.so.1.* libdcsif32.so.1
ln -sf libdcsif32.so.1 libdcsif32.so

echo "Creating link for libcivil32"
ln -sf libcivil32.so.1.* libcivil32.so.1
ln -sf libcivil32.so.1 libcivil32.so

echo "Creating link for libdcsipe32"
ln -sf libdcsipe32.so.1.* libdcsipe32.so.1
ln -sf libdcsipe32.so.1 libdcsipe32.so

echo "Creating link for libevtmsg32"
ln -sf libevtmsg32.so.1.* libevtmsg32.so.1
ln -sf libevtmsg32.so.1 libevtmsg32.so

echo "Creating link for libssimp32"
ln -sf libssimp32.so.1.* libssimp32.so.1
ln -sf libssimp32.so.1 libssimp32.so

echo "Creating link for libdscil32"
ln -sf libdscil32.so.1.* libdscil32.so.1
ln -sf libdscil32.so.1 libdscil32.so

echo "Creating link for libScsiDevDiag"
ln -sf libScsiDevDiag.so.300.* libScsiDevDiag.so.300
ln -sf libScsiDevDiag.so.300 libScsiDevDiag.so

echo "Creating link for libdiagframework"
ln -sf libdiagframework.so.300.* libdiagframework.so.300
ln -sf libdiagframework.so.300 libdiagframework.so

#change directory to dellvl folder
cd /usr/lib/dell/openmanage/sm/dellvl 

##############
#CREATE LINKS#
##############

echo "Creating link for liblsivil"
ln -sf liblsivil.so.1.* liblsivil.so.1
ln -sf liblsivil.so.1 liblsivil.so

echo "Creating link for libafavil"
ln -sf libafavil.so.1.* libafavil.so.1
ln -sf libafavil.so.1 libafavil.so

echo "Creating link for libnrsvil"
ln -sf libnrsvil.so.1.* libnrsvil.so.1
ln -sf libnrsvil.so.1 libnrsvil.so

echo "Creating link for libenclvil"
ln -sf libenclvil.so.1.* libenclvil.so.1
ln -sf libenclvil.so.1 libenclvil.so

#check dynamic linker config file for shared library directory
grep "^/usr/lib/dell/openmanage/sm" /etc/ld.so.conf >/dev/null
if [ $? != 0 ];
then
	# shared library directory not found in linker config file;
	# add to it
	echo "Adding /usr/lib/dell/openmanage/sm to ld.so.conf file"
	echo "/usr/lib/dell/openmanage/sm" >>/etc/ld.so.conf
fi

#check dynamic linker config file for shared library directory
grep "^/usr/lib/dell/openmanage/sm/dellvl" /etc/ld.so.conf >/dev/null
if [ $? != 0 ];
then
	#shared library directory not found in linker config file;
	# add to it
	echo "Adding /usr/lib/dell/openmanage/sm/dellvl to ld.so.conf file"
	echo "/usr/lib/dell/openmanage/sm/dellvl" >>/etc/ld.so.conf
fi


# add shared directories to the dynamic linker cache
echo "Executing ldconfig"
ldconfig

echo "instlx32links ends."	
