/*
 * Decompiled with CFR 0.152.
 */
package com.dell.drsc;

import com.dell.oma.common.InitializationException;
import com.dell.oma.common.OMACSUtil;
import com.dell.oma.common.OMAComponent;
import com.dell.oma.common.OMAComponentListCreationException;
import com.dell.oma.common.OMALogging;
import com.dell.oma.common.OMAStylesheetLoader;
import com.dell.oma.db.DataBridgeBroker;
import com.dell.oma.db.IOMADataBridge;
import com.dell.oma.registration.OMAApplicationRegistration;
import com.dell.oma.registration.OMARegistrationEngine;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Vector;
import org.xml.sax.InputSource;

public class OMDRSCRegistration
extends OMAApplicationRegistration {
    public IOMADataBridge getDataBridge() {
        try {
            DataBridgeBroker dataBridgeBroker = DataBridgeBroker.getInstance();
            return dataBridgeBroker.getDataBridge("drsda");
        }
        catch (InitializationException initializationException) {
            OMALogging.getInstance().write(1, "OMDRSCRegistration.getDataBridge: Initializatin exception getting bridge");
            return null;
        }
    }

    public String getName() {
        return "drsc";
    }

    public String getDisplayName() {
        return "Remote Service Card";
    }

    public String getVersion() {
        return "1.2";
    }

    public Vector getComponentList(Locale locale) throws OMAComponentListCreationException {
        Vector vector = null;
        String string = "<LUSupported>0</LUSupported>";
        OMARegistrationEngine oMARegistrationEngine = OMARegistrationEngine.getInstance();
        for (int i = 0; i < oMARegistrationEngine.getRegisteredObjectCount(); ++i) {
            if (!oMARegistrationEngine.getRegisteredObject(i).getName().equalsIgnoreCase("lu")) continue;
            string = "<LUSupported>1</LUSupported>";
        }
        try {
            OMALogging.getInstance().write(9, "OMDRSCRegistration.getComponentTree");
            OMACSUtil oMACSUtil = new OMACSUtil();
            String string2 = oMACSUtil.getXSLDocPath(locale, "drsc", "web", "DRSCComponentRegistration.xsl");
            OMAStylesheetLoader oMAStylesheetLoader = new OMAStylesheetLoader(string2);
            DataBridgeBroker dataBridgeBroker = DataBridgeBroker.getInstance();
            IOMADataBridge iOMADataBridge = dataBridgeBroker.getDataBridge("drsda");
            String[] stringArray = new String[3];
            String[] stringArray2 = new String[3];
            String[] stringArray3 = new String[3];
            stringArray[0] = "omacmd=getmenucomps";
            stringArray[1] = "omausrmask=OMA";
            stringArray[2] = "omausrinfo=OMA";
            stringArray2[0] = "omacmd=getrscnetworkconf";
            stringArray2[1] = "omausrmask=OMA";
            stringArray2[2] = "omausrinfo=OMA";
            stringArray3[0] = "omacmd=getsummary";
            stringArray3[1] = "omausrmask=OMA";
            stringArray3[2] = "omausrinfo=OMA";
            String string3 = "<?xml version='1.0' encoding='UTF-8'?><OMA>" + iOMADataBridge.sendCmd(stringArray) + iOMADataBridge.sendCmd(stringArray2) + iOMADataBridge.sendCmd(stringArray3) + string + "</OMA>";
            OMALogging.getInstance().write(9, "OMDRSCRegistration.getComponentList(): XML Received: " + string3);
            StringWriter stringWriter = new StringWriter();
            oMAStylesheetLoader.process((Reader)new StringReader(string3), (Writer)stringWriter);
            vector = OMAComponent.buildComponentList((InputSource)new InputSource(new StringReader(stringWriter.toString())));
        }
        catch (Exception exception) {
            OMALogging.getInstance().write(1, "OMDRSCRegistration.getComponentTree: " + exception.toString());
            throw new OMAComponentListCreationException("OMDRSCRegistration.getComponentTree(): Exception: " + exception);
        }
        return vector;
    }
}

