/*
 * Decompiled with CFR 0.152.
 */
package stec.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class ArrayList
implements Cloneable,
Serializable {
    private static final int INITIAL_CAPACITY = 10;
    private Object[] items;
    protected int item_count;
    private int capacity_increment;

    public ArrayList() {
        this(10, 0);
    }

    public ArrayList(int initial_capacity) throws IllegalArgumentException {
        this(initial_capacity, 0);
    }

    public ArrayList(int initial_capacity, int capacity_increment) throws IllegalArgumentException {
        if (initial_capacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initial_capacity);
        }
        if (capacity_increment < 0) {
            throw new IllegalArgumentException("Illegal Capacity Increment: " + capacity_increment);
        }
        this.items = new Object[initial_capacity];
        this.capacity_increment = capacity_increment;
    }

    public void trimToSize() {
        if (this.item_count < this.items.length) {
            Object[] titems = new Object[this.item_count];
            System.arraycopy(this.items, 0, titems, 0, this.item_count);
            this.items = titems;
        }
    }

    public void ensureCapacity(int capacity) {
        if (capacity > this.items.length) {
            int tcapacity = this.capacity_increment > 0 ? this.items.length + this.capacity_increment : this.items.length * 2;
            if (tcapacity < capacity) {
                tcapacity = capacity;
            }
            Object[] titems = new Object[tcapacity];
            System.arraycopy(this.items, 0, titems, 0, this.item_count);
            this.items = titems;
        }
    }

    public int size() {
        return this.item_count;
    }

    public int capacity() {
        return this.items.length;
    }

    public boolean isEmpty() {
        return this.item_count == 0;
    }

    public int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.item_count - 1);
    }

    public int lastIndexOf(Object object, int index) {
        if (object == null) {
            int i = index - 1;
            while (i >= 0) {
                if (this.items[i] == null) {
                    return i;
                }
                --i;
            }
        } else {
            int i = index - 1;
            while (i >= 0) {
                if (object.equals(this.items[i])) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public int indexOf(Object object, int index) {
        if (object == null) {
            int i = index;
            while (i < this.item_count) {
                if (this.items[i] == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = index;
            while (i < this.item_count) {
                if (object.equals(this.items[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public Object clone() {
        ArrayList list = new ArrayList(this.items.length, this.capacity_increment);
        list.item_count = this.item_count;
        System.arraycopy(this.items, 0, list.items, 0, this.item_count);
        return list;
    }

    public Object[] toArray() {
        Object[] titems = new Object[this.item_count];
        System.arraycopy(this.items, 0, titems, 0, this.item_count);
        return titems;
    }

    public Object[] toArray(Object[] objects) {
        int length = objects.length;
        if (length < this.item_count) {
            objects = new Object[this.item_count];
            length = this.item_count;
        }
        System.arraycopy(this.items, 0, objects, 0, this.item_count);
        int i = this.item_count;
        while (i < length) {
            objects[i] = null;
            ++i;
        }
        return objects;
    }

    private final void check(int index) {
        if (index >= this.item_count || index < 0) {
            throw new IndexOutOfBoundsException("index: " + index + ", size: " + this.item_count);
        }
    }

    public Object get(int index) throws IndexOutOfBoundsException {
        this.check(index);
        return this.items[index];
    }

    public Object set(int index, Object object) throws IndexOutOfBoundsException {
        this.check(index);
        Object tobject = this.items[index];
        this.items[index] = object;
        return tobject;
    }

    public void add(Object object) {
        this.ensureCapacity(this.item_count + 1);
        this.items[this.item_count++] = object;
    }

    public void add(int index, Object object) throws IndexOutOfBoundsException {
        if (index > this.item_count || index < 0) {
            throw new IndexOutOfBoundsException("index: " + index + ", size: " + this.item_count);
        }
        this.ensureCapacity(this.item_count + 1);
        System.arraycopy(this.items, index, this.items, index + 1, this.item_count - index);
        this.items[index] = object;
        ++this.item_count;
    }

    public Object remove(int index) throws IndexOutOfBoundsException {
        this.check(index);
        Object item = this.items[index];
        int offset = this.item_count - index - 1;
        if (offset > 0) {
            System.arraycopy(this.items, index + 1, this.items, index, offset);
        }
        --this.item_count;
        this.items[this.item_count] = null;
        return item;
    }

    public boolean remove(Object object) {
        int index = this.indexOf(object);
        if (index != -1) {
            this.remove(index);
            return true;
        }
        return false;
    }

    public void clear() {
        this.items = new Object[10];
        this.item_count = 0;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    public Enumeration elements() {
        return new ArrayListEnumerator(this);
    }

    class ArrayListEnumerator
    implements Enumeration {
        ArrayList list;
        int index;

        ArrayListEnumerator(ArrayList list) {
            this.list = list;
            this.index = 0;
        }

        @Override
        public boolean hasMoreElements() {
            return this.index < this.list.item_count;
        }

        public Object nextElement() {
            if (this.index < this.list.item_count) {
                return this.list.items[this.index++];
            }
            throw new NoSuchElementException("ArrayListEnumerator");
        }
    }
}

