/*
 * Decompiled with CFR 0.152.
 */
package stec.sql;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import stec.iws.iws;
import stec.sql.Connection;
import stec.sql.ConnectionPool;
import stec.util.LocalStrings;

public final class ConnectionPoolManager
implements Runnable {
    protected static final LocalStrings local_strings = new LocalStrings("stec.sql.LocalStrings");
    private static Hashtable pools = new Hashtable();
    protected long interval;

    public ConnectionPoolManager(long _interval) {
        this.interval = _interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void createConnectionPool(String name, String driver, String url, int initSize, int maxSize) throws SQLException {
        Hashtable hashtable = pools;
        synchronized (hashtable) {
            if (pools.containsKey(name)) {
                throw new SQLException(local_strings.getLocalString("err.connection_pool_already_exists", name));
            }
            ConnectionPool pool = new ConnectionPool(driver, url, initSize, maxSize, -1L);
            pools.put(name, pool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void createConnectionPool(String name, String driver, String url, String id, String pw, int initSize, int maxSize) throws SQLException {
        Hashtable hashtable = pools;
        synchronized (hashtable) {
            if (pools.containsKey(name)) {
                throw new SQLException(local_strings.getLocalString("err.connection_pool_already_exists", name));
            }
            ConnectionPool pool = new ConnectionPool(driver, url, id, pw, initSize, maxSize, -1L);
            pools.put(name, pool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void createConnectionPool(String name, String driver, String url, Properties info, int initSize, int maxSize) throws SQLException {
        Hashtable hashtable = pools;
        synchronized (hashtable) {
            if (pools.containsKey(name)) {
                throw new SQLException(local_strings.getLocalString("err.connection_pool_already_exists", name));
            }
            ConnectionPool pool = new ConnectionPool(driver, url, info, initSize, maxSize, -1L);
            pools.put(name, pool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void createConnectionPool(String name, String driver, String url, int initSize, int maxSize, long timeout) throws SQLException {
        Hashtable hashtable = pools;
        synchronized (hashtable) {
            if (pools.containsKey(name)) {
                throw new SQLException(local_strings.getLocalString("err.connection_pool_already_exists", name));
            }
            ConnectionPool pool = new ConnectionPool(driver, url, initSize, maxSize, timeout);
            pools.put(name, pool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void createConnectionPool(String name, String driver, String url, String id, String pw, int initSize, int maxSize, long timeout) throws SQLException {
        Hashtable hashtable = pools;
        synchronized (hashtable) {
            if (pools.containsKey(name)) {
                throw new SQLException(local_strings.getLocalString("err.connection_pool_already_exists", name));
            }
            ConnectionPool pool = new ConnectionPool(driver, url, id, pw, initSize, maxSize, timeout);
            pools.put(name, pool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void createConnectionPool(String name, String driver, String url, Properties info, int initSize, int maxSize, long timeout) throws SQLException {
        Hashtable hashtable = pools;
        synchronized (hashtable) {
            if (pools.containsKey(name)) {
                throw new SQLException(local_strings.getLocalString("err.connection_pool_already_exists", name));
            }
            ConnectionPool pool = new ConnectionPool(driver, url, info, initSize, maxSize, timeout);
            pools.put(name, pool);
        }
    }

    public static final void destroyConnectionPool(String name) {
        Object obj = pools.remove(name);
        if (obj == null) {
            return;
        }
        ConnectionPool pool = (ConnectionPool)obj;
        pool.destroyPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void destroyAllConnectionPools() {
        Hashtable hashtable = pools;
        synchronized (hashtable) {
            Enumeration e = pools.keys();
            while (e.hasMoreElements()) {
                try {
                    ConnectionPoolManager.destroyConnectionPool((String)e.nextElement());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            pools.clear();
        }
    }

    public static final Connection getConnection(String name) throws SQLException {
        Object obj = pools.get(name);
        if (obj == null) {
            return null;
        }
        ConnectionPool pool = (ConnectionPool)obj;
        return pool.getConnection();
    }

    public static final Enumeration getConnectionPools() {
        return pools.keys();
    }

    public static final boolean containsConnectionPool(String name) {
        return pools.containsKey(name);
    }

    private final void monitor() {
        Enumeration e = pools.elements();
        while (e.hasMoreElements()) {
            if (iws.shutdown()) {
                return;
            }
            ConnectionPool pool = (ConnectionPool)e.nextElement();
            pool.monitor();
        }
    }

    @Override
    public final void run() {
        while (!iws.shutdown()) {
            do {
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!iws.shutdown()) continue;
                return;
            } while (pools.size() == 0);
            this.monitor();
        }
    }
}

