/*
 * Decompiled with CFR 0.152.
 */
package stec.sql;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Stack;
import stec.iws.iws;
import stec.sql.Connection;
import stec.sql.ConnectionPoolManager;

public final class ConnectionPool {
    protected Stack connections;
    protected String url;
    protected Properties info;
    protected int initSize;
    protected int currentSize;
    protected int maxSize;
    protected String driver;
    protected long timeout;

    protected ConnectionPool(String driver, String url, Properties info, int initSize, int maxSize, long timeout) throws SQLException {
        this.createConnectionPool(driver, url, info, initSize, maxSize, timeout);
    }

    protected ConnectionPool(String driver, String url, int initSize, int maxSize, long timeout) throws SQLException {
        Properties info = new Properties();
        this.createConnectionPool(driver, url, info, initSize, maxSize, timeout);
    }

    protected ConnectionPool(String driver, String url, String user, String password, int initSize, int maxSize, long timeout) throws SQLException {
        Properties info = new Properties();
        if (user != null) {
            info.put("user", user);
        }
        if (password != null) {
            info.put("password", password);
        }
        this.createConnectionPool(driver, url, info, initSize, maxSize, timeout);
    }

    /*
     * Unable to fully structure code
     */
    private final void createConnectionPool(String _driver, String _url, Properties _info, int _initSize, int _maxSize, long _timeout) throws SQLException {
        block12: {
            if (_initSize < 1) {
                throw new IllegalArgumentException(ConnectionPoolManager.local_strings.getLocalString("err.initial_size_must_be_greater_than_or_equal_to_one"));
            }
            if (_maxSize < 1) {
                throw new IllegalArgumentException(ConnectionPoolManager.local_strings.getLocalString("err.maximum_size_must_be_greater_than_or_equal_to_one"));
            }
            if (_initSize > _maxSize) {
                sb = new StringBuffer(ConnectionPoolManager.local_strings.getLocalString("err.initial_size_must_be_less_than_maximum_size"));
                sb.append(_initSize);
                sb.append(' ');
                sb.append(_maxSize);
                throw new IllegalArgumentException(sb.toString());
            }
            this.timeout = _timeout;
            try {
                Class.forName(_driver);
            }
            catch (ClassNotFoundException ex) {
                throw new SQLException(ConnectionPoolManager.local_strings.getLocalString("err.database_driver_was_not_found", _driver));
            }
            _connection = null;
            try {
                this.connections = new Stack<E>();
                i = 0;
                while (i < _initSize) {
                    _connection = DriverManager.getConnection(_url, _info);
                    connection = new Connection(this, _connection);
                    _connection = null;
                    this.connections.push(connection);
                    ++i;
                }
                break block12;
            }
            catch (SQLException ex) {
                if (_connection != null) {
                    _connection.close();
                }
                ** while (this.connections.size() > 0)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    connection = (Connection)this.connections.pop();
                    connection.close();
                }
                catch (Exception var11_14) {
                    // empty catch block
                }
                continue;
            }
lbl45:
            // 1 sources

            throw ex;
        }
        this.url = _url;
        this.info = _info;
        this.initSize = _initSize;
        this.currentSize = _initSize;
        this.maxSize = _maxSize;
        this.driver = _driver;
    }

    protected final synchronized void destroyPool() {
        while (this.connections.size() > 0) {
            try {
                Connection connection = (Connection)this.connections.pop();
                connection.kill();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.connections = null;
    }

    public final synchronized int available() {
        return this.maxSize - this.currentSize + this.connections.size();
    }

    public final synchronized int inUse() {
        return this.currentSize - this.connections.size();
    }

    public final synchronized int capacity() {
        return this.maxSize;
    }

    public final synchronized int size() {
        return this.currentSize;
    }

    public final synchronized String url() {
        return this.url;
    }

    protected final synchronized void putConnection(Connection connection) throws SQLException {
        if (this.connections == null) {
            connection.kill();
        } else {
            if (this.connections.contains(this)) {
                throw new SQLException(ConnectionPoolManager.local_strings.getLocalString("err.connection_is_already_in_pool"));
            }
            if (this.connections.size() >= this.initSize) {
                --this.currentSize;
                connection.kill();
            } else {
                try {
                    if (!connection.getAutoCommit()) {
                        connection.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.timeout > 0L) {
                    connection.timeout = System.currentTimeMillis() + this.timeout;
                }
                this.connections.push(connection);
            }
        }
    }

    protected final synchronized Connection getConnection() throws SQLException {
        if (this.connections == null) {
            return null;
        }
        if (this.connections.size() == 0) {
            if (this.currentSize > this.maxSize) {
                return null;
            }
            java.sql.Connection _connection = null;
            Connection connection = null;
            try {
                _connection = DriverManager.getConnection(this.url, this.info);
                connection = new Connection(this, _connection);
            }
            catch (SQLException ex) {
                if (_connection != null) {
                    _connection.close();
                }
                throw ex;
            }
            ++this.currentSize;
            return connection;
        }
        return (Connection)this.connections.pop();
    }

    protected final synchronized void monitor() {
        if (this.timeout > 0L && this.connections != null) {
            int count = this.connections.size();
            int i = 0;
            int o = 0;
            while (i < count) {
                if (iws.shutdown()) {
                    return;
                }
                try {
                    Connection connection = (Connection)this.connections.elementAt(o);
                    if (System.currentTimeMillis() >= connection.timeout) {
                        this.connections.removeElementAt(o);
                        --this.currentSize;
                        connection.kill();
                    } else {
                        ++o;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
    }
}

