/*
 * Decompiled with CFR 0.152.
 */
package stec.net;

import java.io.PrintStream;
import java.util.Date;
import java.util.Vector;
import stec.net.Attachment;

public final class Message {
    private static final int MAXLINESIZE = 74;
    private static final String[] DAY = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final String[] MONTH = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String EOL = "\r\n";
    private static final String delimiter = "---bOuNdArY";
    private String fromAddress;
    private String toAddress;
    private String ccAddress;
    private String subject;
    private String message;
    private String date;
    private Vector attachments;
    private Vector headers;

    public Message() {
    }

    public Message(String _from, String _to, String _subject, String _message) {
        this.set(_from, _to, null, _subject, _message, null, null);
    }

    public Message(String _from, String _to, String _cc, String _subject, String _message) {
        this.set(_from, _to, _cc, _subject, _message, null, null);
    }

    public Message(String _from, String _to, String _cc, String _subject, String _message, Vector _headers, Vector _attachments) {
        this.set(_from, _to, _cc, _subject, _message, null, null);
    }

    public final void set(String _from, String _to, String _cc, String _subject, String _message, Vector _headers, Vector _attachments) {
        this.fromAddress = _from;
        this.toAddress = _to;
        this.ccAddress = _cc;
        this.subject = _subject;
        this.message = _message;
        this.date = Message.getDate();
        this.headers = _headers == null ? new Vector() : _headers;
        this.attachments = _attachments == null ? new Vector() : _attachments;
    }

    public final String getFrom() {
        return this.fromAddress;
    }

    public final String getTo() {
        return this.toAddress;
    }

    public final String getCC() {
        return this.ccAddress;
    }

    public final void setTo(String _toAddress) {
        this.toAddress = _toAddress;
    }

    public final void setCC(String _ccAddress) {
        this.ccAddress = _ccAddress;
    }

    public void addHeader(String key, String value) {
        this.headers.addElement(String.valueOf(key) + ": " + value);
    }

    public final void addAttachment(Attachment _attachment) {
        this.attachments.addElement(_attachment);
    }

    public final void sendHeaders(PrintStream _ps) {
        _ps.print("From: ");
        _ps.print(this.fromAddress);
        _ps.print(EOL);
        _ps.print("To: ");
        _ps.print(this.toAddress);
        _ps.print(EOL);
        if (this.ccAddress != null) {
            _ps.print("Cc: ");
            _ps.print(this.ccAddress);
            _ps.print(EOL);
        }
        _ps.print("Subject: ");
        _ps.print(this.subject);
        _ps.print(EOL);
        _ps.print("Date: ");
        _ps.print(Message.getDate());
        _ps.print(EOL);
        int size = this.headers.size();
        int i = 0;
        while (i < size) {
            _ps.print((String)this.headers.elementAt(i));
            _ps.print(EOL);
            ++i;
        }
        if (this.attachments.size() > 0) {
            _ps.print("Mime-Version: 1.0");
            _ps.print(EOL);
            _ps.print("Content-Type: multipart/mixed; boundary=\"");
            _ps.print(delimiter);
            _ps.print("\"");
            _ps.print(EOL);
            _ps.print(EOL);
            _ps.print("This is a multi-part message in MIME format.");
            _ps.print(EOL);
            _ps.print(EOL);
            _ps.print("--");
            _ps.print(delimiter);
            _ps.print(EOL);
            _ps.print("Content-Type: text/plain; charset=\"us-ascii\"");
            _ps.print(EOL);
        }
        _ps.print(EOL);
    }

    public final void sendBody(PrintStream _ps) {
        _ps.print(this.message);
        _ps.print(EOL);
    }

    public final void sendAttachments(PrintStream _ps) {
        int size = this.attachments.size();
        if (size > 0) {
            int i = 0;
            while (i < size) {
                Attachment attachment = (Attachment)this.attachments.elementAt(i);
                _ps.print("--");
                _ps.print(delimiter);
                _ps.print(EOL);
                _ps.print("Content-Type: application/octet-stream; name=\"");
                _ps.print(attachment.name);
                _ps.print("\"");
                _ps.print(EOL);
                _ps.print("Content-Transfer-Encoding: base64");
                _ps.print(EOL);
                _ps.print("Content-Disposition: attachment; filename=\"");
                _ps.print(attachment.name);
                _ps.print("\"");
                _ps.print(EOL);
                if (attachment.description != null) {
                    _ps.print("Content-Description: ");
                    _ps.print(attachment.description);
                    _ps.print(EOL);
                }
                _ps.print(EOL);
                int length = attachment.item.length;
                int iLines = length / 74;
                int o = 0;
                while (o < iLines) {
                    _ps.write(attachment.item, o * 74, 74);
                    _ps.print(EOL);
                    ++o;
                }
                if (iLines * 74 < length) {
                    _ps.write(attachment.item, o * 74, length - o * 74);
                    _ps.print(EOL);
                }
                ++i;
            }
            _ps.print("--");
            _ps.print(delimiter);
            _ps.print("--");
            _ps.print(EOL);
        }
    }

    public final void send(PrintStream _ps) {
        this.sendHeaders(_ps);
        this.sendBody(_ps);
        this.sendAttachments(_ps);
    }

    public static String getDate() {
        Date dt = new Date();
        StringBuffer out = new StringBuffer();
        out.append(DAY[dt.getDay()]);
        out.append(", ");
        out.append(dt.getDate());
        out.append(" ");
        out.append(MONTH[dt.getMonth()]);
        out.append(" ");
        String val = dt.getYear() > 99 ? String.valueOf(String.valueOf(1900 + dt.getYear())) + " " : String.valueOf(String.valueOf(dt.getYear())) + " ";
        out.append(val);
        val = dt.getHours() < 10 ? "0" + String.valueOf(dt.getHours()) : String.valueOf(dt.getHours());
        out.append(val);
        val = dt.getMinutes() < 10 ? "0" + String.valueOf(dt.getMinutes()) : String.valueOf(dt.getMinutes());
        out.append(val);
        val = dt.getSeconds() < 10 ? "0" + String.valueOf(dt.getSeconds()) : String.valueOf(dt.getSeconds());
        out.append(val);
        int tz = dt.getTimezoneOffset();
        if (tz < 0) {
            out.append("-");
        } else {
            out.append("+");
        }
        tz = Math.abs(tz);
        if (tz / 60 < 10) {
            out.append("0");
        }
        out.append(String.valueOf(tz / 60));
        if (tz % 60 < 10) {
            out.append("0");
        }
        out.append(String.valueOf(tz % 60));
        return out.toString();
    }
}

