/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Random;
import stec.iws.RequestHandler;
import stec.iws.ServletContextImpl;
import stec.iws.Session;
import stec.iws.iws;

public abstract class SessionStore
implements Runnable {
    private Random random = new Random();
    private Hashtable parameters;

    public void init(Hashtable _parameters) throws Exception {
        this.parameters = _parameters;
    }

    public void destroy() {
    }

    @Override
    public void run() {
        while (!iws.shutdown) {
            try {
                Thread.sleep(iws.sessionStoreInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (iws.shutdown) {
                return;
            }
            try {
                this.checkSessionStore();
            }
            catch (Exception ex) {
                iws.logger.log(ex, iws.local_strings.getLocalString("err.error_checking_session_store", ex.getMessage()));
            }
        }
    }

    public abstract void checkSessionStore() throws Exception;

    public abstract void checkServletContext(ServletContextImpl var1) throws Exception;

    public abstract void checkSession(Session var1) throws Exception;

    public abstract Session getSession(ServletContextImpl var1, String var2) throws Exception;

    public abstract void removeSession(Session var1) throws Exception;

    public abstract void removeResidentSession(Session var1) throws Exception;

    public abstract void load(ServletContextImpl var1) throws Exception;

    public abstract void unload(ServletContextImpl var1) throws Exception;

    public abstract void saveSession(Session var1, boolean var2) throws Exception;

    public abstract boolean isDistributed();

    public String getIdentifier() {
        String id = Long.toHexString(System.currentTimeMillis());
        StringBuffer sb = new StringBuffer();
        int id_length = id.length();
        while (sb.length() < id_length) {
            sb.append(Long.toHexString(this.random.nextLong()));
        }
        String rnd = sb.toString();
        sb.setLength(0);
        int i = 0;
        while (i < id_length) {
            sb.append(rnd.charAt(i));
            sb.append(id.charAt(i));
            ++i;
        }
        return sb.toString();
    }

    public Session createSession(RequestHandler _handler) throws Exception {
        InetAddress remote_address = _handler.socket.getInetAddress();
        return new Session(this.getIdentifier(), _handler.servlet_context, remote_address);
    }
}

